/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.insar.gpf.support.SARUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.dataop.dem.ElevationModel;
import org.esa.snap.core.dataop.dem.ElevationModelDescriptor;
import org.esa.snap.core.dataop.dem.ElevationModelRegistry;
import org.esa.snap.core.dataop.resamp.ResamplingFactory;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.dem.dataio.DEMFactory;
import org.esa.snap.dem.dataio.FileElevationModel;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.OrbitStateVector;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;
import org.esa.snap.engine_utilities.util.Maths;
import org.jlinda.core.Baseline;
import org.jlinda.core.Orbit;
import org.jlinda.core.SLCImage;

@OperatorMetadata(alias="PhaseToElevation", category="Radar/Interferometric/Products", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2016 by Array Systems Computing Inc.", description="DEM Generation")
public final class PhaseToElevationOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The digital elevation model.", defaultValue="SRTM 3Sec", label="Digital Elevation Model")
    private String demName = "SRTM 3Sec";
    @Parameter(defaultValue="BILINEAR_INTERPOLATION", label="DEM Resampling Method")
    private String demResamplingMethod = "BILINEAR_INTERPOLATION";
    @Parameter(label="External DEM")
    private File externalDEMFile = null;
    @Parameter(label="DEM No Data Value", defaultValue="0")
    private double externalDEMNoDataValue = 0.0;
    private ElevationModel dem = null;
    private FileElevationModel fileElevationModel = null;
    private TiePointGrid latitudeTPG = null;
    private TiePointGrid longitudeTPG = null;
    private TiePointGrid incidenceAngleTPG = null;
    private TiePointGrid slantRangeTimeTPG = null;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private boolean isElevationModelAvailable = false;
    private boolean refHeightPhaseComputed = false;
    private double waveNumber = 0.0;
    private double refHeight = 0.0;
    private double refPhase = 0.0;
    private double demNoDataValue = 0.0;
    private double[] lookAngles = null;
    private double firstLineUTC = 0.0;
    private OrbitStateVector[] orbitStateVectors = null;
    private final Baseline baseline = new Baseline();
    private Band unwrappedPhaseBand;
    private static final String PRODUCT_SUFFIX = "_Hgt";

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfMapProjected(false);
            this.getMetadata();
            this.getTiePointGrid();
            this.createTargetProduct();
            if (this.externalDEMFile == null) {
                DEMFactory.checkIfDEMInstalled((String)this.demName);
            }
            DEMFactory.validateDEM((String)this.demName, (Product)this.sourceProduct);
            this.getBaseline();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    public synchronized void dispose() {
        if (this.dem != null) {
            this.dem.dispose();
            this.dem = null;
        }
        if (this.fileElevationModel != null) {
            this.fileElevationModel.dispose();
        }
    }

    private void getMetadata() throws Exception {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
        double wavelength = SARUtils.getRadarFrequency(absRoot);
        this.waveNumber = Math.PI * 2 / wavelength;
        this.orbitStateVectors = AbstractMetadata.getOrbitStateVectors((MetadataElement)absRoot);
        this.firstLineUTC = absRoot.getAttributeUTC("first_line_time").getMJD();
        this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
    }

    private void getTiePointGrid() {
        this.latitudeTPG = OperatorUtils.getLatitude((Product)this.sourceProduct);
        if (this.latitudeTPG == null) {
            throw new OperatorException("Cannot find latitude tie point grid with the source product");
        }
        this.longitudeTPG = OperatorUtils.getLongitude((Product)this.sourceProduct);
        if (this.longitudeTPG == null) {
            throw new OperatorException("Cannot find longitude tie point grid with the source product");
        }
        this.incidenceAngleTPG = OperatorUtils.getIncidenceAngle((Product)this.sourceProduct);
        if (this.incidenceAngleTPG == null) {
            throw new OperatorException("Cannot find incidence angle tie point grid with the source product");
        }
        this.slantRangeTimeTPG = OperatorUtils.getSlantRangeTime((Product)this.sourceProduct);
        if (this.slantRangeTimeTPG == null) {
            throw new OperatorException("Cannot find slant range time tie point grid with the source product");
        }
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName() + PRODUCT_SUFFIX, this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
        this.addSelectedBands();
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (this.externalDEMFile != null && this.fileElevationModel == null) {
            AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"DEM", (String)this.externalDEMFile.getPath());
        } else {
            AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"DEM", (String)this.demName);
        }
        absTgt.setAttributeString("DEM resampling method", this.demResamplingMethod);
        if (this.externalDEMFile != null) {
            absTgt.setAttributeDouble("external DEM no data value", this.externalDEMNoDataValue);
        }
    }

    private void addSelectedBands() {
        Band[] sourceBands = OperatorUtils.getSourceBands((Product)this.sourceProduct, null, (boolean)false);
        boolean validProduct = false;
        for (Band band : sourceBands) {
            if (!band.getName().toLowerCase().startsWith("unw")) continue;
            validProduct = true;
            this.unwrappedPhaseBand = band;
            break;
        }
        if (!validProduct) {
            throw new OperatorException("Cannot find UnwrappedPhase band in the source product.");
        }
        Band targetBand = new Band("elevation", 30, this.sourceImageWidth, this.sourceImageHeight);
        targetBand.setUnit("meters");
        this.targetProduct.addBand(targetBand);
    }

    private void getBaseline() throws Exception {
        MetadataElement masterMeta = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
        SLCImage masterMetaData = new SLCImage(masterMeta, this.sourceProduct);
        Orbit masterOrbit = new Orbit(masterMeta, 3);
        MetadataElement[] slaveRoot = this.sourceProduct.getMetadataRoot().getElement("Slave_Metadata").getElements();
        SLCImage slaveMetaData = new SLCImage(slaveRoot[0], this.sourceProduct);
        Orbit slaveOrbit = new Orbit(slaveRoot[0], 3);
        this.baseline.model(masterMetaData, slaveMetaData, masterOrbit, slaveOrbit);
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            Band sourceBand = this.unwrappedPhaseBand;
            Tile sourceTile = this.getSourceTile((RasterDataNode)sourceBand, targetRectangle);
            ProductData sourceData = sourceTile.getDataBuffer();
            Band targetBand = this.targetProduct.getBand("elevation");
            Tile targetTile = targetTiles.get(targetBand);
            ProductData targetData = targetTile.getDataBuffer();
            TileIndex srcIndex = new TileIndex(sourceTile);
            TileIndex trgIndex = new TileIndex(targetTile);
            if (!this.isElevationModelAvailable) {
                this.getElevationModel();
            }
            if (!this.refHeightPhaseComputed) {
                this.computeReferenceHeightAndPhase(sourceBand, this.baseline);
            }
            int x0 = targetRectangle.x;
            int y0 = targetRectangle.y;
            int w = targetRectangle.width;
            int h = targetRectangle.height;
            int xc = this.sourceImageWidth / 2;
            for (int y = y0; y < y0 + h; ++y) {
                srcIndex.calculateStride(y);
                trgIndex.calculateStride(y);
                for (int x = x0; x < x0 + w; ++x) {
                    double phase = sourceData.getElemDoubleAt(srcIndex.getIndex(x));
                    double slantRange = this.slantRangeTimeTPG.getPixelDouble(x, y) / 1.0E9 * 1.49896229E8;
                    double incidenceAngle = this.incidenceAngleTPG.getPixelDouble(x, y) * (Math.PI / 180);
                    double bn = this.baseline.getBperp((double)y, (double)x);
                    double bp = this.baseline.getBpar((double)y, (double)x);
                    double flatAngle = this.lookAngles[x] - this.lookAngles[xc];
                    double alpha = -slantRange * FastMath.sin((double)incidenceAngle) / (2.0 * this.waveNumber * (bp * FastMath.sin((double)flatAngle) + bn * FastMath.cos((double)flatAngle)));
                    double height = this.refHeight + alpha * (phase - this.refPhase);
                    targetData.setElemDoubleAt(trgIndex.getIndex(x), height);
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private synchronized void getElevationModel() throws Exception {
        if (this.isElevationModelAvailable) {
            return;
        }
        if (this.externalDEMFile != null && this.fileElevationModel == null) {
            this.fileElevationModel = new FileElevationModel(this.externalDEMFile, this.demResamplingMethod, Double.valueOf(this.externalDEMNoDataValue));
            this.demNoDataValue = this.externalDEMNoDataValue;
            this.demName = this.externalDEMFile.getPath();
        } else {
            ElevationModelRegistry elevationModelRegistry = ElevationModelRegistry.getInstance();
            ElevationModelDescriptor demDescriptor = elevationModelRegistry.getDescriptor(this.demName);
            if (demDescriptor == null) {
                throw new OperatorException("The DEM '" + this.demName + "' is not supported.");
            }
            this.dem = demDescriptor.createDem(ResamplingFactory.createResampling((String)this.demResamplingMethod));
            if (this.dem == null) {
                throw new OperatorException("The DEM '" + this.demName + "' has not been installed.");
            }
            this.demNoDataValue = this.dem.getDescriptor().getNoDataValue();
        }
        this.isElevationModelAvailable = true;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void computeReferenceHeightAndPhase(Band unwrappedPhaseBand, Baseline baseline) throws Exception {
        void var14_19;
        if (this.refHeightPhaseComputed) {
            return;
        }
        this.computeLookAngles();
        int seedGridSize = 100;
        int slopeCalRadius = 4;
        int seedGridResY = (this.sourceImageHeight - 1 - 8) / 99;
        int seedGridResX = (this.sourceImageWidth - 1 - 8) / 99;
        ArrayList<Object> seedList = new ArrayList<Object>(10000);
        for (int r = 0; r < 100; ++r) {
            int y = r * seedGridResY + 4;
            for (int c = 0; c < 100; ++c) {
                int x = c * seedGridResX + 4;
                Double h = this.getElevation(x, y);
                if (h.equals(this.demNoDataValue) || !(h > 0.0)) continue;
                SeedRecord seed = new SeedRecord(x, y, h, this.computeSlope(x, y, 4));
                seedList.add(seed);
            }
        }
        Collections.sort(seedList);
        int maskSize = 15;
        int totalFinalSeeds = 150;
        boolean[][] mask = new boolean[15][15];
        SeedRecord[] finalSeedList = new SeedRecord[150];
        int numSeeds = 0;
        for (SeedRecord seedRecord : seedList) {
            int maskY = (int)((double)seedRecord.y / (double)this.sourceImageHeight * 15.0);
            int maskX = (int)((double)seedRecord.x / (double)this.sourceImageWidth * 15.0);
            if (mask[maskY][maskX]) continue;
            finalSeedList[numSeeds++] = new SeedRecord(seedRecord.x, seedRecord.y, seedRecord.height, seedRecord.slope);
            if (numSeeds >= 150) break;
            mask[maskY][maskX] = true;
        }
        double[] phaseList = new double[150];
        boolean bl = false;
        while (var14_19 < finalSeedList.length) {
            SeedRecord seed = finalSeedList[var14_19];
            Rectangle srcRect = new Rectangle(seed.x, seed.y, 1, 1);
            Tile sourceTile = this.getSourceTile((RasterDataNode)unwrappedPhaseBand, srcRect);
            phaseList[var14_19] = sourceTile.getDataBuffer().getElemDoubleAt(sourceTile.getDataBufferIndex(seed.x, seed.y));
            ++var14_19;
        }
        int n = this.sourceImageWidth / 2;
        double a = 0.0;
        double b = 0.0;
        double c = 0.0;
        double d = 0.0;
        double e = 0.0;
        double f = 0.0;
        for (int i = 0; i < finalSeedList.length; ++i) {
            SeedRecord seed = finalSeedList[i];
            double phase = phaseList[i];
            double slantRange = this.slantRangeTimeTPG.getPixelDouble(seed.x, seed.y) / 1.0E9 * 1.49896229E8;
            double incidenceAngle = this.incidenceAngleTPG.getPixelDouble(seed.x, seed.y) * (Math.PI / 180);
            double bn = baseline.getBperp((double)seed.y, (double)seed.x);
            double bp = baseline.getBpar((double)seed.y, (double)seed.x);
            double flatAngle = this.lookAngles[seed.x] - this.lookAngles[n];
            double alpha = -slantRange * FastMath.sin((double)incidenceAngle) / (2.0 * this.waveNumber * (bp * FastMath.sin((double)flatAngle) + bn * FastMath.cos((double)flatAngle)));
            a += -alpha * alpha;
            b += alpha;
            e += alpha * (seed.height - alpha * phase);
            f += seed.height - alpha * phase;
        }
        c = -b;
        d = finalSeedList.length;
        this.refHeight = (a * f - c * e) / (a * d - c * b);
        this.refPhase = (e * d - b * f) / (a * d - c * b);
        this.refHeightPhaseComputed = true;
    }

    private synchronized void computeLookAngles() {
        double[] senPos = new double[3];
        this.getSensorPosition(this.firstLineUTC, senPos);
        double ht = Math.sqrt(senPos[0] * senPos[0] + senPos[1] * senPos[1] + senPos[2] * senPos[2]);
        double er = PhaseToElevationOp.computeEarthRadius(senPos[2], ht);
        this.lookAngles = new double[this.sourceImageWidth];
        for (int x = 0; x < this.sourceImageWidth; ++x) {
            double sr = this.slantRangeTimeTPG.getPixelDouble(x, 0) / 1.0E9 * 1.49896229E8;
            this.lookAngles[x] = FastMath.acos((double)((sr * sr + ht * ht - er * er) / (2.0 * sr * ht)));
        }
    }

    private void getSensorPosition(double time, double[] senPos) {
        int numVectors = this.orbitStateVectors.length;
        int numVectorsUsed = Math.min(this.orbitStateVectors.length, 5);
        int d = numVectors / numVectorsUsed;
        double[] timeArray = new double[numVectorsUsed];
        double[] xPosArray = new double[numVectorsUsed];
        double[] yPosArray = new double[numVectorsUsed];
        double[] zPosArray = new double[numVectorsUsed];
        for (int i = 0; i < numVectorsUsed; ++i) {
            timeArray[i] = this.orbitStateVectors[i * d].time_mjd;
            xPosArray[i] = this.orbitStateVectors[i * d].x_pos;
            yPosArray[i] = this.orbitStateVectors[i * d].y_pos;
            zPosArray[i] = this.orbitStateVectors[i * d].z_pos;
        }
        senPos[0] = Maths.lagrangeInterpolatingPolynomial((double[])timeArray, (double[])xPosArray, (double)time);
        senPos[1] = Maths.lagrangeInterpolatingPolynomial((double[])timeArray, (double[])yPosArray, (double)time);
        senPos[2] = Maths.lagrangeInterpolatingPolynomial((double[])timeArray, (double[])zPosArray, (double)time);
    }

    private static double computeEarthRadius(double senPosZ, double satelliteHeight) {
        double re = 6378137.0;
        double rp = 6356752.314245179;
        double lat = FastMath.asin((double)(senPosZ / satelliteHeight));
        return 4.0544237135322805E13 / Math.sqrt(4.0408299984661445E13 * FastMath.cos((double)lat) * FastMath.cos((double)lat) + 4.0680631590769E13 * FastMath.sin((double)lat) * FastMath.sin((double)lat));
    }

    private double getElevation(int x, int y) throws Exception {
        GeoPos geoPos = new GeoPos();
        geoPos.setLocation(this.latitudeTPG.getPixelDouble(x, y), this.longitudeTPG.getPixelDouble(x, y));
        double alt = this.externalDEMFile == null ? this.dem.getElevation(geoPos) : this.fileElevationModel.getElevation(geoPos);
        return alt;
    }

    private double computeSlope(int xc, int yc, int slopeCalRadius) throws Exception {
        double slope = 0.0;
        Double h = 0.0;
        int numPoints = 0;
        double hc = this.getElevation(xc, yc);
        int halfSlopeCalRadius = slopeCalRadius / 2;
        for (int y = yc - slopeCalRadius; y <= yc + slopeCalRadius; y += slopeCalRadius) {
            for (int x = xc - slopeCalRadius; x <= xc + slopeCalRadius; x += halfSlopeCalRadius) {
                h = this.getElevation(x, y);
                if (h.equals(this.demNoDataValue)) continue;
                slope += Math.abs(h - hc);
                ++numPoints;
            }
        }
        return slope / (double)numPoints;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(PhaseToElevationOp.class);
        }
    }

    static class SeedRecord
    implements Comparable<SeedRecord> {
        public int x;
        public int y;
        public double height;
        public double slope;

        SeedRecord(int x, int y, double h, double slope) {
            this.x = x;
            this.y = y;
            this.height = h;
            this.slope = slope;
        }

        @Override
        public int compareTo(SeedRecord record) {
            double slopeCmp = this.slope - record.slope;
            return slopeCmp < 0.0 ? -1 : 1;
        }
    }
}

