/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.Map;
import org.esa.s1tbx.insar.gpf.support.SARUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="PhaseToDisplacement", category="Radar/Interferometric/Products", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2016 by Array Systems Computing Inc.", description="Phase To Displacement Conversion along LOS")
public final class PhaseToDisplacementOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private double wavelength = 0.0;
    private Band unwrappedPhaseBand;
    private static final String PRODUCT_SUFFIX = "_Disp";

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfMapProjected(false);
            this.getMetadata();
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void getMetadata() throws Exception {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
        this.wavelength = SARUtils.getRadarFrequency(absRoot);
        this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName() + PRODUCT_SUFFIX, this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
        this.addSelectedBands();
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
    }

    private void addSelectedBands() {
        Band[] sourceBands = this.sourceProduct.getBands();
        boolean validProduct = false;
        for (Band band : sourceBands) {
            if (!band.getName().toLowerCase().startsWith("unw")) continue;
            validProduct = true;
            this.unwrappedPhaseBand = band;
            break;
        }
        if (!validProduct) {
            throw new OperatorException("Cannot find UnwrappedPhase band in the source product.");
        }
        Band targetBand = new Band("displacement", 30, this.sourceImageWidth, this.sourceImageHeight);
        targetBand.setUnit("meters");
        this.targetProduct.addBand(targetBand);
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            Band sourceBand = this.unwrappedPhaseBand;
            Tile sourceTile = this.getSourceTile((RasterDataNode)sourceBand, targetRectangle);
            ProductData sourceData = sourceTile.getDataBuffer();
            Band targetBand = this.targetProduct.getBand("displacement");
            Tile targetTile = targetTiles.get(targetBand);
            ProductData targetData = targetTile.getDataBuffer();
            TileIndex srcIndex = new TileIndex(sourceTile);
            TileIndex trgIndex = new TileIndex(targetTile);
            int x0 = targetRectangle.x;
            int y0 = targetRectangle.y;
            int w = targetRectangle.width;
            int h = targetRectangle.height;
            double wavelengthOver4PI = this.wavelength / (Math.PI * 4);
            for (int y = y0; y < y0 + h; ++y) {
                srcIndex.calculateStride(y);
                trgIndex.calculateStride(y);
                for (int x = x0; x < x0 + w; ++x) {
                    double phase = sourceData.getElemDoubleAt(srcIndex.getIndex(x));
                    double displacement = -wavelengthOver4PI * phase;
                    targetData.setElemDoubleAt(trgIndex.getIndex(x), displacement);
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(PhaseToDisplacementOp.class);
        }
    }
}

