/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf;

import com.bc.ceres.core.ProgressMonitor;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Map;
import org.esa.s1tbx.insar.gpf.coregistration.CrossCorrelationOp;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.PlainFeatureFactory;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.dataop.downloadable.StatusProgressMonitor;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.dataop.resamp.ResamplingFactory;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.eo.GeoUtils;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.StackUtils;
import org.esa.snap.engine_utilities.gpf.ThreadManager;
import org.esa.snap.engine_utilities.gpf.TileIndex;
import org.esa.snap.engine_utilities.util.VectorUtils;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.jblas.ComplexDouble;
import org.jblas.ComplexDoubleMatrix;
import org.jlinda.core.coregistration.utils.CoregistrationUtils;
import org.jlinda.nest.utils.TileUtilsDoris;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

@OperatorMetadata(alias="Offset-Tracking", category="Radar/SAR Applications", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2016 by Array Systems Computing Inc.", description="Create velocity vectors from offset tracking")
public class OffsetTrackingOp
extends Operator {
    @SourceProduct
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The output grid azimuth spacing in pixels", interval="(1, *)", defaultValue="40", label="Grid Azimuth Spacing in Pixels")
    private int gridAzimuthSpacing = 40;
    @Parameter(description="The output grid range spacing in pixels", interval="(1, *)", defaultValue="40", label="Grid Range Spacing in Pixels")
    private int gridRangeSpacing = 40;
    @Parameter(valueSet={"32", "64", "128", "256", "512", "1024", "2048"}, defaultValue="128", label="Registration Window Width")
    private String registrationWindowWidth = "128";
    @Parameter(valueSet={"32", "64", "128", "256", "512", "1024", "2048"}, defaultValue="128", label="Registration Window Height")
    private String registrationWindowHeight = "128";
    @Parameter(description="The cross-correlation threshold", interval="(0, *)", defaultValue="0.1", label="Cross-Correlation Threshold")
    private double xCorrThreshold = 0.1;
    private String registrationWindowAccAzimuth = "16";
    private String registrationWindowAccRange = "16";
    private String registrationOversampling = "16";
    @Parameter(valueSet={"3", "5", "9", "11"}, defaultValue="5", label="Averaging Box Size")
    private String averageBoxSize = "5";
    @Parameter(description="The threshold for eliminating invalid GCPs", interval="(0, *)", defaultValue="5.0", label="Max Velocity (m/day)")
    private double maxVelocity = 5.0;
    @Parameter(description="Radius for Hole-Filling", interval="(0, *)", defaultValue="4", label="Radius for Hole-Filling")
    private int radius = 4;
    @Parameter(valueSet={"NEAREST_NEIGHBOUR", "BILINEAR_INTERPOLATION", "BICUBIC_INTERPOLATION", "BISINC_5_POINT_INTERPOLATION", "CUBIC_CONVOLUTION"}, defaultValue="BICUBIC_INTERPOLATION", description="Methods for velocity interpolation.", label="Resampling Type")
    private String resamplingType = "BICUBIC_INTERPOLATION";
    @Parameter(defaultValue="true", label="Spatial Average")
    private boolean spatialAverage = true;
    @Parameter(defaultValue="true", label="Fill Holes")
    private boolean fillHoles = true;
    @Parameter(label="ROI Vector", defaultValue="")
    private String roiVector = "";
    private boolean outputDebuggingBands = false;
    private int cHalfWindowWidth = 0;
    private int cHalfWindowHeight = 0;
    private int halfAvgWindowSize = 0;
    private CrossCorrelationOp.CorrelationWindow corrWin = null;
    private Band masterBand = null;
    private Band slaveBand = null;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private int numGCPsPerAzLine = 0;
    private int numGCPsPerRgLine = 0;
    private int spacingX = 0;
    private int spacingY = 0;
    private int halfSpacingX = 0;
    private int halfSpacingY = 0;
    private double acquisitionTimeInterval = 0.0;
    private double rangeSpacing = 0.0;
    private double azimuthSpacing = 0.0;
    private double maxOffset = 0.0;
    private boolean velocityAvailable = false;
    private VelocityData velocityData = null;
    private Resampling selectedResampling = null;
    private static final double invalidIndex = -9999.0;
    private static final String PRODUCT_SUFFIX = "_Vel";
    private static final String VELOCITY = "Velocity";
    private static final String POINTS = "Points";
    private static final String RANGE_SHIFT = "Range_Shift";
    private static final String AZIMUTH_SHIFT = "Azimuth_Shift";
    private SimpleFeatureType windFeatureType;
    private static final String VECTOR_NODE_NAME = "Velocity";
    private static final String STYLE_FORMAT = "fill:#0000ff; fill-opacity:0.2; stroke:#ff0000; stroke-opacity:1.0; stroke-width:1.0; symbol:plus";
    private static final String ATTRIB_MST_LAT = "mst_lat";
    private static final String ATTRIB_MST_LON = "mst_lon";
    private static final String ATTRIB_SLV_LAT = "slv_lat";
    private static final String ATTRIB_SLV_LON = "slv_lon";
    private static final String ATTRIB_DISTANCE = "distance";
    private static final String ATTRIB_VELOCITY = "velocity";
    private static final String ATTRIB_HEADING = "heading";
    private static final String ATTRIB_RANGE_SHIFT = "range_shift";
    private static final String ATTRIB_AZIMUTH_SHIFT = "azimuth_shift";

    public void initialize() throws OperatorException {
        try {
            this.selectedResampling = ResamplingFactory.createResampling((String)this.resamplingType);
            if (this.selectedResampling == null) {
                throw new OperatorException("Resampling method " + this.resamplingType + " is invalid");
            }
            int avgWindowSize = Integer.parseInt(this.averageBoxSize);
            this.halfAvgWindowSize = avgWindowSize / 2;
            this.setRegistrationWindows();
            this.getMetadata();
            this.getMasterSlaveBands();
            this.createTargetProduct();
            this.createGCPGrid();
            this.updateTargetProductMetadata();
            this.windFeatureType = this.createFeatureType();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void setRegistrationWindows() {
        int cWindowWidth = Integer.parseInt(this.registrationWindowWidth);
        int cWindowHeight = Integer.parseInt(this.registrationWindowHeight);
        this.cHalfWindowWidth = cWindowWidth / 2;
        this.cHalfWindowHeight = cWindowHeight / 2;
        this.corrWin = new CrossCorrelationOp.CorrelationWindow(Integer.parseInt(this.registrationWindowWidth), Integer.parseInt(this.registrationWindowHeight), Integer.parseInt(this.registrationWindowAccAzimuth), Integer.parseInt(this.registrationWindowAccRange), Integer.parseInt(this.registrationOversampling));
    }

    private void getMetadata() throws Exception {
        MetadataElement mstAbsRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
        MetadataElement slvAbsRoot = AbstractMetadata.getSlaveMetadata((MetadataElement)this.sourceProduct.getMetadataRoot()).getElementAt(0);
        double mstFirstLineTime = AbstractMetadata.parseUTC((String)mstAbsRoot.getAttributeString("first_line_time")).getMJD();
        this.rangeSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)mstAbsRoot, (String)"range_spacing");
        this.azimuthSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)mstAbsRoot, (String)"azimuth_spacing");
        double slvFirstLineTime = AbstractMetadata.parseUTC((String)slvAbsRoot.getAttributeString("first_line_time")).getMJD();
        this.acquisitionTimeInterval = Math.abs(slvFirstLineTime - mstFirstLineTime);
        this.maxOffset = this.maxVelocity * this.acquisitionTimeInterval;
    }

    private void getMasterSlaveBands() {
        this.masterBand = OffsetTrackingOp.getSourceBand(this.sourceProduct, "_mst");
        this.slaveBand = OffsetTrackingOp.getSourceBand(this.sourceProduct, "_slv");
        if (this.masterBand == null || this.slaveBand == null) {
            throw new OperatorException("Cannot find master or slave amplitude or intensity band");
        }
    }

    private static Band getSourceBand(Product sourceProduct, String tag) {
        for (Band band : sourceProduct.getBands()) {
            if (!band.getName().toLowerCase().contains(tag) || !band.getUnit().contains("amplitude") && !band.getUnit().contains("intensity")) continue;
            return band;
        }
        return null;
    }

    private void createTargetProduct() {
        Band targetBand;
        this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
        this.targetProduct = new Product(this.sourceProduct.getName() + PRODUCT_SUFFIX, this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
        String suffix = StackUtils.getBandSuffix((String)this.slaveBand.getName());
        String velocityBandName = "Velocity" + suffix;
        if (this.targetProduct.getBand(velocityBandName) == null) {
            targetBand = this.targetProduct.addBand(velocityBandName, 30);
            targetBand.setUnit("m/day");
            targetBand.setDescription("Velocity");
            this.targetProduct.setQuicklookBandName(targetBand.getName());
        }
        if (this.outputDebuggingBands) {
            String azimuthShiftBandName;
            String rangeShiftBandName;
            String gcpPositionBandName = POINTS + suffix;
            if (this.targetProduct.getBand(gcpPositionBandName) == null) {
                targetBand = this.targetProduct.addBand(gcpPositionBandName, 30);
                targetBand.setUnit("m/day");
                targetBand.setDescription("Velocity Points");
            }
            if (this.targetProduct.getBand(rangeShiftBandName = RANGE_SHIFT + suffix) == null) {
                targetBand = this.targetProduct.addBand(rangeShiftBandName, 30);
                targetBand.setUnit("m/day");
                targetBand.setDescription("Range Shift");
            }
            if (this.targetProduct.getBand(azimuthShiftBandName = AZIMUTH_SHIFT + suffix) == null) {
                targetBand = this.targetProduct.addBand(azimuthShiftBandName, 30);
                targetBand.setUnit("m/day");
                targetBand.setDescription("Azimuth Shift");
            }
        }
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
    }

    private void createGCPGrid() {
        this.numGCPsPerAzLine = this.sourceImageHeight / this.gridAzimuthSpacing;
        this.numGCPsPerRgLine = this.sourceImageWidth / this.gridRangeSpacing;
        this.spacingX = this.gridRangeSpacing;
        this.spacingY = this.gridAzimuthSpacing;
        this.halfSpacingX = this.spacingX / 2;
        this.halfSpacingY = this.spacingY / 2;
        this.velocityData = new VelocityData(this.numGCPsPerAzLine, this.numGCPsPerRgLine);
        for (int i = 0; i < this.numGCPsPerAzLine; ++i) {
            int y = this.halfSpacingY + i * this.spacingY;
            for (int j = 0; j < this.numGCPsPerRgLine; ++j) {
                int x = this.halfSpacingX + j * this.spacingX;
                this.velocityData.mstGCPx[i][j] = x;
                this.velocityData.mstGCPy[i][j] = y;
                this.velocityData.slvGCPx[i][j] = -9999.0;
                this.velocityData.slvGCPy[i][j] = -9999.0;
            }
        }
    }

    private void updateTargetProductMetadata() {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"coregistered_stack", (int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTileStack(Map<Band, Tile> targetTileMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int xMax = x0 + w;
        int yMax = y0 + h;
        try {
            Band[] targetBands;
            if (pm.isCanceled()) {
                return;
            }
            if (!this.velocityAvailable) {
                this.computeVelocity();
            }
            Tile tgtRangeShiftTile = null;
            Tile tgtAzimuthShiftTile = null;
            Tile tgtVelocityTile = null;
            Tile tgtGCPPositionTile = null;
            ProductData tgtRangeShiftBuffer = null;
            ProductData tgtAzimuthShiftBuffer = null;
            ProductData tgtVelocityBuffer = null;
            ProductData tgtGCPPositionBuffer = null;
            for (Band tgtBand : targetBands = this.targetProduct.getBands()) {
                String tgtBandName = tgtBand.getName();
                if (tgtBandName.contains(RANGE_SHIFT)) {
                    tgtRangeShiftTile = targetTileMap.get(tgtBand);
                    tgtRangeShiftBuffer = tgtRangeShiftTile.getDataBuffer();
                    continue;
                }
                if (tgtBandName.contains(AZIMUTH_SHIFT)) {
                    tgtAzimuthShiftTile = targetTileMap.get(tgtBand);
                    tgtAzimuthShiftBuffer = tgtAzimuthShiftTile.getDataBuffer();
                    continue;
                }
                if (tgtBandName.contains("Velocity")) {
                    tgtVelocityTile = targetTileMap.get(tgtBand);
                    tgtVelocityBuffer = tgtVelocityTile.getDataBuffer();
                    continue;
                }
                if (!tgtBandName.contains(POINTS)) continue;
                tgtGCPPositionTile = targetTileMap.get(tgtBand);
                tgtGCPPositionBuffer = tgtGCPPositionTile.getDataBuffer();
            }
            if (tgtVelocityBuffer == null || this.outputDebuggingBands && (tgtGCPPositionBuffer == null || tgtRangeShiftBuffer == null || tgtAzimuthShiftBuffer == null)) {
                throw new OperatorException("Cannot find desired target bands");
            }
            TileIndex tgtIndex = new TileIndex(tgtVelocityTile);
            ResamplingRaster resamplingRasterVelocity = new ResamplingRaster(tgtVelocityTile, this.velocityData.velocity);
            ResamplingRaster resamplingRasterRangeShift = null;
            ResamplingRaster resamplingRasterAzimuthShift = null;
            if (this.outputDebuggingBands) {
                resamplingRasterRangeShift = new ResamplingRaster(tgtRangeShiftTile, this.velocityData.rangeShift);
                resamplingRasterAzimuthShift = new ResamplingRaster(tgtAzimuthShiftTile, this.velocityData.azimuthShift);
            }
            Resampling.Index resamplingIndex = this.selectedResampling.createIndex();
            for (int y = y0; y < yMax; ++y) {
                tgtIndex.calculateStride(y);
                double i = (double)(y - this.halfSpacingY) / (double)this.spacingY;
                for (int x = x0; x < xMax; ++x) {
                    int tgtIdx = tgtIndex.getIndex(x);
                    double j = (double)(x - this.halfSpacingX) / (double)this.spacingX;
                    this.selectedResampling.computeCornerBasedIndex(j, i, this.numGCPsPerRgLine, this.numGCPsPerAzLine, resamplingIndex);
                    tgtVelocityBuffer.setElemFloatAt(tgtIdx, (float)this.selectedResampling.resample((Resampling.Raster)resamplingRasterVelocity, resamplingIndex));
                    if (!this.outputDebuggingBands) continue;
                    tgtRangeShiftBuffer.setElemFloatAt(tgtIdx, (float)this.selectedResampling.resample((Resampling.Raster)resamplingRasterRangeShift, resamplingIndex));
                    tgtAzimuthShiftBuffer.setElemFloatAt(tgtIdx, (float)this.selectedResampling.resample((Resampling.Raster)resamplingRasterAzimuthShift, resamplingIndex));
                }
            }
            if (this.outputDebuggingBands && tgtGCPPositionBuffer != null) {
                for (int i = 0; i < this.numGCPsPerAzLine; ++i) {
                    for (int j = 0; j < this.numGCPsPerRgLine; ++j) {
                        int x = (int)this.velocityData.mstGCPx[i][j];
                        int y = (int)this.velocityData.mstGCPy[i][j];
                        if (this.velocityData.slvGCPx[i][j] == -9999.0 || this.velocityData.slvGCPy[i][j] == -9999.0 || x < x0 || x >= xMax || y < y0 || y >= yMax) continue;
                        tgtGCPPositionBuffer.setElemFloatAt(tgtGCPPositionTile.getDataBufferIndex(x, y), (float)this.velocityData.velocity[i][j]);
                    }
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    private synchronized void computeVelocity() {
        if (this.velocityAvailable) {
            return;
        }
        this.computeSlaveGCPs();
        this.computeGCPOffsets();
        if (this.spatialAverage) {
            this.averageOffsets();
        }
        if (this.fillHoles) {
            this.fillHoles();
        }
        this.computeGCPVelocities();
        this.AddVelocitiesAsVectors();
        this.writeGCPsToMetadata();
        this.velocityAvailable = true;
    }

    private void computeSlaveGCPs() {
        try {
            ArrayList<GCPData> gcpList = new ArrayList<GCPData>();
            for (int i = 0; i < this.numGCPsPerAzLine; ++i) {
                for (int j = 0; j < this.numGCPsPerRgLine; ++j) {
                    PixelPos mGCP = new PixelPos(this.velocityData.mstGCPx[i][j], this.velocityData.mstGCPy[i][j]);
                    if (!this.checkGCPValidity(mGCP)) continue;
                    gcpList.add(new GCPData(mGCP, i, j));
                }
            }
            StatusProgressMonitor status = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
            status.beginTask("Computing slave GCPs... ", gcpList.size());
            ThreadManager threadManager = new ThreadManager();
            for (final GCPData gcpData : gcpList) {
                this.checkForCancellation();
                Thread worker = new Thread(){

                    @Override
                    public void run() {
                        PixelPos sGCP = new PixelPos(gcpData.mGCP.x, gcpData.mGCP.y);
                        boolean getSlaveGCP = OffsetTrackingOp.this.getOffsets(gcpData.mGCP, sGCP);
                        if (getSlaveGCP) {
                            this.saveSlaveGCP(sGCP);
                        }
                    }

                    private synchronized void saveSlaveGCP(PixelPos sGCP) {
                        ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.slvGCPx[gcpData.i][gcpData.j] = sGCP.x;
                        ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.slvGCPy[gcpData.i][gcpData.j] = sGCP.y;
                    }
                };
                threadManager.add(worker);
                status.worked(1);
            }
            status.done();
            threadManager.finish();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"computeGCPsByXCorrelation", (Throwable)e);
        }
    }

    private void computeGCPOffsets() {
        StatusProgressMonitor status = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
        status.beginTask("Compute Offsets... ", this.numGCPsPerAzLine * this.numGCPsPerRgLine);
        ThreadManager threadManager = new ThreadManager();
        try {
            for (int i = 0; i < this.numGCPsPerAzLine; ++i) {
                for (int j = 0; j < this.numGCPsPerRgLine; ++j) {
                    this.checkForCancellation();
                    final int iIdx = i;
                    final int jIdx = j;
                    if (this.velocityData.slvGCPx[i][j] == -9999.0 || this.velocityData.slvGCPy[i][j] == -9999.0) continue;
                    Thread worker = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Override
                        public void run() {
                            double yShift;
                            double xShift = (((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.mstGCPx[iIdx][jIdx] - ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.slvGCPx[iIdx][jIdx]) * OffsetTrackingOp.this.rangeSpacing;
                            double offset = Math.sqrt(xShift * xShift + (yShift = (((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.mstGCPy[iIdx][jIdx] - ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.slvGCPy[iIdx][jIdx]) * OffsetTrackingOp.this.azimuthSpacing) * yShift);
                            if (offset <= OffsetTrackingOp.this.maxOffset) {
                                this.saveOffset(xShift, yShift);
                                return;
                            }
                            double[][] dArray = ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.slvGCPx;
                            synchronized (((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.slvGCPx) {
                                ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.slvGCPx[iIdx][jIdx] = -9999.0;
                                ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.slvGCPy[iIdx][jIdx] = -9999.0;
                                // ** MonitorExit[var7_4] (shouldn't be in output)
                                return;
                            }
                        }

                        private synchronized void saveOffset(double xShift, double yShift) {
                            ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.rangeShift[iIdx][jIdx] = xShift;
                            ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.azimuthShift[iIdx][jIdx] = yShift;
                        }
                    };
                    threadManager.add(worker);
                    status.worked(1);
                }
            }
            status.done();
            threadManager.finish();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"computeGCPOffsets", (Throwable)e);
        }
    }

    private void averageOffsets() {
        StatusProgressMonitor status = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
        status.beginTask("Average Offsets... ", this.numGCPsPerAzLine * this.numGCPsPerRgLine);
        ThreadManager threadManager = new ThreadManager();
        try {
            for (int i = 0; i < this.numGCPsPerAzLine; ++i) {
                for (int j = 0; j < this.numGCPsPerRgLine; ++j) {
                    this.checkForCancellation();
                    final int iIdx = i;
                    final int jIdx = j;
                    if (this.velocityData.slvGCPx[i][j] == -9999.0 || this.velocityData.slvGCPy[i][j] == -9999.0) continue;
                    Thread worker = new Thread(){

                        @Override
                        public void run() {
                            int i0 = Math.max(iIdx - OffsetTrackingOp.this.halfAvgWindowSize, 0);
                            int iN = Math.min(iIdx + OffsetTrackingOp.this.halfAvgWindowSize, OffsetTrackingOp.this.numGCPsPerAzLine - 1);
                            int j0 = Math.max(jIdx - OffsetTrackingOp.this.halfAvgWindowSize, 0);
                            int jN = Math.min(jIdx + OffsetTrackingOp.this.halfAvgWindowSize, OffsetTrackingOp.this.numGCPsPerRgLine - 1);
                            int count = 0;
                            double rangeShiftSum = 0.0;
                            double azimuthShiftSum = 0.0;
                            for (int ii = i0; ii <= iN; ++ii) {
                                for (int jj = j0; jj <= jN; ++jj) {
                                    if (((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.slvGCPx[ii][jj] == -9999.0 || ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.slvGCPy[ii][jj] == -9999.0) continue;
                                    rangeShiftSum += ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.rangeShift[ii][jj];
                                    azimuthShiftSum += ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.azimuthShift[ii][jj];
                                    ++count;
                                }
                            }
                            if (count > 0) {
                                double xShift = rangeShiftSum / (double)count;
                                double yShift = azimuthShiftSum / (double)count;
                                double slvGCPx = ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.mstGCPx[iIdx][jIdx] - xShift / OffsetTrackingOp.this.rangeSpacing;
                                double slvGCPy = ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.mstGCPy[iIdx][jIdx] - yShift / OffsetTrackingOp.this.azimuthSpacing;
                                this.saveOffset(xShift, yShift, slvGCPx, slvGCPy);
                            }
                        }

                        private synchronized void saveOffset(double xShift, double yShift, double slvGCPx, double slvGCPy) {
                            ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.rangeShift[iIdx][jIdx] = xShift;
                            ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.azimuthShift[iIdx][jIdx] = yShift;
                            ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.slvGCPx[iIdx][jIdx] = slvGCPx;
                            ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.slvGCPy[iIdx][jIdx] = slvGCPy;
                        }
                    };
                    threadManager.add(worker);
                    status.worked(1);
                }
            }
            status.done();
            threadManager.finish();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"averageOffsets", (Throwable)e);
        }
    }

    private void fillHoles() {
        StatusProgressMonitor status = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
        status.beginTask("Fill Holes... ", this.numGCPsPerAzLine * this.numGCPsPerRgLine);
        ThreadManager threadManager = new ThreadManager();
        try {
            final ArrayList<int[]> holeList = new ArrayList<int[]>();
            for (int i = 0; i < this.numGCPsPerAzLine; ++i) {
                for (int j = 0; j < this.numGCPsPerRgLine; ++j) {
                    if (this.velocityData.slvGCPx[i][j] != -9999.0 && this.velocityData.slvGCPy[i][j] != -9999.0) continue;
                    holeList.add(new int[]{i, j});
                }
            }
            for (int k = 0; k < holeList.size(); ++k) {
                this.checkForCancellation();
                final int iIdx = ((int[])holeList.get(k))[0];
                final int jIdx = ((int[])holeList.get(k))[1];
                Thread worker = new Thread(){

                    @Override
                    public void run() {
                        int i0 = Math.max(iIdx - OffsetTrackingOp.this.radius, 0);
                        int iN = Math.min(iIdx + OffsetTrackingOp.this.radius, OffsetTrackingOp.this.numGCPsPerAzLine - 1);
                        int j0 = Math.max(jIdx - OffsetTrackingOp.this.radius, 0);
                        int jN = Math.min(jIdx + OffsetTrackingOp.this.radius, OffsetTrackingOp.this.numGCPsPerRgLine - 1);
                        double xShiftMean = 0.0;
                        double yShiftMean = 0.0;
                        double totalWeight = 0.0;
                        for (int ii = i0; ii <= iN; ++ii) {
                            for (int jj = j0; jj <= jN; ++jj) {
                                if (this.inList(ii, jj)) continue;
                                double w = 1.0 / (double)Math.max(Math.abs(ii - iIdx), Math.abs(jj - jIdx));
                                xShiftMean += w * ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.rangeShift[ii][jj];
                                yShiftMean += w * ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.azimuthShift[ii][jj];
                                totalWeight += w;
                            }
                        }
                        if (totalWeight != 0.0) {
                            double slvGCPx = ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.mstGCPx[iIdx][jIdx] - (xShiftMean /= totalWeight) / OffsetTrackingOp.this.rangeSpacing;
                            double slvGCPy = ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.mstGCPy[iIdx][jIdx] - (yShiftMean /= totalWeight) / OffsetTrackingOp.this.azimuthSpacing;
                            this.saveOffset(xShiftMean, yShiftMean, slvGCPx, slvGCPy);
                        }
                    }

                    private boolean inList(int ii, int jj) {
                        for (int[] aHoleList : holeList) {
                            if (aHoleList[0] != ii || aHoleList[1] != jj) continue;
                            return true;
                        }
                        return false;
                    }

                    private synchronized void saveOffset(double xShift, double yShift, double slvGCPx, double slvGCPy) {
                        ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.rangeShift[iIdx][jIdx] = xShift;
                        ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.azimuthShift[iIdx][jIdx] = yShift;
                        ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.slvGCPx[iIdx][jIdx] = slvGCPx;
                        ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.slvGCPy[iIdx][jIdx] = slvGCPy;
                    }
                };
                threadManager.add(worker);
                status.worked(1);
            }
            status.done();
            threadManager.finish();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"fillHoles", (Throwable)e);
        }
    }

    private void computeGCPVelocities() {
        StatusProgressMonitor status = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
        status.beginTask("Compute Velocities... ", this.numGCPsPerAzLine * this.numGCPsPerRgLine);
        ThreadManager threadManager = new ThreadManager();
        try {
            for (int i = 0; i < this.numGCPsPerAzLine; ++i) {
                for (int j = 0; j < this.numGCPsPerRgLine; ++j) {
                    this.checkForCancellation();
                    final int iIdx = i;
                    final int jIdx = j;
                    if (this.velocityData.slvGCPx[i][j] == -9999.0 || this.velocityData.slvGCPy[i][j] == -9999.0) continue;
                    Thread worker = new Thread(){

                        @Override
                        public void run() {
                            double xShift = ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.rangeShift[iIdx][jIdx];
                            double yShift = ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.azimuthShift[iIdx][jIdx];
                            double v = Math.sqrt(xShift * xShift + yShift * yShift) / OffsetTrackingOp.this.acquisitionTimeInterval;
                            this.saveVelocity(v);
                        }

                        private synchronized void saveVelocity(double v) {
                            ((OffsetTrackingOp)OffsetTrackingOp.this).velocityData.velocity[iIdx][jIdx] = v;
                        }
                    };
                    threadManager.add(worker);
                    status.worked(1);
                }
            }
            status.done();
            threadManager.finish();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"computeGCPVelocities", (Throwable)e);
        }
    }

    private boolean checkGCPValidity(PixelPos pixelPos) {
        boolean valid;
        boolean bl = valid = pixelPos.x - (double)this.cHalfWindowWidth + 1.0 >= 0.0 && pixelPos.x + (double)this.cHalfWindowWidth <= (double)(this.sourceImageWidth - 1) && pixelPos.y - (double)this.cHalfWindowHeight + 1.0 >= 0.0 && pixelPos.y + (double)this.cHalfWindowHeight <= (double)(this.sourceImageHeight - 1);
        if (valid && this.roiVector != null && !this.roiVector.isEmpty()) {
            Mask mask = (Mask)this.sourceProduct.getMaskGroup().get(this.roiVector);
            valid = mask.getSampleInt((int)pixelPos.x, (int)pixelPos.y) != 0;
        }
        return valid;
    }

    private boolean getOffsets(PixelPos mGCPPixelPos, PixelPos sGCPPixelPos) {
        try {
            ComplexDoubleMatrix mI = this.getComplexDoubleMatrix(this.masterBand, null, mGCPPixelPos, this.corrWin);
            ComplexDoubleMatrix sI = this.getComplexDoubleMatrix(this.slaveBand, null, sGCPPixelPos, this.corrWin);
            double[] coarseOffset = new double[]{0.0, 0.0};
            double coherence = CoregistrationUtils.crossCorrelateFFT((double[])coarseOffset, (ComplexDoubleMatrix)mI, (ComplexDoubleMatrix)sI, (int)this.corrWin.ovsFactor, (int)this.corrWin.accY, (int)this.corrWin.accX);
            if (coherence < this.xCorrThreshold) {
                return false;
            }
            sGCPPixelPos.x += coarseOffset[1];
            sGCPPixelPos.y += coarseOffset[0];
            return true;
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)(this.getId() + " getOffsets "), (Throwable)e);
            return false;
        }
    }

    private void dumpComplexMatrix(ComplexDoubleMatrix I, String title) {
        System.out.println(title);
        int numRows = I.rows;
        int numCols = I.columns;
        for (int r = 0; r < numRows; ++r) {
            for (int c = 0; c < numCols; ++c) {
                ComplexDouble v = I.get(r, c);
                System.out.print(v.real() + ", ");
            }
            System.out.println();
        }
        System.out.println();
    }

    private ComplexDoubleMatrix getComplexDoubleMatrix(Band band1, Band band2, PixelPos pixelPos, CrossCorrelationOp.CorrelationWindow corrWindow) {
        Rectangle rectangle = corrWindow.defineRectangleMask(pixelPos);
        Tile tileReal = this.getSourceTile((RasterDataNode)band1, rectangle);
        Tile tileImag = null;
        if (band2 != null) {
            tileImag = this.getSourceTile((RasterDataNode)band2, rectangle);
        }
        return TileUtilsDoris.pullComplexDoubleMatrix((Tile)tileReal, tileImag);
    }

    private void writeGCPsToMetadata() {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        String suffix = StackUtils.getBandSuffix((String)this.slaveBand.getName());
        String velocityBandName = "Velocity" + suffix;
        MetadataElement bandElem = AbstractMetadata.getBandAbsMetadata((MetadataElement)absRoot, (String)velocityBandName, (boolean)true);
        MetadataElement warpDataElem = bandElem.getElement("WarpData");
        if (warpDataElem == null) {
            warpDataElem = new MetadataElement("WarpData");
            bandElem.addElement(warpDataElem);
        } else {
            MetadataAttribute[] attribList;
            for (MetadataAttribute attrib : attribList = warpDataElem.getAttributes()) {
                warpDataElem.removeAttribute(attrib);
            }
        }
        int k = 0;
        for (int i = 0; i < this.numGCPsPerAzLine; ++i) {
            for (int j = 0; j < this.numGCPsPerRgLine; ++j) {
                if (this.velocityData.slvGCPx[i][j] == -9999.0 || this.velocityData.slvGCPx[i][j] == -9999.0) continue;
                MetadataElement gcpElem = new MetadataElement("GCP" + k);
                warpDataElem.addElement(gcpElem);
                gcpElem.setAttributeDouble("mst_x", this.velocityData.mstGCPx[i][j]);
                gcpElem.setAttributeDouble("mst_y", this.velocityData.mstGCPy[i][j]);
                gcpElem.setAttributeDouble("slv_x", this.velocityData.slvGCPx[i][j]);
                gcpElem.setAttributeDouble("slv_y", this.velocityData.slvGCPy[i][j]);
                ++k;
            }
        }
    }

    private SimpleFeatureType createFeatureType() {
        ArrayList<AttributeDescriptorImpl> attributeDescriptors = new ArrayList<AttributeDescriptorImpl>();
        attributeDescriptors.add(VectorUtils.createAttribute((String)ATTRIB_MST_LAT, Double.class));
        attributeDescriptors.add(VectorUtils.createAttribute((String)ATTRIB_MST_LON, Double.class));
        attributeDescriptors.add(VectorUtils.createAttribute((String)ATTRIB_SLV_LAT, Double.class));
        attributeDescriptors.add(VectorUtils.createAttribute((String)ATTRIB_SLV_LON, Double.class));
        attributeDescriptors.add(VectorUtils.createAttribute((String)ATTRIB_DISTANCE, Double.class));
        attributeDescriptors.add(VectorUtils.createAttribute((String)ATTRIB_VELOCITY, Double.class));
        attributeDescriptors.add(VectorUtils.createAttribute((String)ATTRIB_HEADING, Double.class));
        attributeDescriptors.add(VectorUtils.createAttribute((String)ATTRIB_RANGE_SHIFT, Double.class));
        attributeDescriptors.add(VectorUtils.createAttribute((String)ATTRIB_AZIMUTH_SHIFT, Double.class));
        return VectorUtils.createFeatureType((Product)this.targetProduct, (String)"Velocity", attributeDescriptors);
    }

    private synchronized void AddVelocitiesAsVectors() {
        VectorDataNode vectorDataNode = (VectorDataNode)this.targetProduct.getVectorDataGroup().get("Velocity");
        if (vectorDataNode == null) {
            vectorDataNode = new VectorDataNode("Velocity", this.windFeatureType);
            this.targetProduct.getVectorDataGroup().add((ProductNode)vectorDataNode);
        }
        FeatureCollection collection = vectorDataNode.getFeatureCollection();
        GeometryFactory geometryFactory = new GeometryFactory();
        GeoCoding geoCoding = this.targetProduct.getSceneGeoCoding();
        GeoPos mstGeoPos = new GeoPos();
        GeoPos slvGeoPos = new GeoPos();
        int c = collection.size();
        for (int i = 0; i < this.numGCPsPerAzLine; ++i) {
            for (int j = 0; j < this.numGCPsPerRgLine; ++j) {
                if (this.velocityData.slvGCPx[i][j] == -9999.0 || this.velocityData.slvGCPx[i][j] == -9999.0) continue;
                String name = "post_" + c;
                Point p = geometryFactory.createPoint(new Coordinate(this.velocityData.mstGCPx[i][j], this.velocityData.mstGCPy[i][j]));
                SimpleFeature feature = PlainFeatureFactory.createPlainFeature((SimpleFeatureType)this.windFeatureType, (String)name, (Geometry)p, (String)STYLE_FORMAT);
                geoCoding.getGeoPos(new PixelPos(this.velocityData.mstGCPx[i][j], this.velocityData.mstGCPy[i][j]), mstGeoPos);
                geoCoding.getGeoPos(new PixelPos(this.velocityData.slvGCPx[i][j], this.velocityData.slvGCPy[i][j]), slvGeoPos);
                GeoUtils.DistanceHeading heading = GeoUtils.vincenty_inverse((double)mstGeoPos.lat, (double)mstGeoPos.lon, (double)slvGeoPos.lat, (double)slvGeoPos.lon);
                feature.setAttribute(ATTRIB_MST_LAT, (Object)mstGeoPos.lat);
                feature.setAttribute(ATTRIB_MST_LON, (Object)mstGeoPos.lon);
                feature.setAttribute(ATTRIB_SLV_LAT, (Object)slvGeoPos.lat);
                feature.setAttribute(ATTRIB_SLV_LON, (Object)slvGeoPos.lon);
                feature.setAttribute(ATTRIB_DISTANCE, (Object)heading.distance);
                feature.setAttribute(ATTRIB_HEADING, (Object)heading.heading1);
                feature.setAttribute(ATTRIB_VELOCITY, (Object)this.velocityData.velocity[i][j]);
                feature.setAttribute(ATTRIB_RANGE_SHIFT, (Object)this.velocityData.rangeShift[i][j]);
                feature.setAttribute(ATTRIB_AZIMUTH_SHIFT, (Object)this.velocityData.azimuthShift[i][j]);
                collection.add((Feature)feature);
                ++c;
            }
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(OffsetTrackingOp.class);
        }
    }

    private static class ResamplingRaster
    implements Resampling.Raster {
        private final Tile tile;
        private final double[][] data;
        private final boolean usesNoData;
        private final boolean scalingApplied;
        private final double noDataValue;
        private final double geophysicalNoDataValue;

        public ResamplingRaster(Tile tile, double[][] data) {
            this.tile = tile;
            this.data = data;
            RasterDataNode rasterDataNode = tile.getRasterDataNode();
            this.usesNoData = rasterDataNode.isNoDataValueUsed();
            this.noDataValue = rasterDataNode.getNoDataValue();
            this.geophysicalNoDataValue = rasterDataNode.getGeophysicalNoDataValue();
            this.scalingApplied = rasterDataNode.isScalingApplied();
        }

        public final int getWidth() {
            return this.tile.getWidth();
        }

        public final int getHeight() {
            return this.tile.getHeight();
        }

        public boolean getSamples(int[] x, int[] y, double[][] samples) throws Exception {
            boolean allValid = true;
            try {
                for (int i = 0; i < y.length; ++i) {
                    for (int j = 0; j < x.length; ++j) {
                        double val = this.data[y[i]][x[j]];
                        if (this.usesNoData && (this.scalingApplied && this.geophysicalNoDataValue == val || this.noDataValue == val)) {
                            val = Double.NaN;
                            allValid = false;
                        }
                        samples[i][j] = val;
                    }
                }
            }
            catch (Exception e) {
                SystemUtils.LOG.severe(e.getMessage());
                allValid = false;
            }
            return allValid;
        }
    }

    public static class VelocityData {
        public final double[][] mstGCPx;
        public final double[][] mstGCPy;
        public final double[][] slvGCPx;
        public final double[][] slvGCPy;
        public final double[][] velocity;
        public final double[][] rangeShift;
        public final double[][] azimuthShift;

        public VelocityData(int numGCPsPerAzimuthLine, int numGCPsPerRangeLine) {
            this.mstGCPx = new double[numGCPsPerAzimuthLine][numGCPsPerRangeLine];
            this.mstGCPy = new double[numGCPsPerAzimuthLine][numGCPsPerRangeLine];
            this.slvGCPx = new double[numGCPsPerAzimuthLine][numGCPsPerRangeLine];
            this.slvGCPy = new double[numGCPsPerAzimuthLine][numGCPsPerRangeLine];
            this.rangeShift = new double[numGCPsPerAzimuthLine][numGCPsPerRangeLine];
            this.azimuthShift = new double[numGCPsPerAzimuthLine][numGCPsPerRangeLine];
            this.velocity = new double[numGCPsPerAzimuthLine][numGCPsPerRangeLine];
        }
    }

    private static class GCPData {
        final PixelPos mGCP;
        final int i;
        final int j;

        GCPData(PixelPos gcp, int i, int j) {
            this.mGCP = gcp;
            this.i = i;
            this.j = j;
        }
    }
}

