/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.BorderExtender;
import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.insar.gpf.support.Sentinel1Utils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.PosVector;
import org.esa.snap.engine_utilities.eo.GeoUtils;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.engine_utilities.gpf.StackUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;
import org.jblas.ComplexDouble;
import org.jblas.ComplexDoubleMatrix;
import org.jblas.DoubleMatrix;
import org.jblas.MatrixFunctions;
import org.jblas.Solve;
import org.jlinda.core.Orbit;
import org.jlinda.core.Point;
import org.jlinda.core.SLCImage;
import org.jlinda.core.Window;
import org.jlinda.core.utils.MathUtils;
import org.jlinda.core.utils.PolyUtils;
import org.jlinda.core.utils.SarUtils;
import org.jlinda.nest.utils.BandUtilsDoris;
import org.jlinda.nest.utils.CplxContainer;
import org.jlinda.nest.utils.ProductContainer;
import org.jlinda.nest.utils.TileUtilsDoris;

@OperatorMetadata(alias="Interferogram", category="Radar/Interferometric/Products", authors="Petar Marinkovic, Jun Lu", version="1.0", description="Compute interferograms from stack of coregistered S-1 images", internal=false)
public class InterferogramOp
extends Operator {
    @SourceProduct
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(defaultValue="true", label="Subtract flat-earth phase")
    private boolean subtractFlatEarthPhase = true;
    @Parameter(valueSet={"1", "2", "3", "4", "5", "6", "7", "8"}, description="Order of 'Flat earth phase' polynomial", defaultValue="5", label="Degree of \"Flat Earth\" polynomial")
    private int srpPolynomialDegree = 5;
    @Parameter(valueSet={"301", "401", "501", "601", "701", "801", "901", "1001"}, description="Number of points for the 'flat earth phase' polynomial estimation", defaultValue="501", label="Number of \"Flat Earth\" estimation points")
    private int srpNumberPoints = 501;
    @Parameter(valueSet={"1", "2", "3", "4", "5"}, description="Degree of orbit (polynomial) interpolator", defaultValue="3", label="Orbit interpolation degree")
    private int orbitDegree = 3;
    @Parameter(defaultValue="true", label="Include coherence estimation")
    private boolean includeCoherence = true;
    @Parameter(description="Size of coherence estimation window in Azimuth direction", defaultValue="10", label="Coherence Azimuth Window Size")
    private int cohWinAz = 10;
    @Parameter(description="Size of coherence estimation window in Range direction", defaultValue="10", label="Coherence Range Window Size")
    private int cohWinRg = 10;
    @Parameter(description="Use ground square pixel", defaultValue="true", label="Square Pixel")
    private Boolean squarePixel = true;
    private Map<String, DoubleMatrix> flatEarthPolyMap = new HashMap<String, DoubleMatrix>();
    private boolean flatEarthEstimated = false;
    private Map<String, CplxContainer> masterMap = new HashMap<String, CplxContainer>();
    private Map<String, CplxContainer> slaveMap = new HashMap<String, CplxContainer>();
    private String[] polarisations;
    private String[] subswaths = new String[]{""};
    private Map<String, ProductContainer> targetMap = new HashMap<String, ProductContainer>();
    private String productTag = "ifg";
    private int sourceImageWidth;
    private int sourceImageHeight;
    private boolean isTOPSARBurstProduct = false;
    private Sentinel1Utils su = null;
    private Sentinel1Utils.SubSwathInfo[] subSwath = null;
    private int numSubSwaths = 0;
    private Point[] mstSceneCentreXYZ = null;
    private int subSwathIndex = 0;
    private MetadataElement mstRoot = null;
    private static final boolean CREATE_VIRTUAL_BAND = true;
    private static final boolean OUTPUT_FLAT_EARTH_PHASE = false;
    private static final String PRODUCT_SUFFIX = "_Ifg";

    public void initialize() throws OperatorException {
        try {
            this.mstRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            this.checkUserInput();
            this.constructSourceMetadata();
            this.constructTargetMetadata();
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void checkUserInput() {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSARProduct();
            validator.checkIfCoregisteredStack();
            validator.checkIfSLC();
            boolean bl = this.isTOPSARBurstProduct = !validator.isDebursted();
            if (this.isTOPSARBurstProduct) {
                MetadataElement[] slaveRoot;
                String mProcSysId = this.mstRoot.getAttributeString("Processing_system_identifier");
                float mVersion = Float.valueOf(mProcSysId.substring(mProcSysId.lastIndexOf(32))).floatValue();
                MetadataElement slaveElem = this.sourceProduct.getMetadataRoot().getElement("Slave_Metadata");
                if (slaveElem == null) {
                    slaveElem = this.sourceProduct.getMetadataRoot().getElement("Slave Metadata");
                }
                for (MetadataElement slvRoot : slaveRoot = slaveElem.getElements()) {
                    String sProcSysId = slvRoot.getAttributeString("Processing_system_identifier");
                    float sVersion = Float.valueOf(sProcSysId.substring(sProcSysId.lastIndexOf(32))).floatValue();
                    if (!((double)mVersion < 2.43 && (double)sVersion >= 2.43 && this.mstRoot.getAttribute("EAP Correction") == null) && (!((double)sVersion < 2.43) || !((double)mVersion >= 2.43) || slvRoot.getAttribute("EAP Correction") != null)) continue;
                    throw new OperatorException("Source products cannot be InSAR pairs: one is EAP phase corrected and the other is not. Apply EAP Correction.");
                }
                this.su = new Sentinel1Utils(this.sourceProduct);
                this.subswaths = this.su.getSubSwathNames();
                this.subSwath = this.su.getSubSwath();
                this.numSubSwaths = this.su.getNumOfSubSwath();
                this.subSwathIndex = 1;
            }
            this.polarisations = OperatorUtils.getPolarisations((Product)this.sourceProduct);
            if (this.polarisations.length == 0) {
                this.polarisations = new String[]{""};
            }
            this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
            this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
        }
        catch (Exception e) {
            throw new OperatorException((Throwable)e);
        }
    }

    private void getMstApproxSceneCentreXYZ() throws Exception {
        int numOfBursts = this.subSwath[this.subSwathIndex - 1].numOfBursts;
        this.mstSceneCentreXYZ = new Point[numOfBursts];
        for (int b = 0; b < numOfBursts; ++b) {
            double firstLineTime = this.subSwath[this.subSwathIndex - 1].burstFirstLineTime[b];
            double lastLineTime = this.subSwath[this.subSwathIndex - 1].burstLastLineTime[b];
            double slrTimeToFirstPixel = this.subSwath[this.subSwathIndex - 1].slrTimeToFirstPixel;
            double slrTimeToLastPixel = this.subSwath[this.subSwathIndex - 1].slrTimeToLastPixel;
            double latUL = this.su.getLatitude(firstLineTime, slrTimeToFirstPixel, this.subSwathIndex);
            double latUR = this.su.getLatitude(firstLineTime, slrTimeToLastPixel, this.subSwathIndex);
            double latLL = this.su.getLatitude(lastLineTime, slrTimeToFirstPixel, this.subSwathIndex);
            double latLR = this.su.getLatitude(lastLineTime, slrTimeToLastPixel, this.subSwathIndex);
            double lonUL = this.su.getLongitude(firstLineTime, slrTimeToFirstPixel, this.subSwathIndex);
            double lonUR = this.su.getLongitude(firstLineTime, slrTimeToLastPixel, this.subSwathIndex);
            double lonLL = this.su.getLongitude(lastLineTime, slrTimeToFirstPixel, this.subSwathIndex);
            double lonLR = this.su.getLongitude(lastLineTime, slrTimeToLastPixel, this.subSwathIndex);
            double lat = (latUL + latUR + latLL + latLR) / 4.0;
            double lon = (lonUL + lonUR + lonLL + lonLR) / 4.0;
            PosVector mstSceneCenter = new PosVector();
            GeoUtils.geo2xyzWGS84((double)lat, (double)lon, (double)0.0, (PosVector)mstSceneCenter);
            this.mstSceneCentreXYZ[b] = new Point(mstSceneCenter.toArray());
        }
    }

    private void constructFlatEarthPolynomials() throws Exception {
        for (String keyMaster : this.masterMap.keySet()) {
            CplxContainer master = this.masterMap.get(keyMaster);
            for (String keySlave : this.slaveMap.keySet()) {
                CplxContainer slave = this.slaveMap.get(keySlave);
                this.flatEarthPolyMap.put(slave.name, InterferogramOp.estimateFlatEarthPolynomial(master.metaData, master.orbit, slave.metaData, slave.orbit, this.sourceImageWidth, this.sourceImageHeight, this.srpPolynomialDegree, this.srpNumberPoints, this.sourceProduct));
            }
        }
    }

    private void constructFlatEarthPolynomialsForTOPSARProduct() throws Exception {
        for (String keyMaster : this.masterMap.keySet()) {
            CplxContainer master = this.masterMap.get(keyMaster);
            for (String keySlave : this.slaveMap.keySet()) {
                CplxContainer slave = this.slaveMap.get(keySlave);
                for (int s = 0; s < this.numSubSwaths; ++s) {
                    int numBursts = this.subSwath[s].numOfBursts;
                    for (int b = 0; b < numBursts; ++b) {
                        String polynomialName = slave.name + '_' + s + '_' + b;
                        this.flatEarthPolyMap.put(polynomialName, InterferogramOp.estimateFlatEarthPolynomial(master, slave, s + 1, b, this.mstSceneCentreXYZ, this.orbitDegree, this.srpPolynomialDegree, this.srpNumberPoints, this.subSwath, this.su));
                    }
                }
            }
        }
    }

    private void constructTargetMetadata() {
        for (String keyMaster : this.masterMap.keySet()) {
            CplxContainer master = this.masterMap.get(keyMaster);
            for (String keySlave : this.slaveMap.keySet()) {
                CplxContainer slave = this.slaveMap.get(keySlave);
                if (master.polarisation != null && !master.polarisation.equals(slave.polarisation)) continue;
                String productName = keyMaster + '_' + keySlave;
                ProductContainer product = new ProductContainer(productName, master, slave, true);
                this.targetMap.put(productName, product);
            }
        }
    }

    private void constructSourceMetadata() throws Exception {
        MetadataElement[] slaveRoot;
        String masterTag = "mst";
        String slaveTag = "slv";
        String slaveMetadataRoot = "Slave_Metadata";
        this.metaMapPut("mst", this.mstRoot, this.sourceProduct, this.masterMap);
        MetadataElement slaveElem = this.sourceProduct.getMetadataRoot().getElement("Slave_Metadata");
        if (slaveElem == null) {
            slaveElem = this.sourceProduct.getMetadataRoot().getElement("Slave Metadata");
        }
        for (MetadataElement meta : slaveRoot = slaveElem.getElements()) {
            this.metaMapPut("slv", meta, this.sourceProduct, this.slaveMap);
        }
    }

    private void metaMapPut(String tag, MetadataElement root, Product product, Map<String, CplxContainer> map) throws Exception {
        for (String swath : this.subswaths) {
            String subswath = swath.isEmpty() ? "" : '_' + swath.toUpperCase();
            for (String polarisation : this.polarisations) {
                String pol = polarisation.isEmpty() ? "" : '_' + polarisation.toUpperCase();
                String mapKey = root.getAttributeInt("ABS_ORBIT") + subswath + pol;
                String date = OperatorUtils.getAcquisitionDate((MetadataElement)root);
                SLCImage meta = new SLCImage(root, product);
                Orbit orbit = new Orbit(root, this.orbitDegree);
                meta.setMlAz(1);
                meta.setMlRg(1);
                Band bandReal = null;
                Band bandImag = null;
                for (String bandName : product.getBandNames()) {
                    if (!bandName.contains(tag) || !bandName.contains(date) || !subswath.isEmpty() && !bandName.contains(subswath) || !pol.isEmpty() && !bandName.contains(pol)) continue;
                    Band band = product.getBand(bandName);
                    if (BandUtilsDoris.isBandReal((Band)band)) {
                        bandReal = band;
                        continue;
                    }
                    if (!BandUtilsDoris.isBandImag((Band)band)) continue;
                    bandImag = band;
                }
                if (bandReal == null || bandImag == null) continue;
                map.put(mapKey, new CplxContainer(date, meta, orbit, bandReal, bandImag));
            }
        }
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName() + PRODUCT_SUFFIX, this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        for (String key : this.targetMap.keySet()) {
            ArrayList<String> targetBandNames = new ArrayList<String>();
            ProductContainer container = this.targetMap.get(key);
            CplxContainer master = container.sourceMaster;
            CplxContainer slave = container.sourceSlave;
            String subswath = master.subswath.isEmpty() ? "" : '_' + master.subswath.toUpperCase();
            String pol = InterferogramOp.getPolarisationTag(master);
            String tag = subswath + pol + '_' + master.date + '_' + slave.date;
            String targetBandName_I = "i_" + this.productTag + tag;
            Band iBand = this.targetProduct.addBand(targetBandName_I, 30);
            container.addBand("real", iBand.getName());
            iBand.setUnit("real");
            targetBandNames.add(iBand.getName());
            String targetBandName_Q = "q_" + this.productTag + tag;
            Band qBand = this.targetProduct.addBand(targetBandName_Q, 30);
            container.addBand("imaginary", qBand.getName());
            qBand.setUnit("imaginary");
            targetBandNames.add(qBand.getName());
            String countStr = '_' + this.productTag + tag;
            ReaderUtils.createVirtualIntensityBand((Product)this.targetProduct, (Band)this.targetProduct.getBand(targetBandName_I), (Band)this.targetProduct.getBand(targetBandName_Q), (String)countStr);
            Band phaseBand = ReaderUtils.createVirtualPhaseBand((Product)this.targetProduct, (Band)this.targetProduct.getBand(targetBandName_I), (Band)this.targetProduct.getBand(targetBandName_Q), (String)countStr);
            this.targetProduct.setQuicklookBandName(phaseBand.getName());
            targetBandNames.add(phaseBand.getName());
            if (this.includeCoherence) {
                String targetBandCoh = "coh" + tag;
                Band coherenceBand = this.targetProduct.addBand(targetBandCoh, 30);
                coherenceBand.setNoDataValueUsed(true);
                coherenceBand.setNoDataValue(master.realBand.getNoDataValue());
                container.addBand("coherence", coherenceBand.getName());
                coherenceBand.setUnit("coherence");
                targetBandNames.add(coherenceBand.getName());
            }
            if (this.subtractFlatEarthPhase) {
                // empty if block
            }
            String slvProductName = StackUtils.findOriginalSlaveProductName((Product)this.sourceProduct, (Band)container.sourceSlave.realBand);
            StackUtils.saveSlaveProductBandNames((Product)this.targetProduct, (String)slvProductName, (String[])targetBandNames.toArray(new String[targetBandNames.size()]));
        }
    }

    public static String getPolarisationTag(CplxContainer master) {
        return master.polarisation == null || master.polarisation.isEmpty() ? "" : '_' + master.polarisation.toUpperCase();
    }

    public static DoubleMatrix estimateFlatEarthPolynomial(SLCImage masterMetadata, Orbit masterOrbit, SLCImage slaveMetadata, Orbit slaveOrbit, int sourceImageWidth, int sourceImageHeight, int srpPolynomialDegree, int srpNumberPoints, Product sourceProduct) throws Exception {
        long minLine = 0L;
        long maxLine = sourceImageHeight;
        long minPixel = 0L;
        long maxPixel = sourceImageWidth;
        int numberOfCoefficients = PolyUtils.numberOfCoefficients((int)srpPolynomialDegree);
        int[][] position = MathUtils.distributePoints((int)srpNumberPoints, (Window)new Window(minLine, maxLine, minPixel, maxPixel));
        DoubleMatrix y = new DoubleMatrix(srpNumberPoints);
        DoubleMatrix A = new DoubleMatrix(srpNumberPoints, numberOfCoefficients);
        double masterMinPi4divLam = -3.7673031346177063E9 / masterMetadata.getRadarWavelength();
        double slaveMinPi4divLam = -3.7673031346177063E9 / slaveMetadata.getRadarWavelength();
        boolean isBiStaticStack = StackUtils.isBiStaticStack((Product)sourceProduct);
        for (int i = 0; i < srpNumberPoints; ++i) {
            double line = position[i][0];
            double pixel = position[i][1];
            double masterTimeRange = masterMetadata.pix2tr(pixel + 1.0);
            Point xyzMaster = masterOrbit.lp2xyz(line + 1.0, pixel + 1.0, masterMetadata);
            Point slaveTimeVector = slaveOrbit.xyz2t(xyzMaster, slaveMetadata);
            double slaveTimeRange = isBiStaticStack ? 0.5 * (slaveTimeVector.x + masterTimeRange) : slaveTimeVector.x;
            y.put(i, masterMinPi4divLam * masterTimeRange - slaveMinPi4divLam * slaveTimeRange);
            double posL = PolyUtils.normalize2((double)line, (double)minLine, (double)maxLine);
            double posP = PolyUtils.normalize2((double)pixel, (double)minPixel, (double)maxPixel);
            int index = 0;
            for (int j = 0; j <= srpPolynomialDegree; ++j) {
                for (int k = 0; k <= j; ++k) {
                    A.put(i, index, FastMath.pow((double)posL, (double)(j - k)) * FastMath.pow((double)posP, (double)k));
                    ++index;
                }
            }
        }
        DoubleMatrix Atranspose = A.transpose();
        DoubleMatrix N = Atranspose.mmul(A);
        DoubleMatrix rhs = Atranspose.mmul(y);
        return Solve.solve((DoubleMatrix)N, (DoubleMatrix)rhs);
    }

    public static DoubleMatrix estimateFlatEarthPolynomial(CplxContainer master, CplxContainer slave, int subSwathIndex, int burstIndex, Point[] mstSceneCentreXYZ, int orbitDegree, int srpPolynomialDegree, int srpNumberPoints, Sentinel1Utils.SubSwathInfo[] subSwath, Sentinel1Utils su) throws Exception {
        double[][] masterOSV = InterferogramOp.getAdjacentOrbitStateVectors(master, mstSceneCentreXYZ[burstIndex]);
        double[][] slaveOSV = InterferogramOp.getAdjacentOrbitStateVectors(slave, mstSceneCentreXYZ[burstIndex]);
        Orbit masterOrbit = new Orbit(masterOSV, orbitDegree);
        Orbit slaveOrbit = new Orbit(slaveOSV, orbitDegree);
        long minLine = burstIndex * subSwath[subSwathIndex - 1].linesPerBurst;
        long maxLine = minLine + (long)subSwath[subSwathIndex - 1].linesPerBurst - 1L;
        long minPixel = 0L;
        long maxPixel = subSwath[subSwathIndex - 1].samplesPerBurst - 1;
        int numberOfCoefficients = PolyUtils.numberOfCoefficients((int)srpPolynomialDegree);
        int[][] position = MathUtils.distributePoints((int)srpNumberPoints, (Window)new Window(minLine, maxLine, minPixel, maxPixel));
        DoubleMatrix y = new DoubleMatrix(srpNumberPoints);
        DoubleMatrix A = new DoubleMatrix(srpNumberPoints, numberOfCoefficients);
        double masterMinPi4divLam = -3.7673031346177063E9 / master.metaData.getRadarWavelength();
        double slaveMinPi4divLam = -3.7673031346177063E9 / slave.metaData.getRadarWavelength();
        for (int i = 0; i < srpNumberPoints; ++i) {
            double line = position[i][0];
            double pixel = position[i][1];
            double mstRgTime = subSwath[subSwathIndex - 1].slrTimeToFirstPixel + pixel * su.rangeSpacing / 2.99792458E8;
            double mstAzTime = InterferogramOp.line2AzimuthTime(line, subSwathIndex, burstIndex, subSwath);
            Point xyzMaster = masterOrbit.lph2xyz(mstAzTime, mstRgTime, 0.0, mstSceneCentreXYZ[burstIndex]);
            Point slaveTimeVector = slaveOrbit.xyz2t(xyzMaster, slave.metaData.getSceneCentreAzimuthTime());
            double slaveTimeRange = slaveTimeVector.x;
            y.put(i, masterMinPi4divLam * mstRgTime - slaveMinPi4divLam * slaveTimeRange);
            double posL = PolyUtils.normalize2((double)line, (double)minLine, (double)maxLine);
            double posP = PolyUtils.normalize2((double)pixel, (double)minPixel, (double)maxPixel);
            int index = 0;
            for (int j = 0; j <= srpPolynomialDegree; ++j) {
                for (int k = 0; k <= j; ++k) {
                    A.put(i, index, FastMath.pow((double)posL, (double)(j - k)) * FastMath.pow((double)posP, (double)k));
                    ++index;
                }
            }
        }
        DoubleMatrix Atranspose = A.transpose();
        DoubleMatrix N = Atranspose.mmul(A);
        DoubleMatrix rhs = Atranspose.mmul(y);
        return Solve.solve((DoubleMatrix)N, (DoubleMatrix)rhs);
    }

    private static double[][] getAdjacentOrbitStateVectors(CplxContainer container, Point sceneCentreXYZ) {
        try {
            int edIdx;
            int stIdx;
            double[] time = container.orbit.getTime();
            double[] dataX = container.orbit.getData_X();
            double[] dataY = container.orbit.getData_Y();
            double[] dataZ = container.orbit.getData_Z();
            int numOfOSV = dataX.length;
            double minDistance = 0.0;
            int minIdx = 0;
            for (int i = 0; i < numOfOSV; ++i) {
                double dx = dataX[i] - sceneCentreXYZ.x;
                double dy = dataY[i] - sceneCentreXYZ.y;
                double dz = dataZ[i] - sceneCentreXYZ.z;
                double distance = Math.sqrt(dx * dx + dy * dy + dz * dz) / 1000.0;
                if (i == 0) {
                    minDistance = distance;
                    minIdx = i;
                    continue;
                }
                if (!(distance < minDistance)) continue;
                minDistance = distance;
                minIdx = i;
            }
            if (minIdx < 3) {
                stIdx = 0;
                edIdx = Math.min(7, numOfOSV - 1);
            } else if (minIdx > numOfOSV - 5) {
                stIdx = Math.max(numOfOSV - 8, 0);
                edIdx = numOfOSV - 1;
            } else {
                stIdx = minIdx - 3;
                edIdx = minIdx + 4;
            }
            double[][] adjacentOSV = new double[edIdx - stIdx + 1][4];
            int k = 0;
            for (int i = stIdx; i <= edIdx; ++i) {
                adjacentOSV[k][0] = time[i];
                adjacentOSV[k][1] = dataX[i];
                adjacentOSV[k][2] = dataY[i];
                adjacentOSV[k][3] = dataZ[i];
                ++k;
            }
            return adjacentOSV;
        }
        catch (Throwable e) {
            SystemUtils.LOG.warning("Unable to getAdjacentOrbitStateVectors " + e.getMessage());
            return null;
        }
    }

    private static double line2AzimuthTime(double line, int subSwathIndex, int burstIndex, Sentinel1Utils.SubSwathInfo[] subSwath) {
        double firstLineTimeInDays = subSwath[subSwathIndex - 1].burstFirstLineTime[burstIndex] / 86400.0;
        double firstLineTime = (firstLineTimeInDays - (double)((int)firstLineTimeInDays)) * 86400.0;
        return firstLineTime + (line - (double)(burstIndex * subSwath[subSwathIndex - 1].linesPerBurst)) * subSwath[subSwathIndex - 1].azimuthTimeInterval;
    }

    private synchronized void estimateFlatEarth() throws Exception {
        if (this.flatEarthEstimated) {
            return;
        }
        if (this.subtractFlatEarthPhase) {
            if (this.isTOPSARBurstProduct) {
                this.getMstApproxSceneCentreXYZ();
                this.constructFlatEarthPolynomialsForTOPSARProduct();
            } else {
                this.constructFlatEarthPolynomials();
            }
            this.flatEarthEstimated = true;
        }
    }

    public void computeTileStack(Map<Band, Tile> targetTileMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            if (this.subtractFlatEarthPhase && !this.flatEarthEstimated) {
                this.estimateFlatEarth();
            }
            if (this.isTOPSARBurstProduct) {
                this.computeTileStackForTOPSARProduct(targetTileMap, targetRectangle, pm);
            } else {
                this.computeTileStackForNormalProduct(targetTileMap, targetRectangle, pm);
            }
        }
        catch (Exception e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeTileStackForNormalProduct(Map<Band, Tile> targetTileMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            int cohx0 = targetRectangle.x - (this.cohWinRg - 1) / 2;
            int cohy0 = targetRectangle.y - (this.cohWinAz - 1) / 2;
            int cohw = targetRectangle.width + this.cohWinRg - 1;
            int cohh = targetRectangle.height + this.cohWinAz - 1;
            Rectangle rect = new Rectangle(cohx0, cohy0, cohw, cohh);
            BorderExtender border = BorderExtender.createInstance((int)0);
            int y0 = targetRectangle.y;
            int yN = y0 + targetRectangle.height - 1;
            int x0 = targetRectangle.x;
            int xN = targetRectangle.x + targetRectangle.width - 1;
            for (String ifgKey : this.targetMap.keySet()) {
                ProductContainer product = this.targetMap.get(ifgKey);
                Tile mstTileReal = this.getSourceTile((RasterDataNode)product.sourceMaster.realBand, targetRectangle, border);
                Tile mstTileImag = this.getSourceTile((RasterDataNode)product.sourceMaster.imagBand, targetRectangle, border);
                ComplexDoubleMatrix dataMaster = TileUtilsDoris.pullComplexDoubleMatrix((Tile)mstTileReal, (Tile)mstTileImag);
                Tile slvTileReal = this.getSourceTile((RasterDataNode)product.sourceSlave.realBand, targetRectangle, border);
                Tile slvTileImag = this.getSourceTile((RasterDataNode)product.sourceSlave.imagBand, targetRectangle, border);
                ComplexDoubleMatrix dataSlave = TileUtilsDoris.pullComplexDoubleMatrix((Tile)slvTileReal, (Tile)slvTileImag);
                double srcNoDataValue = product.sourceMaster.realBand.getNoDataValue();
                ComplexDoubleMatrix cohMatrix = null;
                if (this.includeCoherence) {
                    Tile mstTileReal2 = this.getSourceTile((RasterDataNode)product.sourceMaster.realBand, rect, border);
                    Tile mstTileImag2 = this.getSourceTile((RasterDataNode)product.sourceMaster.imagBand, rect, border);
                    Tile slvTileReal2 = this.getSourceTile((RasterDataNode)product.sourceSlave.realBand, rect, border);
                    Tile slvTileImag2 = this.getSourceTile((RasterDataNode)product.sourceSlave.imagBand, rect, border);
                    ComplexDoubleMatrix dataMaster2 = TileUtilsDoris.pullComplexDoubleMatrix((Tile)mstTileReal2, (Tile)mstTileImag2);
                    ComplexDoubleMatrix dataSlave2 = TileUtilsDoris.pullComplexDoubleMatrix((Tile)slvTileReal2, (Tile)slvTileImag2);
                    for (int i = 0; i < dataMaster2.length; ++i) {
                        double tmp = InterferogramOp.norm(dataMaster2.get(i));
                        dataMaster2.put(i, dataMaster2.get(i).mul(dataSlave2.get(i).conj()));
                        dataSlave2.put(i, new ComplexDouble(InterferogramOp.norm(dataSlave2.get(i)), tmp));
                    }
                    cohMatrix = SarUtils.cplxCoherence((ComplexDoubleMatrix)dataMaster2, (ComplexDoubleMatrix)dataSlave2, (int)this.cohWinAz, (int)this.cohWinRg);
                }
                ComplexDoubleMatrix complexReferencePhase = null;
                if (this.subtractFlatEarthPhase) {
                    DoubleMatrix rangeAxisNormalized = DoubleMatrix.linspace((int)x0, (int)xN, (int)dataMaster.columns);
                    rangeAxisNormalized = InterferogramOp.normalizeDoubleMatrix(rangeAxisNormalized, 0.0, this.sourceImageWidth - 1);
                    DoubleMatrix azimuthAxisNormalized = DoubleMatrix.linspace((int)y0, (int)yN, (int)dataMaster.rows);
                    azimuthAxisNormalized = InterferogramOp.normalizeDoubleMatrix(azimuthAxisNormalized, 0.0, this.sourceImageHeight - 1);
                    DoubleMatrix polyCoeffs = this.flatEarthPolyMap.get(product.sourceSlave.name);
                    DoubleMatrix realReferencePhase = PolyUtils.polyval((DoubleMatrix)azimuthAxisNormalized, (DoubleMatrix)rangeAxisNormalized, (DoubleMatrix)polyCoeffs, (int)PolyUtils.degreeFromCoefficients((int)polyCoeffs.length));
                    complexReferencePhase = new ComplexDoubleMatrix(MatrixFunctions.cos((DoubleMatrix)realReferencePhase), MatrixFunctions.sin((DoubleMatrix)realReferencePhase));
                    dataSlave.muli(complexReferencePhase);
                }
                dataMaster.muli(dataSlave.conji());
                DoubleMatrix cohDataReal = null;
                DoubleMatrix cohDataImag = null;
                ProductData tgtCohData = null;
                Object tgtCohPhaseData = null;
                if (this.includeCoherence) {
                    if (this.subtractFlatEarthPhase) {
                        cohMatrix.muli(complexReferencePhase.conji());
                    }
                    cohDataReal = cohMatrix.real();
                    cohDataImag = cohMatrix.imag();
                    Band tgtCohBand = this.targetProduct.getBand(product.getBandName("coherence"));
                    Tile tgtCohTile = targetTileMap.get(tgtCohBand);
                    tgtCohData = tgtCohTile.getDataBuffer();
                }
                Band targetBand_I = this.targetProduct.getBand(product.getBandName("real"));
                Tile tileOutReal = targetTileMap.get(targetBand_I);
                Band targetBand_Q = this.targetProduct.getBand(product.getBandName("imaginary"));
                Tile tileOutImag = targetTileMap.get(targetBand_Q);
                ProductData samplesReal = tileOutReal.getDataBuffer();
                ProductData samplesImag = tileOutImag.getDataBuffer();
                DoubleMatrix dataReal = dataMaster.real();
                DoubleMatrix dataImag = dataMaster.imag();
                TileIndex tgtIndex = new TileIndex(tileOutReal);
                ProductData srcSlvData = slvTileReal.getDataBuffer();
                TileIndex srcSlvIndex = new TileIndex(slvTileReal);
                for (int y = y0; y <= yN; ++y) {
                    tgtIndex.calculateStride(y);
                    srcSlvIndex.calculateStride(y);
                    int yy = y - y0;
                    for (int x = x0; x <= xN; ++x) {
                        int trgIndex = tgtIndex.getIndex(x);
                        int xx = x - x0;
                        if (srcSlvData.getElemDoubleAt(srcSlvIndex.getIndex(x)) == srcNoDataValue) {
                            samplesReal.setElemFloatAt(trgIndex, (float)srcNoDataValue);
                            samplesImag.setElemFloatAt(trgIndex, (float)srcNoDataValue);
                            if (!this.includeCoherence) continue;
                            tgtCohData.setElemFloatAt(trgIndex, (float)srcNoDataValue);
                            continue;
                        }
                        samplesReal.setElemFloatAt(trgIndex, (float)dataReal.get(yy, xx));
                        samplesImag.setElemFloatAt(trgIndex, (float)dataImag.get(yy, xx));
                        if (!this.includeCoherence) continue;
                        double cohI = cohDataReal.get(yy, xx);
                        double cohQ = cohDataImag.get(yy, xx);
                        double coh = Math.sqrt(cohI * cohI + cohQ * cohQ);
                        tgtCohData.setElemFloatAt(trgIndex, (float)coh);
                    }
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    private static double norm(ComplexDouble number) {
        return number.real() * number.real() + number.imag() * number.imag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeTileStackForTOPSARProduct(Map<Band, Tile> targetTileMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            int tx0 = targetRectangle.x;
            int ty0 = targetRectangle.y;
            int tw = targetRectangle.width;
            int th = targetRectangle.height;
            int txMax = tx0 + tw;
            int tyMax = ty0 + th;
            for (int burstIndex = 0; burstIndex < this.subSwath[this.subSwathIndex - 1].numOfBursts; ++burstIndex) {
                int firstLineIdx = burstIndex * this.subSwath[this.subSwathIndex - 1].linesPerBurst;
                int lastLineIdx = firstLineIdx + this.subSwath[this.subSwathIndex - 1].linesPerBurst - 1;
                if (tyMax <= firstLineIdx || ty0 > lastLineIdx) continue;
                int ntx0 = tx0;
                int ntw = tw;
                int nty0 = Math.max(ty0, firstLineIdx);
                int ntyMax = Math.min(tyMax, lastLineIdx + 1);
                int nth = ntyMax - nty0;
                Rectangle partialTileRectangle = new Rectangle(ntx0, nty0, ntw, nth);
                this.computePartialTile(this.subSwathIndex, burstIndex, partialTileRectangle, targetTileMap);
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    private void computePartialTile(int subSwathIndex, int burstIndex, Rectangle targetRectangle, Map<Band, Tile> targetTileMap) throws Exception {
        try {
            int cohx0 = targetRectangle.x - (this.cohWinRg - 1) / 2;
            int cohy0 = targetRectangle.y - (this.cohWinAz - 1) / 2;
            int cohw = targetRectangle.width + this.cohWinRg - 1;
            int cohh = targetRectangle.height + this.cohWinAz - 1;
            Rectangle rect = new Rectangle(cohx0, cohy0, cohw, cohh);
            BorderExtender border = BorderExtender.createInstance((int)0);
            int y0 = targetRectangle.y;
            int yN = y0 + targetRectangle.height - 1;
            int x0 = targetRectangle.x;
            int xN = x0 + targetRectangle.width - 1;
            long minLine = burstIndex * this.subSwath[subSwathIndex - 1].linesPerBurst;
            long maxLine = minLine + (long)this.subSwath[subSwathIndex - 1].linesPerBurst - 1L;
            long minPixel = 0L;
            long maxPixel = this.subSwath[subSwathIndex - 1].samplesPerBurst - 1;
            for (String ifgKey : this.targetMap.keySet()) {
                ProductContainer product = this.targetMap.get(ifgKey);
                Tile mstTileReal = this.getSourceTile((RasterDataNode)product.sourceMaster.realBand, targetRectangle);
                Tile mstTileImag = this.getSourceTile((RasterDataNode)product.sourceMaster.imagBand, targetRectangle);
                ComplexDoubleMatrix dataMaster = TileUtilsDoris.pullComplexDoubleMatrix((Tile)mstTileReal, (Tile)mstTileImag);
                Tile slvTileReal = this.getSourceTile((RasterDataNode)product.sourceSlave.realBand, targetRectangle);
                Tile slvTileImag = this.getSourceTile((RasterDataNode)product.sourceSlave.imagBand, targetRectangle);
                ComplexDoubleMatrix dataSlave = TileUtilsDoris.pullComplexDoubleMatrix((Tile)slvTileReal, (Tile)slvTileImag);
                double srcNoDataValue = product.sourceMaster.realBand.getNoDataValue();
                ComplexDoubleMatrix cohMatrix = null;
                if (this.includeCoherence) {
                    Tile mstTileReal2 = this.getSourceTile((RasterDataNode)product.sourceMaster.realBand, rect, border);
                    Tile mstTileImag2 = this.getSourceTile((RasterDataNode)product.sourceMaster.imagBand, rect, border);
                    Tile slvTileReal2 = this.getSourceTile((RasterDataNode)product.sourceSlave.realBand, rect, border);
                    Tile slvTileImag2 = this.getSourceTile((RasterDataNode)product.sourceSlave.imagBand, rect, border);
                    ComplexDoubleMatrix dataMaster2 = TileUtilsDoris.pullComplexDoubleMatrix((Tile)mstTileReal2, (Tile)mstTileImag2);
                    ComplexDoubleMatrix dataSlave2 = TileUtilsDoris.pullComplexDoubleMatrix((Tile)slvTileReal2, (Tile)slvTileImag2);
                    for (int r = 0; r < dataMaster2.rows; ++r) {
                        int y = cohy0 + r;
                        for (int c = 0; c < dataMaster2.columns; ++c) {
                            double tmp = InterferogramOp.norm(dataMaster2.get(r, c));
                            if ((long)y < minLine || (long)y > maxLine) {
                                dataMaster2.put(r, c, 0.0);
                            } else {
                                dataMaster2.put(r, c, dataMaster2.get(r, c).mul(dataSlave2.get(r, c).conj()));
                            }
                            dataSlave2.put(r, c, new ComplexDouble(InterferogramOp.norm(dataSlave2.get(r, c)), tmp));
                        }
                    }
                    cohMatrix = SarUtils.cplxCoherence((ComplexDoubleMatrix)dataMaster2, (ComplexDoubleMatrix)dataSlave2, (int)this.cohWinAz, (int)this.cohWinRg);
                }
                DoubleMatrix realReferencePhase = null;
                ComplexDoubleMatrix complexReferencePhase = null;
                if (this.subtractFlatEarthPhase) {
                    DoubleMatrix rangeAxisNormalized = DoubleMatrix.linspace((int)x0, (int)xN, (int)dataMaster.columns);
                    rangeAxisNormalized = InterferogramOp.normalizeDoubleMatrix(rangeAxisNormalized, 0.0, maxPixel);
                    DoubleMatrix azimuthAxisNormalized = DoubleMatrix.linspace((int)y0, (int)yN, (int)dataMaster.rows);
                    azimuthAxisNormalized = InterferogramOp.normalizeDoubleMatrix(azimuthAxisNormalized, minLine, maxLine);
                    String polynomialName = product.sourceSlave.name + '_' + (subSwathIndex - 1) + '_' + burstIndex;
                    DoubleMatrix polyCoeffs = this.flatEarthPolyMap.get(polynomialName);
                    realReferencePhase = PolyUtils.polyval((DoubleMatrix)azimuthAxisNormalized, (DoubleMatrix)rangeAxisNormalized, (DoubleMatrix)polyCoeffs, (int)PolyUtils.degreeFromCoefficients((int)polyCoeffs.length));
                    complexReferencePhase = new ComplexDoubleMatrix(MatrixFunctions.cos((DoubleMatrix)realReferencePhase), MatrixFunctions.sin((DoubleMatrix)realReferencePhase));
                    dataSlave.muli(complexReferencePhase);
                }
                dataMaster.muli(dataSlave.conji());
                Band targetBand_I = this.targetProduct.getBand(product.getBandName("real"));
                Tile tileOutReal = targetTileMap.get(targetBand_I);
                Band targetBand_Q = this.targetProduct.getBand(product.getBandName("imaginary"));
                Tile tileOutImag = targetTileMap.get(targetBand_Q);
                DoubleMatrix cohDataReal = null;
                DoubleMatrix cohDataImag = null;
                ProductData tgtCohData = null;
                Object tgtCohPhaseData = null;
                if (this.includeCoherence) {
                    if (this.subtractFlatEarthPhase) {
                        cohMatrix.muli(complexReferencePhase.conji());
                    }
                    cohDataReal = cohMatrix.real();
                    cohDataImag = cohMatrix.imag();
                    Band tgtCohBand = this.targetProduct.getBand(product.getBandName("coherence"));
                    Tile tgtCohTile = targetTileMap.get(tgtCohBand);
                    tgtCohData = tgtCohTile.getDataBuffer();
                }
                Object samplesFep = null;
                if (this.subtractFlatEarthPhase) {
                    // empty if block
                }
                ProductData samplesReal = tileOutReal.getDataBuffer();
                ProductData samplesImag = tileOutImag.getDataBuffer();
                ProductData srcSlvData = slvTileReal.getDataBuffer();
                DoubleMatrix dataReal = dataMaster.real();
                DoubleMatrix dataImag = dataMaster.imag();
                TileIndex tgtIndex = new TileIndex(tileOutReal);
                TileIndex srcSlvIndex = new TileIndex(slvTileReal);
                for (int y = y0; y <= yN; ++y) {
                    tgtIndex.calculateStride(y);
                    srcSlvIndex.calculateStride(y);
                    int yy = y - y0;
                    for (int x = x0; x <= xN; ++x) {
                        int tgtIdx = tgtIndex.getIndex(x);
                        int xx = x - x0;
                        if (srcSlvData.getElemDoubleAt(srcSlvIndex.getIndex(x)) == srcNoDataValue) {
                            samplesReal.setElemFloatAt(tgtIdx, (float)srcNoDataValue);
                            samplesImag.setElemFloatAt(tgtIdx, (float)srcNoDataValue);
                            if (this.includeCoherence) {
                                tgtCohData.setElemFloatAt(tgtIdx, (float)srcNoDataValue);
                            }
                            if (samplesFep == null) continue;
                            samplesFep.setElemFloatAt(tgtIdx, (float)srcNoDataValue);
                            continue;
                        }
                        samplesReal.setElemFloatAt(tgtIdx, (float)dataReal.get(yy, xx));
                        samplesImag.setElemFloatAt(tgtIdx, (float)dataImag.get(yy, xx));
                        if (this.includeCoherence) {
                            double cohI = cohDataReal.get(yy, xx);
                            double cohQ = cohDataImag.get(yy, xx);
                            double coh = Math.sqrt(cohI * cohI + cohQ * cohQ);
                            tgtCohData.setElemFloatAt(tgtIdx, (float)coh);
                        }
                        if (samplesFep == null || realReferencePhase == null) continue;
                        samplesFep.setElemFloatAt(tgtIdx, (float)realReferencePhase.get(yy, xx));
                    }
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    public static DoubleMatrix normalizeDoubleMatrix(DoubleMatrix matrix, double min, double max) {
        matrix.subi(0.5 * (min + max));
        matrix.divi(0.25 * (max - min));
        return matrix;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(InterferogramOp.class);
        }
    }
}

