/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.Map;
import org.esa.s1tbx.insar.gpf.InSARStackOverview;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.SourceProducts;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.engine_utilities.gpf.StackUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="IntegerInterferogram", category="Radar/Interferometric/Products", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2016 by Array Systems Computing Inc.", description="Create integer interferogram")
public class IntegerInterferogramOp
extends Operator {
    @SourceProducts
    private Product[] sourceProduct;
    @TargetProduct
    Product targetProduct;
    private MetadataElement mstRoot = null;
    private MetadataElement slv1Root = null;
    private MetadataElement slv2Root = null;
    private Band slv1BandI = null;
    private Band slv1BandQ = null;
    private Band slv2BandI = null;
    private Band slv2BandQ = null;
    private Band ifgBandI = null;
    private Band ifgBandQ = null;
    private double hoa1 = 0.0;
    private double hoa2 = 0.0;
    private int qOpt1 = 0;
    private int qOpt2 = 0;

    public void initialize() throws OperatorException {
        try {
            this.checkSourceProductValidity();
            this.getMetadata();
            this.getHOA();
            this.computeOptimalHOA();
            this.getSourceBands();
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void checkSourceProductValidity() {
        InputProductValidator validator1 = new InputProductValidator(this.sourceProduct[0]);
        validator1.checkIfSARProduct();
        validator1.checkIfCoregisteredStack();
        InputProductValidator validator2 = new InputProductValidator(this.sourceProduct[1]);
        validator2.checkIfSARProduct();
        validator2.checkIfCoregisteredStack();
    }

    private void getMetadata() {
        this.mstRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct[0]);
        MetadataElement slaveElem1 = this.sourceProduct[0].getMetadataRoot().getElement("Slave_Metadata");
        if (slaveElem1 == null) {
            throw new OperatorException("Slave_Metadata not found in product " + this.sourceProduct[0].getName());
        }
        this.slv1Root = slaveElem1.getElements()[0];
        MetadataElement slaveElem2 = this.sourceProduct[1].getMetadataRoot().getElement("Slave_Metadata");
        if (slaveElem2 == null) {
            throw new OperatorException("Slave_Metadata not found in product " + this.sourceProduct[1].getName());
        }
        this.slv2Root = slaveElem2.getElements()[0];
    }

    private void getHOA() throws Exception {
        InSARStackOverview.IfgStack[] stackOverview1 = InSARStackOverview.calculateInSAROverview(new MetadataElement[]{this.mstRoot, this.slv1Root});
        this.hoa1 = stackOverview1[0].getMasterSlave()[1].getHeightAmb();
        if (StackUtils.isBiStaticStack((Product)this.sourceProduct[0])) {
            this.hoa1 *= 2.0;
        }
        InSARStackOverview.IfgStack[] stackOverview2 = InSARStackOverview.calculateInSAROverview(new MetadataElement[]{this.mstRoot, this.slv2Root});
        this.hoa2 = stackOverview2[0].getMasterSlave()[1].getHeightAmb();
        if (StackUtils.isBiStaticStack((Product)this.sourceProduct[1])) {
            this.hoa2 *= 2.0;
        }
    }

    private void computeOptimalHOA() {
        double hoaMax = 0.0;
        for (int q1 = -3; q1 <= 3; ++q1) {
            for (int q2 = -3; q2 <= 3; ++q2) {
                double hoaEq;
                if (q1 == 0 || q2 == 0 || !((hoaEq = 1.0 / ((double)q1 / this.hoa1 + (double)q2 / this.hoa2)) > hoaMax)) continue;
                hoaMax = hoaEq;
                this.qOpt1 = q1;
                this.qOpt2 = q2;
            }
        }
    }

    private void getSourceBands() {
        Band[] srcBands2;
        Band[] srcBands1;
        String mstDate = OperatorUtils.getAcquisitionDate((MetadataElement)this.mstRoot);
        String slv1Date = OperatorUtils.getAcquisitionDate((MetadataElement)this.slv1Root);
        String slv2Date = OperatorUtils.getAcquisitionDate((MetadataElement)this.slv2Root);
        String slv1Tag = mstDate + '_' + slv1Date;
        String slv2Tag = mstDate + '_' + slv2Date;
        for (Band band : srcBands1 = this.sourceProduct[0].getBands()) {
            if (band instanceof VirtualBand) continue;
            String unit = band.getUnit();
            if (!band.getName().contains(slv1Tag)) continue;
            if (unit.equals("real")) {
                this.slv1BandI = band;
                continue;
            }
            if (!unit.equals("imaginary")) continue;
            this.slv1BandQ = band;
        }
        for (Band band : srcBands2 = this.sourceProduct[1].getBands()) {
            if (band instanceof VirtualBand) continue;
            String unit = band.getUnit();
            if (!band.getName().contains(slv2Tag)) continue;
            if (unit.equals("real")) {
                this.slv2BandI = band;
                continue;
            }
            if (!unit.equals("imaginary")) continue;
            this.slv2BandQ = band;
        }
        if (this.slv1BandI == null || this.slv1BandQ == null || this.slv2BandI == null || this.slv2BandQ == null) {
            throw new OperatorException("Two interferogram products are expected.");
        }
    }

    private void createTargetProduct() {
        int sourceImageWidth = this.sourceProduct[0].getSceneRasterWidth();
        int sourceImageHeight = this.sourceProduct[0].getSceneRasterHeight();
        this.targetProduct = new Product(this.sourceProduct[0].getName(), this.sourceProduct[0].getProductType(), sourceImageWidth, sourceImageHeight);
        ProductUtils.copyProductNodes((Product)this.sourceProduct[0], (Product)this.targetProduct);
        this.ifgBandI = new Band("i_ifg", 30, sourceImageWidth, sourceImageHeight);
        this.ifgBandI.setUnit("real");
        this.targetProduct.addBand(this.ifgBandI);
        this.ifgBandQ = new Band("q_ifg", 30, sourceImageWidth, sourceImageHeight);
        this.ifgBandQ.setUnit("imaginary");
        this.targetProduct.addBand(this.ifgBandQ);
        ReaderUtils.createVirtualIntensityBand((Product)this.targetProduct, (Band)this.ifgBandI, (Band)this.ifgBandQ, (String)"");
        ReaderUtils.createVirtualPhaseBand((Product)this.targetProduct, (Band)this.ifgBandI, (Band)this.ifgBandQ, (String)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTileStack(Map<Band, Tile> targetTileMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int yMax = y0 + h;
        int xMax = x0 + w;
        try {
            Tile ifgTileI = targetTileMap.get(this.ifgBandI);
            Tile ifgTileQ = targetTileMap.get(this.ifgBandQ);
            ProductData ifgDataBufferI = ifgTileI.getDataBuffer();
            ProductData ifgDataBufferQ = ifgTileQ.getDataBuffer();
            Tile slv1TileI = this.getSourceTile((RasterDataNode)this.slv1BandI, targetRectangle);
            Tile slv1TileQ = this.getSourceTile((RasterDataNode)this.slv1BandQ, targetRectangle);
            ProductData slv1DataBufferI = slv1TileI.getDataBuffer();
            ProductData slv1DataBufferQ = slv1TileQ.getDataBuffer();
            Tile slv2TileI = this.getSourceTile((RasterDataNode)this.slv2BandI, targetRectangle);
            Tile slv2TileQ = this.getSourceTile((RasterDataNode)this.slv2BandQ, targetRectangle);
            ProductData slv2DataBufferI = slv2TileI.getDataBuffer();
            ProductData slv2DataBufferQ = slv2TileQ.getDataBuffer();
            TileIndex tgtIndex = new TileIndex(ifgTileI);
            TileIndex srcIndex = new TileIndex(slv1TileI);
            for (int y = y0; y < yMax; ++y) {
                tgtIndex.calculateStride(y);
                srcIndex.calculateStride(y);
                for (int x = x0; x < xMax; ++x) {
                    int tgtIdx = tgtIndex.getIndex(x);
                    int srcIdx = srcIndex.getIndex(x);
                    double slv1IfgI = slv1DataBufferI.getElemDoubleAt(srcIdx);
                    double slv1IfgQ = slv1DataBufferQ.getElemDoubleAt(srcIdx);
                    double slv2IfgI = slv2DataBufferI.getElemDoubleAt(srcIdx);
                    double slv2IfgQ = slv2DataBufferQ.getElemDoubleAt(srcIdx);
                    ifgDataBufferI.setElemFloatAt(tgtIdx, (float)((double)this.qOpt1 * slv1IfgI + (double)this.qOpt2 * slv2IfgI));
                    ifgDataBufferQ.setElemFloatAt(tgtIdx, (float)((double)this.qOpt1 * slv1IfgQ + (double)this.qOpt2 * slv2IfgQ));
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(IntegerInterferogramOp.class);
        }
    }
}

