/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.util.ArrayList;
import java.util.Arrays;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.Debug;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.jlinda.core.Baseline;
import org.jlinda.core.Orbit;
import org.jlinda.core.Point;
import org.jlinda.core.SLCImage;

public class InSARStackOverview {
    private static final int BTEMP_CRITICAL = 1095;
    private static final int BPERP_CRITICAL = 1200;
    private static final int DFDC_CRITICAL = 1380;
    private SLCImage[] slcImages;
    private Orbit[] orbits;
    private int numOfImages;
    private long orbitNumber;
    private float modeledCoherence;

    public void setInput(SLCImage[] slcImages, Orbit[] orbits) {
        this.slcImages = slcImages;
        this.orbits = orbits;
        this.numOfImages = slcImages.length;
        if (this.numOfImages != orbits.length) {
            throw new IllegalArgumentException("Number of elements in input arrays has to be the same!");
        }
    }

    public long getOrbitNumber() {
        return this.orbitNumber;
    }

    public float getModeledCoherence() {
        return this.modeledCoherence;
    }

    private static float modelCoherence(float bPerp, float bTemp, float fDc, float bPerpCritical, float bTempCritical, float fDcCritical) {
        return InSARStackOverview.coherenceFnc(bPerp, bPerpCritical) * InSARStackOverview.coherenceFnc(bTemp, bTempCritical) * InSARStackOverview.coherenceFnc(fDc, fDcCritical);
    }

    private static float modelCoherence(float bPerp, float bTemp, float fDc) {
        return InSARStackOverview.coherenceFnc(bPerp, 1200.0f) * InSARStackOverview.coherenceFnc(bTemp, 1095.0f) * InSARStackOverview.coherenceFnc(fDc, 1380.0f);
    }

    private static float coherenceFnc(float value, float value_CRITICAL) {
        if (Math.abs(value) > value_CRITICAL) {
            return 0.01f;
        }
        return 1.0f - Math.abs(value) / value_CRITICAL;
    }

    private CplxContainer[] setupCplxContainers() {
        CplxContainer[] cplxContainers = new CplxContainer[this.numOfImages];
        for (int i = 0; i < this.numOfImages; ++i) {
            SLCImage slcImage = this.slcImages[i];
            Orbit orbit = this.orbits[i];
            cplxContainers[i] = new CplxContainer(slcImage.getOrbitNumber(), slcImage.getMjd(), slcImage, orbit);
        }
        return cplxContainers;
    }

    private IfgStack[] setupIfgStack(CplxContainer[] cplxContainers, ProgressMonitor pm) {
        IfgStack[] ifgStack = new IfgStack[this.numOfImages];
        IfgPair[][] ifgPair = new IfgPair[this.numOfImages][this.numOfImages];
        pm.beginTask("Computing...", this.numOfImages);
        for (int i = 0; i < this.numOfImages; ++i) {
            CplxContainer master = cplxContainers[i];
            for (int j = 0; j < this.numOfImages; ++j) {
                CplxContainer slave = cplxContainers[j];
                ifgPair[i][j] = new IfgPair(master, slave);
            }
            ifgStack[i] = new IfgStack(master, ifgPair[i]);
            ifgStack[i].meanCoherence();
            pm.worked(1);
        }
        pm.done();
        return ifgStack;
    }

    public int findOptimalMaster(IfgStack[] ifgStack) {
        this.orbitNumber = ((IfgStack)ifgStack[0]).master.orbitNumber;
        this.modeledCoherence = ifgStack[0].meanCoherence;
        int index = 0;
        int i = 0;
        for (IfgStack anIfgStack : ifgStack) {
            long orbit = ((IfgStack)anIfgStack).master.orbitNumber;
            float coherence = anIfgStack.meanCoherence;
            if (coherence > this.modeledCoherence) {
                this.modeledCoherence = coherence;
                this.orbitNumber = orbit;
                index = i;
            }
            ++i;
        }
        return index;
    }

    public IfgStack[] getCoherenceScores(ProgressMonitor pm) {
        CplxContainer[] cplxContainers = this.setupCplxContainers();
        return this.setupIfgStack(cplxContainers, pm);
    }

    public int estimateOptimalMaster(ProgressMonitor pm) {
        return this.findOptimalMaster(this.getCoherenceScores(pm));
    }

    public static Product findOptimalMasterProduct(Product[] srcProducts) throws Exception {
        int size = srcProducts.length;
        ArrayList<SLCImage> imgList = new ArrayList<SLCImage>(size);
        ArrayList<Orbit> orbList = new ArrayList<Orbit>(size);
        for (Product product : srcProducts) {
            MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
            imgList.add(new SLCImage(absRoot, product));
            orbList.add(new Orbit(absRoot, 3));
        }
        try {
            InSARStackOverview dataStack = new InSARStackOverview();
            dataStack.setInput(imgList.toArray(new SLCImage[size]), orbList.toArray(new Orbit[size]));
            int index = dataStack.estimateOptimalMaster(ProgressMonitor.NULL);
            return srcProducts[index];
        }
        catch (Throwable t) {
            Debug.trace((Throwable)t);
            return srcProducts[0];
        }
    }

    public static IfgStack[] calculateInSAROverview(Product coregProduct) throws Exception {
        MetadataElement slaveElem = coregProduct.getMetadataRoot().getElement("Slave_Metadata");
        if (slaveElem == null) {
            slaveElem = coregProduct.getMetadataRoot().getElement("Slave Metadata");
        }
        ArrayList<MetadataElement> absMetaList = new ArrayList<MetadataElement>();
        absMetaList.add(AbstractMetadata.getAbstractedMetadata((Product)coregProduct));
        absMetaList.addAll(Arrays.asList(slaveElem.getElements()));
        return InSARStackOverview.calculateInSAROverview(absMetaList.toArray(new MetadataElement[absMetaList.size()]));
    }

    public static IfgStack[] calculateInSAROverview(MetadataElement[] absRoots) throws Exception {
        ArrayList<SLCImage> imgList = new ArrayList<SLCImage>(absRoots.length);
        ArrayList<Orbit> orbList = new ArrayList<Orbit>(absRoots.length);
        for (MetadataElement absRoot : absRoots) {
            imgList.add(new SLCImage(absRoot, null));
            orbList.add(new Orbit(absRoot, 3));
        }
        InSARStackOverview dataStack = new InSARStackOverview();
        dataStack.setInput(imgList.toArray(new SLCImage[imgList.size()]), orbList.toArray(new Orbit[orbList.size()]));
        return dataStack.getCoherenceScores(ProgressMonitor.NULL);
    }

    public static IfgStack[] calculateInSAROverview(Product[] products) throws Exception {
        ArrayList<SLCImage> imgList = new ArrayList<SLCImage>(products.length);
        ArrayList<Orbit> orbList = new ArrayList<Orbit>(products.length);
        for (Product product : products) {
            MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
            imgList.add(new SLCImage(absRoot, product));
            orbList.add(new Orbit(absRoot, 3));
        }
        InSARStackOverview dataStack = new InSARStackOverview();
        dataStack.setInput(imgList.toArray(new SLCImage[imgList.size()]), orbList.toArray(new Orbit[orbList.size()]));
        return dataStack.getCoherenceScores(ProgressMonitor.NULL);
    }

    public static class IfgPair {
        private final int refLine;
        private final int refPixel;
        private final double refHeight;
        private final CplxContainer master;
        private final CplxContainer slave;
        private Baseline baseline = null;
        private float bPerp;
        private final float bTemp;
        private final float deltaDoppler;
        private final float coherence;
        private float heightAmb;

        public IfgPair(CplxContainer master, CplxContainer slave) {
            this.master = master;
            this.slave = slave;
            Point refPoint = master.metaData.getApproxRadarCentreOriginal();
            this.refPixel = (int)refPoint.x;
            this.refLine = (int)refPoint.y;
            this.refHeight = 0.0;
            try {
                this.baseline = new Baseline();
                this.baseline.model(master.metaData, slave.metaData, master.orbit, slave.orbit);
                this.bPerp = (float)this.baseline.getBperp((double)this.refLine, (double)this.refPixel);
                this.heightAmb = (float)this.baseline.getHamb((double)this.refLine, (double)this.refPixel, this.refHeight);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.bTemp = (float)(master.dateMjd - slave.dateMjd);
            this.deltaDoppler = (float)(master.metaData.doppler.getF_DC_a0() - slave.metaData.doppler.getF_DC_a0());
            this.coherence = InSARStackOverview.modelCoherence(this.bPerp, this.bTemp, this.deltaDoppler);
        }

        public float getPerpendicularBaseline(double line, double pixel, double height) throws Exception {
            return (float)this.baseline.getBperp(line, pixel, height);
        }

        public float getParallelBaseline(double line, double pixel, double height) throws Exception {
            return (float)this.baseline.getBpar(line, pixel, height);
        }

        public float getAlpha(double line, double pixel, double height) throws Exception {
            return (float)this.baseline.getAlpha(line, pixel, height);
        }

        public float getVerticalBaseline(double line, double pixel, double height) throws Exception {
            return (float)this.baseline.getBvert(line, pixel, height);
        }

        public float getHorizontalBaseline(double line, double pixel, double height) throws Exception {
            return (float)this.baseline.getBhor(line, pixel, height);
        }

        public float getPerpendicularBaseline() {
            return this.bPerp;
        }

        public float getTemporalBaseline() {
            return this.bTemp;
        }

        public float getDopplerDifference() {
            return this.deltaDoppler;
        }

        public float getCoherence() {
            return this.coherence;
        }

        public float getHeightAmb() {
            return this.heightAmb;
        }

        public SLCImage getMasterMetadata() {
            return this.master.metaData;
        }

        public SLCImage getSlaveMetadata() {
            return this.slave.metaData;
        }
    }

    public static class IfgStack {
        private final CplxContainer master;
        private final IfgPair[] master_slave;
        private float meanCoherence;

        public IfgStack(CplxContainer master, IfgPair ... master_slave) {
            this.master = master;
            this.master_slave = master_slave;
        }

        public void meanCoherence() {
            for (IfgPair aMaster_slave : this.master_slave) {
                this.meanCoherence += aMaster_slave.coherence;
            }
            this.meanCoherence /= (float)this.master_slave.length;
        }

        public IfgPair[] getMasterSlave() {
            return this.master_slave;
        }
    }

    private static class CplxContainer {
        public final long orbitNumber;
        public final double dateMjd;
        public final SLCImage metaData;
        public final Orbit orbit;

        public CplxContainer(long orbitNumber, double dateMjd, SLCImage metaData, Orbit orbit) {
            this.orbitNumber = orbitNumber;
            this.dateMjd = dateMjd;
            this.metaData = metaData;
            this.orbit = orbit;
        }
    }
}

