/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf;

import com.bc.ceres.core.ProgressMonitor;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="GoldsteinPhaseFiltering", category="Radar/Interferometric/Filtering", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Phase Filtering")
public class GoldsteinFilterOp
extends Operator {
    @SourceProduct
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="adaptive filter exponent", interval="(0, 1]", defaultValue="1.0", label="Adaptive Filter Exponent in (0,1]")
    private double alpha = 1.0;
    @Parameter(valueSet={"32", "64", "128", "256"}, defaultValue="64", label="FFT Size")
    private String FFTSizeString = "64";
    @Parameter(valueSet={"3", "5", "7"}, defaultValue="3", label="Window Size")
    private String windowSizeString = "3";
    @Parameter(description="Use coherence mask", defaultValue="false", label="Use coherence mask")
    private Boolean useCoherenceMask = false;
    @Parameter(description="The coherence threshold", interval="[0, 1]", defaultValue="0.2", label="Coherence Threshold in [0,1]")
    private double coherenceThreshold = 0.2;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private int FFTSize;
    private int halfFFTSize;
    private int windowSize;
    private int halfWindowSize;
    private double noDataValue = 0.0;
    private Band cohBand = null;
    private final Map<Band, Band> targetIQPair = new HashMap<Band, Band>();
    private static final String PRODUCT_SUFFIX = "_Flt";

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSARProduct();
            validator.checkIfCoregisteredStack();
            validator.checkIfSLC();
            this.FFTSize = Integer.parseInt(this.FFTSizeString);
            this.halfFFTSize = this.FFTSize / 2;
            this.windowSize = Integer.parseInt(this.windowSizeString);
            this.halfWindowSize = this.windowSize / 2;
            this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
            this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
            this.createTargetProduct();
            if (this.useCoherenceMask.booleanValue()) {
                for (Band band : this.sourceProduct.getBands()) {
                    if (band.getUnit() == null || !band.getUnit().equals("coherence")) continue;
                    this.cohBand = band;
                }
                if (this.cohBand == null) {
                    throw new OperatorException("Cannot find coherence band");
                }
            }
        }
        catch (Exception e) {
            throw new OperatorException((Throwable)e);
        }
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName() + PRODUCT_SUFFIX, this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
        this.addSelectedBands();
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        if (this.sourceProduct.getQuicklookBandName() != null && this.targetProduct.getBand(this.sourceProduct.getQuicklookBandName()) != null) {
            this.targetProduct.setQuicklookBandName(this.sourceProduct.getQuicklookBandName());
        }
    }

    private void addSelectedBands() {
        String[] sourceBandNames = null;
        Band[] sourceBands = OperatorUtils.getSourceBands((Product)this.sourceProduct, sourceBandNames, (boolean)false);
        int i = 0;
        while (i < sourceBands.length) {
            Band srcBandI = sourceBands[i];
            String unit = srcBandI.getUnit();
            String nextUnit = null;
            if (unit == null) {
                throw new OperatorException("band " + srcBandI.getName() + " requires a unit");
            }
            if (unit.contains("db")) {
                throw new OperatorException("bands in dB are not supported");
            }
            if (unit.contains("imaginary")) {
                throw new OperatorException("I and Q bands should be selected in pairs");
            }
            if (unit.contains("real")) {
                if (i + 1 >= sourceBands.length) {
                    throw new OperatorException("I and Q bands should be selected in pairs");
                }
                nextUnit = sourceBands[i + 1].getUnit();
                if (nextUnit == null || !nextUnit.contains("imaginary")) {
                    throw new OperatorException("I and Q bands should be selected in pairs");
                }
            } else {
                ProductUtils.copyBand((String)srcBandI.getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
                ++i;
                continue;
            }
            Band targetBandI = this.targetProduct.addBand(srcBandI.getName(), 30);
            targetBandI.setUnit(unit);
            Band srcBandQ = sourceBands[i + 1];
            Band targetBandQ = this.targetProduct.addBand(srcBandQ.getName(), 30);
            targetBandQ.setUnit(nextUnit);
            this.targetIQPair.put(targetBandI, targetBandQ);
            String suffix = targetBandI.getName().substring(targetBandI.getName().indexOf(95));
            ReaderUtils.createVirtualIntensityBand((Product)this.targetProduct, (Band)targetBandI, (Band)targetBandQ, (String)suffix);
            ReaderUtils.createVirtualPhaseBand((Product)this.targetProduct, (Band)targetBandI, (Band)targetBandQ, (String)suffix);
            i += 2;
        }
    }

    public void computeTileStack(Map<Band, Tile> targetTileMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            int x0 = targetRectangle.x;
            int y0 = targetRectangle.y;
            int w = targetRectangle.width;
            int h = targetRectangle.height;
            if (w < this.FFTSize || h < this.FFTSize) {
                return;
            }
            Rectangle sourceTileRectangle = this.getSourceRectangle(x0, y0, w, h);
            int sx0 = sourceTileRectangle.x;
            int sy0 = sourceTileRectangle.y;
            int sw = sourceTileRectangle.width;
            int sh = sourceTileRectangle.height;
            for (Band iBand : this.targetIQPair.keySet()) {
                Band qBand = this.targetIQPair.get(iBand);
                Tile iTargetTile = targetTileMap.get(iBand);
                Tile qTargetTile = targetTileMap.get(qBand);
                Tile iBandRaster = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand(iBand.getName()), sourceTileRectangle);
                Tile qBandRaster = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand(qBand.getName()), sourceTileRectangle);
                ProductData iBandData = iBandRaster.getDataBuffer();
                ProductData qBandData = qBandRaster.getDataBuffer();
                TileIndex srcIndex = new TileIndex(iBandRaster);
                this.noDataValue = iBand.getNoDataValue();
                boolean[][] mask = new boolean[this.FFTSize][this.FFTSize];
                double[][] I = new double[this.FFTSize][this.FFTSize];
                double[][] Q = new double[this.FFTSize][this.FFTSize];
                double[][] specI = new double[this.FFTSize][this.FFTSize];
                double[][] specQ = new double[this.FFTSize][this.FFTSize];
                double[][] pwrSpec = new double[this.FFTSize][this.FFTSize];
                double[][] fltSpec = new double[this.FFTSize][this.FFTSize];
                int colMax = I[0].length;
                float[] iBandFiltered = new float[w * h];
                float[] qBandFiltered = new float[w * h];
                int stepSize = this.FFTSize / 4;
                int syMax = FastMath.min((int)(sy0 + sh - this.FFTSize), (int)(this.sourceImageHeight - this.FFTSize));
                int sxMax = FastMath.min((int)(sx0 + sw - this.FFTSize), (int)(this.sourceImageWidth - this.FFTSize));
                for (int y = sy0; y <= syMax; y += stepSize) {
                    for (int x = sx0; x <= sxMax; x += stepSize) {
                        this.getComplexImagettes(x, y, iBandData, qBandData, srcIndex, I, Q, mask);
                        boolean allNoData = true;
                        for (double[] aI : I) {
                            for (int c = 0; c < colMax; ++c) {
                                if (aI[c] == this.noDataValue) continue;
                                allNoData = false;
                                break;
                            }
                            if (!allNoData) break;
                        }
                        if (allNoData) continue;
                        GoldsteinFilterOp.perform2DFFT(I, Q, specI, specQ);
                        GoldsteinFilterOp.getPowerSpectrum(specI, specQ, pwrSpec);
                        this.getFilteredPowerSpectrum(pwrSpec, fltSpec, this.alpha, this.halfWindowSize);
                        GoldsteinFilterOp.performInverse2DFFT(specI, specQ, fltSpec, I, Q);
                        this.updateFilteredBands(x0, y0, w, h, x, y, I, Q, mask, iBandFiltered, qBandFiltered);
                    }
                }
                if (this.cohBand != null) {
                    Tile cohBandRaster = this.getSourceTile((RasterDataNode)this.cohBand, targetRectangle);
                    ProductData cohBandData = cohBandRaster.getDataBuffer();
                    TileIndex cohIndex = new TileIndex(cohBandRaster);
                    int yMax = y0 + h;
                    int xMax = x0 + w;
                    for (int y = y0; y < yMax; ++y) {
                        cohIndex.calculateStride(y);
                        for (int x = x0; x < xMax; ++x) {
                            int k = (y - y0) * w + x - x0;
                            if (!((double)cohBandData.getElemFloatAt(cohIndex.getIndex(x)) < this.coherenceThreshold)) continue;
                            int idx = iBandRaster.getDataBufferIndex(x, y);
                            iBandFiltered[k] = iBandData.getElemFloatAt(idx);
                            qBandFiltered[k] = qBandData.getElemFloatAt(idx);
                        }
                    }
                }
                iTargetTile.setRawSamples((ProductData)new ProductData.Float(iBandFiltered));
                qTargetTile.setRawSamples((ProductData)new ProductData.Float(qBandFiltered));
            }
        }
        catch (Exception e) {
            throw new OperatorException((Throwable)e);
        }
    }

    private Rectangle getSourceRectangle(int x0, int y0, int w, int h) {
        int FFTSize3_4 = this.FFTSize * 3 / 4;
        int sx0 = FastMath.max((int)(x0 - FFTSize3_4), (int)0);
        int sy0 = FastMath.max((int)(y0 - FFTSize3_4), (int)0);
        int sxMax = FastMath.min((int)(x0 + w - 1 + FFTSize3_4), (int)(this.sourceImageWidth - 1));
        int syMax = FastMath.min((int)(y0 + h - 1 + FFTSize3_4), (int)(this.sourceImageHeight - 1));
        int sw = sxMax - sx0 + 1;
        int sh = syMax - sy0 + 1;
        return new Rectangle(sx0, sy0, sw, sh);
    }

    private void getComplexImagettes(int x, int y, ProductData iBandData, ProductData qBandData, TileIndex srcIndex, double[][] I, double[][] Q, boolean[][] mask) {
        int maxY = y + this.FFTSize;
        int maxX = x + this.FFTSize;
        for (int yy = y; yy < maxY; ++yy) {
            srcIndex.calculateStride(yy);
            int yidx = yy - y;
            for (int xx = x; xx < maxX; ++xx) {
                int index = srcIndex.getIndex(xx);
                I[yidx][xx - x] = iBandData.getElemDoubleAt(index);
                Q[yidx][xx - x] = qBandData.getElemDoubleAt(index);
                mask[yidx][xx - x] = I[yidx][xx - x] != this.noDataValue;
            }
        }
    }

    private static void perform2DFFT(double[][] I, double[][] Q, double[][] specI, double[][] specQ) {
        int c;
        int colMax;
        int rowMax = I.length;
        int rowFFTSize = colMax = I[0].length;
        int colFFTSize = rowMax;
        DoubleFFT_1D row_fft = new DoubleFFT_1D(rowFFTSize);
        double[][] complexDataI = new double[colFFTSize][rowFFTSize];
        double[][] complexDataQ = new double[colFFTSize][rowFFTSize];
        double[] rowArray = new double[2 * rowFFTSize];
        for (int r = 0; r < rowMax; ++r) {
            int k = 0;
            for (c = 0; c < colMax; ++c) {
                rowArray[k++] = Q[r][c];
                rowArray[k++] = I[r][c];
            }
            row_fft.complexForward(rowArray);
            for (c = 0; c < rowFFTSize; ++c) {
                complexDataQ[r][c] = rowArray[c + c];
                complexDataI[r][c] = rowArray[c + c + 1];
            }
        }
        DoubleFFT_1D col_fft = new DoubleFFT_1D(colFFTSize);
        double[] colArray = new double[2 * colFFTSize];
        for (c = 0; c < colMax; ++c) {
            int r;
            int k = 0;
            for (r = 0; r < rowMax; ++r) {
                colArray[k++] = complexDataQ[r][c];
                colArray[k++] = complexDataI[r][c];
            }
            col_fft.complexForward(colArray);
            for (r = 0; r < colFFTSize; ++r) {
                specQ[r][c] = colArray[r + r];
                specI[r][c] = colArray[r + r + 1];
            }
        }
    }

    private static void getPowerSpectrum(double[][] specI, double[][] specQ, double[][] pwrSpec) {
        int rowMax = specI.length;
        int colMax = specI[0].length;
        for (int r = 0; r < rowMax; ++r) {
            for (int c = 0; c < colMax; ++c) {
                pwrSpec[r][c] = Math.sqrt(specI[r][c] * specI[r][c] + specQ[r][c] * specQ[r][c]);
            }
        }
    }

    private void getFilteredPowerSpectrum(double[][] pwrSpec, double[][] fltSpec, double alpha, int halfWindowSize) {
        int rowMax = pwrSpec.length;
        int colMax = pwrSpec[0].length;
        for (int r = 0; r < rowMax; ++r) {
            int jMin = Math.max(0, r - halfWindowSize);
            int jMax = Math.min(rowMax - 1, r + halfWindowSize);
            for (int c = 0; c < colMax; ++c) {
                double sum = 0.0;
                int k = 0;
                int iMin = Math.max(0, c - halfWindowSize);
                int iMax = Math.min(colMax - 1, c + halfWindowSize);
                for (int j = jMin; j <= jMax; ++j) {
                    for (int i = iMin; i <= iMax; ++i) {
                        if (pwrSpec[j][i] == this.noDataValue) continue;
                        sum += pwrSpec[j][i];
                        ++k;
                    }
                }
                fltSpec[r][c] = k != 0 ? FastMath.pow((double)(sum / (double)k), (double)alpha) : 0.0;
            }
        }
    }

    private static void performInverse2DFFT(double[][] specI, double[][] specQ, double[][] fltSpec, double[][] I, double[][] Q) {
        int r;
        int colMax;
        int rowMax = I.length;
        int rowFFTSize = colMax = I[0].length;
        int colFFTSize = rowMax;
        double[][] complexDataI = new double[colFFTSize][rowFFTSize];
        double[][] complexDataQ = new double[colFFTSize][rowFFTSize];
        DoubleFFT_1D col_fft = new DoubleFFT_1D(colFFTSize);
        double[] colArray = new double[2 * colFFTSize];
        for (int c = 0; c < colMax; ++c) {
            int k = 0;
            for (r = 0; r < rowMax; ++r) {
                colArray[k++] = specQ[r][c] * fltSpec[r][c];
                colArray[k++] = specI[r][c] * fltSpec[r][c];
            }
            col_fft.complexInverse(colArray, false);
            for (r = 0; r < colFFTSize; ++r) {
                complexDataQ[r][c] = colArray[r + r];
                complexDataI[r][c] = colArray[r + r + 1];
            }
        }
        DoubleFFT_1D row_fft = new DoubleFFT_1D(rowFFTSize);
        double[] rowArray = new double[2 * rowFFTSize];
        for (r = 0; r < rowMax; ++r) {
            int c;
            int k = 0;
            for (c = 0; c < colMax; ++c) {
                rowArray[k++] = complexDataQ[r][c];
                rowArray[k++] = complexDataI[r][c];
            }
            row_fft.complexInverse(rowArray, false);
            for (c = 0; c < rowFFTSize; ++c) {
                Q[r][c] = rowArray[c + c];
                I[r][c] = rowArray[c + c + 1];
            }
        }
    }

    private void updateFilteredBands(int x0, int y0, int w, int h, int x, int y, double[][] I, double[][] Q, boolean[][] mask, float[] iBandFiltered, float[] qBandFiltered) {
        int xSt = FastMath.max((int)x, (int)x0);
        int ySt = FastMath.max((int)y, (int)y0);
        int xEd = FastMath.min((int)(x + this.FFTSize), (int)(x0 + w));
        int yEd = FastMath.min((int)(y + this.FFTSize), (int)(y0 + h));
        for (int yy = ySt; yy < yEd; ++yy) {
            int yi = yy - y;
            int yw = (yy - y0) * w;
            double weightY = 1.0 - Math.abs((double)(yy - y - this.halfFFTSize) + 0.5) / (double)this.halfFFTSize;
            for (int xx = xSt; xx < xEd; ++xx) {
                int k;
                if (!mask[yi][xx - x]) continue;
                double weight = (1.0 - Math.abs((double)(xx - x - this.halfFFTSize) + 0.5) / (double)this.halfFFTSize) * weightY;
                int n = k = yw + (xx - x0);
                iBandFiltered[n] = (float)((double)iBandFiltered[n] + I[yi][xx - x] * weight);
                int n2 = k;
                qBandFiltered[n2] = (float)((double)qBandFiltered[n2] + Q[yi][xx - x] * weight);
            }
        }
    }

    private double getTriangularWeight(int xUL, int yUL, int x, int y) {
        return (1.0 - Math.abs((double)(x - xUL - this.halfFFTSize) + 0.5) / (double)this.halfFFTSize) * (1.0 - Math.abs((double)(y - yUL - this.halfFFTSize) + 0.5) / (double)this.halfFFTSize);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(GoldsteinFilterOp.class);
        }
    }
}

