/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.BorderExtender;
import org.esa.s1tbx.insar.gpf.InterferogramOp;
import org.esa.s1tbx.insar.gpf.support.Sentinel1Utils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.PosVector;
import org.esa.snap.engine_utilities.eo.GeoUtils;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.StackUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;
import org.jblas.ComplexDouble;
import org.jblas.ComplexDoubleMatrix;
import org.jblas.DoubleMatrix;
import org.jblas.MatrixFunctions;
import org.jlinda.core.Orbit;
import org.jlinda.core.Point;
import org.jlinda.core.SLCImage;
import org.jlinda.core.utils.PolyUtils;
import org.jlinda.core.utils.SarUtils;
import org.jlinda.nest.utils.BandUtilsDoris;
import org.jlinda.nest.utils.CplxContainer;
import org.jlinda.nest.utils.ProductContainer;
import org.jlinda.nest.utils.TileUtilsDoris;

@OperatorMetadata(alias="Coherence", category="Radar/Interferometric/Products", authors="Petar Marinkovic, Jun Lu", version="1.0", copyright="Copyright (C) 2013 by PPO.labs", description="Estimate coherence from stack of coregistered images")
public class CoherenceOp
extends Operator {
    @SourceProduct
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(interval="(1, 90]", description="Size of coherence estimation window in Azimuth direction", defaultValue="10", label="Coherence Azimuth Window Size")
    private int cohWinAz = 10;
    @Parameter(interval="(1, 90]", description="Size of coherence estimation window in Range direction", defaultValue="10", label="Coherence Range Window Size")
    private int cohWinRg = 10;
    @Parameter(defaultValue="false", label="Subtract flat-earth phase in coherence phase")
    private boolean subtractFlatEarthPhase = false;
    @Parameter(valueSet={"1", "2", "3", "4", "5", "6", "7", "8"}, description="Order of 'Flat earth phase' polynomial", defaultValue="5", label="Degree of \"Flat Earth\" polynomial")
    private int srpPolynomialDegree = 5;
    @Parameter(valueSet={"301", "401", "501", "601", "701", "801", "901", "1001"}, description="Number of points for the 'flat earth phase' polynomial estimation", defaultValue="501", label="Number of \"Flat Earth\" estimation points")
    private int srpNumberPoints = 501;
    @Parameter(valueSet={"1", "2", "3", "4", "5"}, description="Degree of orbit (polynomial) interpolator", defaultValue="3", label="Orbit interpolation degree")
    private int orbitDegree = 3;
    @Parameter(description="Use ground square pixel", defaultValue="true", label="Square Pixel")
    private Boolean squarePixel = true;
    private Map<String, CplxContainer> masterMap = new HashMap<String, CplxContainer>();
    private Map<String, CplxContainer> slaveMap = new HashMap<String, CplxContainer>();
    private String[] polarisations;
    private String[] subswaths = new String[]{""};
    private Map<String, ProductContainer> targetMap = new HashMap<String, ProductContainer>();
    private Map<Band, Band> detectedSlaveMap = new HashMap<Band, Band>();
    private boolean isComplex;
    private boolean isTOPSARBurstProduct = false;
    private String productTag = null;
    private Sentinel1Utils su = null;
    private Sentinel1Utils.SubSwathInfo[] subSwath = null;
    private int numSubSwaths = 0;
    private int subSwathIndex = 0;
    private MetadataElement mstRoot = null;
    private MetadataElement slvRoot = null;
    private Point[] mstSceneCentreXYZ = null;
    private double slvSceneCentreAzimuthTime = 0.0;
    private HashMap<String, DoubleMatrix> flatEarthPolyMap = new HashMap();
    private int sourceImageWidth;
    private int sourceImageHeight;
    private static final int ORBIT_DEGREE = 3;
    private static final String COHERENCE_PHASE = "coherence_phase";
    private static final String PRODUCT_SUFFIX = "_Coh";

    public void initialize() throws OperatorException {
        try {
            this.productTag = "coh";
            this.mstRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            MetadataElement slaveElem = this.sourceProduct.getMetadataRoot().getElement("Slave_Metadata");
            if (slaveElem != null) {
                this.slvRoot = slaveElem.getElements()[0];
            }
            this.checkUserInput();
            this.constructSourceMetadata();
            this.constructTargetMetadata();
            this.createTargetProduct();
            if (this.isComplex && this.subtractFlatEarthPhase) {
                if (this.isTOPSARBurstProduct) {
                    this.getMstApproxSceneCentreXYZ();
                    this.getSlvApproxSceneCentreAzimuthTime();
                    this.constructFlatEarthPolynomialsForTOPSARProduct();
                } else {
                    this.constructFlatEarthPolynomials();
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void checkUserInput() {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSARProduct();
            validator.checkIfCoregisteredStack();
            this.isTOPSARBurstProduct = !validator.isDebursted();
            this.isComplex = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct).getAttributeString("SAMPLE_TYPE").contains("COMPLEX");
            if (this.isTOPSARBurstProduct) {
                this.su = new Sentinel1Utils(this.sourceProduct);
                this.subswaths = this.su.getSubSwathNames();
                this.subSwath = this.su.getSubSwath();
                this.numSubSwaths = this.su.getNumOfSubSwath();
                this.subSwathIndex = 1;
            }
            this.polarisations = OperatorUtils.getPolarisations((Product)this.sourceProduct);
            if (this.polarisations.length == 0) {
                this.polarisations = new String[]{""};
            }
            this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
            this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
        }
        catch (Exception e) {
            throw new OperatorException((Throwable)e);
        }
    }

    private void constructSourceMetadata() throws Exception {
        MetadataElement[] slaveRoot;
        String masterTag = "mst";
        String slaveTag = "slv";
        this.metaMapPut("mst", this.mstRoot, this.sourceProduct, this.masterMap);
        MetadataElement slaveElem = this.sourceProduct.getMetadataRoot().getElement("Slave_Metadata");
        if (slaveElem == null) {
            slaveElem = this.sourceProduct.getMetadataRoot().getElement("Slave Metadata");
        }
        for (MetadataElement meta : slaveRoot = slaveElem.getElements()) {
            this.metaMapPut("slv", meta, this.sourceProduct, this.slaveMap);
        }
    }

    private void metaMapPut(String tag, MetadataElement root, Product product, Map<String, CplxContainer> map) throws Exception {
        for (String swath : this.subswaths) {
            String subswath = swath.isEmpty() ? "" : '_' + swath.toUpperCase();
            for (String polarisation : this.polarisations) {
                String pol = polarisation.isEmpty() ? "" : '_' + polarisation.toUpperCase();
                String mapKey = root.getAttributeInt("ABS_ORBIT") + subswath + pol;
                String date = OperatorUtils.getAcquisitionDate((MetadataElement)root);
                SLCImage meta = new SLCImage(root, product);
                Orbit orbit = new Orbit(root, 3);
                Band bandReal = null;
                Band bandImag = null;
                for (String bandName : product.getBandNames()) {
                    if (!bandName.contains(tag) || !bandName.contains(date) || !subswath.isEmpty() && !bandName.contains(subswath) || !pol.isEmpty() && !bandName.contains(pol)) continue;
                    Band band = product.getBand(bandName);
                    if (BandUtilsDoris.isBandReal((Band)band)) {
                        bandReal = band;
                        continue;
                    }
                    if (!BandUtilsDoris.isBandImag((Band)band)) continue;
                    bandImag = band;
                }
                if (bandReal == null || bandImag == null) continue;
                map.put(mapKey, new CplxContainer(date, meta, orbit, bandReal, bandImag));
            }
        }
    }

    private void constructTargetMetadata() {
        for (String keyMaster : this.masterMap.keySet()) {
            CplxContainer master = this.masterMap.get(keyMaster);
            for (String keySlave : this.slaveMap.keySet()) {
                CplxContainer slave = this.slaveMap.get(keySlave);
                if ((master.polarisation != null || slave.polarisation != null) && (master.polarisation == null || !master.polarisation.equals(slave.polarisation))) continue;
                String productName = keyMaster + '_' + keySlave;
                ProductContainer product = new ProductContainer(productName, master, slave, false);
                this.targetMap.put(productName, product);
            }
        }
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName() + PRODUCT_SUFFIX, this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        if (this.isComplex) {
            for (String key : this.targetMap.keySet()) {
                ArrayList<String> targetBandNames = new ArrayList<String>();
                ProductContainer container = this.targetMap.get(key);
                CplxContainer master = container.sourceMaster;
                CplxContainer slave = container.sourceSlave;
                String subswath = master.subswath.isEmpty() ? "" : '_' + master.subswath.toUpperCase();
                String pol = InterferogramOp.getPolarisationTag(master);
                String tag = subswath + pol + '_' + master.date + '_' + slave.date;
                String coherenceBandName = this.productTag + tag;
                Band coherenceBand = this.targetProduct.addBand(coherenceBandName, 30);
                coherenceBand.setNoDataValueUsed(true);
                coherenceBand.setNoDataValue(master.realBand.getNoDataValue());
                container.addBand("coherence", coherenceBand.getName());
                coherenceBand.setUnit("coherence");
                targetBandNames.add(coherenceBand.getName());
                String slvProductName = StackUtils.findOriginalSlaveProductName((Product)this.sourceProduct, (Band)container.sourceSlave.realBand);
                StackUtils.saveSlaveProductBandNames((Product)this.targetProduct, (String)slvProductName, (String[])targetBandNames.toArray(new String[targetBandNames.size()]));
            }
        } else {
            String slaveBandName;
            int numSrcBands = this.sourceProduct.getNumBands();
            String[] bandNames = this.sourceProduct.getBandNames();
            if (numSrcBands < 2) {
                throw new OperatorException("To create a coherence image, more than 2 bands are needed.");
            }
            for (int i = 1; i <= numSrcBands && (slaveBandName = CoherenceOp.findBandName(bandNames, "slv" + i)) != null; ++i) {
                Band slaveBand = this.sourceProduct.getBand(slaveBandName);
                Band coherenceBand = this.targetProduct.addBand("Coherence_slv" + i, 30);
                coherenceBand.setUnit("coherence");
                this.detectedSlaveMap.put(coherenceBand, slaveBand);
            }
        }
    }

    private static String findBandName(String[] bandNames, String namePattern) {
        String bandName = null;
        for (String name : bandNames) {
            if (!name.contains(namePattern)) continue;
            bandName = name;
            break;
        }
        return bandName;
    }

    private void getMstApproxSceneCentreXYZ() throws Exception {
        int numOfBursts = this.subSwath[this.subSwathIndex - 1].numOfBursts;
        this.mstSceneCentreXYZ = new Point[numOfBursts];
        for (int b = 0; b < numOfBursts; ++b) {
            double firstLineTime = this.subSwath[this.subSwathIndex - 1].burstFirstLineTime[b];
            double lastLineTime = this.subSwath[this.subSwathIndex - 1].burstLastLineTime[b];
            double slrTimeToFirstPixel = this.subSwath[this.subSwathIndex - 1].slrTimeToFirstPixel;
            double slrTimeToLastPixel = this.subSwath[this.subSwathIndex - 1].slrTimeToLastPixel;
            double latUL = this.su.getLatitude(firstLineTime, slrTimeToFirstPixel, this.subSwathIndex);
            double latUR = this.su.getLatitude(firstLineTime, slrTimeToLastPixel, this.subSwathIndex);
            double latLL = this.su.getLatitude(lastLineTime, slrTimeToFirstPixel, this.subSwathIndex);
            double latLR = this.su.getLatitude(lastLineTime, slrTimeToLastPixel, this.subSwathIndex);
            double lonUL = this.su.getLongitude(firstLineTime, slrTimeToFirstPixel, this.subSwathIndex);
            double lonUR = this.su.getLongitude(firstLineTime, slrTimeToLastPixel, this.subSwathIndex);
            double lonLL = this.su.getLongitude(lastLineTime, slrTimeToFirstPixel, this.subSwathIndex);
            double lonLR = this.su.getLongitude(lastLineTime, slrTimeToLastPixel, this.subSwathIndex);
            double lat = (latUL + latUR + latLL + latLR) / 4.0;
            double lon = (lonUL + lonUR + lonLL + lonLR) / 4.0;
            PosVector mstSceneCenter = new PosVector();
            GeoUtils.geo2xyzWGS84((double)lat, (double)lon, (double)0.0, (PosVector)mstSceneCenter);
            this.mstSceneCentreXYZ[b] = new Point(mstSceneCenter.toArray());
        }
    }

    private void getSlvApproxSceneCentreAzimuthTime() throws Exception {
        double firstLineTimeInDays = this.slvRoot.getAttributeUTC("first_line_time").getMJD();
        double firstLineTime = (firstLineTimeInDays - (double)((int)firstLineTimeInDays)) * 86400.0;
        double lastLineTimeInDays = this.slvRoot.getAttributeUTC("last_line_time").getMJD();
        double lastLineTime = (lastLineTimeInDays - (double)((int)lastLineTimeInDays)) * 86400.0;
        this.slvSceneCentreAzimuthTime = 0.5 * (firstLineTime + lastLineTime);
    }

    private void constructFlatEarthPolynomialsForTOPSARProduct() throws Exception {
        for (String keyMaster : this.masterMap.keySet()) {
            CplxContainer master = this.masterMap.get(keyMaster);
            for (String keySlave : this.slaveMap.keySet()) {
                CplxContainer slave = this.slaveMap.get(keySlave);
                for (int s = 0; s < this.numSubSwaths; ++s) {
                    int numBursts = this.subSwath[s].numOfBursts;
                    for (int b = 0; b < numBursts; ++b) {
                        String polynomialName = slave.name + '_' + s + '_' + b;
                        this.flatEarthPolyMap.put(polynomialName, InterferogramOp.estimateFlatEarthPolynomial(master, slave, s + 1, b, this.mstSceneCentreXYZ, this.orbitDegree, this.srpPolynomialDegree, this.srpNumberPoints, this.subSwath, this.su));
                    }
                }
            }
        }
    }

    private void constructFlatEarthPolynomials() throws Exception {
        for (String keyMaster : this.masterMap.keySet()) {
            CplxContainer master = this.masterMap.get(keyMaster);
            for (String keySlave : this.slaveMap.keySet()) {
                CplxContainer slave = this.slaveMap.get(keySlave);
                this.flatEarthPolyMap.put(slave.name, InterferogramOp.estimateFlatEarthPolynomial(master.metaData, master.orbit, slave.metaData, slave.orbit, this.sourceImageWidth, this.sourceImageHeight, this.srpPolynomialDegree, this.srpNumberPoints, this.sourceProduct));
            }
        }
    }

    public void computeTileStack(Map<Band, Tile> targetTileMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        if (this.isTOPSARBurstProduct) {
            this.computeTileForTOPSARProduct(targetTileMap, targetRectangle, pm);
        } else if (!this.isComplex) {
            this.computeTileForDetectedProduct(targetTileMap, targetRectangle, pm);
        } else {
            this.computeTileForNormalProduct(targetTileMap, targetRectangle, pm);
        }
    }

    private void computeTileForDetectedProduct(Map<Band, Tile> targetTileMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            int x0 = targetRectangle.x;
            int y0 = targetRectangle.y;
            int w = targetRectangle.width;
            int h = targetRectangle.height;
            int maxX = x0 + w;
            int maxY = y0 + h;
            for (Band targetBand : targetTileMap.keySet()) {
                Tile targetTile = targetTileMap.get(targetBand);
                Band srcBand = this.sourceProduct.getBand(targetBand.getName());
                if (!targetBand.getUnit().contains("coherence")) {
                    Tile srcRaster = this.getSourceTile((RasterDataNode)srcBand, targetRectangle);
                    ProductData srcData = srcRaster.getDataBuffer();
                    ProductData targetData = targetTile.getDataBuffer();
                    for (int y = y0; y < maxY; ++y) {
                        for (int x = x0; x < maxX; ++x) {
                            int index = srcRaster.getDataBufferIndex(x, y);
                            targetData.setElemFloatAt(targetTile.getDataBufferIndex(x, y), srcData.getElemFloatAt(index));
                        }
                    }
                    continue;
                }
                String[] bandNames = this.sourceProduct.getBandNames();
                Band masterBand = this.sourceProduct.getBand(CoherenceOp.findBandName(bandNames, "mst"));
                Band slaveBand = this.detectedSlaveMap.get(targetBand);
                float[] dataArray = new float[w * h];
                RealCoherenceData realData = new RealCoherenceData();
                int k = 0;
                for (int y = y0; y < maxY; ++y) {
                    for (int x = x0; x < maxX; ++x) {
                        this.getMasterSlaveDataForCurWindow(x, y, masterBand, slaveBand, realData);
                        dataArray[k++] = CoherenceOp.computeCoherence(realData);
                    }
                }
                ProductData rawTargetData = ProductData.createInstance((float[])dataArray);
                targetTile.setRawSamples(rawTargetData);
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void getMasterSlaveDataForCurWindow(int xC, int yC, Band masterBand, Band slaveBand, RealCoherenceData realData) {
        int halfWindowSizeAz = this.cohWinAz / 2;
        int halfWindowSizeRg = this.cohWinRg / 2;
        int xUL = Math.max(xC - halfWindowSizeRg, 0);
        int yUL = Math.max(yC - halfWindowSizeAz, 0);
        int xLR = Math.min(xC + halfWindowSizeRg, this.sourceImageWidth - 1);
        int yLR = Math.min(yC + halfWindowSizeAz, this.sourceImageHeight - 1);
        int w = xLR - xUL + 1;
        int h = yLR - yUL + 1;
        RealCoherenceData.access$102(realData, new double[w * h]);
        RealCoherenceData.access$202(realData, new double[w * h]);
        Rectangle windowRectangle = new Rectangle(xUL, yUL, w, h);
        Tile masterRaster = this.getSourceTile((RasterDataNode)masterBand, windowRectangle);
        Tile slaveRaster = this.getSourceTile((RasterDataNode)slaveBand, windowRectangle);
        ProductData masterData = masterRaster.getDataBuffer();
        ProductData slaveData = slaveRaster.getDataBuffer();
        int k = 0;
        for (int y = yUL; y <= yLR; ++y) {
            for (int x = xUL; x <= xLR; ++x) {
                int index = masterRaster.getDataBufferIndex(x, y);
                ((RealCoherenceData)realData).m[k] = masterData.getElemDoubleAt(index);
                ((RealCoherenceData)realData).s[k] = slaveData.getElemDoubleAt(index);
                ++k;
            }
        }
    }

    private static float computeCoherence(RealCoherenceData realData) {
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sum3 = 0.0;
        for (int i = 0; i < realData.m.length; ++i) {
            double m = realData.m[i];
            double s = realData.s[i];
            sum1 += m * s;
            sum2 += m * m;
            sum3 += s * s;
        }
        return (float)(Math.abs(sum1) / Math.sqrt(sum2 * sum3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeTileForNormalProduct(Map<Band, Tile> targetTileMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            int cohx0 = targetRectangle.x - (this.cohWinRg - 1) / 2;
            int cohy0 = targetRectangle.y - (this.cohWinAz - 1) / 2;
            int cohw = targetRectangle.width + this.cohWinRg - 1;
            int cohh = targetRectangle.height + this.cohWinAz - 1;
            Rectangle extRect = new Rectangle(cohx0, cohy0, cohw, cohh);
            BorderExtender border = BorderExtender.createInstance((int)0);
            int y0 = targetRectangle.y;
            int yN = y0 + targetRectangle.height - 1;
            int x0 = targetRectangle.x;
            int xN = targetRectangle.x + targetRectangle.width - 1;
            for (String cohKey : this.targetMap.keySet()) {
                ProductContainer product = this.targetMap.get(cohKey);
                Tile tileRealMaster = this.getSourceTile((RasterDataNode)product.sourceMaster.realBand, extRect, border);
                Tile tileImagMaster = this.getSourceTile((RasterDataNode)product.sourceMaster.imagBand, extRect, border);
                ComplexDoubleMatrix dataMaster = TileUtilsDoris.pullComplexDoubleMatrix((Tile)tileRealMaster, (Tile)tileImagMaster);
                Tile tileRealSlave = this.getSourceTile((RasterDataNode)product.sourceSlave.realBand, extRect, border);
                Tile tileImagSlave = this.getSourceTile((RasterDataNode)product.sourceSlave.imagBand, extRect, border);
                ComplexDoubleMatrix dataSlave = TileUtilsDoris.pullComplexDoubleMatrix((Tile)tileRealSlave, (Tile)tileImagSlave);
                for (int i = 0; i < dataMaster.length; ++i) {
                    double tmp = CoherenceOp.norm(dataMaster.get(i));
                    dataMaster.put(i, dataMaster.get(i).mul(dataSlave.get(i).conj()));
                    dataSlave.put(i, new ComplexDouble(CoherenceOp.norm(dataSlave.get(i)), tmp));
                }
                ComplexDoubleMatrix cohMatrix = SarUtils.cplxCoherence((ComplexDoubleMatrix)dataMaster, (ComplexDoubleMatrix)dataSlave, (int)this.cohWinAz, (int)this.cohWinRg);
                if (this.subtractFlatEarthPhase) {
                    DoubleMatrix rangeAxisNormalized = DoubleMatrix.linspace((int)x0, (int)xN, (int)targetRectangle.width);
                    rangeAxisNormalized = InterferogramOp.normalizeDoubleMatrix(rangeAxisNormalized, 0.0, this.sourceImageWidth - 1);
                    DoubleMatrix azimuthAxisNormalized = DoubleMatrix.linspace((int)y0, (int)yN, (int)targetRectangle.height);
                    azimuthAxisNormalized = InterferogramOp.normalizeDoubleMatrix(azimuthAxisNormalized, 0.0, this.sourceImageHeight - 1);
                    DoubleMatrix polyCoeffs = this.flatEarthPolyMap.get(product.sourceSlave.name);
                    DoubleMatrix realReferencePhase = PolyUtils.polyval((DoubleMatrix)azimuthAxisNormalized, (DoubleMatrix)rangeAxisNormalized, (DoubleMatrix)polyCoeffs, (int)PolyUtils.degreeFromCoefficients((int)polyCoeffs.length));
                    ComplexDoubleMatrix complexReferencePhase = new ComplexDoubleMatrix(MatrixFunctions.cos((DoubleMatrix)realReferencePhase), MatrixFunctions.sin((DoubleMatrix)realReferencePhase));
                    cohMatrix.muli(complexReferencePhase.conji());
                }
                this.saveComplexCoherence(cohMatrix, product, targetTileMap, targetRectangle);
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeTileForTOPSARProduct(Map<Band, Tile> targetTileMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            int tx0 = targetRectangle.x;
            int ty0 = targetRectangle.y;
            int tw = targetRectangle.width;
            int th = targetRectangle.height;
            int txMax = tx0 + tw;
            int tyMax = ty0 + th;
            for (int burstIndex = 0; burstIndex < this.subSwath[this.subSwathIndex - 1].numOfBursts; ++burstIndex) {
                int firstLineIdx = burstIndex * this.subSwath[this.subSwathIndex - 1].linesPerBurst;
                int lastLineIdx = firstLineIdx + this.subSwath[this.subSwathIndex - 1].linesPerBurst - 1;
                if (tyMax <= firstLineIdx || ty0 > lastLineIdx) continue;
                int ntx0 = tx0;
                int ntw = tw;
                int nty0 = Math.max(ty0, firstLineIdx);
                int ntyMax = Math.min(tyMax, lastLineIdx + 1);
                int nth = ntyMax - nty0;
                Rectangle partialTileRectangle = new Rectangle(ntx0, nty0, ntw, nth);
                this.computePartialTile(this.subSwathIndex, burstIndex, targetTileMap, partialTileRectangle);
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    private void computePartialTile(int subSwathIndex, int burstIndex, Map<Band, Tile> targetTileMap, Rectangle targetRectangle) {
        try {
            int cohx0 = targetRectangle.x - (this.cohWinRg - 1) / 2;
            int cohy0 = targetRectangle.y - (this.cohWinAz - 1) / 2;
            int cohw = targetRectangle.width + this.cohWinRg - 1;
            int cohh = targetRectangle.height + this.cohWinAz - 1;
            Rectangle rect = new Rectangle(cohx0, cohy0, cohw, cohh);
            long minLine = burstIndex * this.subSwath[subSwathIndex - 1].linesPerBurst;
            long maxLine = minLine + (long)this.subSwath[subSwathIndex - 1].linesPerBurst - 1L;
            long minPixel = 0L;
            long maxPixel = this.subSwath[subSwathIndex - 1].samplesPerBurst - 1;
            BorderExtender border = BorderExtender.createInstance((int)0);
            int y0 = targetRectangle.y;
            int yN = y0 + targetRectangle.height - 1;
            int x0 = targetRectangle.x;
            int xN = x0 + targetRectangle.width - 1;
            for (String cohKey : this.targetMap.keySet()) {
                ProductContainer product = this.targetMap.get(cohKey);
                Tile tileRealMaster = this.getSourceTile((RasterDataNode)product.sourceMaster.realBand, rect, border);
                Tile tileImagMaster = this.getSourceTile((RasterDataNode)product.sourceMaster.imagBand, rect, border);
                ComplexDoubleMatrix dataMaster = TileUtilsDoris.pullComplexDoubleMatrix((Tile)tileRealMaster, (Tile)tileImagMaster);
                Tile tileRealSlave = this.getSourceTile((RasterDataNode)product.sourceSlave.realBand, rect, border);
                Tile tileImagSlave = this.getSourceTile((RasterDataNode)product.sourceSlave.imagBand, rect, border);
                ComplexDoubleMatrix dataSlave = TileUtilsDoris.pullComplexDoubleMatrix((Tile)tileRealSlave, (Tile)tileImagSlave);
                for (int r = 0; r < dataMaster.rows; ++r) {
                    int y = cohy0 + r;
                    for (int c = 0; c < dataMaster.columns; ++c) {
                        double tmp = CoherenceOp.norm(dataMaster.get(r, c));
                        if ((long)y < minLine || (long)y > maxLine) {
                            dataMaster.put(r, c, 0.0);
                        } else {
                            dataMaster.put(r, c, dataMaster.get(r, c).mul(dataSlave.get(r, c).conj()));
                        }
                        dataSlave.put(r, c, new ComplexDouble(CoherenceOp.norm(dataSlave.get(r, c)), tmp));
                    }
                }
                ComplexDoubleMatrix cohMatrix = SarUtils.cplxCoherence((ComplexDoubleMatrix)dataMaster, (ComplexDoubleMatrix)dataSlave, (int)this.cohWinAz, (int)this.cohWinRg);
                if (this.subtractFlatEarthPhase) {
                    DoubleMatrix rangeAxisNormalized = DoubleMatrix.linspace((int)x0, (int)xN, (int)targetRectangle.width);
                    rangeAxisNormalized = InterferogramOp.normalizeDoubleMatrix(rangeAxisNormalized, 0.0, maxPixel);
                    DoubleMatrix azimuthAxisNormalized = DoubleMatrix.linspace((int)y0, (int)yN, (int)targetRectangle.height);
                    azimuthAxisNormalized = InterferogramOp.normalizeDoubleMatrix(azimuthAxisNormalized, minLine, maxLine);
                    String polynomialName = product.sourceSlave.name + '_' + (subSwathIndex - 1) + '_' + burstIndex;
                    DoubleMatrix polyCoeffs = this.flatEarthPolyMap.get(polynomialName);
                    DoubleMatrix realReferencePhase = PolyUtils.polyval((DoubleMatrix)azimuthAxisNormalized, (DoubleMatrix)rangeAxisNormalized, (DoubleMatrix)polyCoeffs, (int)PolyUtils.degreeFromCoefficients((int)polyCoeffs.length));
                    ComplexDoubleMatrix complexReferencePhase = new ComplexDoubleMatrix(MatrixFunctions.cos((DoubleMatrix)realReferencePhase), MatrixFunctions.sin((DoubleMatrix)realReferencePhase));
                    cohMatrix.muli(complexReferencePhase.conji());
                }
                this.saveComplexCoherence(cohMatrix, product, targetTileMap, targetRectangle);
            }
        }
        catch (Exception e) {
            throw new OperatorException((Throwable)e);
        }
    }

    private void saveComplexCoherence(ComplexDoubleMatrix cohMatrix, ProductContainer product, Map<Band, Tile> targetTileMap, Rectangle targetRectangle) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int maxX = x0 + targetRectangle.width;
        int maxY = y0 + targetRectangle.height;
        Band coherenceBand = this.targetProduct.getBand(product.getBandName("coherence"));
        Tile coherenceTile = targetTileMap.get(coherenceBand);
        ProductData coherenceData = coherenceTile.getDataBuffer();
        DoubleMatrix dataReal = cohMatrix.real();
        DoubleMatrix dataImag = cohMatrix.imag();
        double srcNoDataValue = product.sourceMaster.realBand.getNoDataValue();
        Tile slvTileReal = this.getSourceTile((RasterDataNode)product.sourceSlave.realBand, targetRectangle);
        ProductData srcSlvData = slvTileReal.getDataBuffer();
        TileIndex srcSlvIndex = new TileIndex(slvTileReal);
        TileIndex tgtIndex = new TileIndex(coherenceTile);
        for (int y = y0; y < maxY; ++y) {
            tgtIndex.calculateStride(y);
            srcSlvIndex.calculateStride(y);
            int yy = y - y0;
            for (int x = x0; x < maxX; ++x) {
                int tgtIdx = tgtIndex.getIndex(x);
                int xx = x - x0;
                if (srcSlvData.getElemDoubleAt(srcSlvIndex.getIndex(x)) == srcNoDataValue) {
                    coherenceData.setElemFloatAt(tgtIdx, (float)srcNoDataValue);
                    continue;
                }
                double cohI = dataReal.get(yy, xx);
                double cohQ = dataImag.get(yy, xx);
                double coh = Math.sqrt(cohI * cohI + cohQ * cohQ);
                coherenceData.setElemFloatAt(tgtIdx, (float)coh);
            }
        }
    }

    private static double norm(ComplexDouble number) {
        return number.real() * number.real() + number.imag() * number.imag();
    }

    private static double norm(double real, double imag) {
        return real * real + imag * imag;
    }

    public static DoubleMatrix coherence(double[] iMst, double[] qMst, double[] iSlv, double[] qSlv, int winL, int winP, int w, int h) {
        ComplexDoubleMatrix input = new ComplexDoubleMatrix(h, w);
        ComplexDoubleMatrix norms = new ComplexDoubleMatrix(h, w);
        for (int y = 0; y < h; ++y) {
            int stride = y * w;
            for (int x = 0; x < w; ++x) {
                input.put(y, x, new ComplexDouble(iMst[stride + x], qMst[stride + x]));
                norms.put(y, x, new ComplexDouble(iSlv[stride + x], qSlv[stride + x]));
            }
        }
        if (input.rows != norms.rows) {
            throw new IllegalArgumentException("coherence: not the same dimensions.");
        }
        int extent_RG = input.columns;
        int extent_AZ = input.rows - winL + 1;
        DoubleMatrix result = new DoubleMatrix(input.rows - winL + 1, input.columns - winP + 1);
        int leadingZeros = (winP - 1) / 2;
        int trailingZeros = winP / 2;
        for (int j = leadingZeros; j < extent_RG - trailingZeros; ++j) {
            int l;
            ComplexDouble sum = new ComplexDouble(0.0);
            ComplexDouble power = new ComplexDouble(0.0);
            int minL = j - leadingZeros;
            int maxL = minL + winP;
            for (int k = 0; k < winL; ++k) {
                for (l = minL; l < maxL; ++l) {
                    int inI = 2 * input.index(k, l);
                    sum.set(sum.real() + input.data[inI], sum.imag() + input.data[inI + 1]);
                    power.set(power.real() + norms.data[inI], power.imag() + norms.data[inI + 1]);
                }
            }
            result.put(0, minL, CoherenceOp.coherenceProduct(sum, power));
            int maxI = extent_AZ - 1;
            for (int i = 0; i < maxI; ++i) {
                int iwinL = i + winL;
                for (l = minL; l < maxL; ++l) {
                    int inI = 2 * input.index(i, l);
                    int inWinL = 2 * input.index(iwinL, l);
                    sum.set(sum.real() + (input.data[inWinL] - input.data[inI]), sum.imag() + (input.data[inWinL + 1] - input.data[inI + 1]));
                    power.set(power.real() + (norms.data[inWinL] - norms.data[inI]), power.imag() + (norms.data[inWinL + 1] - norms.data[inI + 1]));
                }
                result.put(i + 1, j - leadingZeros, CoherenceOp.coherenceProduct(sum, power));
            }
        }
        return result;
    }

    static double coherenceProduct(ComplexDouble sum, ComplexDouble power) {
        double product = power.real() * power.imag();
        return product > 0.0 ? sum.abs() / Math.sqrt(product) : 0.0;
    }

    public static void getDerivedParameters(Product srcProduct, DerivedParams param) throws Exception {
        TiePointGrid incidenceAngle;
        MetadataElement abs = AbstractMetadata.getAbstractedMetadata((Product)srcProduct);
        double rangeSpacing = abs.getAttributeDouble("range_spacing", 1.0);
        double azimuthSpacing = abs.getAttributeDouble("azimuth_spacing", 1.0);
        boolean srgrFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)abs, (String)"srgr_flag");
        double groundRangeSpacing = rangeSpacing;
        if (rangeSpacing == 99999.0) {
            azimuthSpacing = 1.0;
            groundRangeSpacing = 1.0;
        } else if (!srgrFlag && (incidenceAngle = OperatorUtils.getIncidenceAngle((Product)srcProduct)) != null) {
            int sourceImageWidth = srcProduct.getSceneRasterWidth();
            int sourceImageHeight = srcProduct.getSceneRasterHeight();
            int x = sourceImageWidth / 2;
            int y = sourceImageHeight / 2;
            double incidenceAngleAtCentreRangePixel = incidenceAngle.getPixelDouble(x, y);
            groundRangeSpacing /= Math.sin(incidenceAngleAtCentreRangePixel * (Math.PI / 180));
        }
        double cohWinAz = (double)param.cohWinRg * groundRangeSpacing / azimuthSpacing;
        if (cohWinAz < 1.0) {
            param.cohWinAz = 2;
            param.cohWinRg = (int)Math.round(azimuthSpacing / groundRangeSpacing);
        } else {
            param.cohWinAz = (int)Math.round(cohWinAz);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(CoherenceOp.class);
        }
    }

    private static class RealCoherenceData {
        private double[] m = null;
        private double[] s = null;

        private RealCoherenceData() {
        }

        static /* synthetic */ double[] access$102(RealCoherenceData x0, double[] x1) {
            x0.m = x1;
            return x1;
        }

        static /* synthetic */ double[] access$202(RealCoherenceData x0, double[] x1) {
            x0.s = x1;
            return x1;
        }
    }

    public static class DerivedParams {
        public int cohWinAz = 0;
        public int cohWinRg = 0;
    }
}

