/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.rcp.toolviews.insar_statistics;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Formatter;
import java.util.Locale;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.esa.s1tbx.insar.rcp.toolviews.InSARStatisticsTopComponent;
import org.esa.s1tbx.insar.rcp.toolviews.insar_statistics.InSARStatistic;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.util.ResourceUtils;
import org.esa.snap.rcp.SnapApp;

public class StatResiduals
implements InSARStatistic {
    private JTextArea textarea;
    private final InSARStatisticsTopComponent parent;
    private static final String EmptyMsg = "This tool window requires a coregistered Stripmap stack product to be selected";

    public StatResiduals(InSARStatisticsTopComponent parent) {
        this.parent = parent;
    }

    @Override
    public String getName() {
        return "Coregistration Residuals";
    }

    @Override
    public Component createPanel() {
        this.textarea = new JTextArea();
        return new JScrollPane(this.textarea);
    }

    @Override
    public void update(Product product) {
        try {
            if (!InSARStatistic.isValidProduct(product)) {
                this.textarea.setText(EmptyMsg);
            } else {
                String content = "";
                MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
                File residualFile = StatResiduals.getResidualFile(absRoot);
                content = residualFile.exists() ? StatResiduals.readFile(residualFile) : StatResiduals.readFromMetadata(product, absRoot);
                this.textarea.setText(content);
            }
        }
        catch (Exception e) {
            SnapApp.getDefault().handleError("Unable to update product", (Throwable)e);
        }
    }

    @Override
    public void copyToClipboard() {
        SystemUtils.copyToClipboard((String)this.textarea.getText());
    }

    @Override
    public void saveToFile() {
        this.saveToFile(this.textarea.getText());
    }

    @Override
    public String getHelpId() {
        return "StatResiduals";
    }

    private static File getResidualFile(MetadataElement absRoot) {
        String mstName = absRoot.getAttributeString("PRODUCT");
        return new File(ResourceUtils.getReportFolder(), mstName + "_residual.txt");
    }

    private static String readFile(File file) {
        StringBuilder str = new StringBuilder();
        try (FileInputStream fis = new FileInputStream(file);){
            int content;
            while ((content = fis.read()) != -1) {
                str.append((char)content);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return str.toString();
    }

    private static String readFromMetadata(Product product, MetadataElement absRoot) {
        Band[] bands;
        StringBuilder str = new StringBuilder();
        Formatter formatter = new Formatter(str, Locale.US);
        for (Band band : bands = product.getBands()) {
            MetadataElement warpDataElem;
            MetadataElement bandElem = AbstractMetadata.getBandAbsMetadata((MetadataElement)absRoot, (String)band.getName(), (boolean)false);
            if (bandElem == null || (warpDataElem = bandElem.getElement("WarpData")) == null) continue;
            MetadataElement[] GCPElems = warpDataElem.getElements();
            formatter.format("%15s %15s %15s %15s %15s %20s\n", "GCP", "mst_x", "mst_y", "slv_x", "slv_y", "rms");
            for (MetadataElement GCPElem : GCPElems) {
                formatter.format("%15s", GCPElem.getName());
                for (String attrib : GCPElem.getAttributeNames()) {
                    double value = GCPElem.getAttributeDouble(attrib);
                    formatter.format("%15.4f", value);
                }
                str.append('\n');
            }
            str.append('\n');
            formatter.format("%-20s %-25.4f\n", "rmsStd", warpDataElem.getAttributeDouble("rmsStd", 0.0));
            formatter.format("%-20s %-25.4f\n", "rmsMean", warpDataElem.getAttributeDouble("rmsMean", 0.0));
            formatter.format("%-20s %-25.4f\n", "rowResidualStd", warpDataElem.getAttributeDouble("rowResidualStd", 0.0));
            formatter.format("%-20s %-25.4f\n", "rowResidualMean", warpDataElem.getAttributeDouble("rowResidualMean", 0.0));
            formatter.format("%-20s %-25.4f\n", "colResidualStd", warpDataElem.getAttributeDouble("colResidualStd", 0.0));
            formatter.format("%-20s %-25.4f\n", "colResidualMean", warpDataElem.getAttributeDouble("colResidualMean", 0.0));
            break;
        }
        return str.toString();
    }
}

