/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.rcp.toolviews.insar_statistics;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.esa.s1tbx.insar.rcp.toolviews.InSARStatisticsTopComponent;
import org.esa.s1tbx.insar.rcp.toolviews.insar_statistics.InSARStatistic;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.rcp.SnapApp;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class StatESDMeasure
implements InSARStatistic {
    private JPanel panel;
    private ChartPanel chartPanel;
    private JTextArea textarea;
    private JFreeChart chart;
    private XYSeriesCollection dataset;
    private Map<String, Map<Integer, Double>> esdData = new HashMap<String, Map<Integer, Double>>();
    private final InSARStatisticsTopComponent parent;
    private static final String TITLE = "Estimated Azimuth Shifts per Burst Overlap";
    private static final String XAXIS_LABEL = "Burst Overlap #";
    private static final String YAXIS_LABEL = "ESD Measurement [cm]";
    public static final String ESD_MEASURE_ELEM = "ESD Measurement";
    public static final String EmptyMsg = "This tool window requires a coregistered TOPSAR stack product to be selected with ESD applied to it.";

    public StatESDMeasure(InSARStatisticsTopComponent parent) {
        this.parent = parent;
    }

    @Override
    public String getName() {
        return "ESD Measure";
    }

    @Override
    public Component createPanel() {
        this.dataset = new XYSeriesCollection();
        this.chart = ChartFactory.createXYLineChart((String)TITLE, (String)XAXIS_LABEL, (String)YAXIS_LABEL, (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.setPreferredSize(new Dimension(500, 470));
        this.chartPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.panel = new JPanel(new BorderLayout());
        this.textarea = new JTextArea(EmptyMsg);
        this.panel.add((Component)this.textarea, "North");
        this.panel.add((Component)this.chartPanel, "Center");
        this.setVisible(false);
        return this.panel;
    }

    @Override
    public void update(Product product) {
        try {
            if (InSARStatistic.isValidProduct(product) && this.readESDMeasure(product)) {
                this.setVisible(true);
                this.dataset.removeAllSeries();
                int i = 0;
                for (Map.Entry<String, Map<Integer, Double>> stringMapEntry : this.esdData.entrySet()) {
                    XYSeries series = new XYSeries((Comparable)((Object)stringMapEntry.getKey()));
                    Map<Integer, Double> values = stringMapEntry.getValue();
                    for (Map.Entry<Integer, Double> integerDoubleEntry : values.entrySet()) {
                        series.add((double)(integerDoubleEntry.getKey() + 1), (Number)integerDoubleEntry.getValue());
                    }
                    this.dataset.addSeries(series);
                    XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)this.chart.getXYPlot().getRenderer();
                    renderer.setSeriesLinesVisible(i, true);
                    renderer.setSeriesShapesVisible(i, true);
                    this.chart.getXYPlot().getDomainAxis().setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                    ++i;
                }
            } else {
                this.setVisible(false);
            }
        }
        catch (Exception e) {
            SnapApp.getDefault().handleError("Unable to update product", (Throwable)e);
        }
    }

    private void setVisible(boolean flag) {
        this.textarea.setVisible(!flag);
        this.chartPanel.setVisible(flag);
    }

    private synchronized boolean readESDMeasure(Product product) {
        MetadataElement[] subSwathElems;
        MetadataElement azimuthShiftElem;
        MetadataElement esdElem;
        this.esdData.clear();
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        if (absRoot != null && (esdElem = absRoot.getElement(ESD_MEASURE_ELEM)) != null && (azimuthShiftElem = esdElem.getElement("Azimuth_Shift_Per_Overlap")) != null && (subSwathElems = azimuthShiftElem.getElements()) != null) {
            for (MetadataElement subSwathElem : subSwathElems) {
                HashMap<Integer, Double> shiftMap = new HashMap<Integer, Double>(9);
                this.esdData.put(subSwathElem.getName(), shiftMap);
                MetadataElement[] overlapElems = subSwathElem.getElements();
                if (overlapElems == null) continue;
                for (MetadataElement overlapElem : overlapElems) {
                    int overlapIndex = overlapElem.getAttributeInt("overlapIndex");
                    double azimuthShift = overlapElem.getAttributeDouble("azimuthShift");
                    shiftMap.put(overlapIndex, azimuthShift);
                }
            }
        }
        return !this.esdData.isEmpty();
    }

    @Override
    public void copyToClipboard() {
        this.chartPanel.doCopy();
    }

    @Override
    public void saveToFile() {
        try {
            this.chartPanel.doSaveAs();
        }
        catch (Exception e) {
            SnapApp.getDefault().handleError("Unable to save to file", (Throwable)e);
        }
    }

    @Override
    public String getHelpId() {
        return "StatESDMeasure";
    }
}

