/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.rcp.toolviews.insar_statistics;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.esa.s1tbx.insar.gpf.InSARStackOverview;
import org.esa.s1tbx.insar.rcp.toolviews.InSARStatisticsTopComponent;
import org.esa.s1tbx.insar.rcp.toolviews.insar_statistics.InSARStatistic;
import org.esa.s1tbx.insar.rcp.toolviews.insar_statistics.StatBaselines;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.rcp.SnapApp;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class StatBaselinesChart
implements InSARStatistic {
    private JPanel panel;
    private ChartPanel chartPanel;
    private JTextArea textarea;
    private JFreeChart chart;
    private XYSeriesCollection dataset;
    private final InSARStatisticsTopComponent parent;
    private static final String TITLE = "Baselines";
    private static final String XAXIS_LABEL = "Temporal Baseline";
    private static final String YAXIS_LABEL = "Perpendicular Baseline";
    public static final String EmptyMsg = "This tool window requires a coregistered stack product.";

    public StatBaselinesChart(InSARStatisticsTopComponent parent) {
        this.parent = parent;
    }

    @Override
    public String getName() {
        return "Baseline Chart";
    }

    @Override
    public Component createPanel() {
        this.dataset = new XYSeriesCollection();
        this.chart = ChartFactory.createXYLineChart((String)TITLE, (String)XAXIS_LABEL, (String)YAXIS_LABEL, (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.setPreferredSize(new Dimension(500, 470));
        this.chartPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.panel = new JPanel(new BorderLayout());
        this.textarea = new JTextArea(EmptyMsg);
        this.panel.add((Component)this.textarea, "North");
        this.panel.add((Component)this.chartPanel, "Center");
        this.setVisible(false);
        return this.panel;
    }

    private StatBaselines getStatBaselineComponent() {
        List<InSARStatistic> components = this.parent.getStatisticComponents();
        for (InSARStatistic component : components) {
            if (!(component instanceof StatBaselines)) continue;
            return (StatBaselines)component;
        }
        return null;
    }

    private StatBaselines.CachedBaseline[] getBaselines(Product product) {
        StatBaselines statBaselines = this.getStatBaselineComponent();
        if (statBaselines != null) {
            return statBaselines.getBaselines(product);
        }
        return null;
    }

    @Override
    public void update(Product product) {
        try {
            if (!InSARStatistic.isValidProduct(product)) {
                this.setVisible(false);
                return;
            }
            StatBaselines.CachedBaseline[] baselines = this.getBaselines(product);
            if (baselines == null) {
                this.setVisible(false);
                return;
            }
            XYSeries series = new XYSeries((Comparable)((Object)"data"));
            for (StatBaselines.CachedBaseline baseline : baselines) {
                InSARStackOverview.IfgPair slave = baseline.getIfgPair();
                if (slave.getSlaveMetadata() == slave.getMasterMetadata()) continue;
                series.add((double)slave.getTemporalBaseline(), (double)slave.getPerpendicularBaseline());
            }
            this.setVisible(true);
            this.dataset.removeAllSeries();
            this.dataset.addSeries(series);
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)this.chart.getXYPlot().getRenderer();
            renderer.setSeriesLinesVisible(0, false);
            renderer.setSeriesShapesVisible(0, true);
            renderer.setSeriesItemLabelsVisible(0, true);
            this.chart.getXYPlot().getDomainAxis().setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        }
        catch (Exception e) {
            SnapApp.getDefault().handleError("Unable to update product", (Throwable)e);
        }
    }

    private void setVisible(boolean flag) {
        this.textarea.setVisible(!flag);
        this.chartPanel.setVisible(flag);
    }

    @Override
    public void copyToClipboard() {
        this.chartPanel.doCopy();
    }

    @Override
    public void saveToFile() {
        try {
            this.chartPanel.doSaveAs();
        }
        catch (Exception e) {
            SnapApp.getDefault().handleError("Unable to save to file", (Throwable)e);
        }
    }

    @Override
    public String getHelpId() {
        return "StatBaselinesChart";
    }
}

