/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.rcp.toolviews;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.esa.s1tbx.insar.rcp.toolviews.Bundle;
import org.esa.s1tbx.insar.rcp.toolviews.insar_statistics.InSARStatistic;
import org.esa.s1tbx.insar.rcp.toolviews.insar_statistics.StatBaselines;
import org.esa.s1tbx.insar.rcp.toolviews.insar_statistics.StatBaselinesChart;
import org.esa.s1tbx.insar.rcp.toolviews.insar_statistics.StatESDHistogram;
import org.esa.s1tbx.insar.rcp.toolviews.insar_statistics.StatESDMeasure;
import org.esa.s1tbx.insar.rcp.toolviews.insar_statistics.StatInSARInfo;
import org.esa.s1tbx.insar.rcp.toolviews.insar_statistics.StatResiduals;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.SelectionSupport;
import org.esa.snap.tango.TangoIcons;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="InSARStatisticsTopComponent", iconBase="org/esa/s1tbx/insar/icons/stack24.png", persistenceType=2)
public class InSARStatisticsTopComponent
extends TopComponent {
    public static final String EmptyMsg = "This tool window requires a coregistered stack product to be selected";
    private final List<InSARStatistic> statisticList = new ArrayList<InSARStatistic>();
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private ProductNode oldNode = null;
    private static final ImageIcon copyIcon = TangoIcons.actions_edit_copy((TangoIcons.Res)TangoIcons.Res.R22);
    private static final ImageIcon saveIcon = TangoIcons.actions_document_save_as((TangoIcons.Res)TangoIcons.Res.R22);
    private static final ImageIcon helpIcon = TangoIcons.apps_help_browser((TangoIcons.Res)TangoIcons.Res.R22);

    public InSARStatisticsTopComponent() {
        this.setLayout(new BorderLayout());
        this.setDisplayName(Bundle.CTL_InSARStatisticsTopComponentName());
        this.setToolTipText(Bundle.CTL_InSARStatisticsTopComponentDescription());
        this.add(this.createPanel(), "Center");
        this.add(this.createButtonPanel(), "East");
        SnapApp snapApp = SnapApp.getDefault();
        snapApp.getProductManager().addListener((ProductManager.Listener)new ProductManagerListener());
        snapApp.getSelectionSupport(ProductNode.class).addHandler((SelectionSupport.Handler)new SelectionSupport.Handler<ProductNode>(){

            public void selectionChange(@NullAllowed ProductNode oldValue, @NullAllowed ProductNode newValue) {
                if (newValue != null && newValue != InSARStatisticsTopComponent.this.oldNode) {
                    Product product = newValue.getProduct();
                    for (InSARStatistic statistic : InSARStatisticsTopComponent.this.statisticList) {
                        statistic.update(product);
                    }
                    InSARStatisticsTopComponent.this.oldNode = newValue;
                }
            }
        });
        Product product = snapApp.getSelectedProduct(SnapApp.SelectionSourceHint.AUTO);
        if (InSARStatistic.isValidProduct(product)) {
            for (InSARStatistic statistic : this.statisticList) {
                statistic.update(product);
            }
        }
    }

    public JTabbedPane createPanel() {
        this.statisticList.add(new StatInSARInfo(this));
        this.statisticList.add(new StatResiduals(this));
        this.statisticList.add(new StatESDMeasure(this));
        this.statisticList.add(new StatESDHistogram(this));
        this.statisticList.add(new StatBaselines(this));
        this.statisticList.add(new StatBaselinesChart(this));
        for (InSARStatistic statistic : this.statisticList) {
            this.tabbedPane.add(statistic.getName(), statistic.createPanel());
        }
        this.tabbedPane.setSelectedIndex(0);
        return this.tabbedPane;
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        JButton copyBtn = DialogUtils.createButton((String)"copyBtn", (String)"Copy", (ImageIcon)copyIcon, (JPanel)buttonPanel, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        copyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InSARStatistic stat = (InSARStatistic)InSARStatisticsTopComponent.this.statisticList.get(InSARStatisticsTopComponent.this.tabbedPane.getSelectedIndex());
                stat.copyToClipboard();
            }
        });
        JButton saveBtn = DialogUtils.createButton((String)"saveBtn", (String)"Save", (ImageIcon)saveIcon, (JPanel)buttonPanel, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InSARStatistic stat = (InSARStatistic)InSARStatisticsTopComponent.this.statisticList.get(InSARStatisticsTopComponent.this.tabbedPane.getSelectedIndex());
                stat.saveToFile();
            }
        });
        JButton helpBtn = DialogUtils.createButton((String)"helpBtn", (String)"Help", (ImageIcon)helpIcon, (JPanel)buttonPanel, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        helpBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InSARStatistic stat = (InSARStatistic)InSARStatisticsTopComponent.this.statisticList.get(InSARStatisticsTopComponent.this.tabbedPane.getSelectedIndex());
                new HelpCtx(stat.getHelpId()).display();
            }
        });
        buttonPanel.add(Box.createRigidArea(new Dimension(10, 25)));
        buttonPanel.add(copyBtn);
        buttonPanel.add(saveBtn);
        buttonPanel.add(helpBtn);
        return buttonPanel;
    }

    public List<InSARStatistic> getStatisticComponents() {
        return this.statisticList;
    }

    public class ProductManagerListener
    implements ProductManager.Listener {
        public void productAdded(ProductManager.Event event) {
            Product product = event.getProduct();
            for (InSARStatistic statistic : InSARStatisticsTopComponent.this.statisticList) {
                statistic.update(product);
            }
        }

        public void productRemoved(ProductManager.Event event) {
            for (InSARStatistic statistic : InSARStatisticsTopComponent.this.statisticList) {
                statistic.update(null);
            }
        }
    }
}

