/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.rcp.layersrc;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerTypeRegistry;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.Viewport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import org.esa.s1tbx.dat.graphics.GraphicShape;
import org.esa.s1tbx.dat.layers.ScreenPixelConverter;
import org.esa.s1tbx.insar.rcp.layersrc.GCPVectorLayerType;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;

public class GCPVectorLayer
extends Layer {
    private final Product product;
    private final Band band;
    private static final float lineThickness = 1.0f;
    private final List<GCPData> gcpList = new ArrayList<GCPData>(200);

    public GCPVectorLayer(PropertySet configuration) {
        super(LayerTypeRegistry.getLayerType((String)GCPVectorLayerType.class.getName()), configuration);
        this.setName("GCP Movement");
        this.product = (Product)configuration.getValue("product");
        this.band = (Band)configuration.getValue("band");
        this.getData();
    }

    private void getData() {
        MetadataElement warpDataElem;
        MetadataElement bandElem;
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.product);
        if (absRoot != null && (bandElem = AbstractMetadata.getBandAbsMetadata((MetadataElement)absRoot, (String)this.band.getName(), (boolean)false)) != null && (warpDataElem = bandElem.getElement("WarpData")) != null) {
            MetadataElement[] gcpElems = warpDataElem.getElements();
            this.gcpList.clear();
            for (MetadataElement gcpElem : gcpElems) {
                double mstX = gcpElem.getAttributeDouble("mst_x", 0.0);
                double mstY = gcpElem.getAttributeDouble("mst_y", 0.0);
                double slvX = gcpElem.getAttributeDouble("slv_x", 0.0);
                double slvY = gcpElem.getAttributeDouble("slv_y", 0.0);
                this.gcpList.add(new GCPData(mstX, mstY, slvX, slvY));
            }
        }
    }

    protected void renderLayer(Rendering rendering) {
        Band raster;
        if (this.gcpList.isEmpty()) {
            return;
        }
        Viewport vp = rendering.getViewport();
        ScreenPixelConverter screenPixel = new ScreenPixelConverter(vp, (RasterDataNode)(raster = this.band));
        if (!screenPixel.withInBounds()) {
            return;
        }
        Graphics2D graphics = rendering.getGraphics();
        graphics.setStroke(new BasicStroke(1.0f));
        graphics.setColor(Color.RED);
        for (GCPData gcp : this.gcpList) {
            GraphicShape.drawArrow((Graphics2D)graphics, (ScreenPixelConverter)screenPixel, (int)((int)gcp.slvX), (int)((int)gcp.slvY), (int)((int)gcp.mstX), (int)((int)gcp.mstY), (int)50);
        }
    }

    private static class GCPData {
        public final double mstX;
        public final double mstY;
        public final double slvX;
        public final double slvY;

        public GCPData(double mX, double mY, double sX, double sY) {
            this.mstX = mX;
            this.mstY = mY;
            this.slvX = sX;
            this.slvY = sY;
        }
    }
}

