/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.rcp.dialogs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.engine_utilities.db.CommonReaders;
import org.esa.snap.graphbuilder.rcp.dialogs.BatchGraphDialog;
import org.esa.snap.graphbuilder.rcp.dialogs.support.GraphExecuter;
import org.esa.snap.graphbuilder.rcp.dialogs.support.GraphNode;
import org.esa.snap.ui.AppContext;

public class VirtualStackCoregistrationDialog
extends BatchGraphDialog {
    public VirtualStackCoregistrationDialog(AppContext theAppContext, String title, String helpID, boolean closeOnDone) {
        super(theAppContext, title, helpID, closeOnDone);
        this.openProcessedProducts = true;
        this.LoadGraph(VirtualStackCoregistrationDialog.getDefaultGraphFile());
    }

    private static File getDefaultGraphFile() {
        return new File(defaultGraphPath + File.separator + "internal" + File.separator + "coregistration", "MultiOutputCoregister.xml");
    }

    protected void cloneGraphs() throws Exception {
        GraphExecuter graphEx = (GraphExecuter)this.graphExecutorList.get(0);
        for (int graphIndex = 1; graphIndex < this.graphExecutorList.size(); ++graphIndex) {
            GraphExecuter cloneGraphEx = (GraphExecuter)this.graphExecutorList.get(graphIndex);
            cloneGraphEx.ClearGraph();
        }
        this.graphExecutorList.clear();
        this.graphExecutorList.add(graphEx);
        File[] fileList = this.productSetPanel.getFileList();
        for (int graphIndex = 1; graphIndex < fileList.length - 1; ++graphIndex) {
            GraphExecuter cloneGraphEx = new GraphExecuter();
            this.LoadGraph(cloneGraphEx, this.graphFile, false);
            this.graphExecutorList.add(cloneGraphEx);
            List cloneGraphNodes = cloneGraphEx.GetGraphNodes();
            for (GraphNode cloneNode : cloneGraphNodes) {
                GraphNode graphNode = graphEx.getGraphNodeList().findGraphNode(cloneNode.getID());
            }
        }
    }

    private File[] getSlaveFileList() {
        File[] fileList = this.productSetPanel.getFileList();
        if (fileList == null || fileList.length == 0) {
            return null;
        }
        File masterFile = fileList[0];
        ArrayList<File> slaveList = new ArrayList<File>(fileList.length);
        for (File f : fileList) {
            if (f == masterFile) continue;
            slaveList.add(f);
        }
        return slaveList.toArray(new File[slaveList.size()]);
    }

    protected void assignParameters() {
        File[] fileList = this.productSetPanel.getFileList();
        if (fileList == null || fileList.length == 0) {
            return;
        }
        File masterFile = fileList[0];
        File[] slaveList = this.getSlaveFileList();
        int graphIndex = 0;
        for (File slaveFile : slaveList) {
            String name;
            try {
                Product slvProduct = CommonReaders.readProduct((File)slaveFile);
                name = slvProduct.getName();
            }
            catch (IOException e) {
                name = FileUtils.getFilenameWithoutExtension((File)slaveFile);
            }
            File targetFile = new File(this.productSetPanel.getTargetFolder(), name);
            String targetFormat = this.productSetPanel.getTargetFormat();
            VirtualStackCoregistrationDialog.setIO((GraphExecuter)((GraphExecuter)this.graphExecutorList.get(graphIndex)), (String)"Read", (File)masterFile, (String)"Write", (File)targetFile, (String)targetFormat);
            VirtualStackCoregistrationDialog.setSlaveIO((GraphExecuter)((GraphExecuter)this.graphExecutorList.get(graphIndex)), (String)"ProductSet-Reader", (File)masterFile, (File[])new File[]{slaveFile});
            ++graphIndex;
        }
    }
}

