/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.rcp.dialogs;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.esa.s1tbx.insar.gpf.InSARStackOverview;
import org.esa.s1tbx.insar.rcp.dialogs.InSARFileModel;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.db.CommonReaders;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.graphbuilder.rcp.dialogs.ProductSetPanel;
import org.esa.snap.graphbuilder.rcp.dialogs.support.FileTableModel;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.productlibrary.rcp.utils.ProductOpener;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.ModelessDialog;
import org.jlinda.core.Orbit;
import org.jlinda.core.SLCImage;

public class InSARStackOverviewDialog
extends ModelessDialog {
    DecimalFormat df = new DecimalFormat("0.00");
    private boolean ok = false;
    private final InSARFileModel outputFileModel = new InSARFileModel();
    private final AppContext appContext = SnapApp.getDefault().getAppContext();
    private final ProductSetPanel inputProductListPanel = new ProductSetPanel(this.appContext, "Input stack");
    private final ProductSetPanel outputProductListPanel = new ProductSetPanel(this.appContext, "Overview", (FileTableModel)this.outputFileModel);
    private final Map<SLCImage, File> slcFileMap = new HashMap<SLCImage, File>(10);
    private JButton openBtn;
    private final JCheckBox searchDBCheckBox = new JCheckBox("Search Product Library");

    public InSARStackOverviewDialog() {
        super((Window)SnapApp.getDefault().getMainFrame(), "Stack Overview and Optimal InSAR Master Selection", 161, "InSARStackOverview");
        this.getButton(1).setText("Overview");
        this.getButton(32).setText("Close");
        this.initContent();
    }

    private void initContent() {
        JPanel contentPane = new JPanel(new BorderLayout());
        JPanel buttonPanel1 = new JPanel(new GridLayout(10, 1));
        JButton addAllBtn = DialogUtils.createButton((String)"addAllBtn", (String)"Add Opened", null, (JPanel)buttonPanel1, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Text);
        addAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Product[] products = SnapApp.getDefault().getProductManager().getProducts();
                ArrayList<File> fileList = new ArrayList<File>(products.length);
                for (Product prod : products) {
                    File file = prod.getFileLocation();
                    if (file == null || !file.exists()) continue;
                    fileList.add(file);
                }
                InSARStackOverviewDialog.this.inputProductListPanel.setProductFileList(fileList.toArray(new File[fileList.size()]));
            }
        });
        buttonPanel1.add(addAllBtn);
        JButton clearBtn = DialogUtils.createButton((String)"clearBtn", (String)"Clear", null, (JPanel)buttonPanel1, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Text);
        clearBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InSARStackOverviewDialog.this.inputProductListPanel.setProductFileList(new File[0]);
            }
        });
        buttonPanel1.add(clearBtn);
        this.inputProductListPanel.add((Component)buttonPanel1, (Object)"East");
        contentPane.add((Component)this.inputProductListPanel, "North");
        JPanel optionsPane = new JPanel(new GridBagLayout());
        optionsPane.setBorder(BorderFactory.createTitledBorder("Options"));
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)optionsPane, (GridBagConstraints)gbc, (String)"", (JComponent)this.searchDBCheckBox);
        ++gbc.gridy;
        JPanel buttonPanel2 = new JPanel(new GridLayout(10, 1));
        this.openBtn = DialogUtils.createButton((String)"openButton", (String)"     Open     ", null, (JPanel)buttonPanel2, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Text);
        this.openBtn.setEnabled(false);
        this.openBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File[] files = InSARStackOverviewDialog.this.outputProductListPanel.getSelectedFiles();
                if (files.length == 0) {
                    files = InSARStackOverviewDialog.this.outputProductListPanel.getFileList();
                }
                ProductOpener.openProducts((File[])files);
            }
        });
        buttonPanel2.add(this.openBtn);
        this.outputProductListPanel.add((Component)buttonPanel2, (Object)"East");
        contentPane.add((Component)this.outputProductListPanel, "South");
        this.setContent(contentPane);
    }

    public void setInputProductList(ProductEntry[] productEntryList) {
        this.inputProductListPanel.setProductEntryList(productEntryList);
        this.processStack();
    }

    private void validate() throws Exception {
        File[] inputFiles = this.inputProductListPanel.getFileList();
        if (inputFiles.length < 2) {
            throw new Exception("Please select at least two SLC products");
        }
    }

    private void processStack() {
        try {
            this.validate();
            File[] inputFiles = this.inputProductListPanel.getFileList();
            InSARStackOverview.IfgStack[] ifgStack = this.findInSARProducts(inputFiles);
            if (ifgStack == null) {
                this.openBtn.setEnabled(false);
                Dialogs.showWarning((String)"Optimal master not found");
            } else {
                InSARStackOverview dataStack = new InSARStackOverview();
                int masterIndex = dataStack.findOptimalMaster(ifgStack);
                InSARStackOverview.IfgPair[] slaveList = ifgStack[masterIndex].getMasterSlave();
                this.updateData(slaveList, masterIndex);
                this.openBtn.setEnabled(true);
                this.ok = true;
            }
        }
        catch (Exception e) {
            Dialogs.showError((String)("Error: " + e.getMessage()));
        }
    }

    protected void onOK() {
        this.processStack();
    }

    public boolean IsOK() {
        return this.ok;
    }

    private void updateData(InSARStackOverview.IfgPair[] slaveList, int masterIndex) {
        this.outputFileModel.clear();
        File mstFile = this.slcFileMap.get(slaveList[masterIndex].getMasterMetadata());
        try {
            Product productMst = CommonReaders.readProduct((File)mstFile);
            MetadataElement absRootMst = AbstractMetadata.getAbstractedMetadata((Product)productMst);
            String[] mstValues = new String[]{productMst.getName(), "Master", OperatorUtils.getAcquisitionDate((MetadataElement)absRootMst), String.valueOf(absRootMst.getAttributeInt("REL_ORBIT", 0)), String.valueOf(absRootMst.getAttributeInt("ABS_ORBIT", 0)), String.valueOf(this.df.format(slaveList[masterIndex].getPerpendicularBaseline())), String.valueOf(this.df.format(slaveList[masterIndex].getTemporalBaseline())), String.valueOf(this.df.format(slaveList[masterIndex].getCoherence())), String.valueOf(this.df.format(slaveList[masterIndex].getHeightAmb())), String.valueOf(this.df.format(slaveList[masterIndex].getDopplerDifference()))};
            this.outputFileModel.addFile(mstFile, mstValues);
        }
        catch (Exception e) {
            Dialogs.showError((String)("Unable to read " + mstFile.getName() + '\n' + e.getMessage()));
        }
        for (InSARStackOverview.IfgPair slave : slaveList) {
            File slvFile = this.slcFileMap.get(slave.getSlaveMetadata());
            if (slvFile.equals(mstFile)) continue;
            try {
                Product product = CommonReaders.readProduct((File)slvFile);
                MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
                String[] slvValues = new String[]{product.getName(), "Slave", OperatorUtils.getAcquisitionDate((MetadataElement)absRoot), String.valueOf(absRoot.getAttributeInt("REL_ORBIT", 0)), String.valueOf(absRoot.getAttributeInt("ABS_ORBIT", 0)), String.valueOf(this.df.format(slave.getPerpendicularBaseline())), String.valueOf(this.df.format(slave.getTemporalBaseline())), String.valueOf(this.df.format(slave.getCoherence())), String.valueOf(this.df.format(slave.getHeightAmb())), String.valueOf(this.df.format(slave.getDopplerDifference()))};
                this.outputFileModel.addFile(slvFile, slvValues);
            }
            catch (Exception e) {
                Dialogs.showError((String)("Unable to read " + slvFile.getName() + '\n' + e.getMessage()));
            }
        }
    }

    private InSARStackOverview.IfgStack[] findInSARProducts(File[] inputFiles) {
        ArrayList<SLCImage> imgList = new ArrayList<SLCImage>(inputFiles.length);
        ArrayList<Orbit> orbList = new ArrayList<Orbit>(inputFiles.length);
        for (File file : inputFiles) {
            try {
                Product product = CommonReaders.readProduct((File)file);
                MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
                SLCImage img = new SLCImage(absRoot, product);
                Orbit orb = new Orbit(absRoot, 3);
                this.slcFileMap.put(img, file);
                imgList.add(img);
                orbList.add(orb);
            }
            catch (IOException e) {
                Dialogs.showError((String)("Error: unable to read " + file.getPath() + '\n' + e.getMessage()));
            }
            catch (Exception e) {
                Dialogs.showError((String)("Error: " + file.getPath() + '\n' + e.getMessage()));
            }
        }
        try {
            InSARStackOverview dataStack = new InSARStackOverview();
            dataStack.setInput(imgList.toArray(new SLCImage[imgList.size()]), orbList.toArray(new Orbit[orbList.size()]));
            Worker worker = new Worker(SnapApp.getDefault().getMainFrame(), "Computing Optimal InSAR Master", dataStack);
            worker.executeWithBlocking();
            return (InSARStackOverview.IfgStack[])worker.get();
        }
        catch (Throwable t) {
            Dialogs.showError((String)("Error:" + t.getMessage()));
            return null;
        }
    }

    private static class Worker
    extends ProgressMonitorSwingWorker {
        private final InSARStackOverview dataStack;

        Worker(Component component, String title, InSARStackOverview optimalMaster) {
            super(component, title);
            this.dataStack = optimalMaster;
        }

        protected Object doInBackground(ProgressMonitor pm) throws Exception {
            return this.dataStack.getCoherenceScores(pm);
        }
    }
}

