/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf.ui.coregistration;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.ui.AppContext;

public class WarpOpUI
extends BaseOperatorUI {
    private final JComboBox<String> warpPolynomialOrder = new JComboBox<String>(new String[]{"1", "2", "3"});
    private final JComboBox<String> interpolationMethod = new JComboBox<String>(new String[]{"Nearest-neighbor interpolation", "Bilinear interpolation", "Bicubic interpolation", "Bicubic2 interpolation", "Linear interpolation", "Cubic convolution (4 points)", "Cubic convolution (6 points)", "Truncated sinc (6 points)", "Truncated sinc (8 points)", "Truncated sinc (16 points)"});
    private final JComboBox<String> rmsThreshold = new JComboBox<String>(new String[]{"0.001", "0.05", "0.1", "0.5", "1.0"});
    private final JCheckBox openResidualsFileCheckBox = new JCheckBox("Show Residuals");
    private boolean openResidualsFile;

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        this.openResidualsFileCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                WarpOpUI.this.openResidualsFile = e.getStateChange() == 1;
            }
        });
        return new JScrollPane(panel);
    }

    public void initParameters() {
        this.rmsThreshold.setSelectedItem(String.valueOf(this.paramMap.get("rmsThreshold")));
        this.warpPolynomialOrder.setSelectedItem(this.paramMap.get("warpPolynomialOrder"));
        this.interpolationMethod.setSelectedItem(this.paramMap.get("interpolationMethod"));
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        this.paramMap.put("rmsThreshold", Float.valueOf(Float.parseFloat((String)this.rmsThreshold.getSelectedItem())));
        this.paramMap.put("warpPolynomialOrder", Integer.parseInt((String)this.warpPolynomialOrder.getSelectedItem()));
        this.paramMap.put("interpolationMethod", this.interpolationMethod.getSelectedItem());
        this.paramMap.put("openResidualsFile", this.openResidualsFile);
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"RMS Threshold (pixel accuracy):", this.rmsThreshold);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Warp Polynomial Order:", this.warpPolynomialOrder);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Interpolation Method:", this.interpolationMethod);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridx = 0;
        ++gbc.gridy;
        contentPane.add((Component)this.openResidualsFileCheckBox, gbc);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }
}

