/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf.ui.coregistration;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.resamp.ResamplingFactory;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.ui.AppContext;

public class OffsetTrackingOpUI
extends BaseOperatorUI {
    private final JTextField gridAzimuthSpacing = new JTextField("");
    private final JTextField gridRangeSpacing = new JTextField("");
    private final JTextField gridAzimuthSpacingInMeters = new JTextField("");
    private final JTextField gridRangeSpacingInMeters = new JTextField("");
    private final JTextField gridAzimuthDimension = new JTextField("");
    private final JTextField gridRangeDimension = new JTextField("");
    private final JTextField totalGridPoints = new JTextField("");
    private final JComboBox<String> registrationWindowWidth = new JComboBox<String>(new String[]{"32", "64", "128", "256", "512", "1024", "2048"});
    private final JComboBox<String> registrationWindowHeight = new JComboBox<String>(new String[]{"32", "64", "128", "256", "512", "1024", "2048"});
    private final JTextField xCorrThreshold = new JTextField("");
    private final JComboBox<String> averageBoxSize = new JComboBox<String>(new String[]{"3", "5", "7", "9"});
    private final JTextField maxVelocity = new JTextField("");
    private final JTextField radius = new JTextField("");
    private final JComboBox resamplingType = new JComboBox<String>(ResamplingFactory.resamplingNames);

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        return new JScrollPane(panel);
    }

    public void initParameters() {
        this.gridAzimuthSpacing.setText(String.valueOf(this.paramMap.get("gridAzimuthSpacing")));
        this.gridRangeSpacing.setText(String.valueOf(this.paramMap.get("gridRangeSpacing")));
        this.registrationWindowWidth.setSelectedItem(this.paramMap.get("registrationWindowWidth"));
        this.registrationWindowHeight.setSelectedItem(this.paramMap.get("registrationWindowHeight"));
        this.xCorrThreshold.setText(String.valueOf(this.paramMap.get("xCorrThreshold")));
        this.averageBoxSize.setSelectedItem(this.paramMap.get("averageBoxSize"));
        this.maxVelocity.setText(String.valueOf(this.paramMap.get("maxVelocity")));
        this.radius.setText(String.valueOf(this.paramMap.get("radius")));
        this.resamplingType.setSelectedItem(this.paramMap.get("resamplingType"));
        this.gridAzimuthSpacingInMeters.setText("");
        this.gridAzimuthSpacingInMeters.setEditable(false);
        this.gridRangeSpacingInMeters.setText("");
        this.gridRangeSpacingInMeters.setEditable(false);
        this.gridAzimuthDimension.setText("");
        this.gridAzimuthDimension.setEditable(false);
        this.gridRangeDimension.setText("");
        this.gridRangeDimension.setEditable(false);
        this.totalGridPoints.setText("");
        this.totalGridPoints.setEditable(false);
        if (this.sourceProducts != null && this.sourceProducts.length > 0) {
            this.setDerivedAzimuthParameters();
            this.setDerivedRangeParameters();
        }
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        this.paramMap.put("gridAzimuthSpacing", Integer.parseInt(this.gridAzimuthSpacing.getText()));
        this.paramMap.put("gridRangeSpacing", Integer.parseInt(this.gridRangeSpacing.getText()));
        this.paramMap.put("registrationWindowWidth", this.registrationWindowWidth.getSelectedItem());
        this.paramMap.put("registrationWindowHeight", this.registrationWindowHeight.getSelectedItem());
        this.paramMap.put("xCorrThreshold", Double.parseDouble(this.xCorrThreshold.getText()));
        this.paramMap.put("averageBoxSize", this.averageBoxSize.getSelectedItem());
        this.paramMap.put("maxVelocity", Double.parseDouble(this.maxVelocity.getText()));
        this.paramMap.put("radius", Integer.parseInt(this.radius.getText()));
        this.paramMap.put("resamplingType", this.resamplingType.getSelectedItem());
        this.setDerivedAzimuthParameters();
        this.setDerivedRangeParameters();
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        contentPane.add((Component)new JLabel(" "), gbc);
        ++gbc.gridy;
        JPanel gridPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc2 = DialogUtils.createGridBagConstraints();
        gridPanel.setBorder(BorderFactory.createTitledBorder("Output Grid"));
        DialogUtils.addComponent((JPanel)gridPanel, (GridBagConstraints)gbc2, (String)"Grid Azimuth Spacing (in pixels):", (JComponent)this.gridAzimuthSpacing);
        ++gbc2.gridy;
        DialogUtils.addComponent((JPanel)gridPanel, (GridBagConstraints)gbc2, (String)"Grid Range Spacing (in pixels):", (JComponent)this.gridRangeSpacing);
        ++gbc2.gridy;
        DialogUtils.addComponent((JPanel)gridPanel, (GridBagConstraints)gbc2, (String)"Grid Azimuth Spacing (in meters):", (JComponent)this.gridAzimuthSpacingInMeters);
        ++gbc2.gridy;
        DialogUtils.addComponent((JPanel)gridPanel, (GridBagConstraints)gbc2, (String)"Grid Range Spacing (in meters):", (JComponent)this.gridRangeSpacingInMeters);
        ++gbc2.gridy;
        DialogUtils.addComponent((JPanel)gridPanel, (GridBagConstraints)gbc2, (String)"Grid Azimuth Dimension:", (JComponent)this.gridAzimuthDimension);
        ++gbc2.gridy;
        DialogUtils.addComponent((JPanel)gridPanel, (GridBagConstraints)gbc2, (String)"Grid Range Dimension:", (JComponent)this.gridRangeDimension);
        ++gbc2.gridy;
        DialogUtils.addComponent((JPanel)gridPanel, (GridBagConstraints)gbc2, (String)"Total Grid Points:", (JComponent)this.totalGridPoints);
        this.gridAzimuthSpacing.setDocument(new gridAzimuthSpacingDocument());
        this.gridRangeSpacing.setDocument(new gridRangeSpacingDocument());
        JPanel registrationPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc3 = DialogUtils.createGridBagConstraints();
        registrationPanel.setBorder(BorderFactory.createTitledBorder("Registration"));
        DialogUtils.addComponent((JPanel)registrationPanel, (GridBagConstraints)gbc3, (String)"Registration Window Width:", this.registrationWindowWidth);
        ++gbc3.gridy;
        DialogUtils.addComponent((JPanel)registrationPanel, (GridBagConstraints)gbc3, (String)"Registration Window Height:", this.registrationWindowHeight);
        ++gbc3.gridy;
        DialogUtils.addComponent((JPanel)registrationPanel, (GridBagConstraints)gbc3, (String)"Cross-Correlation Threshold:", (JComponent)this.xCorrThreshold);
        ++gbc3.gridy;
        DialogUtils.addComponent((JPanel)registrationPanel, (GridBagConstraints)gbc3, (String)"Average Box Size:", this.averageBoxSize);
        ++gbc3.gridy;
        DialogUtils.addComponent((JPanel)registrationPanel, (GridBagConstraints)gbc3, (String)"Max Velocity (m/day):", (JComponent)this.maxVelocity);
        ++gbc3.gridy;
        DialogUtils.addComponent((JPanel)registrationPanel, (GridBagConstraints)gbc3, (String)"Radius for Hole Filling:", (JComponent)this.radius);
        ++gbc3.gridy;
        contentPane.add((Component)gridPanel, gbc);
        gbc.gridx = 1;
        contentPane.add((Component)registrationPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Resampling Type:", (JComponent)this.resamplingType);
        ++gbc.gridy;
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }

    private synchronized void setDerivedAzimuthParameters() {
        if (this.sourceProducts != null && this.sourceProducts.length > 0) {
            try {
                int sourceImageWidth = this.sourceProducts[0].getSceneRasterWidth();
                int sourceImageHeight = this.sourceProducts[0].getSceneRasterHeight();
                int gridRgSpacingInPixel = Integer.parseInt(this.gridRangeSpacing.getText());
                int gridAzSpacingInPixel = Integer.parseInt(this.gridAzimuthSpacing.getText());
                MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProducts[0]);
                double azPixelSpacing = 0.0;
                if (absRoot != null) {
                    azPixelSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"azimuth_spacing");
                }
                if (azPixelSpacing != 0.0) {
                    double azSpacingInM = azPixelSpacing * (double)gridAzSpacingInPixel;
                    this.gridAzimuthSpacingInMeters.setText(String.valueOf(azSpacingInM));
                }
                int azimuthDimension = sourceImageHeight / gridAzSpacingInPixel;
                this.gridAzimuthDimension.setText(String.valueOf(azimuthDimension));
                int rangeDimension = sourceImageWidth / gridRgSpacingInPixel;
                int totalPoints = rangeDimension * azimuthDimension;
                this.totalGridPoints.setText(String.valueOf(totalPoints));
            }
            catch (Exception e) {
                this.gridAzimuthSpacingInMeters.setText("");
                this.gridAzimuthDimension.setText("");
            }
        }
    }

    private synchronized void setDerivedRangeParameters() {
        if (this.sourceProducts != null && this.sourceProducts.length > 0) {
            try {
                int sourceImageWidth = this.sourceProducts[0].getSceneRasterWidth();
                int sourceImageHeight = this.sourceProducts[0].getSceneRasterHeight();
                int gridRgSpacingInPixel = Integer.parseInt(this.gridRangeSpacing.getText());
                int gridAzSpacingInPixel = Integer.parseInt(this.gridAzimuthSpacing.getText());
                MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProducts[0]);
                double rgPixelSpacing = 0.0;
                if (absRoot != null) {
                    rgPixelSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"range_spacing");
                }
                if (rgPixelSpacing != 0.0) {
                    double rgSpacingInM = rgPixelSpacing * (double)gridRgSpacingInPixel;
                    this.gridRangeSpacingInMeters.setText(String.valueOf(rgSpacingInM));
                }
                int rangeDimension = sourceImageWidth / gridRgSpacingInPixel;
                this.gridRangeDimension.setText(String.valueOf(rangeDimension));
                int azimuthDimension = sourceImageHeight / gridAzSpacingInPixel;
                int totalPoints = rangeDimension * azimuthDimension;
                this.totalGridPoints.setText(String.valueOf(totalPoints));
            }
            catch (Exception e) {
                this.gridRangeSpacingInMeters.setText("");
                this.gridRangeDimension.setText("");
            }
        }
    }

    private class gridRangeSpacingDocument
    extends PlainDocument {
        private gridRangeSpacingDocument() {
        }

        @Override
        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            super.replace(offset, length, text, attrs);
            OffsetTrackingOpUI.this.setDerivedRangeParameters();
        }
    }

    private class gridAzimuthSpacingDocument
    extends PlainDocument {
        private gridAzimuthSpacingDocument() {
        }

        @Override
        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            super.replace(offset, length, text, attrs);
            OffsetTrackingOpUI.this.setDerivedAzimuthParameters();
        }
    }
}

