/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf.ui.coregistration;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.ui.AppContext;

public class CrossCorrelationOpUI
extends BaseOperatorUI {
    private final JComboBox<String> coarseRegistrationWindowWidth = new JComboBox<String>(new String[]{"32", "64", "128", "256", "512", "1024", "2048"});
    private final JComboBox<String> coarseRegistrationWindowHeight = new JComboBox<String>(new String[]{"32", "64", "128", "256", "512", "1024", "2048"});
    private final JComboBox<String> rowInterpFactor = new JComboBox<String>(new String[]{"2", "4", "8", "16"});
    private final JComboBox<String> columnInterpFactor = new JComboBox<String>(new String[]{"2", "4", "8", "16"});
    private final JTextField numGCPtoGenerate = new JTextField("");
    private final JTextField maxIteration = new JTextField("");
    private final JTextField gcpTolerance = new JTextField("");
    final JCheckBox applyFineRegistrationCheckBox = new JCheckBox("Apply Fine Registration for SLCs");
    final JRadioButton crossCorrelationCheckBox = new JRadioButton("Cross-Correlation based registration");
    final JRadioButton coherenceCheckBox = new JRadioButton("Coherence based registration");
    private final JComboBox<String> fineRegistrationWindowWidth = new JComboBox<String>(new String[]{"8", "16", "32", "64", "128", "256", "512"});
    private final JComboBox<String> fineRegistrationWindowHeight = new JComboBox<String>(new String[]{"8", "16", "32", "64", "128", "256", "512"});
    private final JComboBox<String> fineRegistrationWindowAccAzimuth = new JComboBox<String>(new String[]{"2", "4", "8", "16", "64"});
    private final JComboBox<String> fineRegistrationWindowAccRange = new JComboBox<String>(new String[]{"2", "4", "8", "16", "64"});
    private final JComboBox<String> fineRegistrationOversampling = new JComboBox<String>(new String[]{"2", "4", "8", "16", "32", "64"});
    private final JTextField coherenceWindowSize = new JTextField("");
    private final JTextField coherenceThreshold = new JTextField("");
    private final JCheckBox useSlidingWindowCheckBox = new JCheckBox("Use Coherence Sliding Window");
    private boolean useSlidingWindow = false;
    private boolean isComplex = false;
    private boolean applyFineRegistration = true;
    private boolean inSAROptimized = true;
    final JCheckBox computeOffsetCheckBox = new JCheckBox("Estimate Initial Coarse Offset");
    private boolean computeOffset = false;
    final JCheckBox onlyGCPsOnLandCheckBox = new JCheckBox("Test GCPs are on land");
    private boolean onlyGCPsOnLand = false;

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        this.applyFineRegistrationCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CrossCorrelationOpUI.this.applyFineRegistration = e.getStateChange() == 1;
                CrossCorrelationOpUI.this.enableComplexFields();
            }
        });
        this.crossCorrelationCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CrossCorrelationOpUI.this.inSAROptimized = e.getStateChange() == 1;
                CrossCorrelationOpUI.this.enableComplexFields();
            }
        });
        this.useSlidingWindowCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CrossCorrelationOpUI.this.useSlidingWindow = e.getStateChange() == 1;
                CrossCorrelationOpUI.this.coherenceWindowSize.setEditable(CrossCorrelationOpUI.this.useSlidingWindow);
                CrossCorrelationOpUI.this.enableComplexFields();
            }
        });
        this.computeOffsetCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CrossCorrelationOpUI.this.computeOffset = e.getStateChange() == 1;
            }
        });
        this.onlyGCPsOnLandCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CrossCorrelationOpUI.this.onlyGCPsOnLand = e.getStateChange() == 1;
            }
        });
        return new JScrollPane(panel);
    }

    public void initParameters() {
        this.numGCPtoGenerate.setText(String.valueOf(this.paramMap.get("numGCPtoGenerate")));
        this.coarseRegistrationWindowWidth.setSelectedItem(this.paramMap.get("coarseRegistrationWindowWidth"));
        this.coarseRegistrationWindowHeight.setSelectedItem(this.paramMap.get("coarseRegistrationWindowHeight"));
        this.rowInterpFactor.setSelectedItem(this.paramMap.get("rowInterpFactor"));
        this.columnInterpFactor.setSelectedItem(this.paramMap.get("columnInterpFactor"));
        this.maxIteration.setText(String.valueOf(this.paramMap.get("maxIteration")));
        this.gcpTolerance.setText(String.valueOf(this.paramMap.get("gcpTolerance")));
        if (this.sourceProducts != null && this.sourceProducts.length > 0) {
            InputProductValidator validator = new InputProductValidator(this.sourceProducts[0]);
            this.isComplex = validator.isComplex();
        }
        if (this.isComplex) {
            this.applyFineRegistration = (Boolean)this.paramMap.get("applyFineRegistration");
            this.applyFineRegistrationCheckBox.setSelected(this.applyFineRegistration);
            this.crossCorrelationCheckBox.setSelected(this.inSAROptimized);
            this.fineRegistrationWindowWidth.setSelectedItem(this.paramMap.get("fineRegistrationWindowWidth"));
            this.fineRegistrationWindowHeight.setSelectedItem(this.paramMap.get("fineRegistrationWindowHeight"));
            this.fineRegistrationWindowAccAzimuth.setSelectedItem(this.paramMap.get("fineRegistrationWindowAccAzimuth"));
            this.fineRegistrationWindowAccRange.setSelectedItem(this.paramMap.get("fineRegistrationWindowAccRange"));
            this.fineRegistrationOversampling.setSelectedItem(this.paramMap.get("fineRegistrationOversampling"));
            Boolean useSlidingWindowVal = (Boolean)this.paramMap.get("useSlidingWindow");
            if (useSlidingWindowVal != null) {
                this.useSlidingWindow = useSlidingWindowVal;
            }
            this.useSlidingWindowCheckBox.setSelected(this.useSlidingWindow);
            this.coherenceWindowSize.setText(String.valueOf(this.paramMap.get("coherenceWindowSize")));
            this.coherenceThreshold.setText(String.valueOf(this.paramMap.get("coherenceThreshold")));
        }
        this.enableComplexFields();
        Boolean offsetValue = (Boolean)this.paramMap.get("computeOffset");
        if (offsetValue != null) {
            this.computeOffset = offsetValue;
        }
        this.computeOffsetCheckBox.setSelected(this.computeOffset);
        Boolean gcpOnLandValue = (Boolean)this.paramMap.get("onlyGCPsOnLand");
        if (gcpOnLandValue != null) {
            this.onlyGCPsOnLand = gcpOnLandValue;
        }
        this.onlyGCPsOnLandCheckBox.setSelected(this.onlyGCPsOnLand);
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        this.paramMap.put("numGCPtoGenerate", Integer.parseInt(this.numGCPtoGenerate.getText()));
        this.paramMap.put("coarseRegistrationWindowWidth", this.coarseRegistrationWindowWidth.getSelectedItem());
        this.paramMap.put("coarseRegistrationWindowHeight", this.coarseRegistrationWindowHeight.getSelectedItem());
        this.paramMap.put("rowInterpFactor", this.rowInterpFactor.getSelectedItem());
        this.paramMap.put("columnInterpFactor", this.columnInterpFactor.getSelectedItem());
        this.paramMap.put("maxIteration", Integer.parseInt(this.maxIteration.getText()));
        this.paramMap.put("gcpTolerance", Double.parseDouble(this.gcpTolerance.getText()));
        if (this.isComplex) {
            this.paramMap.put("applyFineRegistration", this.applyFineRegistration);
            if (this.applyFineRegistration) {
                this.paramMap.put("inSAROptimized", this.inSAROptimized);
                this.paramMap.put("fineRegistrationWindowWidth", this.fineRegistrationWindowWidth.getSelectedItem());
                this.paramMap.put("fineRegistrationWindowHeight", this.fineRegistrationWindowHeight.getSelectedItem());
                this.paramMap.put("fineRegistrationWindowAccAzimuth", this.fineRegistrationWindowAccAzimuth.getSelectedItem());
                this.paramMap.put("fineRegistrationWindowAccRange", this.fineRegistrationWindowAccRange.getSelectedItem());
                this.paramMap.put("fineRegistrationOversampling", this.fineRegistrationOversampling.getSelectedItem());
                this.paramMap.put("coherenceThreshold", Double.parseDouble(this.coherenceThreshold.getText()));
                this.paramMap.put("useSlidingWindow", this.useSlidingWindow);
                this.paramMap.put("coherenceWindowSize", Integer.parseInt(this.coherenceWindowSize.getText()));
            }
        }
        this.paramMap.put("computeOffset", this.computeOffset);
        this.paramMap.put("onlyGCPsOnLand", this.onlyGCPsOnLand);
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Number of GCPs:", (JComponent)this.numGCPtoGenerate);
        ++gbc.gridy;
        contentPane.add((Component)this.onlyGCPsOnLandCheckBox, gbc);
        gbc.gridx = 1;
        contentPane.add((Component)this.applyFineRegistrationCheckBox, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        contentPane.add((Component)new JLabel(" "), gbc);
        ++gbc.gridy;
        JPanel coarsePanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc2 = DialogUtils.createGridBagConstraints();
        coarsePanel.setBorder(BorderFactory.createTitledBorder("Coarse Registration"));
        coarsePanel.add((Component)this.computeOffsetCheckBox, gbc2);
        ++gbc2.gridy;
        DialogUtils.addComponent((JPanel)coarsePanel, (GridBagConstraints)gbc2, (String)"Coarse Window Width:", this.coarseRegistrationWindowWidth);
        ++gbc2.gridy;
        DialogUtils.addComponent((JPanel)coarsePanel, (GridBagConstraints)gbc2, (String)"Coarse Window Height:", this.coarseRegistrationWindowHeight);
        ++gbc2.gridy;
        DialogUtils.addComponent((JPanel)coarsePanel, (GridBagConstraints)gbc2, (String)"Row Interpolation Factor:", this.rowInterpFactor);
        ++gbc2.gridy;
        DialogUtils.addComponent((JPanel)coarsePanel, (GridBagConstraints)gbc2, (String)"Column Interpolation Factor:", this.columnInterpFactor);
        ++gbc2.gridy;
        DialogUtils.addComponent((JPanel)coarsePanel, (GridBagConstraints)gbc2, (String)"Max Iterations:", (JComponent)this.maxIteration);
        ++gbc2.gridy;
        DialogUtils.addComponent((JPanel)coarsePanel, (GridBagConstraints)gbc2, (String)"GCP Tolerance:", (JComponent)this.gcpTolerance);
        JPanel finePanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc3 = DialogUtils.createGridBagConstraints();
        finePanel.setBorder(BorderFactory.createTitledBorder("Fine Registration"));
        DialogUtils.addComponent((JPanel)finePanel, (GridBagConstraints)gbc3, (String)"Fine Window Width:", this.fineRegistrationWindowWidth);
        ++gbc3.gridy;
        DialogUtils.addComponent((JPanel)finePanel, (GridBagConstraints)gbc3, (String)"Fine Window Height:", this.fineRegistrationWindowHeight);
        ++gbc3.gridy;
        DialogUtils.addComponent((JPanel)finePanel, (GridBagConstraints)gbc3, (String)"Coherence Threshold:", (JComponent)this.coherenceThreshold);
        ++gbc3.gridy;
        finePanel.add((Component)this.crossCorrelationCheckBox, gbc3);
        ++gbc3.gridy;
        DialogUtils.addComponent((JPanel)finePanel, (GridBagConstraints)gbc3, (String)"Fine Accuracy in Azimuth:", this.fineRegistrationWindowAccAzimuth);
        ++gbc3.gridy;
        DialogUtils.addComponent((JPanel)finePanel, (GridBagConstraints)gbc3, (String)"Fine Accuracy in Range:", this.fineRegistrationWindowAccRange);
        ++gbc3.gridy;
        DialogUtils.addComponent((JPanel)finePanel, (GridBagConstraints)gbc3, (String)"Fine Window oversampling factor:", this.fineRegistrationOversampling);
        ++gbc3.gridy;
        ButtonGroup group = new ButtonGroup();
        group.add(this.crossCorrelationCheckBox);
        group.add(this.coherenceCheckBox);
        finePanel.add((Component)this.coherenceCheckBox, gbc3);
        ++gbc3.gridy;
        finePanel.add((Component)this.useSlidingWindowCheckBox, gbc3);
        ++gbc3.gridy;
        DialogUtils.addComponent((JPanel)finePanel, (GridBagConstraints)gbc3, (String)"Coherence Window Size:", (JComponent)this.coherenceWindowSize);
        ++gbc3.gridy;
        this.enableComplexFields();
        contentPane.add((Component)coarsePanel, gbc);
        gbc.gridx = 1;
        contentPane.add((Component)finePanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }

    private void enableComplexFields() {
        this.applyFineRegistrationCheckBox.setEnabled(this.isComplex);
        this.crossCorrelationCheckBox.setEnabled(this.isComplex && this.applyFineRegistration);
        this.fineRegistrationWindowWidth.setEnabled(this.isComplex && this.applyFineRegistration);
        this.fineRegistrationWindowHeight.setEnabled(this.isComplex && this.applyFineRegistration);
        this.fineRegistrationWindowAccAzimuth.setEnabled(this.isComplex && this.applyFineRegistration && this.inSAROptimized);
        this.fineRegistrationWindowAccRange.setEnabled(this.isComplex && this.applyFineRegistration && this.inSAROptimized);
        this.fineRegistrationOversampling.setEnabled(this.isComplex && this.applyFineRegistration && this.inSAROptimized);
        this.coherenceWindowSize.setEnabled(this.isComplex && this.applyFineRegistration && this.useSlidingWindow && !this.inSAROptimized);
        this.coherenceThreshold.setEnabled(this.isComplex && this.applyFineRegistration);
        this.useSlidingWindowCheckBox.setEnabled(this.isComplex && this.applyFineRegistration && !this.inSAROptimized);
    }
}

