/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf.ui.coregistration;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.esa.s1tbx.insar.gpf.InSARStackOverview;
import org.esa.s1tbx.insar.gpf.coregistration.CreateStackOp;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.resamp.ResamplingFactory;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUIUtils;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.AppContext;

public class CreateStackOpUI
extends BaseOperatorUI {
    private final JList mstBandList = new JList();
    private final JList slvBandList = new JList();
    private final List<Integer> defaultMasterBandIndices = new ArrayList<Integer>(2);
    private final List<Integer> defaultSlaveBandIndices = new ArrayList<Integer>(2);
    private final JLabel masterProductLabel = new JLabel();
    private final JComboBox resamplingType = new JComboBox<String>(ResamplingFactory.resamplingNames);
    private final JComboBox initialOffsetMethod = new JComboBox<String>(new String[]{"Orbit", "Product Geolocation"});
    private final JComboBox extent = new JComboBox<String>(new String[]{"Master", "Minimum", "Maximum"});
    private final JButton optimalMasterButton = new JButton("Find Optimal Master");
    private Product masterProduct = null;

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.resamplingType.addItem("NONE");
        this.initParameters();
        return new JScrollPane(panel);
    }

    public void initParameters() {
        if (this.masterProduct == null && this.sourceProducts != null && this.sourceProducts.length > 0) {
            this.masterProduct = this.sourceProducts[0];
        }
        if (this.masterProduct != null) {
            this.masterProductLabel.setText(this.masterProduct.getName());
        }
        this.resamplingType.setSelectedItem(this.paramMap.get("resamplingType"));
        this.initialOffsetMethod.setSelectedItem(this.paramMap.get("initialOffsetMethod"));
        this.extent.setSelectedItem(this.paramMap.get("extent"));
    }

    private static List<Integer> getSelectedIndices(String[] allBandNames, String[] selBandNames, List<Integer> defaultIndices) {
        ArrayList<Integer> bandIndices = new ArrayList<Integer>(2);
        if (selBandNames != null && selBandNames.length > 0) {
            int i = 0;
            for (String bandName : allBandNames) {
                for (String selName : selBandNames) {
                    if (!bandName.equals(selName)) continue;
                    bandIndices.add(i);
                }
                ++i;
            }
        }
        if (bandIndices.isEmpty()) {
            return defaultIndices;
        }
        return bandIndices;
    }

    public UIValidation validateParameters() {
        if (this.resamplingType.getSelectedItem().equals("NONE") && this.sourceProducts != null) {
            try {
                CreateStackOp.checkPixelSpacing((Product[])this.sourceProducts);
            }
            catch (OperatorException e) {
                return new UIValidation(UIValidation.State.WARNING, "Resampling type cannot be NONE pixel spacings are different for master and slave");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        this.paramMap.put("resamplingType", this.resamplingType.getSelectedItem());
        this.paramMap.put("initialOffsetMethod", this.initialOffsetMethod.getSelectedItem());
        this.paramMap.put("extent", this.extent.getSelectedItem());
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Master:", (JComponent)this.masterProductLabel);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Resampling Type:", (JComponent)this.resamplingType);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Initial Offset Method:", (JComponent)this.initialOffsetMethod);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Output Extents:", (JComponent)this.extent);
        ++gbc.gridy;
        this.optimalMasterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CreateStackOpUI.this.sourceProducts != null) {
                    try {
                        CreateStackOpUI.this.masterProduct = InSARStackOverview.findOptimalMasterProduct((Product[])CreateStackOpUI.this.sourceProducts);
                        CreateStackOpUI.this.masterProductLabel.setText(CreateStackOpUI.this.masterProduct.getName());
                    }
                    catch (Exception ex) {
                        Dialogs.showError((String)("Error finding optimal master: " + ex.getMessage()));
                    }
                }
                CreateStackOpUI.this.updateMasterSlaveSelections();
            }
        });
        gbc.fill = 3;
        contentPane.add((Component)this.optimalMasterButton, gbc);
        ++gbc.gridy;
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }

    private void enableOptimalMasterButton() {
        if (this.sourceProducts == null) {
            return;
        }
        for (Product prod : this.sourceProducts) {
            InputProductValidator validator = new InputProductValidator(prod);
            if (validator.isComplex()) continue;
            this.optimalMasterButton.setEnabled(false);
            return;
        }
    }

    private void updateMasterSlaveSelections() {
        String[] bandNames = this.getBandNames();
        OperatorUIUtils.initParamList((JList)this.mstBandList, (String[])bandNames);
        OperatorUIUtils.initParamList((JList)this.slvBandList, (String[])bandNames);
        OperatorUIUtils.setSelectedListIndices((JList)this.mstBandList, CreateStackOpUI.getSelectedIndices(bandNames, new String[0], this.defaultMasterBandIndices));
        OperatorUIUtils.setSelectedListIndices((JList)this.slvBandList, CreateStackOpUI.getSelectedIndices(bandNames, new String[0], this.defaultSlaveBandIndices));
    }

    protected String[] getBandNames() {
        if (this.sourceProducts == null) {
            return new String[0];
        }
        this.defaultMasterBandIndices.clear();
        this.defaultSlaveBandIndices.clear();
        if (this.sourceProducts.length > 1) {
            for (int i = 1; i < this.sourceProducts.length; ++i) {
                if (!this.sourceProducts[i].getDisplayName().equals(this.masterProduct.getDisplayName())) continue;
                this.masterProduct = null;
                return new String[0];
            }
        }
        ArrayList<String> bandNames = new ArrayList<String>(5);
        boolean masterBandsSelected = false;
        for (Product prod : this.sourceProducts) {
            if (this.sourceProducts.length > 1) {
                Band[] bands = prod.getBands();
                for (int i = 0; i < bands.length; ++i) {
                    Band band = bands[i];
                    bandNames.add(band.getName() + "::" + prod.getName());
                    int index = bandNames.size() - 1;
                    if (band instanceof VirtualBand) continue;
                    if (prod == this.masterProduct && !masterBandsSelected) {
                        Band qBand;
                        this.defaultMasterBandIndices.add(index);
                        if (band.getUnit() != null && band.getUnit().equals("real") && i + 1 < bands.length && (qBand = bands[i + 1]).getUnit() != null && qBand.getUnit().equals("imaginary")) {
                            this.defaultMasterBandIndices.add(index + 1);
                            bandNames.add(qBand.getName() + "::" + prod.getName());
                            ++i;
                        }
                        masterBandsSelected = true;
                        continue;
                    }
                    this.defaultSlaveBandIndices.add(index);
                }
                continue;
            }
            bandNames.addAll(Arrays.asList(prod.getBandNames()));
        }
        return bandNames.toArray(new String[bandNames.size()]);
    }
}

