/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.esa.snap.core.dataop.dem.ElevationModelDescriptor;
import org.esa.snap.core.dataop.dem.ElevationModelRegistry;
import org.esa.snap.core.dataop.resamp.ResamplingFactory;
import org.esa.snap.dem.dataio.DEMFactory;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUIUtils;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.AppContext;

public class PhaseToElevationOpUI
extends BaseOperatorUI {
    private final JList bandList = new JList();
    private final JComboBox<String> demName = new JComboBox();
    private static final String externalDEMStr = "External DEM";
    private final JComboBox<String> demResamplingMethod = new JComboBox<String>(ResamplingFactory.resamplingNames);
    private final JTextField externalDEMFile = new JTextField("");
    private final JTextField externalDEMNoDataValue = new JTextField("");
    private final JButton externalDEMBrowseButton = new JButton("...");
    private final JLabel externalDEMFileLabel = new JLabel("External DEM:");
    private final JLabel externalDEMNoDataValueLabel = new JLabel("DEM No Data Value:");
    private Double extNoDataValue = 0.0;
    private final DialogUtils.TextAreaKeyListener textAreaKeyListener = new DialogUtils.TextAreaKeyListener();

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        String[] demNames;
        for (String name : demNames = DEMFactory.getDEMNameList()) {
            this.demName.addItem(name);
        }
        this.demName.addItem(externalDEMStr);
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        this.demName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (((String)PhaseToElevationOpUI.this.demName.getSelectedItem()).startsWith(PhaseToElevationOpUI.externalDEMStr)) {
                    PhaseToElevationOpUI.this.enableExternalDEM(true);
                } else {
                    PhaseToElevationOpUI.this.externalDEMFile.setText("");
                    PhaseToElevationOpUI.this.enableExternalDEM(false);
                }
            }
        });
        this.externalDEMFile.setColumns(30);
        this.enableExternalDEM(((String)this.demName.getSelectedItem()).startsWith(externalDEMStr));
        this.externalDEMBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = Dialogs.requestFileForOpen((String)"External DEM File", (boolean)false, null, (String)"snap.externalDEMDir");
                PhaseToElevationOpUI.this.externalDEMFile.setText(file.getAbsolutePath());
                PhaseToElevationOpUI.this.extNoDataValue = OperatorUIUtils.getNoDataValue((File)file);
                PhaseToElevationOpUI.this.externalDEMNoDataValue.setText(String.valueOf(PhaseToElevationOpUI.this.extNoDataValue));
            }
        });
        this.externalDEMNoDataValue.addKeyListener((KeyListener)this.textAreaKeyListener);
        return new JScrollPane(panel);
    }

    public void initParameters() {
        OperatorUIUtils.initParamList((JList)this.bandList, (String[])this.getBandNames());
        String demNameParam = (String)this.paramMap.get("demName");
        if (demNameParam != null) {
            ElevationModelDescriptor descriptor = ElevationModelRegistry.getInstance().getDescriptor(demNameParam);
            if (descriptor != null) {
                this.demName.setSelectedItem(DEMFactory.getDEMDisplayName((ElevationModelDescriptor)descriptor));
            } else {
                this.demName.setSelectedItem(demNameParam);
            }
        }
        this.demResamplingMethod.setSelectedItem(this.paramMap.get("demResamplingMethod"));
        File extFile = (File)this.paramMap.get("externalDEMFile");
        if (extFile != null) {
            this.externalDEMFile.setText(extFile.getAbsolutePath());
            this.extNoDataValue = (Double)this.paramMap.get("externalDEMNoDataValue");
            if (this.extNoDataValue != null && !this.textAreaKeyListener.isChangedByUser()) {
                this.externalDEMNoDataValue.setText(String.valueOf(this.extNoDataValue));
            }
        }
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        OperatorUIUtils.updateParamList((JList)this.bandList, (Map)this.paramMap, (String)"sourceBandNames");
        this.paramMap.put("demName", DEMFactory.getProperDEMName((String)((String)this.demName.getSelectedItem())));
        this.paramMap.put("demResamplingMethod", this.demResamplingMethod.getSelectedItem());
        String extFileStr = this.externalDEMFile.getText();
        if (!extFileStr.isEmpty()) {
            this.paramMap.put("externalDEMFile", new File(extFileStr));
            this.paramMap.put("externalDEMNoDataValue", Double.parseDouble(this.externalDEMNoDataValue.getText()));
        }
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        gbc.gridx = 0;
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Digital Elevation Model:", this.demName);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.externalDEMFileLabel, (JComponent)this.externalDEMFile);
        gbc.gridx = 2;
        contentPane.add((Component)this.externalDEMBrowseButton, gbc);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.externalDEMNoDataValueLabel, (JComponent)this.externalDEMNoDataValue);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"DEM Resampling Method:", this.demResamplingMethod);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }

    private void enableExternalDEM(boolean flag) {
        DialogUtils.enableComponents((JComponent)this.externalDEMFileLabel, (JComponent)this.externalDEMFile, (boolean)flag);
        DialogUtils.enableComponents((JComponent)this.externalDEMNoDataValueLabel, (JComponent)this.externalDEMNoDataValue, (boolean)flag);
        this.externalDEMBrowseButton.setVisible(flag);
    }
}

