/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUIUtils;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.GridBagUtils;

public class PCAOpUI
extends BaseOperatorUI {
    private final JList bandList = new JList();
    private final JComboBox selectEigenvaluesBy = new JComboBox<String>(new String[]{"Eigenvalue Threshold", "Number of Eigenvalues"});
    private final JTextField eigenvalueThreshold = new JTextField("");
    private final JTextField numberOfEigenvalues = new JTextField("");
    private final JCheckBox showEigenvalues = new JCheckBox("Show Eigenvalues");
    private final JCheckBox subtractMeanImage = new JCheckBox("Subtract Mean Image");
    private final JLabel eigenvalueThresholdLabel = new JLabel("Eigenvalue Threshold (%):");
    private final JLabel numberOfEigenvaluesLabel = new JLabel("Number Of Eigenvalues:");
    private final JLabel selectEigenvaluesByLabel = new JLabel("Select Eigenvalues By:     ");
    private boolean showEigenvaluesFlag = false;
    private boolean subtractMeanImageFlag = false;

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.bandList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PCAOpUI.this.setNumberOfEigenvalues();
            }
        });
        this.showEigenvalues.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PCAOpUI.this.showEigenvaluesFlag = e.getStateChange() == 1;
            }
        });
        this.subtractMeanImage.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PCAOpUI.this.subtractMeanImageFlag = e.getStateChange() == 1;
            }
        });
        this.initParameters();
        return panel;
    }

    public void initParameters() {
        OperatorUIUtils.initParamList((JList)this.bandList, (String[])this.getBandNames());
        this.selectEigenvaluesBy.setSelectedItem(this.paramMap.get("selectEigenvaluesBy"));
        this.eigenvalueThreshold.setText(String.valueOf(this.paramMap.get("eigenvalueThreshold")));
        this.setNumberOfEigenvalues();
    }

    private void setNumberOfEigenvalues() {
        if (this.sourceProducts != null && this.sourceProducts.length > 0) {
            if (this.bandList.getSelectedValues().length > 0) {
                this.numberOfEigenvalues.setText(String.valueOf(this.bandList.getSelectedValues().length));
            } else {
                this.numberOfEigenvalues.setText(String.valueOf(this.getBandNames().length));
            }
        } else {
            this.numberOfEigenvalues.setText(String.valueOf(this.paramMap.get("numPCA")));
        }
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        if (this.sourceProducts == null) {
            OperatorUIUtils.updateParamList((JList)this.bandList, (Map)this.paramMap, (String)"sourceBandNames");
        } else if (this.bandList.getSelectedValues().length > 0) {
            OperatorUIUtils.updateParamList((JList)this.bandList, (Map)this.paramMap, (String)"sourceBandNames");
        } else {
            this.paramMap.put("sourceBandNames", this.sourceProducts[0].getBandNames());
        }
        this.paramMap.put("selectEigenvaluesBy", this.selectEigenvaluesBy.getSelectedItem());
        this.paramMap.put("eigenvalueThreshold", Double.parseDouble(this.eigenvalueThreshold.getText()));
        this.paramMap.put("numPCA", Integer.parseInt(this.numberOfEigenvalues.getText()));
        this.paramMap.put("showEigenvalues", this.showEigenvaluesFlag);
        this.paramMap.put("subtractMeanImage", this.subtractMeanImageFlag);
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints _gbc = GridBagUtils.createDefaultConstraints();
        _gbc.fill = 2;
        _gbc.anchor = 18;
        _gbc.insets.top = 2;
        _gbc.insets.bottom = 2;
        _gbc.gridx = 0;
        _gbc.gridy = 0;
        contentPane.add((Component)new JLabel("Source Bands:"), _gbc);
        _gbc.fill = 1;
        _gbc.gridx = 1;
        contentPane.add((Component)new JScrollPane(this.bandList), _gbc);
        _gbc.fill = 2;
        ++_gbc.gridy;
        _gbc.gridx = 0;
        contentPane.add((Component)this.selectEigenvaluesByLabel, _gbc);
        _gbc.gridx = 1;
        contentPane.add((Component)this.selectEigenvaluesBy, _gbc);
        this.selectEigenvaluesBy.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                PCAOpUI.this.updateSelectEigenvaluesBy(true);
            }
        });
        int savedY = ++_gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)_gbc, (JLabel)this.eigenvalueThresholdLabel, (JComponent)this.eigenvalueThreshold);
        _gbc.gridy = savedY;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)_gbc, (JLabel)this.numberOfEigenvaluesLabel, (JComponent)this.numberOfEigenvalues);
        ++_gbc.gridy;
        _gbc.gridx = 0;
        contentPane.add((Component)this.showEigenvalues, _gbc);
        ++_gbc.gridy;
        contentPane.add((Component)this.subtractMeanImage, _gbc);
        this.updateSelectEigenvaluesBy(true);
        return contentPane;
    }

    private void enableEigenvalueThreshold(boolean flag) {
        DialogUtils.enableComponents((JComponent)this.eigenvalueThresholdLabel, (JComponent)this.eigenvalueThreshold, (boolean)flag);
    }

    private void enableNumberOfEigenvalues(boolean flag) {
        if (flag) {
            this.setNumberOfEigenvalues();
        }
        DialogUtils.enableComponents((JComponent)this.numberOfEigenvaluesLabel, (JComponent)this.numberOfEigenvalues, (boolean)flag);
    }

    private void updateSelectEigenvaluesBy(boolean show) {
        if (show) {
            this.selectEigenvaluesBy.setVisible(true);
            this.selectEigenvaluesByLabel.setVisible(true);
            String item = (String)this.selectEigenvaluesBy.getSelectedItem();
            if (item.equals("Eigenvalue Threshold")) {
                this.enableEigenvalueThreshold(true);
                this.enableNumberOfEigenvalues(false);
            } else {
                this.enableEigenvalueThreshold(false);
                this.enableNumberOfEigenvalues(true);
            }
        } else {
            this.selectEigenvaluesBy.setVisible(false);
            this.selectEigenvaluesByLabel.setVisible(false);
            this.enableEigenvalueThreshold(false);
            this.enableNumberOfEigenvalues(false);
        }
    }
}

