/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.esa.s1tbx.insar.gpf.CoherenceOp;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.ui.AppContext;

public class InterferogramOpUI
extends BaseOperatorUI {
    private final JCheckBox subtractFlatEarthPhaseCheckBox = new JCheckBox("Subtract flat-earth phase");
    private final JCheckBox includeCoherenceCheckBox = new JCheckBox("Include coherence estimation");
    private final JCheckBox squarePixelCheckBox = new JCheckBox("Square Pixel");
    private final JCheckBox independentWindowSizeCheckBox = new JCheckBox("Independent Window Sizes");
    private final JTextField cohWinAz = new JTextField("");
    private final JTextField cohWinRg = new JTextField("");
    private final JComboBox<Integer> srpPolynomialDegreeStr = new JComboBox<Integer>(new Integer[]{1, 2, 3, 4, 5, 6, 7, 8});
    private final JComboBox<Integer> srpNumberPointsStr = new JComboBox<Integer>(new Integer[]{301, 401, 501, 601, 701, 801, 901, 1001});
    private final JComboBox<Integer> orbitDegreeStr = new JComboBox<Integer>(new Integer[]{1, 2, 3, 4, 5});
    private static final JLabel cohWinAzLabel = new JLabel("Coherence Azimuth Window Size");
    private static final JLabel cohWinRgLabel = new JLabel("Coherence Range Window Size");
    private static final JLabel srpPolynomialDegreeStrLabel = new JLabel("Degree of \"Flat Earth\" polynomial");
    private static final JLabel srpNumberPointsStrLabel = new JLabel("Number of \"Flat Earth\" estimation points");
    private static final JLabel orbitDegreeStrLabel = new JLabel("Orbit interpolation degree");
    private Boolean subtractFlatEarthPhase = false;
    private Boolean includeCoherence = true;
    private Boolean squarePixel = true;
    private final CoherenceOp.DerivedParams param = new CoherenceOp.DerivedParams();

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JScrollPane panel = new JScrollPane(this.createPanel());
        this.initParameters();
        this.subtractFlatEarthPhaseCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                InterferogramOpUI.this.subtractFlatEarthPhase = e.getStateChange() == 1;
                if (InterferogramOpUI.this.subtractFlatEarthPhase.booleanValue()) {
                    InterferogramOpUI.this.srpPolynomialDegreeStr.setEnabled(true);
                    InterferogramOpUI.this.srpNumberPointsStr.setEnabled(true);
                    InterferogramOpUI.this.orbitDegreeStr.setEnabled(true);
                } else {
                    InterferogramOpUI.this.srpPolynomialDegreeStr.setEnabled(false);
                    InterferogramOpUI.this.srpNumberPointsStr.setEnabled(false);
                    InterferogramOpUI.this.orbitDegreeStr.setEnabled(false);
                }
            }
        });
        this.includeCoherenceCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                InterferogramOpUI.this.includeCoherence = e.getStateChange() == 1;
                if (InterferogramOpUI.this.includeCoherence.booleanValue()) {
                    InterferogramOpUI.this.squarePixelCheckBox.setEnabled(true);
                    InterferogramOpUI.this.independentWindowSizeCheckBox.setEnabled(true);
                    InterferogramOpUI.this.cohWinAz.setEnabled(true);
                    InterferogramOpUI.this.cohWinRg.setEnabled(true);
                } else {
                    InterferogramOpUI.this.squarePixelCheckBox.setEnabled(false);
                    InterferogramOpUI.this.independentWindowSizeCheckBox.setEnabled(false);
                    InterferogramOpUI.this.cohWinAz.setEnabled(false);
                    InterferogramOpUI.this.cohWinRg.setEnabled(false);
                }
            }
        });
        this.squarePixelCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                InterferogramOpUI.this.squarePixel = e.getStateChange() == 1;
                InterferogramOpUI.this.independentWindowSizeCheckBox.setSelected(InterferogramOpUI.this.squarePixel == false);
                if (InterferogramOpUI.this.squarePixel.booleanValue()) {
                    InterferogramOpUI.this.cohWinAz.setText("");
                    InterferogramOpUI.this.cohWinAz.setEditable(false);
                }
                InterferogramOpUI.this.setCohWinAz();
                InterferogramOpUI.this.setCohWinRg();
            }
        });
        this.independentWindowSizeCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                InterferogramOpUI.this.squarePixel = e.getStateChange() != 1;
                InterferogramOpUI.this.squarePixelCheckBox.setSelected(InterferogramOpUI.this.squarePixel);
                if (!InterferogramOpUI.this.squarePixel.booleanValue()) {
                    InterferogramOpUI.this.cohWinAz.setEditable(true);
                }
                InterferogramOpUI.this.setCohWinAz();
                InterferogramOpUI.this.setCohWinRg();
            }
        });
        return panel;
    }

    public void initParameters() {
        Boolean paramVal = (Boolean)this.paramMap.get("subtractFlatEarthPhase");
        if (paramVal != null) {
            this.subtractFlatEarthPhase = paramVal;
            this.subtractFlatEarthPhaseCheckBox.setSelected(this.subtractFlatEarthPhase);
        }
        this.srpPolynomialDegreeStr.setSelectedItem(this.paramMap.get("srpPolynomialDegree"));
        this.srpNumberPointsStr.setSelectedItem(this.paramMap.get("srpNumberPoints"));
        this.orbitDegreeStr.setSelectedItem(this.paramMap.get("orbitDegree"));
        if (this.subtractFlatEarthPhase.booleanValue()) {
            this.srpPolynomialDegreeStr.setEnabled(true);
            this.srpNumberPointsStr.setEnabled(true);
            this.orbitDegreeStr.setEnabled(true);
        }
        if ((paramVal = (Boolean)this.paramMap.get("includeCoherence")) != null) {
            this.includeCoherence = paramVal;
            this.includeCoherenceCheckBox.setSelected(this.includeCoherence);
        }
        this.cohWinAz.setText(String.valueOf(this.paramMap.get("cohWinAz")));
        this.cohWinRg.setText(String.valueOf(this.paramMap.get("cohWinRg")));
        this.squarePixel = (Boolean)this.paramMap.get("squarePixel");
        if (this.squarePixel != null) {
            this.squarePixelCheckBox.setSelected(this.squarePixel);
            this.independentWindowSizeCheckBox.setSelected(this.squarePixel == false);
            if (this.squarePixel.booleanValue()) {
                this.cohWinAz.setText("");
                this.cohWinAz.setEditable(false);
            } else {
                this.cohWinAz.setEditable(true);
            }
        }
        this.setCohWinAz();
        this.setCohWinRg();
        if (this.includeCoherence.booleanValue()) {
            this.squarePixelCheckBox.setEnabled(true);
            this.independentWindowSizeCheckBox.setEnabled(true);
            this.cohWinAz.setEnabled(true);
            this.cohWinRg.setEnabled(true);
        }
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        this.paramMap.put("subtractFlatEarthPhase", this.subtractFlatEarthPhase);
        if (this.subtractFlatEarthPhase.booleanValue()) {
            this.paramMap.put("srpPolynomialDegree", this.srpPolynomialDegreeStr.getSelectedItem());
            this.paramMap.put("srpNumberPoints", this.srpNumberPointsStr.getSelectedItem());
            this.paramMap.put("orbitDegree", this.orbitDegreeStr.getSelectedItem());
        }
        this.paramMap.put("includeCoherence", this.includeCoherence);
        if (this.includeCoherence.booleanValue()) {
            String cohWinRgStr = this.cohWinRg.getText();
            String cohWinAzStr = this.cohWinAz.getText();
            if (cohWinRgStr != null && !cohWinRgStr.isEmpty()) {
                this.paramMap.put("cohWinRg", Integer.parseInt(this.cohWinRg.getText()));
            }
            if (cohWinAzStr != null && !cohWinAzStr.isEmpty()) {
                this.paramMap.put("cohWinAz", Integer.parseInt(this.cohWinAz.getText()));
            }
            this.paramMap.put("squarePixel", this.squarePixel);
        }
    }

    JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        contentPane.add((Component)this.subtractFlatEarthPhaseCheckBox, gbc);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)srpPolynomialDegreeStrLabel, this.srpPolynomialDegreeStr);
        this.srpPolynomialDegreeStr.setEnabled(false);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)srpNumberPointsStrLabel, this.srpNumberPointsStr);
        this.srpNumberPointsStr.setEnabled(false);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)orbitDegreeStrLabel, this.orbitDegreeStr);
        this.orbitDegreeStr.setEnabled(false);
        ++gbc.gridy;
        contentPane.add((Component)this.includeCoherenceCheckBox, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        contentPane.add((Component)this.squarePixelCheckBox, gbc);
        this.squarePixelCheckBox.setEnabled(false);
        gbc.gridx = 1;
        contentPane.add((Component)this.independentWindowSizeCheckBox, gbc);
        this.independentWindowSizeCheckBox.setEnabled(false);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)cohWinRgLabel, (JComponent)this.cohWinRg);
        this.cohWinRg.setEnabled(false);
        this.cohWinRg.setDocument(new CohWinRgDocument());
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)cohWinAzLabel, (JComponent)this.cohWinAz);
        this.cohWinAz.setEnabled(false);
        this.cohWinAz.setEditable(false);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }

    private synchronized void setCohWinAz() {
        if (this.sourceProducts != null && this.sourceProducts.length > 0) {
            try {
                if (this.squarePixelCheckBox.isSelected()) {
                    this.param.cohWinRg = Integer.parseInt(this.cohWinRg.getText());
                    CoherenceOp.getDerivedParameters((Product)this.sourceProducts[0], (CoherenceOp.DerivedParams)this.param);
                    this.cohWinAz.setText(String.valueOf(this.param.cohWinAz));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setCohWinRg() {
        if (this.sourceProducts != null && this.sourceProducts.length > 0 && this.squarePixelCheckBox.isSelected()) {
            this.cohWinRg.setText(String.valueOf(this.param.cohWinRg));
        }
    }

    private class CohWinRgDocument
    extends PlainDocument {
        private CohWinRgDocument() {
        }

        @Override
        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            super.replace(offset, length, text, attrs);
            InterferogramOpUI.this.setCohWinAz();
        }
    }
}

