/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.esa.s1tbx.insar.gpf.CoherenceOp;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.ui.AppContext;

public class CoherenceOpUI
extends BaseOperatorUI {
    private final JCheckBox squarePixelCheckBox = new JCheckBox("Square Pixel");
    private final JCheckBox independentWindowSizeCheckBox = new JCheckBox("Independent Window Sizes");
    private final JCheckBox subtractFlatEarthPhaseCheckBox = new JCheckBox("Subtract flat-earth phase in coherence phase");
    private final JTextField cohWinAz = new JTextField("");
    private final JTextField cohWinRg = new JTextField("");
    private final JComboBox<Integer> srpPolynomialDegreeStr = new JComboBox<Integer>(new Integer[]{1, 2, 3, 4, 5, 6, 7, 8});
    private final JComboBox<Integer> srpNumberPointsStr = new JComboBox<Integer>(new Integer[]{301, 401, 501, 601, 701, 801, 901, 1001});
    private final JComboBox<Integer> orbitDegreeStr = new JComboBox<Integer>(new Integer[]{1, 2, 3, 4, 5});
    private static final JLabel cohWinAzLabel = new JLabel("Coherence Azimuth Window Size");
    private static final JLabel cohWinRgLabel = new JLabel("Coherence Range Window Size");
    private static final JLabel srpPolynomialDegreeStrLabel = new JLabel("Degree of \"Flat Earth\" polynomial");
    private static final JLabel srpNumberPointsStrLabel = new JLabel("Number of \"Flat Earth\" estimation points");
    private static final JLabel orbitDegreeStrLabel = new JLabel("Orbit interpolation degree");
    private Boolean squarePixel = true;
    private Boolean subtractFlatEarthPhase = false;
    private final CoherenceOp.DerivedParams param = new CoherenceOp.DerivedParams();

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JScrollPane panel = new JScrollPane(this.createPanel());
        this.initParameters();
        this.subtractFlatEarthPhaseCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CoherenceOpUI.this.subtractFlatEarthPhase = e.getStateChange() == 1;
                if (CoherenceOpUI.this.subtractFlatEarthPhase.booleanValue()) {
                    CoherenceOpUI.this.srpPolynomialDegreeStr.setEnabled(true);
                    CoherenceOpUI.this.srpNumberPointsStr.setEnabled(true);
                    CoherenceOpUI.this.orbitDegreeStr.setEnabled(true);
                } else {
                    CoherenceOpUI.this.srpPolynomialDegreeStr.setEnabled(false);
                    CoherenceOpUI.this.srpNumberPointsStr.setEnabled(false);
                    CoherenceOpUI.this.orbitDegreeStr.setEnabled(false);
                }
            }
        });
        this.squarePixelCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CoherenceOpUI.this.squarePixel = e.getStateChange() == 1;
                CoherenceOpUI.this.independentWindowSizeCheckBox.setSelected(CoherenceOpUI.this.squarePixel == false);
                if (CoherenceOpUI.this.squarePixel.booleanValue()) {
                    CoherenceOpUI.this.cohWinAz.setText("2");
                    CoherenceOpUI.this.cohWinAz.setEditable(false);
                }
                CoherenceOpUI.this.setCohWinAz();
                CoherenceOpUI.this.setCohWinRg();
            }
        });
        this.independentWindowSizeCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CoherenceOpUI.this.squarePixel = e.getStateChange() != 1;
                CoherenceOpUI.this.squarePixelCheckBox.setSelected(CoherenceOpUI.this.squarePixel);
                if (!CoherenceOpUI.this.squarePixel.booleanValue()) {
                    CoherenceOpUI.this.cohWinAz.setEditable(true);
                }
                CoherenceOpUI.this.setCohWinAz();
                CoherenceOpUI.this.setCohWinRg();
            }
        });
        return panel;
    }

    public void initParameters() {
        this.cohWinAz.setText(String.valueOf(this.paramMap.get("cohWinAz")));
        this.cohWinRg.setText(String.valueOf(this.paramMap.get("cohWinRg")));
        Boolean paramVal = (Boolean)this.paramMap.get("subtractFlatEarthPhase");
        if (paramVal != null) {
            this.subtractFlatEarthPhase = paramVal;
            this.subtractFlatEarthPhaseCheckBox.setSelected(this.subtractFlatEarthPhase);
        }
        this.srpPolynomialDegreeStr.setSelectedItem(this.paramMap.get("srpPolynomialDegree"));
        this.srpNumberPointsStr.setSelectedItem(this.paramMap.get("srpNumberPoints"));
        this.orbitDegreeStr.setSelectedItem(this.paramMap.get("orbitDegree"));
        this.squarePixel = (Boolean)this.paramMap.get("squarePixel");
        if (this.squarePixel != null) {
            this.squarePixelCheckBox.setSelected(this.squarePixel);
            this.independentWindowSizeCheckBox.setSelected(this.squarePixel == false);
            if (this.squarePixel.booleanValue()) {
                this.cohWinAz.setText("2");
                this.cohWinAz.setEditable(false);
            } else {
                this.cohWinAz.setEditable(true);
            }
        }
        this.setCohWinAz();
        this.setCohWinRg();
        if (this.sourceProducts != null && this.sourceProducts.length > 0) {
            boolean isComplex = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProducts[0]).getAttributeString("SAMPLE_TYPE").contains("COMPLEX");
            this.enableControls(isComplex);
        }
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        this.paramMap.put("cohWinAz", Integer.parseInt(this.cohWinAz.getText()));
        this.paramMap.put("cohWinRg", Integer.parseInt(this.cohWinRg.getText()));
        this.paramMap.put("subtractFlatEarthPhase", this.subtractFlatEarthPhase);
        if (this.subtractFlatEarthPhase.booleanValue()) {
            this.paramMap.put("srpPolynomialDegree", this.srpPolynomialDegreeStr.getSelectedItem());
            this.paramMap.put("srpNumberPoints", this.srpNumberPointsStr.getSelectedItem());
            this.paramMap.put("orbitDegree", this.orbitDegreeStr.getSelectedItem());
        }
    }

    JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        gbc.gridx = 0;
        contentPane.add((Component)this.squarePixelCheckBox, gbc);
        gbc.gridx = 1;
        contentPane.add((Component)this.independentWindowSizeCheckBox, gbc);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)cohWinRgLabel, (JComponent)this.cohWinRg);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)cohWinAzLabel, (JComponent)this.cohWinAz);
        this.cohWinAz.setEditable(false);
        this.cohWinRg.setDocument(new CohWinRgDocument());
        ++gbc.gridy;
        contentPane.add((Component)this.subtractFlatEarthPhaseCheckBox, gbc);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)srpPolynomialDegreeStrLabel, this.srpPolynomialDegreeStr);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)srpNumberPointsStrLabel, this.srpNumberPointsStr);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)orbitDegreeStrLabel, this.orbitDegreeStr);
        this.srpPolynomialDegreeStr.setEnabled(false);
        this.srpNumberPointsStr.setEnabled(false);
        this.orbitDegreeStr.setEnabled(false);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }

    private void enableControls(boolean flag) {
        this.subtractFlatEarthPhaseCheckBox.setEnabled(flag);
    }

    private synchronized void setCohWinAz() {
        if (this.sourceProducts != null && this.sourceProducts.length > 0) {
            try {
                if (this.squarePixelCheckBox.isSelected()) {
                    this.param.cohWinRg = Integer.parseInt(this.cohWinRg.getText());
                    CoherenceOp.getDerivedParameters((Product)this.sourceProducts[0], (CoherenceOp.DerivedParams)this.param);
                    this.cohWinAz.setText(String.valueOf(this.param.cohWinAz));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setCohWinRg() {
        if (this.sourceProducts != null && this.sourceProducts.length > 0 && this.squarePixelCheckBox.isSelected()) {
            this.cohWinRg.setText(String.valueOf(this.param.cohWinRg));
        }
    }

    private class CohWinRgDocument
    extends PlainDocument {
        private CohWinRgDocument() {
        }

        @Override
        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            super.replace(offset, length, text, attrs);
            CoherenceOpUI.this.setCohWinAz();
        }
    }
}

