/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.fex.gpf.texture;

import org.apache.commons.math3.util.FastMath;

public class GaborFilter {
    public static double[][] createGarborFilter(double lambda, double theta, double psi, double sigma, double gamma) {
        int y;
        int x;
        double sigma_x = sigma;
        double sigma_y = sigma / gamma;
        int nstds = 3;
        int xmax = (int)Math.ceil(Math.max(1.0, Math.max(Math.abs((double)nstds * sigma_x * FastMath.cos((double)theta)), Math.abs((double)nstds * sigma_y * FastMath.sin((double)theta)))));
        int ymax = (int)Math.ceil(Math.max(1.0, Math.max(Math.abs((double)nstds * sigma_x * FastMath.sin((double)theta)), Math.abs((double)nstds * sigma_y * FastMath.cos((double)theta)))));
        double[][] out = new double[2 * xmax + 1][2 * ymax + 1];
        double sum = 0.0;
        for (x = -xmax; x <= xmax; ++x) {
            for (y = -ymax; y <= ymax; ++y) {
                double x_theta = (double)x * FastMath.cos((double)theta) + (double)y * FastMath.sin((double)theta);
                double y_theta = (double)(-x) * FastMath.sin((double)theta) + (double)y * FastMath.cos((double)theta);
                out[x + xmax][y + ymax] = FastMath.exp((double)(-(FastMath.pow((double)x_theta, (int)2) + FastMath.pow((double)gamma, (int)2) * FastMath.pow((double)y_theta, (int)2)) / (2.0 * FastMath.pow((double)sigma, (int)2)))) * FastMath.cos((double)(Math.PI * 2 * x_theta / lambda + psi));
                sum += out[x + xmax][y + ymax];
            }
        }
        for (x = -xmax; x <= xmax; ++x) {
            for (y = -ymax; y <= ymax; ++y) {
                double[] dArray = out[x + xmax];
                int n = y + ymax;
                dArray[n] = dArray[n] / sum;
            }
        }
        return out;
    }

    public static int[][] applyGarborFilter(int[][] in, double[][] filter) {
        int xmax = (int)Math.floor((double)filter.length / 2.0);
        int ymax = (int)Math.floor((double)filter[0].length / 2.0);
        int[][] out = new int[in.length][in[0].length];
        for (int x = 0; x < in.length; ++x) {
            for (int y = 0; y < in.length; ++y) {
                double sum = 0.0;
                for (int xf = -xmax; xf <= xmax; ++xf) {
                    for (int yf = -ymax; yf <= ymax; ++yf) {
                        if (x - xf < 0 || x - xf >= in.length || y - yf < 0 || y - yf >= in[0].length) continue;
                        sum += filter[xf + xmax][yf + ymax] * (double)in[x - xf][y - yf];
                    }
                }
                out[x][y] = (int)Math.round(sum);
            }
        }
        return out;
    }
}

