/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.fex.gpf.oceantools;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.math3.util.FastMath;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="Oil-Spill-Detection", category="Radar/SAR Applications/Ocean Applications/Oil Spill Detection", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2015 by Array Systems Computing Inc.", description="Detect oil spill.")
public class OilSpillDetectionOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct = null;
    @Parameter(description="The list of source bands.", alias="sourceBands", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] sourceBandNames = null;
    @Parameter(description="Background window size", defaultValue="13", label="Background Window Size")
    private int backgroundWindowSize = 61;
    @Parameter(description="Threshold shift from background mean", defaultValue="2.0", label="Threshold Shift (dB)")
    private double k = 2.0;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private int halfBackgroundWindowSize = 0;
    private double kInLinearScale = 0.0;
    private final HashMap<String, String> targetBandNameToSourceBandName = new HashMap();
    public static final String OILSPILLMASK_NAME = "_oil_spill_bit_msk";

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfCalibrated(true);
            validator.checkIfTOPSARBurstProduct(false);
            this.getMission();
            this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
            this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
            this.halfBackgroundWindowSize = (this.backgroundWindowSize - 1) / 2;
            if (this.k < 0.0) {
                throw new OperatorException("Threshold Shift cannot be negative");
            }
            this.kInLinearScale = FastMath.pow((double)10.0, (double)(this.k / 10.0));
            this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
            ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
            this.addSelectedBands();
            OilSpillDetectionOp.addBitmasks(this.targetProduct);
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    public static void addBitmasks(Product product) {
        for (Band band : product.getBands()) {
            if (!band.getName().contains(OILSPILLMASK_NAME)) continue;
            String expression = band.getName() + " > 0";
            Mask mask = new Mask(band.getName() + "_detection", product.getSceneRasterWidth(), product.getSceneRasterHeight(), (Mask.ImageType)Mask.BandMathsType.INSTANCE);
            mask.setDescription("Oil Spill Detection");
            mask.getImageConfig().setValue("color", (Object)Color.RED);
            mask.getImageConfig().setValue("transparency", (Object)0.5);
            mask.getImageConfig().setValue("expression", (Object)expression);
            mask.setNoDataValue(0.0);
            mask.setNoDataValueUsed(true);
            product.getMaskGroup().add((ProductNode)mask);
        }
    }

    private void getMission() {
    }

    private void addSelectedBands() throws OperatorException {
        if (this.sourceBandNames == null || this.sourceBandNames.length == 0) {
            Band[] bands = this.sourceProduct.getBands();
            ArrayList<String> bandNameList = new ArrayList<String>(this.sourceProduct.getNumBands());
            Band[] bandArray = bands;
            int n = bandArray.length;
            for (int i = 0; i < n; ++i) {
                Band band = bandArray[i];
                if (band.getUnit() == null || !band.getUnit().equals("intensity")) continue;
                bandNameList.add(band.getName());
            }
            this.sourceBandNames = bandNameList.toArray(new String[bandNameList.size()]);
        }
        Band[] sourceBands = new Band[this.sourceBandNames.length];
        for (int i = 0; i < this.sourceBandNames.length; ++i) {
            String sourceBandName = this.sourceBandNames[i];
            Band sourceBand = this.sourceProduct.getBand(sourceBandName);
            if (sourceBand == null) {
                throw new OperatorException("Source band not found: " + sourceBandName);
            }
            sourceBands[i] = sourceBand;
        }
        for (Band srcBand : sourceBands) {
            String unit = srcBand.getUnit();
            if (unit == null) {
                throw new OperatorException("band " + srcBand.getName() + " requires a unit");
            }
            String srcBandNames = srcBand.getName();
            String targetBandName = srcBandNames + OILSPILLMASK_NAME;
            this.targetBandNameToSourceBandName.put(targetBandName, srcBandNames);
            Band targetBand = ProductUtils.copyBand((String)srcBand.getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
            Band targetBandMask = new Band(targetBandName, 10, this.sourceImageWidth, this.sourceImageHeight);
            targetBandMask.setNoDataValue(0.0);
            targetBandMask.setNoDataValueUsed(true);
            targetBandMask.setUnit("amplitude");
            this.targetProduct.addBand(targetBandMask);
        }
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        try {
            Rectangle targetTileRectangle = targetTile.getRectangle();
            int tx0 = targetTileRectangle.x;
            int ty0 = targetTileRectangle.y;
            int tw = targetTileRectangle.width;
            int th = targetTileRectangle.height;
            ProductData trgData = targetTile.getDataBuffer();
            int x0 = Math.max(tx0 - this.halfBackgroundWindowSize, 0);
            int y0 = Math.max(ty0 - this.halfBackgroundWindowSize, 0);
            int w = Math.min(tx0 + tw - 1 + this.halfBackgroundWindowSize, this.sourceImageWidth - 1) - x0 + 1;
            int h = Math.min(ty0 + th - 1 + this.halfBackgroundWindowSize, this.sourceImageHeight - 1) - y0 + 1;
            Rectangle sourceTileRectangle = new Rectangle(x0, y0, w, h);
            String srcBandName = this.targetBandNameToSourceBandName.get(targetBand.getName());
            Band sourceBand = this.sourceProduct.getBand(srcBandName);
            Tile sourceTile = this.getSourceTile((RasterDataNode)sourceBand, sourceTileRectangle);
            ProductData srcBuffer = sourceTile.getDataBuffer();
            Double noDataValue = sourceBand.getNoDataValue();
            TileIndex trgIndex = new TileIndex(targetTile);
            TileIndex srcIndex = new TileIndex(sourceTile);
            int maxy = ty0 + th;
            int maxx = tx0 + tw;
            for (int ty = ty0; ty < maxy; ++ty) {
                trgIndex.calculateStride(ty);
                srcIndex.calculateStride(ty);
                for (int tx = tx0; tx < maxx; ++tx) {
                    double v = srcBuffer.getElemDoubleAt(srcIndex.getIndex(tx));
                    if (noDataValue.equals(v)) {
                        trgData.setElemIntAt(trgIndex.getIndex(tx), 0);
                        continue;
                    }
                    double backgroundMean = this.computeBackgroundMean(tx, ty, sourceTile, noDataValue);
                    double threshold = backgroundMean / this.kInLinearScale;
                    if (v < threshold) {
                        trgData.setElemIntAt(trgIndex.getIndex(tx), 1);
                        continue;
                    }
                    trgData.setElemIntAt(trgIndex.getIndex(tx), 0);
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private double computeBackgroundMean(int tx, int ty, Tile sourceTile, double noDataValue) {
        int x0 = Math.max(tx - this.halfBackgroundWindowSize, 0);
        int y0 = Math.max(ty - this.halfBackgroundWindowSize, 0);
        int w = Math.min(tx + this.halfBackgroundWindowSize, this.sourceImageWidth - 1) - x0 + 1;
        int h = Math.min(ty + this.halfBackgroundWindowSize, this.sourceImageHeight - 1) - y0 + 1;
        ProductData srcData = sourceTile.getDataBuffer();
        TileIndex tileIndex = new TileIndex(sourceTile);
        double mean = 0.0;
        int numPixels = 0;
        int maxy = y0 + h;
        int maxx = x0 + w;
        for (int y = y0; y < maxy; ++y) {
            tileIndex.calculateStride(y);
            for (int x = x0; x < maxx; ++x) {
                double v = srcData.getElemDoubleAt(tileIndex.getIndex(x));
                if (v == noDataValue) continue;
                mean += v;
                ++numPixels;
            }
        }
        return mean / (double)numPixels;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(OilSpillDetectionOp.class);
        }
    }
}

