/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.fex.gpf.oceantools;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.esa.s1tbx.fex.gpf.oceantools.OilSpillDetectionOp;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="Oil-Spill-Clustering", category="Radar/SAR Applications/Ocean Applications/Oil Spill Detection", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2015 by Array Systems Computing Inc.", description="Remove small clusters from detected area.")
public class OilSpillClusteringOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct = null;
    @Parameter(description="Minimum cluster size", defaultValue="0.1", label="Minimum Cluster Size (sq km)")
    private double minClusterSizeInKm2 = 0.1;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private int minClusterSizeInPixels = 0;
    private MetadataElement absRoot = null;

    public void initialize() throws OperatorException {
        try {
            this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            this.getPixelSpacings();
            this.getSourceImageDimension();
            this.createTargetProduct();
            OilSpillDetectionOp.addBitmasks(this.targetProduct);
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void getPixelSpacings() throws Exception {
        double rangeSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)this.absRoot, (String)"range_spacing");
        double azimuthSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)this.absRoot, (String)"azimuth_spacing");
        this.minClusterSizeInPixels = (int)(this.minClusterSizeInKm2 * 1000000.0 / (rangeSpacing * azimuthSpacing)) + 1;
    }

    private void getSourceImageDimension() {
        this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        this.addSelectedBands();
    }

    private void addSelectedBands() throws OperatorException {
        Band[] sourceBands;
        Band[] bands = this.sourceProduct.getBands();
        ArrayList<String> bandNameList = new ArrayList<String>(this.sourceProduct.getNumBands());
        for (Band band : bands) {
            bandNameList.add(band.getName());
        }
        String[] sourceBandNames = bandNameList.toArray(new String[bandNameList.size()]);
        for (Band srcBand : sourceBands = OperatorUtils.getSourceBands((Product)this.sourceProduct, (String[])sourceBandNames, (boolean)false)) {
            String srcBandName = srcBand.getName();
            if (!srcBandName.contains("_oil_spill_bit_msk")) {
                Band band = ProductUtils.copyBand((String)srcBandName, (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
                continue;
            }
            ProductUtils.copyBand((String)srcBandName, (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)false);
        }
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        try {
            Rectangle targetTileRectangle = targetTile.getRectangle();
            int tx0 = targetTileRectangle.x;
            int ty0 = targetTileRectangle.y;
            int tw = targetTileRectangle.width;
            int th = targetTileRectangle.height;
            ProductData trgData = targetTile.getDataBuffer();
            int x0 = Math.max(tx0 - this.minClusterSizeInPixels, 0);
            int y0 = Math.max(ty0 - this.minClusterSizeInPixels, 0);
            int w = Math.min(tw + 2 * this.minClusterSizeInPixels, this.sourceImageWidth);
            int h = Math.min(th + 2 * this.minClusterSizeInPixels, this.sourceImageHeight);
            Rectangle sourceTileRectangle = new Rectangle(x0, y0, w, h);
            Band sourceBand = this.sourceProduct.getBand(targetBand.getName());
            Tile sourceTile = this.getSourceTile((RasterDataNode)sourceBand, sourceTileRectangle);
            ProductData srcData = sourceTile.getDataBuffer();
            int[][] pixelsScaned = new int[h][w];
            TileIndex srcIndex = new TileIndex(sourceTile);
            int maxy = ty0 + th;
            int maxx = tx0 + tw;
            for (int ty = ty0; ty < maxy; ++ty) {
                srcIndex.calculateStride(ty);
                for (int tx = tx0; tx < maxx; ++tx) {
                    if (pixelsScaned[ty - y0][tx - x0] != 0 || srcData.getElemIntAt(srcIndex.getIndex(tx)) != 1) continue;
                    ArrayList<PixelPos> clusterPixels = new ArrayList<PixelPos>();
                    OilSpillClusteringOp.clustering(tx, ty, x0, y0, w, h, srcData, sourceTile, pixelsScaned, clusterPixels);
                    if (clusterPixels.size() < this.minClusterSizeInPixels) continue;
                    for (PixelPos pixel : clusterPixels) {
                        int x = (int)pixel.x;
                        int y = (int)pixel.y;
                        if (x < tx0 || x >= tx0 + tw || y < ty0 || y >= ty0 + th) continue;
                        trgData.setElemIntAt(targetTile.getDataBufferIndex(x, y), 1);
                    }
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private static void clustering(int xc, int yc, int x0, int y0, int w, int h, ProductData bitMaskData, Tile bitMaskTile, int[][] pixelsScaned, List<PixelPos> clusterPixels) {
        ArrayList<PixelPos> seeds = new ArrayList<PixelPos>();
        seeds.add(new PixelPos((double)xc, (double)yc));
        pixelsScaned[yc - y0][xc - x0] = 1;
        clusterPixels.add(new PixelPos((double)xc, (double)yc));
        while (seeds.size() > 0) {
            ArrayList<PixelPos> newSeeds = new ArrayList<PixelPos>();
            for (PixelPos pixel : seeds) {
                OilSpillClusteringOp.searchNeighbourhood(pixel, x0, y0, w, h, bitMaskData, bitMaskTile, pixelsScaned, clusterPixels, newSeeds);
            }
            seeds.clear();
            seeds.addAll(newSeeds);
        }
    }

    private static void searchNeighbourhood(PixelPos pixel, int x0, int y0, int w, int h, ProductData bitMaskData, Tile bitMaskTile, int[][] pixelsScaned, List<PixelPos> clusterPixels, List<PixelPos> newSeeds) {
        int xc = (int)pixel.x;
        int yc = (int)pixel.y;
        int[] x = new int[]{xc - 1, xc, xc + 1, xc - 1, xc + 1, xc - 1, xc, xc + 1};
        int[] y = new int[]{yc - 1, yc - 1, yc - 1, yc, yc, yc + 1, yc + 1, yc + 1};
        for (int i = 0; i < 8; ++i) {
            if (x[i] < x0 || x[i] >= x0 + w || y[i] < y0 || y[i] >= y0 + h || pixelsScaned[y[i] - y0][x[i] - x0] != 0 || bitMaskData.getElemIntAt(bitMaskTile.getDataBufferIndex(x[i], y[i])) != 1) continue;
            pixelsScaned[y[i] - y0][x[i] - x0] = 1;
            clusterPixels.add(new PixelPos((double)x[i], (double)y[i]));
            newSeeds.add(new PixelPos((double)x[i], (double)y[i]));
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(OilSpillClusteringOp.class);
        }
    }
}

