/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.fex.gpf.oceantools;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.HashMap;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.integration.IterativeLegendreGaussIntegrator;
import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.util.FastMath;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="AdaptiveThresholding", category="Radar/SAR Applications/Ocean Applications/Object Detection", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2015 by Array Systems Computing Inc.", description="Detect ships using Constant False Alarm Rate detector.")
public class AdaptiveThresholdingOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct = null;
    private String[] sourceBandNames = null;
    @Parameter(description="Target window size", defaultValue="50", label="Target Window Size (m)")
    private int targetWindowSizeInMeter = 50;
    @Parameter(description="Guard window size", defaultValue="500.0", label="Guard Window Size (m)")
    private double guardWindowSizeInMeter = 500.0;
    @Parameter(description="Background window size", defaultValue="800.0", label="Background Window Size (m)")
    private double backgroundWindowSizeInMeter = 800.0;
    @Parameter(description="Probability of false alarm", defaultValue="6.5", label="PFA (10^(-x))")
    private double pfa = 6.5;
    @Parameter(description="Rough estimation of background threshold for quicker processing", defaultValue="false", label="Estimate background")
    private Boolean estimateBackground = false;
    private int sourceImageWidth;
    private int sourceImageHeight;
    private int targetWindowSize;
    private int halfTargetWindowSize;
    private int halfGuardWindowSize;
    private int halfBackgroundWindowSize;
    private double t;
    private double meanPixelSpacing;
    private final HashMap<String, String> targetBandNameToSourceBandName = new HashMap(2);
    public static final String SHIPMASK_NAME = "_ship_bit_msk";
    private static final String PRODUCT_SUFFIX = "_THR";
    private static final double backgroundThreshold = 0.5;
    private static final boolean doKDistribution = false;
    private int numLooks;
    private double oneMinusPFA;
    private static final int NUM_INTEGRATION_PTS = 100;
    private static final double MAX_SOURCE_VALUE = 2.0;
    private static final int MAX_EVAL = 2000;
    private static final double DESIRED_ACCURACY = 1.0E-15;

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfCalibrated(true);
            validator.checkIfTOPSARBurstProduct(false);
            this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
            this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
            this.getMeanPixelSpacing();
            this.targetWindowSize = Math.max(1, (int)((double)this.targetWindowSizeInMeter / this.meanPixelSpacing) + 1);
            int guardWindowSize = (int)(this.guardWindowSizeInMeter / this.meanPixelSpacing) + 1;
            int backgroundWindowSize = (int)(this.backgroundWindowSizeInMeter / this.meanPixelSpacing) + 1;
            this.halfTargetWindowSize = this.targetWindowSize / 2;
            this.halfGuardWindowSize = guardWindowSize / 2;
            this.halfBackgroundWindowSize = (backgroundWindowSize - 1) / 2;
            this.targetProduct = new Product(this.sourceProduct.getName() + PRODUCT_SUFFIX, this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
            ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
            this.addSelectedBands();
            this.t = AdaptiveThresholdingOp.computeDetectorDesignParameter(this.pfa);
            if (this.estimateBackground == null) {
                this.estimateBackground = false;
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    void getMeanPixelSpacing() throws Exception {
        MetadataElement abs = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
        double rangeSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)abs, (String)"range_spacing");
        double azimuthSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)abs, (String)"azimuth_spacing");
        boolean srgrFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)abs, (String)"srgr_flag");
        this.meanPixelSpacing = srgrFlag ? (rangeSpacing + azimuthSpacing) / 2.0 : (rangeSpacing / FastMath.sin((double)this.getIncidenceAngleAtCentreRangePixel()) + azimuthSpacing) / 2.0;
    }

    private double getIncidenceAngleAtCentreRangePixel() throws OperatorException {
        int x = this.sourceImageWidth / 2;
        int y = this.sourceImageHeight / 2;
        TiePointGrid incidenceAngle = OperatorUtils.getIncidenceAngle((Product)this.sourceProduct);
        if (incidenceAngle == null) {
            throw new OperatorException("incidence_angle tie point grid not found in product");
        }
        return incidenceAngle.getPixelDouble(x, y) * (Math.PI / 180);
    }

    private void addSelectedBands() throws OperatorException {
        Object pol;
        if (this.sourceBandNames == null || this.sourceBandNames.length == 0) {
            Band[] bands = this.sourceProduct.getBands();
            HashMap<Object, String> bandNameMap = new HashMap<Object, String>(this.sourceProduct.getNumBands());
            for (Band srcBand : bands) {
                if (srcBand instanceof VirtualBand) {
                    ProductUtils.copyVirtualBand((Product)this.targetProduct, (VirtualBand)((VirtualBand)srcBand), (String)srcBand.getName());
                } else {
                    ProductUtils.copyBand((String)srcBand.getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
                }
                String unit = srcBand.getUnit();
                if (unit == null || unit.contains("phase") || unit.contains("real") || unit.contains("imaginary")) continue;
                pol = OperatorUtils.getPolarizationFromBandName((String)srcBand.getName());
                if (pol != null) {
                    bandNameMap.put(pol, srcBand.getName());
                    continue;
                }
                bandNameMap.put("NoPol", srcBand.getName());
            }
            this.sourceBandNames = bandNameMap.containsKey("hv") ? new String[]{(String)bandNameMap.get("hv")} : (bandNameMap.containsKey("vh") ? new String[]{(String)bandNameMap.get("vh")} : (bandNameMap.containsKey("hh") ? new String[]{(String)bandNameMap.get("hh")} : bandNameMap.values().toArray(new String[bandNameMap.size()])));
        }
        for (String srcBandName : this.sourceBandNames) {
            Band srcBand = this.sourceProduct.getBand(srcBandName);
            String unit = srcBand.getUnit();
            if (unit != null && (unit.contains("phase") || unit.contains("real") || unit.contains("imaginary"))) {
                throw new OperatorException("Please select amplitude or intensity band for ship detection");
            }
            String targetBandName = srcBandName + SHIPMASK_NAME;
            this.targetBandNameToSourceBandName.put(targetBandName, srcBandName);
            if (!this.targetProduct.containsBand(srcBandName)) {
                pol = ProductUtils.copyBand((String)srcBandName, (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
            }
            Band targetBandMask = new Band(targetBandName, 10, this.sourceImageWidth, this.sourceImageHeight);
            targetBandMask.setUnit("amplitude");
            targetBandMask.setNoDataValue(0.0);
            targetBandMask.setNoDataValueUsed(true);
            this.targetProduct.addBand(targetBandMask);
        }
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        try {
            Rectangle sourceTileRectangle;
            int h;
            int w;
            int y0;
            int x0;
            Rectangle targetTileRectangle = targetTile.getRectangle();
            int tx0 = targetTileRectangle.x;
            int ty0 = targetTileRectangle.y;
            int tw = targetTileRectangle.width;
            int th = targetTileRectangle.height;
            ProductData trgData = targetTile.getDataBuffer();
            if (this.estimateBackground.booleanValue()) {
                x0 = tx0;
                y0 = ty0;
                w = tw;
                h = th;
                sourceTileRectangle = targetTileRectangle;
            } else {
                x0 = Math.max(tx0 - this.halfBackgroundWindowSize, 0);
                y0 = Math.max(ty0 - this.halfBackgroundWindowSize, 0);
                w = Math.min(tx0 + tw - 1 + this.halfBackgroundWindowSize, this.sourceImageWidth - 1) - x0 + 1;
                h = Math.min(ty0 + th - 1 + this.halfBackgroundWindowSize, this.sourceImageHeight - 1) - y0 + 1;
                sourceTileRectangle = new Rectangle(x0, y0, w, h);
            }
            String srcBandName = this.targetBandNameToSourceBandName.get(targetBand.getName());
            Band sourceBand = this.sourceProduct.getBand(srcBandName);
            Tile sourceTile = this.getSourceTile((RasterDataNode)sourceBand, sourceTileRectangle);
            TileIndex trgIndex = new TileIndex(targetTile);
            float[] data = sourceTile.getDataBufferFloat();
            double noDataValue = sourceBand.getNoDataValue();
            double backgroundThreshold = 0.0;
            if (this.estimateBackground.booleanValue()) {
                backgroundThreshold = this.computeBackgroundThreshold(data, noDataValue);
            }
            int maxy = ty0 + th;
            int maxx = tx0 + tw;
            for (int ty = ty0; ty < maxy; ++ty) {
                trgIndex.calculateStride(ty);
                for (int tx = tx0; tx < maxx; ++tx) {
                    double targetMean = this.computeTargetMean(tx, ty, data, x0, y0, w, h, noDataValue);
                    if (noDataValue == targetMean) {
                        trgData.setElemIntAt(trgIndex.getIndex(tx), 0);
                        continue;
                    }
                    if (!this.estimateBackground.booleanValue()) {
                        if (targetMean < 0.005) {
                            trgData.setElemIntAt(trgIndex.getIndex(tx), 0);
                            continue;
                        }
                        backgroundThreshold = this.computeBackgroundThreshold(tx, ty, data, x0, y0, w, h, noDataValue);
                    }
                    if (targetMean > backgroundThreshold) {
                        trgData.setElemIntAt(trgIndex.getIndex(tx), 1);
                        continue;
                    }
                    trgData.setElemIntAt(trgIndex.getIndex(tx), 0);
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private double computeTargetMean(int tx, int ty, float[] data, int xx0, int yy0, int width, int height, double noDataValue) {
        int index = (ty - yy0) * width + (tx - xx0);
        double v = data[index];
        if (noDataValue == v) {
            return noDataValue;
        }
        if (this.targetWindowSize == 1) {
            return v;
        }
        int x0 = Math.max(tx - xx0 - this.halfTargetWindowSize, 0);
        int y0 = Math.max(ty - yy0 - this.halfTargetWindowSize, 0);
        int w = Math.min(tx - xx0 + this.halfTargetWindowSize, width - 1) - x0 + 1;
        int h = Math.min(ty - yy0 + this.halfTargetWindowSize, height - 1) - y0 + 1;
        double mean = 0.0;
        int numPixels = 0;
        int nodataCnt = 0;
        int maxy = y0 + h;
        int maxx = x0 + w;
        for (int y = y0; y < maxy; ++y) {
            int yWidth = y * width;
            for (int x = x0; x < maxx; ++x) {
                double val = data[yWidth + x];
                if (noDataValue == val) {
                    ++nodataCnt;
                    continue;
                }
                mean += val;
                ++numPixels;
            }
        }
        if ((double)nodataCnt > 0.1 * (double)w * (double)h) {
            return noDataValue;
        }
        return mean / (double)numPixels;
    }

    private double computeBackgroundThreshold(int tx, int ty, float[] data, int xx0, int yy0, int width, int height, double noDataValue) {
        int x0 = Math.max(tx - xx0 - this.halfBackgroundWindowSize, 0);
        int y0 = Math.max(ty - yy0 - this.halfBackgroundWindowSize, 0);
        int w = Math.min(tx - xx0 + this.halfBackgroundWindowSize, width - 1) - x0 + 1;
        int h = Math.min(ty - yy0 + this.halfBackgroundWindowSize, height - 1) - y0 + 1;
        double sum = 0.0;
        int maxy = y0 + h;
        int maxx = x0 + w;
        double[] dataArray = new double[w * h];
        int numValues = 0;
        for (int y = y0; y < maxy; ++y) {
            int yy = y - (ty - yy0);
            int yWidth = y * width;
            boolean yGtrHalfGuard = (yy < 0 ? -yy : yy) > this.halfGuardWindowSize;
            for (int x = x0; x < maxx; ++x) {
                double val;
                int xx = x - (tx - xx0);
                if (!yGtrHalfGuard && (xx < 0 ? -xx : xx) <= this.halfGuardWindowSize || noDataValue == (val = (double)data[yWidth + x])) continue;
                sum += val;
                dataArray[numValues] = val;
                ++numValues;
            }
        }
        double mean = sum / (double)numValues;
        double std = 0.0;
        for (int i = 0; i < numValues; ++i) {
            double tmp = dataArray[i] - mean;
            std += tmp * tmp;
        }
        double backgroundSTD = Math.sqrt(std / (double)numValues);
        return mean + backgroundSTD * this.t;
    }

    private double computeBackgroundThreshold(float[] data, double noDataValue) {
        double sum = 0.0;
        int numPixels = 0;
        for (float val : data) {
            if (noDataValue == (double)val || !((double)val < 0.5)) continue;
            sum += (double)val;
            ++numPixels;
        }
        double mean = sum / (double)numPixels;
        double std = 0.0;
        for (float val : data) {
            if (noDataValue == (double)val || !((double)val < 0.5)) continue;
            double tmp = (double)val - mean;
            std += tmp * tmp;
        }
        double backgroundSTD = Math.sqrt(std / (double)numPixels);
        return mean + backgroundSTD * this.t;
    }

    private static double computeDetectorDesignParameter(double pfa) {
        return Math.sqrt(2.0) * AdaptiveThresholdingOp.inverf(1.0 - 2.0 * FastMath.pow((double)10.0, (double)(-pfa)));
    }

    private static double erfc(double x) {
        double z = Math.abs(x);
        double t = 1.0 / (1.0 + 0.5 * z);
        double erfc = t * FastMath.exp((double)(-z * z - 1.26551223 + t * (1.00002368 + t * (0.37409196 + t * (0.09678418 + t * (-0.18628806 + t * (0.27886807 + t * (-1.13520398 + t * (1.48851587 + t * (-0.82215223 + t * 0.17087277))))))))));
        if (x < 0.0) {
            erfc = 2.0 - erfc;
        }
        return erfc;
    }

    private static double erf(double x) {
        return 1.0 - AdaptiveThresholdingOp.erfc(x);
    }

    private static double inverfc(double p) {
        if (p >= 2.0) {
            return -100.0;
        }
        if (p <= 0.0) {
            return 100.0;
        }
        double pp = p < 1.0 ? p : 2.0 - p;
        double t = Math.sqrt(-2.0 * Math.log(pp / 2.0));
        double x = -0.70711 * ((2.30753 + t * 0.27061) / (1.0 + t * (0.99229 + t * 0.04481)) - t);
        for (int j = 0; j < 2; ++j) {
            double err = AdaptiveThresholdingOp.erfc(x) - pp;
            x += err / (1.1283791670955126 * FastMath.exp((double)(-Math.sqrt(x))) - x * err);
        }
        return p < 1.0 ? x : -x;
    }

    private static double inverf(double p) {
        return AdaptiveThresholdingOp.inverfc(1.0 - p);
    }

    private boolean computeBackgroundStatistics(int tx, int ty, float[] data, int xx0, int yy0, int width, int height, double noDataValue, double[] stats) {
        double mean;
        int x0 = Math.max(tx - xx0 - this.halfBackgroundWindowSize, 0);
        int y0 = Math.max(ty - yy0 - this.halfBackgroundWindowSize, 0);
        int w = Math.min(tx - xx0 + this.halfBackgroundWindowSize, width - 1) - x0 + 1;
        int h = Math.min(ty - yy0 + this.halfBackgroundWindowSize, height - 1) - y0 + 1;
        double sum = 0.0;
        double sumsq = 0.0;
        int maxy = y0 + h;
        int maxx = x0 + w;
        double[] dataArray = new double[w * h];
        int numValues = 0;
        for (int y = y0; y < maxy; ++y) {
            int yy = y - (ty - yy0);
            int yWidth = y * width;
            boolean yGtrHalfGuard = (yy < 0 ? -yy : yy) > this.halfGuardWindowSize;
            for (int x = x0; x < maxx; ++x) {
                double val;
                int xx = x - (tx - xx0);
                if (!yGtrHalfGuard && (xx < 0 ? -xx : xx) <= this.halfGuardWindowSize || noDataValue == (val = (double)data[yWidth + x])) continue;
                sum += val;
                sumsq += val * val;
                dataArray[numValues] = val;
                ++numValues;
            }
        }
        if (numValues == 0) {
            return false;
        }
        stats[0] = mean = sum / (double)numValues;
        stats[1] = sumsq / (double)numValues;
        double std = 0.0;
        for (int i = 0; i < numValues; ++i) {
            double tmp = dataArray[i] - mean;
            std += tmp * tmp;
        }
        stats[2] = Math.sqrt(std / (double)numValues);
        return true;
    }

    private double evaluateProbability(UnivariateFunction pdf, double x) {
        double result;
        try {
            IterativeLegendreGaussIntegrator integrator = new IterativeLegendreGaussIntegrator(100, 1.0E-15, AdaptiveThresholdingOp.sq(1.0E-15));
            result = integrator.integrate(2000, pdf, 0.0, x);
        }
        catch (Exception e) {
            result = -999.0;
        }
        return result;
    }

    private double integrateFromZeroToInfinity(UnivariateFunction pdf) {
        double result;
        ModifiedFinitePDF mpdf = new ModifiedFinitePDF(pdf);
        try {
            IterativeLegendreGaussIntegrator integrator = new IterativeLegendreGaussIntegrator(100, 1.0E-15, AdaptiveThresholdingOp.sq(1.0E-15));
            result = integrator.integrate(2000, (UnivariateFunction)mpdf, 0.0, 1.5707963267948966);
        }
        catch (Exception e) {
            result = -999.0;
        }
        return result;
    }

    private void findBoundsForT(UnivariateFunction pdf, double[] bounds) {
        int i;
        bounds[0] = -999.0;
        bounds[1] = -999.0;
        double leftT = 0.0;
        double rightT = 2.0;
        boolean foundRightT = false;
        boolean foundLeftT = false;
        for (i = 0; i < 2000; ++i) {
            double rightVal = this.evaluateProbability(pdf, rightT);
            if (rightVal < 0.0) {
                return;
            }
            if (rightVal < this.oneMinusPFA) {
                leftT = rightT;
                foundLeftT = true;
                rightT *= 2.0;
                continue;
            }
            if (rightVal > this.oneMinusPFA) {
                foundRightT = true;
                break;
            }
            bounds[0] = rightT;
            bounds[1] = rightT;
            return;
        }
        if (!foundRightT) {
            System.out.println("DEBUG: ERROR Failed to find bounds for T. " + this.getParamsString(pdf));
            return;
        }
        if (!foundLeftT) {
            leftT = rightT / 2.0;
            for (i = 0; i < 2000; ++i) {
                double leftVal = this.evaluateProbability(pdf, leftT);
                if (leftVal < 0.0) {
                    return;
                }
                if (leftVal > this.oneMinusPFA) {
                    rightT = leftT;
                    leftT /= 2.0;
                    continue;
                }
                if (leftVal < this.oneMinusPFA) {
                    foundLeftT = true;
                    break;
                }
                bounds[0] = leftT;
                bounds[1] = leftT;
                return;
            }
        }
        if (foundLeftT) {
            bounds[0] = leftT;
            bounds[1] = rightT;
            if (leftT > rightT) {
                System.out.println("DEBUG: leftT = " + leftT + "; rightT = " + rightT);
                throw new OperatorException("DEBUG findBoundsForT: BUG!!! leftT > rightT");
            }
            double leftVal = this.evaluateProbability(pdf, leftT);
            double rightVal = this.evaluateProbability(pdf, rightT);
            if (leftVal > this.oneMinusPFA || rightVal < this.oneMinusPFA) {
                System.out.println("DEBUG: leftT = " + leftT + "; rightT = " + rightT + " leftVal = " + leftVal + " rightVal = " + rightVal + " 1-PFA = " + this.oneMinusPFA + this.getParamsString(pdf));
                throw new OperatorException("DEBUG findBoundsForT: BUG!!!");
            }
        }
    }

    private double computeT(UnivariateFunction pdf, int tx, int ty) {
        double[] bounds = new double[2];
        this.findBoundsForT(pdf, bounds);
        if (bounds[0] > bounds[1]) {
            throw new OperatorException("lower bound = " + bounds[0] + " cannot be >" + " upper bound = " + bounds[1]);
        }
        if (bounds[1] < 0.0) {
            System.out.println("DEBUG: ERROR tx = " + tx + " ty = " + ty + " : bounds = " + bounds[0] + ", " + bounds[1]);
            return Double.MAX_VALUE;
        }
        double leftT = bounds[0];
        double rightT = bounds[1];
        for (int i = 0; i < 2000; ++i) {
            double newT = (leftT + rightT) / 2.0;
            double leftVal = this.evaluateProbability(pdf, leftT);
            if (leftVal < 0.0) {
                return Double.MAX_VALUE;
            }
            double rightVal = this.evaluateProbability(pdf, rightT);
            if (rightVal < 0.0) {
                return Double.MAX_VALUE;
            }
            if (Math.abs(leftVal - rightVal) < 1.0E-15) {
                if (Math.abs(this.evaluateProbability(pdf, newT) - this.oneMinusPFA) > 1.0E-15) {
                    System.out.println("ERROR2: tx = " + tx + " ty = " + ty + ": " + this.getParamsString(pdf));
                }
                return newT;
            }
            double newVal = this.evaluateProbability(pdf, newT);
            if (newVal < 0.0) {
                return Double.MAX_VALUE;
            }
            if (newVal < this.oneMinusPFA) {
                leftT = newT;
                continue;
            }
            if (newVal > this.oneMinusPFA) {
                rightT = newT;
                continue;
            }
            if (Math.abs(this.evaluateProbability(pdf, newT) - this.oneMinusPFA) > 1.0E-15) {
                System.out.println("ERROR3: tx = " + tx + " ty = " + ty + ": " + this.getParamsString(pdf));
            }
            return newT;
        }
        System.out.println("DEBUG ERROR1: tx = " + tx + " ty = " + ty);
        return Double.MAX_VALUE;
    }

    private KDistributionPDF getScaledKDistribution(double mu, double nu) {
        KDistributionPDF pdf = new KDistributionPDF(this.numLooks, mu, nu, 1.0);
        double tmp = this.integrateFromZeroToInfinity(pdf);
        if (tmp <= 0.0) {
            return null;
        }
        KDistributionPDF spdf = new KDistributionPDF(this.numLooks, mu, nu, 1.0 / tmp);
        return spdf;
    }

    private double computeBackgroundThreshold1(int tx, int ty, float[] data, int xx0, int yy0, int width, int height, double noDataValue) {
        Object pdf;
        double[] stats = new double[3];
        boolean ok = this.computeBackgroundStatistics(tx, ty, data, xx0, yy0, width, height, noDataValue, stats);
        if (!ok) {
            return Double.MAX_VALUE;
        }
        double mu = stats[0];
        double tmp1 = stats[1] / (mu * mu);
        double tmp2 = 1.0 + 1.0 / (double)this.numLooks;
        double nu = 1.0 / (tmp1 / tmp2 - 1.0);
        Object object = pdf = nu < 0.0 ? new Chi2DistributionPDF(this.numLooks, stats[2]) : this.getScaledKDistribution(mu, nu);
        if (pdf == null) {
            return Double.MAX_VALUE;
        }
        return this.computeT((UnivariateFunction)pdf, tx, ty);
    }

    private String getParamsString(UnivariateFunction pdf) {
        if (pdf instanceof KDistributionPDF) {
            return " K-dis params: " + ((KDistributionPDF)pdf).getParamsString();
        }
        if (pdf instanceof Chi2DistributionPDF) {
            return " Chi2-dis params: " + ((Chi2DistributionPDF)pdf).getParamsString();
        }
        return "getParamsString() called for unknown function";
    }

    private static double sq(double x) {
        return x * x;
    }

    private double integrateFromNegativeInfinityToPositiveInfinity(UnivariateFunction pdf) {
        double result;
        ModifiedFinitePDF mpdf = new ModifiedFinitePDF(pdf);
        try {
            IterativeLegendreGaussIntegrator integrator = new IterativeLegendreGaussIntegrator(100, 1.0E-15, AdaptiveThresholdingOp.sq(1.0E-15));
            result = integrator.integrate(2000, (UnivariateFunction)mpdf, -1.5707963267948966, 1.5707963267948966);
        }
        catch (Exception e) {
            result = -999.0;
        }
        return result;
    }

    private void debugKDistribution() {
        KDistributionPDF pdf = new KDistributionPDF(this.numLooks, 0.08525186254131689, 17.343587288660498, 1.0);
        UniformDistribution updf = new UniformDistribution();
        System.out.println("DEBUG K-Dis: intergrate Uniform distribution from 0 to +infinity = " + this.integrateFromZeroToInfinity(updf));
        System.out.println("DEBUG K-Dis: intergrate Uniform distribution from -infinity to +infinity = " + this.integrateFromNegativeInfinityToPositiveInfinity(updf));
        double tmp = this.integrateFromZeroToInfinity(pdf);
        System.out.println("DEBUG K-Dis: intergrate K-distribution (no scaling) from 0 to +infinity = " + tmp);
        System.out.println("DEBUG K-Dis: intergrate K-distribution from -infinity to +infinity = " + this.integrateFromNegativeInfinityToPositiveInfinity(pdf));
        KDistributionPDF spdf = new KDistributionPDF(this.numLooks, 0.08525186254131689, 17.343587288660498, 1.0 / tmp);
        System.out.println("DEBUG K-Dis: intergrate K-distribution (scaled) from 0 to +infinity = " + this.integrateFromZeroToInfinity(spdf));
    }

    private void debugFindBoundsForT() {
        double mu = 0.0036357872468928934;
        double nu = 48.280481127435564;
        KDistributionPDF pdf = this.getScaledKDistribution(mu, nu);
        double[] bounds = new double[2];
        this.findBoundsForT(pdf, bounds);
        System.out.println("DEBUG find bounds for T: " + bounds[0] + ", " + bounds[1]);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(AdaptiveThresholdingOp.class);
        }
    }

    class UniformDistribution
    implements UnivariateFunction {
        UniformDistribution() {
        }

        public double value(double v) {
            return Math.exp(-v * v / 2.0) / Math.sqrt(Math.PI * 2);
        }
    }

    class NaturalExp
    implements UnivariateFunction {
        NaturalExp() {
        }

        public double value(double v) {
            return Math.exp(v);
        }
    }

    class ModifiedFinitePDF
    implements UnivariateFunction {
        final UnivariateFunction pdf;

        ModifiedFinitePDF(UnivariateFunction pdf) {
            this.pdf = pdf;
        }

        public double value(double v) {
            return 2.0 * this.pdf.value(Math.tan(v)) / (Math.cos(2.0 * v) + 1.0);
        }
    }

    class Chi2DistributionPDF
    implements UnivariateFunction {
        final double n;
        final double sigma;
        final double denominator;
        final double twoSigmaSq;

        Chi2DistributionPDF(double n, double sigma) {
            this.n = n;
            this.sigma = sigma;
            this.denominator = Math.pow(2.0, n) * Math.pow(sigma, 2.0 * n) * Gamma.gamma((double)n);
            this.twoSigmaSq = 2.0 * sigma * sigma;
        }

        double getN() {
            return this.n;
        }

        double getSigma() {
            return this.sigma;
        }

        public double value(double v) {
            if (v < 0.0) {
                return 0.0;
            }
            return Math.pow(v, this.n - 1.0) / this.denominator * Math.exp(-v / this.twoSigmaSq);
        }

        String getParamsString() {
            return "n = " + this.n + "; sigma = " + this.sigma;
        }
    }

    class KDistributionPDF
    implements UnivariateFunction {
        final double L;
        final double mu;
        final double nu;
        final double ptmp1;
        final double z0tmp1;
        final double z0tmp2;
        final double scaleFactor;

        KDistributionPDF(double L, double mu, double nu, double scaleFactor) {
            this.L = L;
            this.mu = mu;
            this.nu = nu;
            this.scaleFactor = scaleFactor;
            double gammaNu = nu < 1.0 ? Gamma.gamma((double)(nu + 1.0)) / nu : Gamma.gamma((double)nu);
            this.ptmp1 = nu * L * Math.sqrt(Math.PI) / (Math.sqrt(2.0) * gammaNu * Gamma.gamma((double)L));
            this.z0tmp1 = mu * (nu - L) / (2.0 * nu);
            this.z0tmp2 = 4.0 * L * nu / (mu * AdaptiveThresholdingOp.sq(nu - L));
        }

        double compute_z0(double x) {
            if (this.nu == this.L) {
                return Math.sqrt(x);
            }
            double tmp = Math.sqrt(1.0 + this.z0tmp2 * x);
            tmp = this.nu > this.L ? 1.0 + tmp : 1.0 - tmp;
            return this.z0tmp1 * tmp;
        }

        double compute_exp_f(double x, double z) {
            double tmp1 = this.nu * z / this.mu;
            double tmp2 = (this.L - 1.0) * Math.log(this.L * x / z) - this.L * x / z + (this.nu - 1.0) * Math.log(tmp1) - tmp1;
            return Math.exp(tmp2);
        }

        double compute_sqrt_f2prime(double x, double z) {
            double sqz = AdaptiveThresholdingOp.sq(z);
            double tmp = -(2.0 * this.L * x / (sqz * z)) - (this.nu - this.L) / sqz;
            return Math.sqrt(Math.abs(tmp));
        }

        double getL() {
            return this.L;
        }

        double getMu() {
            return this.mu;
        }

        double getNu() {
            return this.nu;
        }

        double getScaleFactor() {
            return this.scaleFactor;
        }

        public double value(double v) {
            double z0 = this.compute_z0(v);
            double val = this.ptmp1 * this.compute_exp_f(v, z0) / this.compute_sqrt_f2prime(v, z0);
            return val * this.scaleFactor;
        }

        String getParamsString() {
            return "L = " + this.L + "; mu = " + this.mu + "; nu = " + this.nu + "; scaleFactor = " + this.scaleFactor;
        }
    }
}

