/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.fex.gpf.flood;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;

@OperatorMetadata(alias="Flood-Detection", category="Radar/SAR Applications", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2016 by Array Systems Computing Inc.", version="1.0", description="Detect flooded area.", internal=true)
public class FloodDetectionOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct = null;
    private String[] sourceBandNames = null;
    private final HashMap<String, String> targetBandNameToSourceBandName = new HashMap();
    public static final String MASK_NAME = "_Flood";

    public void initialize() throws OperatorException {
        try {
            this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
            this.addSelectedBands();
            ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void addSelectedBands() throws OperatorException {
        String expression;
        Band[] bands = this.sourceProduct.getBands();
        ArrayList<String> bandNameList = new ArrayList<String>(this.sourceProduct.getNumBands());
        for (Band band : bands) {
            if (band.getUnit() == null || !band.getUnit().startsWith("intensity") && !band.getUnit().startsWith("class")) continue;
            bandNameList.add(band.getName());
        }
        this.sourceBandNames = bandNameList.toArray(new String[bandNameList.size()]);
        Band[] sourceBands = new Band[this.sourceBandNames.length];
        for (int i = 0; i < this.sourceBandNames.length; ++i) {
            String sourceBandName = this.sourceBandNames[i];
            Band sourceBand = this.sourceProduct.getBand(sourceBandName);
            if (sourceBand == null) {
                throw new OperatorException("Source band not found: " + sourceBandName);
            }
            sourceBands[i] = sourceBand;
        }
        if (this.sourceBandNames.length == 0) {
            throw new OperatorException("No calibrated bands founds");
        }
        for (Band srcBand : sourceBands) {
            String srcBandNames = srcBand.getName();
            String unit = srcBand.getUnit();
            if (unit == null) {
                throw new OperatorException("band " + srcBandNames + " requires a unit");
            }
            if (unit.contains("imaginary") || unit.contains("real") || unit.contains("phase")) {
                throw new OperatorException("Please select amplitude or intensity band");
            }
            String targetBandName = srcBandNames + MASK_NAME;
            this.targetBandNameToSourceBandName.put(targetBandName, srcBandNames);
            ProductUtils.copyBand((String)srcBandNames, (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
        }
        Band mstBand = this.targetProduct.getBandAt(0);
        Band slvBand = this.targetProduct.getNumBands() > 1 ? this.targetProduct.getBandAt(1) : null;
        Band terrainMask = FloodDetectionOp.getFeatureBand(this.targetProduct, "Terrain_Mask");
        Band globCover = FloodDetectionOp.getFeatureBand(this.targetProduct, "GlobCover");
        Band homogeneity = FloodDetectionOp.getFeatureBand(this.targetProduct, "Homogeneity");
        Band energy = FloodDetectionOp.getFeatureBand(this.targetProduct, "Energy");
        boolean isdB = mstBand.getUnit().contains("db");
        if (isdB) {
            expression = "(" + mstBand.getName() + " < -13 )";
            if (slvBand != null) {
                expression = "!(" + mstBand.getName() + " < -13 )" + " && (" + slvBand.getName() + " < -13 )";
            }
        } else {
            expression = "(" + mstBand.getName() + " < 0.05 && " + mstBand.getName() + " > 0)";
            if (slvBand != null) {
                expression = "!(" + mstBand.getName() + " < 0.05 && " + mstBand.getName() + " > 0)" + " && (" + slvBand.getName() + " < 0.05 && " + slvBand.getName() + " > 0)";
            }
        }
        if (terrainMask != null) {
            expression = expression + " && " + terrainMask.getName() + " == 0";
        }
        if (globCover != null) {
            expression = expression + " && " + globCover.getName() + " != 210";
        }
        if (energy != null || homogeneity != null) {
            // empty if block
        }
        Mask mask = new Mask(mstBand.getName() + "_flood", mstBand.getRasterWidth(), mstBand.getRasterHeight(), (Mask.ImageType)Mask.BandMathsType.INSTANCE);
        mask.setDescription("Flood");
        mask.getImageConfig().setValue("color", (Object)Color.BLUE);
        mask.getImageConfig().setValue("transparency", (Object)0.7);
        mask.getImageConfig().setValue("expression", (Object)expression);
        mask.setNoDataValue(0.0);
        mask.setNoDataValueUsed(true);
        this.targetProduct.getMaskGroup().add((ProductNode)mask);
    }

    private static Band getFeatureBand(Product product, String idStr) throws OperatorException {
        for (String name : product.getBandNames()) {
            if (!name.contains(idStr)) continue;
            return product.getBand(name);
        }
        return null;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(FloodDetectionOp.class);
        }
    }
}

