/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.fex.gpf.urban;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import org.esa.s1tbx.fex.gpf.masks.TerrainMaskOp;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.Unit;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="Speckle-Divergence", category="Radar/Feature Extraction", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2015 by Array Systems Computing Inc.", description="Detect urban area.")
public class SpeckleDivergenceOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct = null;
    @Parameter(description="The list of source bands.", alias="sourceBands", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] sourceBandNames = null;
    @Parameter(valueSet={"5x5", "7x7", "9x9", "11x11", "13x13", "15x15", "17x17"}, defaultValue="15x15", label="Window Size")
    private String windowSizeStr = "15x15";
    private MetadataElement absRoot = null;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private int windowSize = 0;
    private int halfWindowSize = 0;
    private double c = 0.0;
    private final HashMap<String, String> targetBandNameToSourceBandName = new HashMap();
    public static final String SPECKLE_DIVERGENCE_MASK_NAME = "_speckle_divergence";
    private static final String WINDOW_SIZE_5x5 = "5x5";
    private static final String WINDOW_SIZE_7x7 = "7x7";
    private static final String WINDOW_SIZE_9x9 = "9x9";
    private static final String WINDOW_SIZE_11x11 = "11x11";
    private static final String WINDOW_SIZE_13x13 = "13x13";
    private static final String WINDOW_SIZE_15x15 = "15x15";
    private static final String WINDOW_SIZE_17x17 = "17x17";

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSARProduct();
            this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
            this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
            this.setWindowSize();
            this.computeTheoreticalCoefficientOfVariance();
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void setWindowSize() {
        switch (this.windowSizeStr) {
            case "5x5": {
                this.windowSize = 5;
                break;
            }
            case "7x7": {
                this.windowSize = 7;
                break;
            }
            case "9x9": {
                this.windowSize = 9;
                break;
            }
            case "11x11": {
                this.windowSize = 11;
                break;
            }
            case "13x13": {
                this.windowSize = 13;
                break;
            }
            case "15x15": {
                this.windowSize = 15;
                break;
            }
            case "17x17": {
                this.windowSize = 17;
                break;
            }
            default: {
                throw new OperatorException("Unknown window size: " + this.windowSize);
            }
        }
        this.halfWindowSize = this.windowSize / 2;
    }

    private void computeTheoreticalCoefficientOfVariance() {
        int azimuthLooks = this.absRoot.getAttributeInt("azimuth_looks");
        int rangeLooks = this.absRoot.getAttributeInt("range_looks");
        this.c = 1.0 / (double)(azimuthLooks + rangeLooks);
    }

    private void createTargetProduct() throws Exception {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        this.addSelectedBands();
    }

    private void addSelectedBands() throws OperatorException {
        if (this.sourceBandNames == null || this.sourceBandNames.length == 0) {
            Band[] bands = this.sourceProduct.getBands();
            ArrayList<String> bandNameList = new ArrayList<String>(this.sourceProduct.getNumBands());
            Band[] bandArray = bands;
            int n = bandArray.length;
            for (int i = 0; i < n; ++i) {
                Band band = bandArray[i];
                if (band.getUnit() == null || !band.getUnit().equals("intensity")) continue;
                bandNameList.add(band.getName());
            }
            this.sourceBandNames = bandNameList.toArray(new String[bandNameList.size()]);
        }
        Band[] sourceBands = new Band[this.sourceBandNames.length];
        for (int i = 0; i < this.sourceBandNames.length; ++i) {
            String sourceBandName = this.sourceBandNames[i];
            Band sourceBand = this.sourceProduct.getBand(sourceBandName);
            if (sourceBand == null) {
                throw new OperatorException("Source band not found: " + sourceBandName);
            }
            sourceBands[i] = sourceBand;
        }
        for (Band srcBand : sourceBands) {
            String srcBandNames = srcBand.getName();
            String unit = srcBand.getUnit();
            if (unit == null) {
                throw new OperatorException("band " + srcBandNames + " requires a unit");
            }
            if (unit.contains("imaginary") || unit.contains("real") || unit.contains("phase")) {
                throw new OperatorException("Please select amplitude or intensity band");
            }
            String targetBandName = srcBandNames + SPECKLE_DIVERGENCE_MASK_NAME;
            this.targetBandNameToSourceBandName.put(targetBandName, srcBandNames);
            Band targetBand = ProductUtils.copyBand((String)srcBandNames, (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)false);
            targetBand.setSourceImage(srcBand.getSourceImage());
            Band targetBandMask = new Band(targetBandName, 30, this.sourceImageWidth, this.sourceImageHeight);
            targetBandMask.setNoDataValue(srcBand.getNoDataValue());
            targetBandMask.setNoDataValueUsed(true);
            targetBandMask.setUnit("speckle_divergence");
            this.targetProduct.addBand(targetBandMask);
            String expression = targetBandMask.getName() + " > 0.2";
            Mask mask = new Mask(targetBandMask.getName() + "_mask", this.targetProduct.getSceneRasterWidth(), this.targetProduct.getSceneRasterHeight(), (Mask.ImageType)Mask.BandMathsType.INSTANCE);
            mask.setDescription("Urban Area");
            mask.getImageConfig().setValue("color", (Object)Color.MAGENTA);
            mask.getImageConfig().setValue("transparency", (Object)0.7);
            mask.getImageConfig().setValue("expression", (Object)expression);
            mask.setNoDataValue(0.0);
            mask.setNoDataValueUsed(true);
            this.targetProduct.getMaskGroup().add((ProductNode)mask);
        }
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        try {
            Rectangle targetTileRectangle = targetTile.getRectangle();
            int tx0 = targetTileRectangle.x;
            int ty0 = targetTileRectangle.y;
            int tw = targetTileRectangle.width;
            int th = targetTileRectangle.height;
            ProductData trgData = targetTile.getDataBuffer();
            Rectangle sourceTileRectangle = this.getSourceTileRectangle(tx0, ty0, tw, th);
            String srcBandName = this.targetBandNameToSourceBandName.get(targetBand.getName());
            Band sourceBand = this.sourceProduct.getBand(srcBandName);
            Tile sourceTile = this.getSourceTile((RasterDataNode)sourceBand, sourceTileRectangle);
            ProductData srcData = sourceTile.getDataBuffer();
            double noDataValue = sourceBand.getNoDataValue();
            Unit.UnitType bandUnit = Unit.getUnitType((Band)sourceBand);
            Band maskBand = this.sourceProduct.getBand(TerrainMaskOp.TERRAIN_MASK_NAME);
            Tile maskTile = null;
            ProductData maskData = null;
            if (maskBand != null) {
                maskTile = this.getSourceTile((RasterDataNode)maskBand, targetTileRectangle);
                maskData = maskTile.getDataBuffer();
            }
            TileIndex trgIndex = new TileIndex(targetTile);
            TileIndex srcIndex = new TileIndex(sourceTile);
            int maxy = ty0 + th;
            int maxx = tx0 + tw;
            for (int ty = ty0; ty < maxy; ++ty) {
                trgIndex.calculateStride(ty);
                srcIndex.calculateStride(ty);
                for (int tx = tx0; tx < maxx; ++tx) {
                    int idx = trgIndex.getIndex(tx);
                    double v = srcData.getElemDoubleAt(srcIndex.getIndex(tx));
                    if (v == noDataValue || maskBand != null && maskData.getElemIntAt(idx) == 1) {
                        trgData.setElemFloatAt(idx, (float)noDataValue);
                        continue;
                    }
                    double cv = this.computeCoefficientOfVariance(tx, ty, sourceTile, srcData, bandUnit, noDataValue);
                    double speckleDivergence = cv - this.c;
                    trgData.setElemFloatAt(idx, (float)speckleDivergence);
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private Rectangle getSourceTileRectangle(int x0, int y0, int w, int h) {
        int sx0 = x0;
        int sy0 = y0;
        int sw = w;
        int sh = h;
        if (x0 >= this.halfWindowSize) {
            sx0 -= this.halfWindowSize;
            sw += this.halfWindowSize;
        }
        if (y0 >= this.halfWindowSize) {
            sy0 -= this.halfWindowSize;
            sh += this.halfWindowSize;
        }
        if (x0 + w + this.halfWindowSize <= this.sourceImageWidth) {
            sw += this.halfWindowSize;
        }
        if (y0 + h + this.halfWindowSize <= this.sourceImageHeight) {
            sh += this.halfWindowSize;
        }
        return new Rectangle(sx0, sy0, sw, sh);
    }

    private double computeCoefficientOfVariance(int tx, int ty, Tile sourceTile, ProductData srcData, Unit.UnitType bandUnit, double noDataValue) {
        double[] samples = new double[this.windowSize * this.windowSize];
        int numSamples = this.getSamples(tx, ty, bandUnit, noDataValue, sourceTile, srcData, samples);
        if (numSamples == 0) {
            return noDataValue;
        }
        double mean = SpeckleDivergenceOp.getMeanValue(samples, numSamples);
        double variance = SpeckleDivergenceOp.getVarianceValue(samples, numSamples, mean);
        return Math.sqrt(variance) / mean;
    }

    private int getSamples(int tx, int ty, Unit.UnitType bandUnit, double noDataValue, Tile sourceTile, ProductData srcData, double[] samples) {
        int x0 = Math.max(tx - this.halfWindowSize, 0);
        int y0 = Math.max(ty - this.halfWindowSize, 0);
        int w = Math.min(tx + this.halfWindowSize, this.sourceImageWidth - 1) - x0 + 1;
        int h = Math.min(ty + this.halfWindowSize, this.sourceImageHeight - 1) - y0 + 1;
        TileIndex tileIndex = new TileIndex(sourceTile);
        int numSamples = 0;
        int maxy = Math.min(y0 + h, sourceTile.getMaxY() - 1);
        int maxx = Math.min(x0 + w, sourceTile.getMaxX() - 1);
        if (bandUnit == Unit.UnitType.INTENSITY) {
            for (int y = y0; y < maxy; ++y) {
                tileIndex.calculateStride(y);
                for (int x = x0; x < maxx; ++x) {
                    double v = srcData.getElemDoubleAt(tileIndex.getIndex(x));
                    if (v == noDataValue || !(v > 0.4)) continue;
                    samples[numSamples++] = v;
                }
            }
        } else {
            for (int y = y0; y < maxy; ++y) {
                tileIndex.calculateStride(y);
                for (int x = x0; x < maxx; ++x) {
                    double v = srcData.getElemDoubleAt(tileIndex.getIndex(x));
                    if (!(v != noDataValue & v * v > 0.4)) continue;
                    samples[numSamples++] = v * v;
                }
            }
        }
        return numSamples;
    }

    private static double getMeanValue(double[] samples, int numSamples) {
        double mean = 0.0;
        for (int i = 0; i < numSamples; ++i) {
            mean += samples[i];
        }
        return mean /= (double)numSamples;
    }

    private static double getVarianceValue(double[] samples, int numSamples, double mean) {
        double var = 0.0;
        if (numSamples > 1) {
            for (int i = 0; i < numSamples; ++i) {
                double diff = samples[i] - mean;
                var += diff * diff;
            }
            var /= (double)(numSamples - 1);
        }
        return var;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(SpeckleDivergenceOp.class);
        }
    }
}

