/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.fex.gpf.texture;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.HashMap;
import org.esa.s1tbx.fex.gpf.texture.GaborFilter;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="GaborFilter", category="Radar/Feature Extraction/Texture Analysis", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2015 by Array Systems Computing Inc.", description="Extract Texture Features", internal=true)
public class GaborFilterOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of source bands.", alias="sourceBands", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] sourceBandNames;
    @Parameter
    private double theta = 0.6;
    private final HashMap<String, String[]> targetBandNameToSourceBandName = new HashMap();
    double[][] filter;

    public void initialize() throws OperatorException {
        this.getSourceMetadata();
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        OperatorUtils.addSelectedBands((Product)this.sourceProduct, (String[])this.sourceBandNames, (Product)this.targetProduct, this.targetBandNameToSourceBandName, (boolean)false, (boolean)true);
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        this.updateTargetProductMetadata();
        this.filter = GaborFilter.createGarborFilter(4.0, this.theta, 1.0, 2.0, 0.3);
    }

    private void getSourceMetadata() {
    }

    private void updateTargetProductMetadata() {
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        int x0 = targetTile.getRectangle().x;
        int y0 = targetTile.getRectangle().y;
        int w = targetTile.getRectangle().width;
        int h = targetTile.getRectangle().height;
        int xmax = (int)Math.floor((double)this.filter.length / 2.0);
        int ymax = (int)Math.floor((double)this.filter[0].length / 2.0);
        String[] srcBandName = this.targetBandNameToSourceBandName.get(targetBand.getName());
        Band srcBand = this.sourceProduct.getBand(srcBandName[0]);
        int minBoundx = Math.max(0, x0 - xmax);
        int minBoundy = Math.max(0, y0 - ymax);
        int boundW = Math.min(w + minBoundx + xmax, srcBand.getRasterWidth() - x0);
        int boundH = Math.min(h + minBoundy + ymax, srcBand.getRasterHeight() - y0);
        Rectangle srcRect = new Rectangle(minBoundx, minBoundy, boundW, boundH);
        Tile sourceTile = this.getSourceTile((RasterDataNode)srcBand, srcRect);
        ProductData trgData = targetTile.getDataBuffer();
        ProductData srcData = sourceTile.getDataBuffer();
        TileIndex trgIndex = new TileIndex(targetTile);
        TileIndex srcIndex = new TileIndex(sourceTile);
        int maxIndex = srcData.getNumElems();
        for (int y = y0; y < y0 + h; ++y) {
            trgIndex.calculateStride(y);
            for (int x = x0; x < x0 + w; ++x) {
                double sum = 0.0;
                for (int yf = -ymax; yf <= ymax; ++yf) {
                    int yy = y - yf;
                    if (yy < minBoundy || yy >= y0 + boundH) continue;
                    srcIndex.calculateStride(yy);
                    for (int xf = -xmax; xf <= xmax; ++xf) {
                        int idx;
                        int xx = x - xf;
                        if (xx < minBoundx || xx >= x0 + boundW || (idx = srcIndex.getIndex(xx)) >= maxIndex) continue;
                        sum += this.filter[xf + xmax][yf + ymax] * srcData.getElemDoubleAt(idx);
                    }
                }
                trgData.setElemDoubleAt(trgIndex.getIndex(x), sum);
            }
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(GaborFilterOp.class);
        }
    }
}

