/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.fex.gpf.texture;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Map;
import javax.media.jai.Histogram;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="GLCM", category="Radar/Feature Extraction/Texture Analysis", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2015 by Array Systems Computing Inc.", description="Extract Texture Features")
public final class GLCMOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of source bands.", alias="sourceBands", label="Source Bands")
    private String[] sourceBandNames = null;
    @Parameter(valueSet={"5x5", "7x7", "9x9", "11x11"}, defaultValue="9x9", label="Window Size")
    private String windowSizeStr = "9x9";
    @Parameter(valueSet={"0", "45", "90", "135", "ALL"}, defaultValue="ALL", label="Angle")
    private String angleStr = "ALL";
    @Parameter(valueSet={"Equal Distance Quantizer", "Probabilistic Quantizer"}, defaultValue="Probabilistic Quantizer", label="Quantizer")
    private String quantizerStr = "Probabilistic Quantizer";
    @Parameter(valueSet={"16", "32", "64"}, defaultValue="64", label="Quantization Levels")
    private String quantizationLevelsStr = "64";
    @Parameter(description="Pixel displacement", interval="[1, 10]", defaultValue="1", label="Displacement")
    private int displacement = 1;
    @Parameter(description="Output Contrast", defaultValue="true", label="Contrast")
    private Boolean outputContrast = true;
    @Parameter(description="Output Dissimilarity", defaultValue="true", label="Dissimilarity")
    private Boolean outputDissimilarity = true;
    @Parameter(description="Output Homogeneity", defaultValue="true", label="Homogeneity")
    private Boolean outputHomogeneity = true;
    @Parameter(description="Output Angular Second Moment", defaultValue="true", label="Angular Second Moment")
    private Boolean outputASM = true;
    @Parameter(description="Output Energy", defaultValue="true", label="Energy")
    private Boolean outputEnergy = true;
    @Parameter(description="Output Maximum Probability", defaultValue="true", label="Maximum Probability")
    private Boolean outputMAX = true;
    @Parameter(description="Output Entropy", defaultValue="true", label="Entropy")
    private Boolean outputEntropy = true;
    @Parameter(description="Output GLCM Mean", defaultValue="true", label="GLCM Mean")
    private Boolean outputMean = true;
    @Parameter(description="Output GLCM Variance", defaultValue="true", label="GLCM Variance")
    private Boolean outputVariance = true;
    @Parameter(description="Output GLCM Correlation", defaultValue="true", label="GLCM Correlation")
    private Boolean outputCorrelation = true;
    private int windowSize = 0;
    private int halfWindowSize = 0;
    private int numQuantLevels = 0;
    private int displacementX = 0;
    private int displacementY = 0;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private double bandMax = 0.0;
    private double bandMin = 0.0;
    private double delta = 0.0;
    private boolean useProbabilisticQuantizer = false;
    private boolean quantizerAvailable = false;
    private boolean computeGLCPWithAllAngles = false;
    private double[] newBinLowValues = null;
    private String[] targetBandNames;
    private static final String ANGLE_0 = "0";
    private static final String ANGLE_45 = "45";
    private static final String ANGLE_90 = "90";
    private static final String ANGLE_135 = "135";
    private static final String ANGLE_ALL = "ALL";
    private static final String EQUAL_DISTANCE_QUANTIZER = "Equal Distance Quantizer";
    private static final String PROBABILISTIC_QUANTIZER = "Probabilistic Quantizer";
    private static final String QUANTIZATION_LEVELS_16 = "16";
    private static final String QUANTIZATION_LEVELS_32 = "32";
    private static final String QUANTIZATION_LEVELS_64 = "64";
    private static final String WINDOW_SIZE_5x5 = "5x5";
    private static final String WINDOW_SIZE_7x7 = "7x7";
    private static final String WINDOW_SIZE_9x9 = "9x9";
    private static final String WINDOW_SIZE_11x11 = "11x11";
    private static double epsilon = 1.0E-10;

    public void initialize() throws OperatorException {
        try {
            if (!(this.outputContrast.booleanValue() || this.outputDissimilarity.booleanValue() || this.outputHomogeneity.booleanValue() || this.outputASM.booleanValue() || this.outputEnergy.booleanValue() || this.outputMAX.booleanValue() || this.outputEntropy.booleanValue() || this.outputMean.booleanValue() || this.outputVariance.booleanValue() || this.outputCorrelation.booleanValue())) {
                throw new OperatorException("Please select output features.");
            }
            this.setWindowSize();
            this.setQuantizer();
            this.setQuantizationLevels();
            this.setXYDisplacements();
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void setWindowSize() {
        switch (this.windowSizeStr) {
            case "5x5": {
                this.windowSize = 5;
                break;
            }
            case "7x7": {
                this.windowSize = 7;
                break;
            }
            case "9x9": {
                this.windowSize = 9;
                break;
            }
            case "11x11": {
                this.windowSize = 11;
                break;
            }
            default: {
                throw new OperatorException("Unknown window size: " + this.windowSizeStr);
            }
        }
        this.halfWindowSize = this.windowSize / 2;
        if (this.displacement >= this.windowSize) {
            throw new OperatorException("Displacement should not be larger than window size.");
        }
    }

    private void setQuantizer() {
        this.useProbabilisticQuantizer = this.quantizerStr.equals(PROBABILISTIC_QUANTIZER);
    }

    private void setQuantizationLevels() {
        switch (this.quantizationLevelsStr) {
            case "16": {
                this.numQuantLevels = 16;
                break;
            }
            case "32": {
                this.numQuantLevels = 32;
                break;
            }
            case "64": {
                this.numQuantLevels = 64;
                break;
            }
            default: {
                throw new OperatorException("Unknown number of quantization levels: " + this.quantizationLevelsStr);
            }
        }
    }

    private void setXYDisplacements() {
        switch (this.angleStr) {
            case "0": {
                this.displacementX = this.displacement;
                this.displacementY = 0;
                break;
            }
            case "45": {
                this.displacementX = -this.displacement;
                this.displacementY = this.displacement;
                break;
            }
            case "90": {
                this.displacementX = 0;
                this.displacementY = this.displacement;
                break;
            }
            case "135": {
                this.displacementX = this.displacement;
                this.displacementY = this.displacement;
                break;
            }
            case "ALL": {
                this.computeGLCPWithAllAngles = true;
                break;
            }
            default: {
                throw new OperatorException("Unknown angle: " + this.angleStr);
            }
        }
    }

    private void createTargetProduct() {
        this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
        this.addSelectedBands();
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
    }

    private void getSourceBands() {
        ArrayList<String> srcBandNameList = new ArrayList<String>();
        if (this.sourceBandNames != null) {
            for (String srcBandName : this.sourceBandNames) {
                Band srcBand = this.sourceProduct.getBand(srcBandName);
                if (srcBand == null) continue;
                srcBandNameList.add(srcBand.getName());
            }
        }
        if (srcBandNameList.isEmpty()) {
            Band[] srcBands;
            for (Band srcBand : srcBands = this.sourceProduct.getBands()) {
                String bandUnit = srcBand.getUnit();
                if (bandUnit == null || !bandUnit.equals("intensity") && !bandUnit.equals("intensity_db") && !bandUnit.equals("amplitude") && !bandUnit.equals("amplitude_db")) continue;
                srcBandNameList.add(srcBand.getName());
            }
            if (srcBandNameList.isEmpty()) {
                srcBandNameList.add(this.sourceProduct.getBandAt(0).getName());
            }
        }
        this.sourceBandNames = srcBandNameList.toArray(new String[srcBandNameList.size()]);
    }

    private void addSelectedBands() throws OperatorException {
        Band[] bands;
        this.getSourceBands();
        this.targetBandNames = this.getTargetBandNames();
        for (Band band : bands = OperatorUtils.addBands((Product)this.targetProduct, (String[])this.targetBandNames, (String)"")) {
            band.setNoDataValueUsed(true);
        }
    }

    private String[] getTargetBandNames() {
        ArrayList<String> trgBandNames = new ArrayList<String>();
        for (String srcBandName : this.sourceBandNames) {
            if (this.outputContrast.booleanValue()) {
                trgBandNames.add(srcBandName + '_' + GLCM_TYPES.Contrast.toString());
            }
            if (this.outputDissimilarity.booleanValue()) {
                trgBandNames.add(srcBandName + '_' + GLCM_TYPES.Dissimilarity.toString());
            }
            if (this.outputHomogeneity.booleanValue()) {
                trgBandNames.add(srcBandName + '_' + GLCM_TYPES.Homogeneity.toString());
            }
            if (this.outputASM.booleanValue()) {
                trgBandNames.add(srcBandName + '_' + GLCM_TYPES.ASM.toString());
            }
            if (this.outputEnergy.booleanValue()) {
                trgBandNames.add(srcBandName + '_' + GLCM_TYPES.Energy.toString());
            }
            if (this.outputMAX.booleanValue()) {
                trgBandNames.add(srcBandName + '_' + GLCM_TYPES.MAX.toString());
            }
            if (this.outputEntropy.booleanValue()) {
                trgBandNames.add(srcBandName + '_' + GLCM_TYPES.Entropy.toString());
            }
            if (this.outputMean.booleanValue()) {
                trgBandNames.add(srcBandName + '_' + GLCM_TYPES.GLCMMean.toString());
            }
            if (this.outputVariance.booleanValue()) {
                trgBandNames.add(srcBandName + '_' + GLCM_TYPES.GLCMVariance.toString());
            }
            if (!this.outputCorrelation.booleanValue()) continue;
            trgBandNames.add(srcBandName + '_' + GLCM_TYPES.GLCMCorrelation.toString());
        }
        return trgBandNames.toArray(new String[trgBandNames.size()]);
    }

    private synchronized void computeQuantizationBins() {
        if (this.quantizerAvailable) {
            return;
        }
        Band srcBand = this.sourceProduct.getBand(this.sourceBandNames[0]);
        if (this.useProbabilisticQuantizer) {
            Histogram hist = srcBand.getStx().getHistogram();
            int numBins = hist.getNumBins(0);
            int[] bins = hist.getBins(0);
            int totalNumPixels = 0;
            for (int i = 0; i < numBins; ++i) {
                totalNumPixels += bins[i];
            }
            int newBinSize = totalNumPixels / this.numQuantLevels;
            this.newBinLowValues = new double[this.numQuantLevels + 1];
            this.newBinLowValues[0] = hist.getBinLowValue(0, 0);
            int k = 1;
            int sum = 0;
            for (int i = 0; i < numBins; ++i) {
                if ((sum += bins[i]) < k * newBinSize) continue;
                this.newBinLowValues[k] = hist.getBinLowValue(0, i);
                if (k < this.numQuantLevels - 1) {
                    ++k;
                    continue;
                }
                this.newBinLowValues[this.numQuantLevels] = hist.getHighValue(0);
                break;
            }
        } else {
            this.bandMin = srcBand.getStx(true, ProgressMonitor.NULL).getMinimum();
            this.bandMax = srcBand.getStx(true, ProgressMonitor.NULL).getMaximum();
            this.delta = (this.bandMax - this.bandMin) / (double)this.numQuantLevels;
        }
        this.quantizerAvailable = true;
    }

    public synchronized void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        if (!this.quantizerAvailable) {
            this.computeQuantizationBins();
        }
        int tx0 = targetRectangle.x;
        int ty0 = targetRectangle.y;
        int tw = targetRectangle.width;
        int th = targetRectangle.height;
        int maxY = ty0 + th;
        int maxX = tx0 + tw;
        try {
            TileIndex trgIndex = new TileIndex(targetTiles.get(targetTiles.keySet().iterator().next()));
            Rectangle sourceTileRectangle = this.getSourceTileRectangle(tx0, ty0, tw, th);
            SrcInfo[] srcInfoList = new SrcInfo[this.sourceBandNames.length];
            int cnt = 0;
            for (String srcBandName : this.sourceBandNames) {
                Band sourceBand = this.sourceProduct.getBand(srcBandName);
                srcInfoList[cnt] = new SrcInfo();
                srcInfoList[cnt].sourceTile = this.getSourceTile((RasterDataNode)sourceBand, sourceTileRectangle);
                srcInfoList[cnt].srcData = srcInfoList[cnt].sourceTile.getDataBuffer();
                srcInfoList[cnt].noDataValue = (float)sourceBand.getNoDataValue();
                srcInfoList[cnt].tfNoData = new TextureFeatures(srcInfoList[cnt].noDataValue, srcInfoList[cnt].noDataValue, srcInfoList[cnt].noDataValue, srcInfoList[cnt].noDataValue, srcInfoList[cnt].noDataValue, srcInfoList[cnt].noDataValue, srcInfoList[cnt].noDataValue, srcInfoList[cnt].noDataValue, srcInfoList[cnt].noDataValue, srcInfoList[cnt].noDataValue);
                ArrayList<TileData> tileDataList = new ArrayList<TileData>();
                for (String targetBandName : this.targetBandNames) {
                    if (!targetBandName.startsWith(srcBandName)) continue;
                    Band targetBand = this.targetProduct.getBand(targetBandName);
                    Tile targetTile = targetTiles.get(targetBand);
                    tileDataList.add(new TileData(targetTile, targetBand.getName()));
                }
                srcInfoList[cnt].tileDataList = tileDataList.toArray(new TileData[tileDataList.size()]);
                ++cnt;
            }
            for (int ty = ty0; ty < maxY; ++ty) {
                trgIndex.calculateStride(ty);
                for (int tx = tx0; tx < maxX; ++tx) {
                    int idx = trgIndex.getIndex(tx);
                    for (SrcInfo srcInfo : srcInfoList) {
                        TextureFeatures tf;
                        float val = srcInfo.srcData.getElemFloatAt(srcInfo.sourceTile.getDataBufferIndex(tx, ty));
                        if ((double)Math.abs(val - srcInfo.noDataValue) < epsilon) {
                            tf = srcInfo.tfNoData;
                        } else {
                            GLCMElem[] GLCMElemList = this.computeGLCM(tx, ty, srcInfo.sourceTile, srcInfo.srcData, srcInfo.noDataValue);
                            tf = this.computeTextureFeatures(GLCMElemList);
                        }
                        for (TileData tileData : srcInfo.tileDataList) {
                            if (this.outputContrast.booleanValue() && tileData.type.equals((Object)GLCM_TYPES.Contrast)) {
                                tileData.dataBuffer.setElemFloatAt(idx, (float)tf.Contrast);
                                continue;
                            }
                            if (this.outputDissimilarity.booleanValue() && tileData.type.equals((Object)GLCM_TYPES.Dissimilarity)) {
                                tileData.dataBuffer.setElemFloatAt(idx, (float)tf.Dissimilarity);
                                continue;
                            }
                            if (this.outputHomogeneity.booleanValue() && tileData.type.equals((Object)GLCM_TYPES.Homogeneity)) {
                                tileData.dataBuffer.setElemFloatAt(idx, (float)tf.Homogeneity);
                                continue;
                            }
                            if (this.outputASM.booleanValue() && tileData.type.equals((Object)GLCM_TYPES.ASM)) {
                                tileData.dataBuffer.setElemFloatAt(idx, (float)tf.ASM);
                                continue;
                            }
                            if (this.outputEnergy.booleanValue() && tileData.type.equals((Object)GLCM_TYPES.Energy)) {
                                tileData.dataBuffer.setElemFloatAt(idx, (float)tf.Energy);
                                continue;
                            }
                            if (this.outputMAX.booleanValue() && tileData.type.equals((Object)GLCM_TYPES.MAX)) {
                                tileData.dataBuffer.setElemFloatAt(idx, (float)tf.MAX);
                                continue;
                            }
                            if (this.outputEntropy.booleanValue() && tileData.type.equals((Object)GLCM_TYPES.Entropy)) {
                                tileData.dataBuffer.setElemFloatAt(idx, (float)tf.Entropy);
                                continue;
                            }
                            if (this.outputMean.booleanValue() && tileData.type.equals((Object)GLCM_TYPES.GLCMMean)) {
                                tileData.dataBuffer.setElemFloatAt(idx, (float)tf.GLCMMean);
                                continue;
                            }
                            if (this.outputVariance.booleanValue() && tileData.type.equals((Object)GLCM_TYPES.GLCMVariance)) {
                                tileData.dataBuffer.setElemFloatAt(idx, (float)tf.GLCMVariance);
                                continue;
                            }
                            if (!this.outputCorrelation.booleanValue() || !tileData.type.equals((Object)GLCM_TYPES.GLCMCorrelation)) continue;
                            tileData.dataBuffer.setElemFloatAt(idx, (float)tf.GLCMCorrelation);
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private Rectangle getSourceTileRectangle(int x0, int y0, int w, int h) {
        int sx0 = x0;
        int sy0 = y0;
        int sw = w;
        int sh = h;
        if (x0 >= this.halfWindowSize) {
            sx0 -= this.halfWindowSize;
            sw += this.halfWindowSize;
        }
        if (y0 >= this.halfWindowSize) {
            sy0 -= this.halfWindowSize;
            sh += this.halfWindowSize;
        }
        if (x0 + w + this.halfWindowSize <= this.sourceImageWidth) {
            sw += this.halfWindowSize;
        }
        if (y0 + h + this.halfWindowSize <= this.sourceImageHeight) {
            sh += this.halfWindowSize;
        }
        return new Rectangle(sx0, sy0, sw, sh);
    }

    private GLCMElem[] computeGLCM(int tx, int ty, Tile sourceTile, ProductData srcData, double noDataValue) {
        int i;
        int xx;
        int x;
        int yy;
        int y;
        int x0 = Math.max(tx - this.halfWindowSize, 0);
        int y0 = Math.max(ty - this.halfWindowSize, 0);
        int w = Math.min(tx + this.halfWindowSize, this.sourceImageWidth - 1) - x0 + 1;
        int h = Math.min(ty + this.halfWindowSize, this.sourceImageHeight - 1) - y0 + 1;
        int xMax = x0 + w;
        int yMax = y0 + h;
        int[][] quantizedImage = this.computeQuantizedImage(x0, y0, w, h, sourceTile, srcData, noDataValue);
        double[][] GLCM = new double[this.numQuantLevels][this.numQuantLevels];
        int counter = 0;
        if (this.computeGLCPWithAllAngles) {
            for (y = y0; y < yMax; ++y) {
                yy = y - y0;
                for (x = x0; x < xMax; ++x) {
                    xx = x - x0;
                    i = quantizedImage[yy][xx];
                    if (i < 0) continue;
                    for (int angle = 0; angle <= 135; angle += 45) {
                        int j;
                        int dY;
                        int dX;
                        switch (angle) {
                            case 0: {
                                dX = this.displacement;
                                dY = 0;
                                break;
                            }
                            case 45: {
                                dX = -this.displacement;
                                dY = this.displacement;
                                break;
                            }
                            case 90: {
                                dX = 0;
                                dY = this.displacement;
                                break;
                            }
                            case 135: {
                                dX = this.displacement;
                                dY = this.displacement;
                                break;
                            }
                            default: {
                                throw new OperatorException("Unknown angle: " + angle);
                            }
                        }
                        if (y + dY < y0 || y + dY >= yMax || x + dX < x0 || x + dX >= xMax || (j = quantizedImage[yy + dY][xx + dX]) < 0) continue;
                        double[] dArray = GLCM[i];
                        int n = j;
                        dArray[n] = dArray[n] + 1.0;
                        double[] dArray2 = GLCM[j];
                        int n2 = i;
                        dArray2[n2] = dArray2[n2] + 1.0;
                        ++counter;
                    }
                }
            }
        } else {
            for (y = y0; y < yMax; ++y) {
                yy = y - y0;
                for (x = x0; x < xMax; ++x) {
                    int j;
                    xx = x - x0;
                    i = quantizedImage[yy][xx];
                    if (i < 0 || y + this.displacementY < y0 || y + this.displacementY >= yMax || x + this.displacementX < x0 || x + this.displacementX >= xMax || (j = quantizedImage[yy + this.displacementY][xx + this.displacementX]) < 0) continue;
                    double[] dArray = GLCM[i];
                    int n = j;
                    dArray[n] = dArray[n] + 1.0;
                    double[] dArray3 = GLCM[j];
                    int n3 = i;
                    dArray3[n3] = dArray3[n3] + 1.0;
                    ++counter;
                }
            }
        }
        ArrayList<GLCMElem> GLCMElemList = new ArrayList<GLCMElem>();
        if (counter > 0) {
            for (int i2 = 0; i2 < this.numQuantLevels; ++i2) {
                for (int j = 0; j < this.numQuantLevels; ++j) {
                    if (!(GLCM[i2][j] > 0.0)) continue;
                    GLCMElemList.add(new GLCMElem(i2, j, GLCM[i2][j] / (double)counter));
                }
            }
        }
        return GLCMElemList.toArray(new GLCMElem[GLCMElemList.size()]);
    }

    private int[][] computeQuantizedImage(int x0, int y0, int w, int h, Tile sourceTile, ProductData srcData, double noDataValue) {
        int[][] data = new int[h][w];
        int maxX = x0 + w;
        int maxY = y0 + h;
        if (this.useProbabilisticQuantizer) {
            for (int y = y0; y < maxY; ++y) {
                int yy = y - y0;
                for (int x = x0; x < maxX; ++x) {
                    int xx = x - x0;
                    double v = srcData.getElemDoubleAt(sourceTile.getDataBufferIndex(x, y));
                    data[yy][xx] = Double.isNaN(v) || v == noDataValue ? -1 : this.probQuantizer(v);
                }
            }
        } else {
            for (int y = y0; y < maxY; ++y) {
                int yy = y - y0;
                for (int x = x0; x < maxX; ++x) {
                    int xx = x - x0;
                    double v = srcData.getElemDoubleAt(sourceTile.getDataBufferIndex(x, y));
                    data[yy][xx] = Double.isNaN(v) || v == noDataValue ? -1 : this.equalDisQuantizer(v);
                }
            }
        }
        return data;
    }

    private TextureFeatures computeTextureFeatures(GLCMElem[] GLCMElemList) {
        double Contrast = 0.0;
        double Dissimilarity = 0.0;
        double Homogeneity = 0.0;
        double ASM = 0.0;
        double Energy = 0.0;
        double MAX = 0.0;
        double Entropy = 0.0;
        double GLCMMeanX = 0.0;
        double GLCMMeanY = 0.0;
        double GLCMMean = 0.0;
        double GLCMVariance = 0.0;
        boolean doContrast = this.outputContrast;
        boolean doDissimilarity = this.outputDissimilarity;
        boolean doHomogeneity = this.outputHomogeneity;
        boolean doASM = this.outputASM != false || this.outputEnergy != false;
        boolean doEntropy = this.outputEntropy;
        for (GLCMElem e : GLCMElemList) {
            int ij = e.row - e.col;
            double GLCMval = e.prob;
            if (doContrast) {
                Contrast += GLCMval * (double)ij * (double)ij;
            }
            if (doDissimilarity) {
                Dissimilarity += GLCMval * (double)Math.abs(ij);
            }
            if (doHomogeneity) {
                Homogeneity += GLCMval / (double)(1 + ij * ij);
            }
            if (doASM) {
                ASM += GLCMval * GLCMval;
            }
            if (MAX < GLCMval) {
                MAX = GLCMval;
            }
            if (doEntropy) {
                Entropy += -GLCMval * Math.log(GLCMval + 1.0E-15);
            }
            GLCMMeanY += GLCMval * (double)e.row;
            GLCMMeanX += GLCMval * (double)e.col;
        }
        if (doASM) {
            Energy = Math.sqrt(ASM);
        }
        if (this.outputMean.booleanValue()) {
            GLCMMean = (GLCMMeanX + GLCMMeanY) / 2.0;
        }
        double GLCMVarianceX = 0.0;
        double GLCMVarianceY = 0.0;
        double GLCMCorrelation = 0.0;
        if (this.outputVariance.booleanValue() || this.outputCorrelation.booleanValue()) {
            for (GLCMElem e : GLCMElemList) {
                GLCMVarianceX += e.prob * ((double)e.col - GLCMMeanX) * ((double)e.col - GLCMMeanX);
                GLCMVarianceY += e.prob * ((double)e.row - GLCMMeanY) * ((double)e.row - GLCMMeanY);
            }
            if (this.outputVariance.booleanValue()) {
                GLCMVariance = (GLCMVarianceX + GLCMVarianceY) / 2.0;
            }
            if (this.outputCorrelation.booleanValue()) {
                double sqrtOfGLCMVariance = Math.sqrt(GLCMVarianceX * GLCMVarianceY);
                for (GLCMElem e : GLCMElemList) {
                    GLCMCorrelation += e.prob * ((double)e.row - GLCMMeanY) * ((double)e.col - GLCMMeanX) / sqrtOfGLCMVariance;
                }
            }
        }
        return new TextureFeatures(Contrast, Dissimilarity, Homogeneity, ASM, Energy, MAX, Entropy, GLCMMean, GLCMVariance, GLCMCorrelation);
    }

    private int probQuantizer(double v) {
        if (v < this.newBinLowValues[0]) {
            return 0;
        }
        if (v >= this.newBinLowValues[this.numQuantLevels]) {
            return this.numQuantLevels - 1;
        }
        int low = 0;
        int high = this.numQuantLevels;
        int mid = -1;
        while (!(low >= high || v >= this.newBinLowValues[mid = (low + high) / 2] && v < this.newBinLowValues[mid + 1])) {
            if (v < this.newBinLowValues[mid]) {
                high = mid;
                continue;
            }
            low = mid;
        }
        return mid;
    }

    private int equalDisQuantizer(double v) {
        return Math.min((int)((v - this.bandMin) / this.delta), this.numQuantLevels - 1);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(GLCMOp.class);
        }
    }

    private static class GLCMElem {
        public final int row;
        public final int col;
        public final double prob;

        GLCMElem(int row, int col, double prob) {
            this.row = row;
            this.col = col;
            this.prob = prob;
        }
    }

    private static class TextureFeatures {
        public double Contrast;
        public double Dissimilarity;
        public double Homogeneity;
        public double ASM;
        public double Energy;
        public double MAX;
        public double Entropy;
        public double GLCMMean;
        public double GLCMVariance;
        public double GLCMCorrelation;

        TextureFeatures(double Contrast, double Dissimilarity, double Homogeneity, double ASM, double Energy, double MAX, double Entropy, double GLCMMean, double GLCMVariance, double GLCMCorrelation) {
            this.Contrast = Contrast;
            this.Dissimilarity = Dissimilarity;
            this.Homogeneity = Homogeneity;
            this.ASM = ASM;
            this.Energy = Energy;
            this.MAX = MAX;
            this.Entropy = Entropy;
            this.GLCMMean = GLCMMean;
            this.GLCMVariance = GLCMVariance;
            this.GLCMCorrelation = GLCMCorrelation;
        }
    }

    private static class TileData {
        final Tile tile;
        final ProductData dataBuffer;
        final String bandName;
        final GLCM_TYPES type;

        public TileData(Tile tile, String bandName) {
            this.tile = tile;
            this.dataBuffer = tile.getDataBuffer();
            this.bandName = bandName;
            this.type = bandName.endsWith(GLCM_TYPES.Contrast.toString()) ? GLCM_TYPES.Contrast : (bandName.endsWith(GLCM_TYPES.Dissimilarity.toString()) ? GLCM_TYPES.Dissimilarity : (bandName.endsWith(GLCM_TYPES.Homogeneity.toString()) ? GLCM_TYPES.Homogeneity : (bandName.endsWith(GLCM_TYPES.ASM.toString()) ? GLCM_TYPES.ASM : (bandName.endsWith(GLCM_TYPES.Energy.toString()) ? GLCM_TYPES.Energy : (bandName.endsWith(GLCM_TYPES.MAX.toString()) ? GLCM_TYPES.MAX : (bandName.endsWith(GLCM_TYPES.Entropy.toString()) ? GLCM_TYPES.Entropy : (bandName.endsWith(GLCM_TYPES.GLCMMean.toString()) ? GLCM_TYPES.GLCMMean : (bandName.endsWith(GLCM_TYPES.GLCMVariance.toString()) ? GLCM_TYPES.GLCMVariance : (bandName.endsWith(GLCM_TYPES.GLCMCorrelation.toString()) ? GLCM_TYPES.GLCMCorrelation : GLCM_TYPES.Unknown)))))))));
        }
    }

    private static class SrcInfo {
        public Tile sourceTile;
        public ProductData srcData;
        public float noDataValue;
        public TextureFeatures tfNoData;
        public TileData[] tileDataList;

        private SrcInfo() {
        }
    }

    static enum GLCM_TYPES {
        Contrast,
        Dissimilarity,
        Homogeneity,
        ASM,
        Energy,
        MAX,
        Entropy,
        GLCMMean,
        GLCMVariance,
        GLCMCorrelation,
        Unknown;

    }
}

