/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.fex.gpf.oceantools;

import Jama.Matrix;
import com.bc.ceres.core.ProgressMonitor;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferDouble;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.operator.MedianFilterDescriptor;
import javax.media.jai.operator.MedianFilterShape;
import org.apache.commons.math3.util.FastMath;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.dataop.downloadable.XMLSupport;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.Unit;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.util.ResourceUtils;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

@OperatorMetadata(alias="Wind-Field-Estimation", category="Radar/Feature Extraction/Ocean Tools", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2015 by Array Systems Computing Inc.", description="Estimate wind speed and direction")
public class WindFieldEstimationOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct = null;
    @Parameter(description="The list of source bands.", alias="sourceBands", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] sourceBandNames = null;
    @Parameter(description="Window size", defaultValue="20.0", label="Window Size (km)")
    private double windowSizeInKm = 20.0;
    private String mission = null;
    private int windowSize = 0;
    private int halfWindowSize = 0;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private double rangeSpacing = 0.0;
    private double azimuthSpacing = 0.0;
    private TiePointGrid latitudeTPG = null;
    private TiePointGrid longitudeTPG = null;
    private TiePointGrid incidenceAngle = null;
    private MetadataElement absRoot = null;
    private File windFieldReportFile = null;
    private boolean windFieldEstimated = false;
    private final HashMap<String, List<WindFieldRecord>> bandWindFieldRecord = new HashMap();

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfCalibrated(true);
            validator.checkIfTOPSARBurstProduct(false);
            this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            this.getMission();
            this.checkCalibrationFlag();
            this.getPixelSpacing();
            this.computeWindowSize();
            this.getSourceImageDimension();
            this.getTiePointGrid();
            this.setTargetReportFilePath();
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void getMission() {
        this.mission = this.absRoot.getAttributeString("MISSION");
        if (!(this.mission.equals("ERS") || this.mission.equals("ENVISAT") || this.mission.equals("ERS1") || this.mission.equals("ERS2") || this.mission.contains("SENTINEL-1") || this.mission.contains("RS2"))) {
            throw new OperatorException("Currently only C-Band SAR products are supported");
        }
    }

    private void checkCalibrationFlag() throws Exception {
        if (!AbstractMetadata.getAttributeBoolean((MetadataElement)this.absRoot, (String)"abs_calibration_flag")) {
            throw new OperatorException("The product must be calibrated first.");
        }
    }

    private void getPixelSpacing() throws Exception {
        this.rangeSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)this.absRoot, (String)"range_spacing");
        this.azimuthSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)this.absRoot, (String)"azimuth_spacing");
    }

    private void computeWindowSize() {
        this.windowSize = (int)(this.windowSizeInKm * 1000.0 / Math.min(this.rangeSpacing, this.azimuthSpacing));
        this.halfWindowSize = this.windowSize / 2;
    }

    private void getSourceImageDimension() {
        this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
    }

    private void getTiePointGrid() {
        this.latitudeTPG = OperatorUtils.getLatitude((Product)this.sourceProduct);
        this.longitudeTPG = OperatorUtils.getLongitude((Product)this.sourceProduct);
        this.incidenceAngle = OperatorUtils.getIncidenceAngle((Product)this.sourceProduct);
    }

    private void setTargetReportFilePath() {
        String fileName = this.sourceProduct.getName() + "_wind_field_report.xml";
        this.windFieldReportFile = new File(ResourceUtils.getReportFolder(), fileName);
    }

    void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        this.addSelectedBands();
        this.updateTargetProductMetadata();
    }

    private void addSelectedBands() throws OperatorException {
        Band[] sourceBands;
        for (Band srcBand : sourceBands = OperatorUtils.getSourceBands((Product)this.sourceProduct, (String[])this.sourceBandNames, (boolean)false)) {
            String srcBandName = srcBand.getName();
            String unit = srcBand.getUnit();
            if (unit == null) {
                throw new OperatorException("band " + srcBandName + " requires a unit");
            }
            Band targetBand = new Band(srcBandName, srcBand.getDataType(), this.sourceImageWidth, this.sourceImageHeight);
            targetBand.setUnit(unit);
            this.targetProduct.addBand(targetBand);
            this.bandWindFieldRecord.put(srcBandName, new ArrayList());
        }
    }

    private void updateTargetProductMetadata() {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        absTgt.setAttributeString("wind_field_report_file", this.windFieldReportFile.getAbsolutePath());
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle targetTileRectangle = targetTile.getRectangle();
        int tx0 = targetTileRectangle.x;
        int ty0 = targetTileRectangle.y;
        int tw = targetTileRectangle.width;
        int th = targetTileRectangle.height;
        String targetBandName = targetBand.getName();
        List<WindFieldRecord> windFieldRecordList = this.bandWindFieldRecord.get(targetBandName);
        Band sourceBand = this.sourceProduct.getBand(targetBandName);
        double noDataValue = sourceBand.getNoDataValue();
        String pol = OperatorUtils.getBandPolarization((String)targetBandName, (MetadataElement)this.absRoot);
        if (this.mission.equals("ENVISAT") && pol != null && !pol.contains("hh") && !pol.contains("vv")) {
            throw new OperatorException("Polarization " + pol + " is not supported. Please select HH or VV.");
        }
        Unit.UnitType bandUnit = Unit.getUnitType((Band)sourceBand);
        if (bandUnit != Unit.UnitType.INTENSITY && bandUnit != Unit.UnitType.INTENSITY_DB) {
            throw new OperatorException("Please select calibrated amplitude or intensity band for wind field estimation");
        }
        targetTile.setRawSamples(this.getSourceTile((RasterDataNode)sourceBand, targetTile.getRectangle()).getRawSamples());
        boolean normlizeSigma = this.mission.equals("ENVISAT") && pol.contains("hh");
        for (int xStart = this.halfWindowSize; xStart < tx0; xStart += this.windowSize) {
        }
        for (int yStart = this.halfWindowSize; yStart < ty0; yStart += this.windowSize) {
        }
        int maxY = ty0 + th;
        int maxX = tx0 + tw;
        int halfWindowArea = this.windowSize * this.windowSize / 2;
        int arrowSize = this.halfWindowSize * 2 / 3;
        for (int y = yStart; y < maxY; y += this.windowSize) {
            for (int x = xStart; x < maxX; x += this.windowSize) {
                Rectangle sourceTileRectangle = this.getSourceRectangle(x, y);
                if (sourceTileRectangle == null) continue;
                double lat = this.latitudeTPG.getPixelDouble(x, y);
                double lon = this.longitudeTPG.getPixelDouble(x, y);
                double theta = this.incidenceAngle.getPixelDouble(x, y);
                Tile sourceTile = this.getSourceTile((RasterDataNode)sourceBand, sourceTileRectangle);
                int numLandPixels = this.getNumLandPixels(sourceTile, noDataValue);
                if (numLandPixels >= halfWindowArea) continue;
                double nrcs = WindFieldEstimationOp.getNormalizedRadarCrossSection(sourceTile, bandUnit, x, y, normlizeSigma, theta);
                double[] direction = new double[]{0.0, 0.0};
                double ratio = this.estimateWindDirection(sourceTile, numLandPixels, noDataValue, direction);
                double speed = WindFieldEstimationOp.estimateWindSpeed(nrcs, direction, theta);
                WindFieldRecord record = new WindFieldRecord(lat, lon, speed, (double)arrowSize * direction[0], (double)arrowSize * direction[1], ratio);
                windFieldRecordList.add(record);
            }
        }
        this.windFieldEstimated = true;
    }

    private Rectangle getSourceRectangle(int x, int y) {
        int x0 = x - this.halfWindowSize;
        int y0 = y - this.halfWindowSize;
        int w = this.windowSize;
        int h = this.windowSize;
        if (x0 < 0 || y0 < 0 || x0 + w > this.sourceImageWidth || y0 + h > this.sourceImageHeight) {
            return null;
        }
        return new Rectangle(x0, y0, w, h);
    }

    private int getNumLandPixels(Tile sourceTile, double noDataValue) {
        Rectangle sourceTileRectangle = sourceTile.getRectangle();
        int x0 = sourceTileRectangle.x;
        int y0 = sourceTileRectangle.y;
        int w = sourceTileRectangle.width;
        int h = sourceTileRectangle.height;
        if (w != this.windowSize || h != this.windowSize) {
            throw new OperatorException("Source tile size does not match window size.");
        }
        int maxY = y0 + this.windowSize;
        int maxX = x0 + this.windowSize;
        int numberOfLandPixels = 0;
        for (int y = y0; y < maxY; ++y) {
            for (int x = x0; x < maxX; ++x) {
                if (sourceTile.getDataBuffer().getElemDoubleAt(sourceTile.getDataBufferIndex(x, y)) != noDataValue) continue;
                ++numberOfLandPixels;
            }
        }
        return numberOfLandPixels;
    }

    private static double getNormalizedRadarCrossSection(Tile sourceTile, Unit.UnitType bandUnit, int x, int y, boolean normalizeSigma, double theta) {
        double sigma = sourceTile.getDataBuffer().getElemDoubleAt(sourceTile.getDataBufferIndex(x, y));
        if (bandUnit == Unit.UnitType.INTENSITY_DB) {
            sigma = FastMath.pow((double)10.0, (double)(sigma / 10.0));
        }
        if (normalizeSigma) {
            double alpha = 1.0;
            double tanTheta = FastMath.tan((double)(theta * (Math.PI / 180)));
            sigma *= FastMath.pow((double)((1.0 + 2.0 * tanTheta * tanTheta) / (1.0 + 1.0 * tanTheta * tanTheta)), (double)2.0);
        }
        return sigma;
    }

    private double estimateWindDirection(Tile sourceTile, int numLandPixels, double noDataValue, double[] direction) {
        double[][] imagette = new double[this.windowSize][this.windowSize];
        this.getImagette(sourceTile, numLandPixels, noDataValue, imagette);
        double[][] dcRemovedImage = new double[this.windowSize][this.windowSize];
        this.removeDCComponent(imagette, dcRemovedImage);
        int fftSize = this.windowSize * 2 / 3;
        if (fftSize % 2 == 0) {
            ++fftSize;
        }
        double[][] spec = new double[fftSize][fftSize];
        this.computeSpectrum(dcRemovedImage, fftSize, spec);
        double delta_k = 1.0 / (this.windowSizeInKm * 1000.0 * 2.0 / 3.0);
        int n3 = Math.min((int)(Math.PI * 2 / (2500.0 * delta_k)), fftSize / 2);
        RenderedImage annulusAppliedSpec = WindFieldEstimationOp.applyAnnulusToSpec(spec, fftSize, n3, delta_k);
        RenderedImage filteredImage = WindFieldEstimationOp.medianFilteringSpec(annulusAppliedSpec);
        double[][] array = new double[2 * n3 + 1][2 * n3 + 1];
        double peakValue = WindFieldEstimationOp.getPeakSpectrumValue(filteredImage, array, n3);
        return WindFieldEstimationOp.getDirection(array, peakValue, n3, direction);
    }

    private void getImagette(Tile sourceTile, int numLandPixels, double noDataValue, double[][] imagette) {
        Rectangle sourceTileRectangle = sourceTile.getRectangle();
        int x0 = sourceTileRectangle.x;
        int y0 = sourceTileRectangle.y;
        int w = sourceTileRectangle.width;
        int h = sourceTileRectangle.height;
        if (w != this.windowSize || h != this.windowSize) {
            throw new OperatorException("Source tile size does not match window size.");
        }
        int maxY = y0 + this.windowSize;
        int maxX = x0 + this.windowSize;
        if (numLandPixels > 0) {
            double v;
            int x;
            int y;
            double mean = 0.0;
            for (y = y0; y < maxY; ++y) {
                for (x = x0; x < maxX; ++x) {
                    v = sourceTile.getDataBuffer().getElemDoubleAt(sourceTile.getDataBufferIndex(x, y));
                    if (v == noDataValue) continue;
                    mean += v;
                }
            }
            mean /= (double)(this.windowSize * this.windowSize - numLandPixels);
            for (y = y0; y < maxY; ++y) {
                for (x = x0; x < maxX; ++x) {
                    v = sourceTile.getDataBuffer().getElemDoubleAt(sourceTile.getDataBufferIndex(x, y));
                    imagette[y - y0][x - x0] = v == noDataValue ? mean : v;
                }
            }
        } else {
            for (int y = y0; y < maxY; ++y) {
                for (int x = x0; x < maxX; ++x) {
                    imagette[y - y0][x - x0] = sourceTile.getDataBuffer().getElemDoubleAt(sourceTile.getDataBufferIndex(x, y));
                }
            }
        }
    }

    private void removeDCComponent(double[][] imagette, double[][] dcRemovedImage) {
        int filter_size = 11;
        int half_filter_size = 5;
        for (int r = 0; r < this.windowSize; ++r) {
            int rMin = Math.max(r - 5, 0);
            int rMax = Math.min(r + 5, this.windowSize - 1);
            for (int c = 0; c < this.windowSize; ++c) {
                int cMin = Math.max(c - 5, 0);
                int cMax = Math.min(c + 5, this.windowSize - 1);
                dcRemovedImage[r][c] = imagette[r][c] / WindFieldEstimationOp.getMean(imagette, rMin, rMax, cMin, cMax);
            }
        }
    }

    private static double getMean(double[][] imagette, int rMin, int rMax, int cMin, int cMax) {
        double mean = 0.0;
        for (int r = rMin; r <= rMax; ++r) {
            for (int c = cMin; c <= cMax; ++c) {
                mean += imagette[r][c];
            }
        }
        return mean / (double)((rMax - rMin + 1) * (cMax - cMin + 1));
    }

    private void computeSpectrum(double[][] srcImage, int fftSize, double[][] spec) {
        double[][] F1 = new double[fftSize][fftSize];
        double[][] F2 = new double[fftSize][fftSize];
        double[][] F3 = new double[fftSize][fftSize];
        double[][] F4 = new double[fftSize][fftSize];
        WindFieldEstimationOp.perform2DFFT(srcImage, 0, fftSize - 1, 0, fftSize - 1, F1);
        WindFieldEstimationOp.perform2DFFT(srcImage, 0, fftSize - 1, this.windowSize - fftSize, this.windowSize - 1, F2);
        WindFieldEstimationOp.perform2DFFT(srcImage, this.windowSize - fftSize, this.windowSize - 1, 0, fftSize - 1, F3);
        WindFieldEstimationOp.perform2DFFT(srcImage, this.windowSize - fftSize, this.windowSize - 1, this.windowSize - fftSize, this.windowSize - 1, F4);
        for (int r = 0; r < fftSize; ++r) {
            for (int c = 0; c < fftSize; ++c) {
                spec[r][c] = (F1[r][c] + F2[r][c] + F3[r][c] + F4[r][c]) / 4.0;
            }
        }
    }

    private static void perform2DFFT(double[][] srcImage, int xMin, int xMax, int yMin, int yMax, double[][] spec) {
        int x;
        int rowFFTSize = xMax - xMin + 1;
        int colFFTSize = yMax - yMin + 1;
        DoubleFFT_1D row_fft = new DoubleFFT_1D(rowFFTSize);
        double[][] complexDataI = new double[colFFTSize][rowFFTSize];
        double[][] complexDataQ = new double[colFFTSize][rowFFTSize];
        double[] rowArray = new double[2 * rowFFTSize];
        for (int y = yMin; y <= yMax; ++y) {
            int k = 0;
            for (x = xMin; x <= xMax; ++x) {
                rowArray[k++] = srcImage[y][x];
                rowArray[k++] = 0.0;
            }
            row_fft.complexForward(rowArray);
            for (int c = 0; c < rowFFTSize; ++c) {
                complexDataI[y - yMin][c] = rowArray[c + c];
                complexDataQ[y - yMin][c] = rowArray[c + c + 1];
            }
        }
        DoubleFFT_1D col_fft = new DoubleFFT_1D(colFFTSize);
        double[] colArray = new double[2 * colFFTSize];
        for (x = xMin; x <= xMax; ++x) {
            int k = 0;
            for (int y = yMin; y <= yMax; ++y) {
                colArray[k++] = complexDataI[y - yMin][x - xMin];
                colArray[k++] = complexDataQ[y - yMin][x - xMin];
            }
            col_fft.complexForward(colArray);
            for (int r = 0; r < colFFTSize; ++r) {
                complexDataI[r][x - xMin] = colArray[r + r];
                complexDataQ[r][x - xMin] = colArray[r + r + 1];
            }
        }
        int secondHalfColFFTSize = colFFTSize / 2;
        int firstHalfColFFTSize = colFFTSize - secondHalfColFFTSize;
        int secondHalfRowFFTSize = rowFFTSize / 2;
        int firstHalfRowFFTSize = rowFFTSize - secondHalfRowFFTSize;
        for (int y = yMin; y <= yMax; ++y) {
            int r = y - yMin;
            int rr = r < firstHalfColFFTSize ? r + secondHalfColFFTSize : r - firstHalfColFFTSize;
            for (int x2 = xMin; x2 <= xMax; ++x2) {
                int c = x2 - xMin;
                int cc = c < firstHalfRowFFTSize ? c + secondHalfRowFFTSize : c - firstHalfRowFFTSize;
                spec[rr][cc] = complexDataI[r][c] * complexDataI[r][c] + complexDataQ[r][c] * complexDataQ[r][c];
            }
        }
    }

    private static RenderedImage createRenderedImage(double[] array, int width, int height) {
        SampleModel sampleModel = RasterFactory.createBandedSampleModel((int)5, (int)width, (int)height, (int)1);
        ColorModel colourModel = PlanarImage.createColorModel((SampleModel)sampleModel);
        DataBufferDouble dataBuffer = new DataBufferDouble(array, array.length);
        WritableRaster raster = RasterFactory.createWritableRaster((SampleModel)sampleModel, (DataBuffer)dataBuffer, (Point)new Point(0, 0));
        return new BufferedImage(colourModel, raster, false, new Hashtable());
    }

    private static RenderedImage applyAnnulusToSpec(double[][] spec, int fftSize, int n3, double delta_k) {
        int n15 = (int)(Math.PI * 2 / (15000.0 * delta_k));
        int halfFFTSize = fftSize / 2;
        if (n15 >= halfFFTSize) {
            n15 = 1;
        }
        double[] array = new double[(2 * n3 + 1) * (2 * n3 + 1)];
        int k = 0;
        for (int r = halfFFTSize - n3; r < halfFFTSize + n3 + 1; ++r) {
            for (int c = halfFFTSize - n3; c < halfFFTSize + n3 + 1; ++c) {
                array[k++] = r >= halfFFTSize - n15 && r <= halfFFTSize + n15 && c >= halfFFTSize - n15 && c <= halfFFTSize + n15 ? 0.0 : spec[r][c];
            }
        }
        return WindFieldEstimationOp.createRenderedImage(array, 2 * n3 + 1, 2 * n3 + 1);
    }

    private static RenderedImage medianFilteringSpec(RenderedImage annulusAppliedSpec) {
        int size = 3;
        MedianFilterShape shape = MedianFilterDescriptor.MEDIAN_MASK_SQUARE;
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(annulusAppliedSpec);
        pb.add(shape);
        pb.add(3);
        return JAI.create((String)"medianfilter", (ParameterBlock)pb);
    }

    private static double getPeakSpectrumValue(RenderedImage filteredImage, double[][] array, int n3) {
        Raster data = filteredImage.getData();
        double peakValue = 0.0;
        int length = 2 * n3 + 1;
        for (int y = 0; y < length; ++y) {
            for (int x = 0; x < length; ++x) {
                array[y][x] = data.getSampleDouble(x, y, 0);
                if (!(peakValue < array[y][x])) continue;
                peakValue = array[y][x];
            }
        }
        return peakValue;
    }

    private static double getDirection(double[][] array, double peakValue, int n3, double[] direction) {
        double m00 = 0.0;
        double m01 = 0.0;
        double m02 = 0.0;
        double m10 = 0.0;
        double m11 = 0.0;
        double m12 = 0.0;
        double m20 = 0.0;
        double m21 = 0.0;
        double m22 = 0.0;
        double s0 = 0.0;
        double s1 = 0.0;
        double s2 = 0.0;
        int length = 2 * n3 + 1;
        for (int y = 0; y < length; ++y) {
            int yy = y - n3;
            for (int x = 0; x < length; ++x) {
                int xx = x - n3;
                double v = array[y][x] - peakValue;
                m00 += (double)(xx * xx * xx * xx);
                m01 += (double)(xx * xx * yy * yy);
                m02 += (double)(xx * xx * xx * yy);
                m11 += (double)(yy * yy * yy * yy);
                m12 += (double)(xx * yy * yy * yy);
                s0 += (double)(xx * xx) * v;
                s1 += (double)(yy * yy) * v;
                s2 += (double)(xx * yy) * v;
            }
        }
        m10 = m01;
        m20 = m02;
        m21 = m12;
        m22 = m01;
        Matrix M = new Matrix(3, 3);
        M.set(0, 0, m00);
        M.set(0, 1, m01);
        M.set(0, 2, m02);
        M.set(1, 0, m10);
        M.set(1, 1, m11);
        M.set(1, 2, m12);
        M.set(2, 0, m20);
        M.set(2, 1, m21);
        M.set(2, 2, m22);
        Matrix s = new Matrix(3, 1);
        s.set(0, 0, s0);
        s.set(1, 0, s1);
        s.set(2, 0, s2);
        Matrix c = M.solve(s);
        double c0 = c.get(0, 0);
        double c1 = c.get(1, 0);
        double c2 = -c.get(2, 0);
        double d = Math.sqrt((c0 - c1) * (c0 - c1) + c2 * c2);
        double d2 = 2.0 * d;
        double tmp = Math.abs(c0 - c1);
        double cos_theta_2 = (d + tmp) / d2;
        double sin_theta_2 = (d - tmp) / d2;
        double sin_cos = c2 * tmp / ((c0 - c1) * d2);
        double a = (c0 * (d + tmp) + c1 * (d - tmp) + c2 * c2 * tmp / (c0 - c1)) / d2;
        double b = (c0 * (d - tmp) + c1 * (d + tmp) - c2 * c2 * tmp / (c0 - c1)) / d2;
        if (cos_theta_2 == 0.0) {
            if (Math.abs(a) > Math.abs(b)) {
                direction[0] = 1.0;
                direction[1] = 0.0;
            } else {
                direction[0] = 0.0;
                direction[1] = 1.0;
            }
        } else if (sin_theta_2 == 0.0) {
            if (Math.abs(a) > Math.abs(b)) {
                direction[0] = 0.0;
                direction[1] = 1.0;
            } else {
                direction[0] = 1.0;
                direction[1] = 0.0;
            }
        } else {
            double k = sin_cos / Math.abs(sin_cos) * Math.sqrt(sin_theta_2 / cos_theta_2);
            if (k > 0.0) {
                if (Math.abs(a) > Math.abs(b)) {
                    direction[0] = -k / Math.sqrt(1.0 + k * k);
                    direction[1] = 1.0 / Math.sqrt(1.0 + k * k);
                } else {
                    direction[0] = 1.0 / Math.sqrt(1.0 + k * k);
                    direction[1] = k / Math.sqrt(1.0 + k * k);
                }
            } else if (Math.abs(a) > Math.abs(b)) {
                direction[0] = -k / Math.sqrt(1.0 + k * k);
                direction[1] = 1.0 / Math.sqrt(1.0 + k * k);
            } else {
                direction[0] = -1.0 / Math.sqrt(1.0 + k * k);
                direction[1] = -k / Math.sqrt(1.0 + k * k);
            }
        }
        tmp = direction[0];
        direction[0] = -direction[1];
        direction[1] = tmp;
        return Math.min(Math.abs(a), Math.abs(b)) / Math.max(Math.abs(a), Math.abs(b));
    }

    private static synchronized void dumpData(String title, double[][] data) {
        System.out.println();
        System.out.println(title + ";");
        int h = data.length;
        int w = data[0].length;
        for (double[] aData : data) {
            for (int c = 0; c < w; ++c) {
                System.out.print(aData[c] + ",");
            }
            System.out.println();
        }
        System.out.println();
    }

    private static double estimateWindSpeed(double nrcs, double[] direction, double theta) {
        double fi = Math.atan2(direction[1], direction[0]) * 57.29577951308232;
        double cosFI = FastMath.cos((double)(fi * (Math.PI / 180)));
        double[] err = new double[200];
        err[0] = Math.abs(nrcs - CMOD5.compute(0.1, cosFI, theta));
        double errMin = err[0];
        int errMinIndex = 0;
        for (int i = 1; i < 200; ++i) {
            double v = (double)(i + 1) * 0.1;
            err[i] = Math.abs(nrcs - CMOD5.compute(v, cosFI, theta));
            if (!(err[i] < errMin)) continue;
            errMin = err[i];
            errMinIndex = i;
        }
        return (double)(errMinIndex + 1) * 0.1;
    }

    public void dispose() {
        if (!this.windFieldEstimated) {
            return;
        }
        this.outputWindFieldInfoToFile();
    }

    private void outputWindFieldInfoToFile() throws OperatorException {
        Element root = new Element("Detection");
        Document doc = new Document(root);
        for (String bandName : this.bandWindFieldRecord.keySet()) {
            Element elem = new Element("windFieldEstimated");
            elem.setAttribute("bandName", bandName);
            List<WindFieldRecord> recordList = this.bandWindFieldRecord.get(bandName);
            for (WindFieldRecord rec : recordList) {
                Element subElem = new Element("windFieldInfo");
                subElem.setAttribute("lat", String.valueOf(rec.lat));
                subElem.setAttribute("lon", String.valueOf(rec.lon));
                subElem.setAttribute("speed", String.valueOf(rec.speed));
                subElem.setAttribute("dx", String.valueOf(rec.dx));
                subElem.setAttribute("dy", String.valueOf(rec.dy));
                subElem.setAttribute("ratio", String.valueOf(rec.ratio));
                elem.addContent((Content)subElem);
            }
            root.addContent((Content)elem);
        }
        XMLSupport.SaveXML((Document)doc, (String)this.windFieldReportFile.getAbsolutePath());
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(WindFieldEstimationOp.class);
        }
    }

    public static class WindFieldRecord {
        public final double lat;
        public final double lon;
        public final double speed;
        public final double dx;
        public final double dy;
        public final double ratio;

        public WindFieldRecord(double lat, double lon, double speed, double dx, double dy, double ratio) {
            this.lat = (double)Math.round(lat * 100.0) / 100.0;
            this.lon = (double)Math.round(lon * 100.0) / 100.0;
            this.speed = (double)Math.round(speed * 100.0) / 100.0;
            this.dx = (double)Math.round(dx * 100.0) / 100.0;
            this.dy = (double)Math.round(dy * 100.0) / 100.0;
            this.ratio = (double)Math.round(ratio * 100.0) / 100.0;
        }
    }

    private static class CMOD5 {
        private static final double c1 = -0.688;
        private static final double c15 = 0.007;
        private static final double c2 = -0.793;
        private static final double c16 = 0.33;
        private static final double c3 = 0.338;
        private static final double c17 = 0.012;
        private static final double c4 = -0.173;
        private static final double c18 = 22.0;
        private static final double c5 = 0.0;
        private static final double c19 = 1.95;
        private static final double c6 = 0.004;
        private static final double c20 = 3.0;
        private static final double c7 = 0.111;
        private static final double c21 = 8.39;
        private static final double c8 = 0.0162;
        private static final double c22 = -3.44;
        private static final double c9 = 6.34;
        private static final double c23 = 1.36;
        private static final double c10 = 2.57;
        private static final double c24 = 5.35;
        private static final double c11 = -2.18;
        private static final double c25 = 1.99;
        private static final double c12 = 0.4;
        private static final double c26 = 0.29;
        private static final double c13 = -0.6;
        private static final double c27 = 3.8;
        private static final double c14 = 0.045;
        private static final double c28 = 1.53;
        private static final double THETM = 40.0;
        private static final double THETHR = 25.0;
        private static final double ZPOW = 1.6;
        private static final double y0 = 1.95;
        private static final double n = 3.0;
        private static final double a = 1.6333333333333333;
        private static final double b = 1.0 / (3.0 * FastMath.pow((double)0.95, (double)2.0));

        private CMOD5() {
        }

        static double compute(double v, double cosFI, double incidenceAngle) {
            double x = (incidenceAngle - 40.0) / 25.0;
            double xx = x * x;
            double a0 = -0.688 + -0.793 * x + 0.338 * xx + -0.173 * x * xx;
            double a1 = 0.0 + 0.004 * x;
            double a2 = 0.111 + 0.0162 * x;
            double gamma = 6.34 + 2.57 * x + -2.18 * xx;
            double s0 = 0.4 + -0.6 * x;
            double s = a2 * v;
            double a3 = 1.0 / (1.0 + FastMath.exp((double)(-Math.max(s, s0))));
            if (s < s0) {
                a3 *= FastMath.pow((double)(s / s0), (double)(s0 * (1.0 - a3)));
            }
            double b0 = FastMath.pow((double)a3, (double)gamma) * FastMath.pow((double)10.0, (double)(a0 + a1 * v));
            double b1 = 0.007 * v * (0.5 + x - FastMath.tanh((double)(4.0 * (x + 0.33 + 0.012 * v))));
            b1 = (0.045 * (1.0 + x) - b1) / (FastMath.exp((double)(0.34 * (v - 22.0))) + 1.0);
            double v0 = 8.39 + -3.44 * x + 1.36 * xx;
            double d1 = 5.35 + 1.99 * x + 0.29 * xx;
            double d2 = 3.8 + 1.53 * x;
            double v2 = v / v0 + 1.0;
            if (v2 < 1.95) {
                v2 = 1.6333333333333333 + b * FastMath.pow((double)(v2 - 1.0), (double)3.0);
            }
            double b2 = (-d1 + d2 * v2) * FastMath.exp((double)(-v2));
            return b0 * FastMath.pow((double)(1.0 + b1 * cosFI + b2 * (2.0 * cosFI * cosFI - 1.0)), (double)1.6);
        }
    }
}

