/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.fex.gpf.oceantools;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.dataop.downloadable.XMLSupport;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;
import org.esa.snap.engine_utilities.util.ResourceUtils;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

@OperatorMetadata(alias="Object-Discrimination", category="Radar/Feature Extraction/Ocean Tools/Object Detection", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2015 by Array Systems Computing Inc.", description="Remove false alarms from the detected objects.")
public class ObjectDiscriminationOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct = null;
    @Parameter(description="Minimum target size", defaultValue="120.0", label="Minimum Target Size (m)")
    private double minTargetSizeInMeter = 120.0;
    @Parameter(description="Maximum target size", defaultValue="600.0", label="Maximum Target Size (m)")
    private double maxTargetSizeInMeter = 600.0;
    private boolean clusteringPerformed = false;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private double rangeSpacing = 0.0;
    private double azimuthSpacing = 0.0;
    private TiePointGrid latitude = null;
    private TiePointGrid longitude = null;
    private MetadataElement absRoot = null;
    private final transient Map<Band, Band> bandMap = new HashMap<Band, Band>(3);
    private final HashMap<String, List<ShipRecord>> bandClusterLists = new HashMap();
    private File targetReportFile = null;

    public void initialize() throws OperatorException {
        try {
            this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            this.getPixelSpacings();
            this.getSourceImageDimension();
            this.getTiePointGrid();
            this.setTargetReportFilePath();
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void getPixelSpacings() throws Exception {
        this.rangeSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)this.absRoot, (String)"range_spacing");
        this.azimuthSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)this.absRoot, (String)"azimuth_spacing");
    }

    private void getSourceImageDimension() {
        this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
    }

    private void getTiePointGrid() {
        this.latitude = OperatorUtils.getLatitude((Product)this.sourceProduct);
        this.longitude = OperatorUtils.getLongitude((Product)this.sourceProduct);
    }

    private void setTargetReportFilePath() {
        String fileName = this.sourceProduct.getName() + "_object_detection_report.xml";
        this.targetReportFile = new File(ResourceUtils.getReportFolder(), fileName);
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        this.addSelectedBands();
        this.updateTargetProductMetadata();
    }

    private void addSelectedBands() throws OperatorException {
        Band[] sourceBands;
        Band[] bands = this.sourceProduct.getBands();
        ArrayList<String> bandNameList = new ArrayList<String>(this.sourceProduct.getNumBands());
        for (Band band : bands) {
            bandNameList.add(band.getName());
        }
        String[] sourceBandNames = bandNameList.toArray(new String[bandNameList.size()]);
        for (Band srcBand : sourceBands = OperatorUtils.getSourceBands((Product)this.sourceProduct, (String[])sourceBandNames, (boolean)false)) {
            String srcBandName = srcBand.getName();
            if (srcBandName.contains("_ship_bit_msk")) continue;
            Band targetBand = new Band(srcBandName, srcBand.getDataType(), this.sourceImageWidth, this.sourceImageHeight);
            targetBand.setUnit(srcBand.getUnit());
            this.targetProduct.addBand(targetBand);
            this.bandClusterLists.put(srcBandName, new ArrayList());
            String bitMaskBandName = srcBandName + "_ship_bit_msk";
            Band bitMaskBand = this.sourceProduct.getBand(bitMaskBandName);
            if (bitMaskBand != null) {
                this.bandMap.put(srcBand, bitMaskBand);
                continue;
            }
            throw new OperatorException("No bit mask band found for band: " + srcBandName);
        }
    }

    private void updateTargetProductMetadata() {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        absTgt.setAttributeString("target_report_file", this.targetReportFile.getAbsolutePath());
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        try {
            Rectangle targetTileRectangle = targetTile.getRectangle();
            int tx0 = targetTileRectangle.x;
            int ty0 = targetTileRectangle.y;
            int tw = targetTileRectangle.width;
            int th = targetTileRectangle.height;
            ProductData trgData = targetTile.getDataBuffer();
            int x0 = Math.max(tx0 - 10, 0);
            int y0 = Math.max(ty0 - 10, 0);
            int w = Math.min(tw + 20, this.sourceImageWidth);
            int h = Math.min(th + 20, this.sourceImageHeight);
            Rectangle sourceTileRectangle = new Rectangle(x0, y0, w, h);
            Band sourceBand = this.sourceProduct.getBand(targetBand.getName());
            Tile sourceTile = this.getSourceTile((RasterDataNode)sourceBand, sourceTileRectangle);
            ProductData srcData = sourceTile.getDataBuffer();
            int[][] pixelsScanned = new int[h][w];
            List<ShipRecord> clusterList = this.bandClusterLists.get(targetBand.getName());
            Band bitMaskBand = this.bandMap.get(sourceBand);
            Tile bitMaskTile = this.getSourceTile((RasterDataNode)bitMaskBand, sourceTileRectangle);
            ProductData bitMaskData = bitMaskTile.getDataBuffer();
            TileIndex trgIndex = new TileIndex(targetTile);
            TileIndex srcIndex = new TileIndex(sourceTile);
            int maxy = ty0 + th;
            int maxx = tx0 + tw;
            for (int ty = ty0; ty < maxy; ++ty) {
                trgIndex.calculateStride(ty);
                srcIndex.calculateStride(ty);
                for (int tx = tx0; tx < maxx; ++tx) {
                    int srcIdx = srcIndex.getIndex(tx);
                    if (pixelsScanned[ty - y0][tx - x0] == 0 && bitMaskData.getElemIntAt(srcIdx) == 1) {
                        ArrayList<PixelPos> clusterPixels = new ArrayList<PixelPos>();
                        ObjectDiscriminationOp.clustering(tx, ty, x0, y0, w, h, bitMaskData, bitMaskTile, pixelsScanned, clusterPixels);
                        ShipRecord record = this.generateRecord(x0, y0, w, h, clusterPixels);
                        double size = Math.sqrt(record.length * record.length + record.width * record.width);
                        if (size >= this.minTargetSizeInMeter && size <= this.maxTargetSizeInMeter) {
                            ObjectDiscriminationOp.getClusterIntensity(clusterPixels, srcData, sourceTile, record);
                            clusterList.add(record);
                        }
                    }
                    trgData.setElemDoubleAt(trgIndex.getIndex(tx), srcData.getElemDoubleAt(srcIdx));
                }
            }
            this.clusteringPerformed = true;
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private static void clustering(int xc, int yc, int x0, int y0, int w, int h, ProductData bitMaskData, Tile bitMaskTile, int[][] pixelsScanned, List<PixelPos> clusterPixels) {
        pixelsScanned[yc - y0][xc - x0] = 1;
        clusterPixels.add(new PixelPos((double)xc, (double)yc));
        int[] x = new int[]{xc - 1, xc, xc + 1, xc - 1, xc + 1, xc - 1, xc, xc + 1};
        int[] y = new int[]{yc - 1, yc - 1, yc - 1, yc, yc, yc + 1, yc + 1, yc + 1};
        for (int i = 0; i < 8; ++i) {
            if (x[i] < x0 || x[i] >= x0 + w || y[i] < y0 || y[i] >= y0 + h || pixelsScanned[y[i] - y0][x[i] - x0] != 0 || bitMaskData.getElemIntAt(bitMaskTile.getDataBufferIndex(x[i], y[i])) != 1) continue;
            ObjectDiscriminationOp.clustering(x[i], y[i], x0, y0, w, h, bitMaskData, bitMaskTile, pixelsScanned, clusterPixels);
        }
    }

    private ShipRecord generateRecord(int x0, int y0, int w, int h, List<PixelPos> clusterPixels) {
        int xMin = x0 + w - 1;
        int xMax = x0;
        int yMin = y0 + h - 1;
        int yMax = y0;
        for (PixelPos pixel : clusterPixels) {
            if (pixel.x < (double)xMin) {
                xMin = (int)pixel.x;
            }
            if (pixel.x > (double)xMax) {
                xMax = (int)pixel.x;
            }
            if (pixel.y < (double)yMin) {
                yMin = (int)pixel.y;
            }
            if (!(pixel.y > (double)yMax)) continue;
            yMax = (int)pixel.y;
        }
        double xMid = (double)(xMin + xMax) / 2.0;
        double yMid = (double)(yMin + yMax) / 2.0;
        double lat = this.latitude.getPixelDouble(xMid, yMid);
        double lon = this.longitude.getPixelDouble(xMid, yMid);
        double width = (double)(xMax - xMin + 1) * this.rangeSpacing;
        double length = (double)(yMax - yMin + 1) * this.azimuthSpacing;
        return new ShipRecord(lat, lon, width, length, 0.0);
    }

    private static void getClusterIntensity(List<PixelPos> clusterPixels, ProductData srcData, Tile sourceTile, ShipRecord record) {
        double totalIntensity = 0.0;
        for (PixelPos pixel : clusterPixels) {
            totalIntensity += srcData.getElemDoubleAt(sourceTile.getDataBufferIndex((int)pixel.x, (int)pixel.y));
        }
        record.intensity = totalIntensity;
    }

    public void dispose() {
        if (!this.clusteringPerformed) {
            return;
        }
        this.writeBandClusterListsToFile();
    }

    private void writeBandClusterListsToFile() throws OperatorException {
        Element root = new Element("Detection");
        Document doc = new Document(root);
        for (String bandName : this.bandClusterLists.keySet()) {
            Element elem = new Element("targetsDetected");
            elem.setAttribute("bandName", bandName);
            List<ShipRecord> clusterList = this.bandClusterLists.get(bandName);
            for (ShipRecord rec : clusterList) {
                Element subElem = new Element("target");
                subElem.setAttribute("lat", String.valueOf(rec.lat));
                subElem.setAttribute("lon", String.valueOf(rec.lon));
                subElem.setAttribute("width", String.valueOf(rec.width));
                subElem.setAttribute("length", String.valueOf(rec.length));
                subElem.setAttribute("intensity", String.valueOf(rec.intensity));
                elem.addContent((Content)subElem);
            }
            root.addContent((Content)elem);
        }
        XMLSupport.SaveXML((Document)doc, (String)this.targetReportFile.getAbsolutePath());
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ObjectDiscriminationOp.class);
        }
    }

    public static class ShipRecord {
        public double lat;
        public double lon;
        public double width;
        public double length;
        public double intensity;

        public ShipRecord(double lat, double lon, double width, double length, double intensity) {
            this.lat = lat;
            this.lon = lon;
            this.width = width;
            this.length = length;
            this.intensity = intensity;
        }
    }
}

