/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.fex.gpf.oceantools;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.math3.util.FastMath;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="AdaptiveThresholding", category="Radar/Feature Extraction/Ocean Tools/Object Detection", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2015 by Array Systems Computing Inc.", description="Detect ships using Constant False Alarm Rate detector.")
public class AdaptiveThresholdingOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct = null;
    private String[] sourceBandNames = null;
    @Parameter(description="Target window size", defaultValue="75", label="Target Window Size (m)")
    private int targetWindowSizeInMeter = 75;
    @Parameter(description="Guard window size", defaultValue="400.0", label="Guard Window Size (m)")
    private double guardWindowSizeInMeter = 400.0;
    @Parameter(description="Background window size", defaultValue="1000.0", label="Background Window Size (m)")
    private double backgroundWindowSizeInMeter = 1000.0;
    @Parameter(description="Probability of false alarm", defaultValue="6.5", label="PFA (10^(-x))")
    private double pfa = 6.5;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private int targetWindowSize = 0;
    private int halfGuardWindowSize = 0;
    private int halfBackgroundWindowSize = 0;
    private double t = 0.0;
    private double meanPixelSpacing = 0.0;
    private final HashMap<String, String> targetBandNameToSourceBandName = new HashMap(2);
    public static final String SHIPMASK_NAME = "_ship_bit_msk";

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfCalibrated(true);
            validator.checkIfTOPSARBurstProduct(false);
            this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
            this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
            this.getMeanPixelSpacing();
            this.targetWindowSize = (int)((double)this.targetWindowSizeInMeter / this.meanPixelSpacing) + 1;
            int guardWindowSize = (int)(this.guardWindowSizeInMeter / this.meanPixelSpacing) + 1;
            int backgroundWindowSize = (int)(this.backgroundWindowSizeInMeter / this.meanPixelSpacing) + 1;
            this.halfGuardWindowSize = guardWindowSize / 2;
            this.halfBackgroundWindowSize = (backgroundWindowSize - 1) / 2;
            this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
            ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
            this.addSelectedBands();
            this.t = AdaptiveThresholdingOp.computeDetectorDesignParameter(this.pfa);
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    void getMeanPixelSpacing() throws Exception {
        MetadataElement abs = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
        double rangeSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)abs, (String)"range_spacing");
        double azimuthSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)abs, (String)"azimuth_spacing");
        boolean srgrFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)abs, (String)"srgr_flag");
        this.meanPixelSpacing = srgrFlag ? (rangeSpacing + azimuthSpacing) / 2.0 : (rangeSpacing / FastMath.sin((double)this.getIncidenceAngleAtCentreRangePixel()) + azimuthSpacing) / 2.0;
    }

    private double getIncidenceAngleAtCentreRangePixel() throws OperatorException {
        int x = this.sourceImageWidth / 2;
        int y = this.sourceImageHeight / 2;
        TiePointGrid incidenceAngle = OperatorUtils.getIncidenceAngle((Product)this.sourceProduct);
        if (incidenceAngle == null) {
            throw new OperatorException("incidence_angle tie point grid not found in product");
        }
        return incidenceAngle.getPixelDouble(x, y) * (Math.PI / 180);
    }

    private void addSelectedBands() throws OperatorException {
        if (this.sourceBandNames == null || this.sourceBandNames.length == 0) {
            Band[] bands = this.sourceProduct.getBands();
            ArrayList<String> bandNameList = new ArrayList<String>(this.sourceProduct.getNumBands());
            for (Band band : bands) {
                String unit = band.getUnit();
                if (unit.contains("phase") || unit.contains("real") || unit.contains("imaginary")) continue;
                bandNameList.add(band.getName());
            }
            this.sourceBandNames = bandNameList.toArray(new String[bandNameList.size()]);
        }
        for (String srcBandName : this.sourceBandNames) {
            Band srcBand = this.sourceProduct.getBand(srcBandName);
            String unit = srcBand.getUnit();
            if (unit != null && (unit.contains("phase") || unit.contains("real") || unit.contains("imaginary"))) {
                throw new OperatorException("Please select amplitude or intensity band for ship detection");
            }
            String srcBandNames = srcBand.getName();
            String targetBandName = srcBandNames + SHIPMASK_NAME;
            this.targetBandNameToSourceBandName.put(targetBandName, srcBandNames);
            Band targetBand = ProductUtils.copyBand((String)srcBand.getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)false);
            targetBand.setSourceImage(srcBand.getSourceImage());
            Band targetBandMask = new Band(targetBandName, 10, this.sourceImageWidth, this.sourceImageHeight);
            targetBandMask.setUnit("amplitude");
            this.targetProduct.addBand(targetBandMask);
        }
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        try {
            Rectangle targetTileRectangle = targetTile.getRectangle();
            int tx0 = targetTileRectangle.x;
            int ty0 = targetTileRectangle.y;
            int tw = targetTileRectangle.width;
            int th = targetTileRectangle.height;
            ProductData trgData = targetTile.getDataBuffer();
            int x0 = Math.max(tx0 - this.halfBackgroundWindowSize, 0);
            int y0 = Math.max(ty0 - this.halfBackgroundWindowSize, 0);
            int w = Math.min(tx0 + tw - 1 + this.halfBackgroundWindowSize, this.sourceImageWidth - 1) - x0 + 1;
            int h = Math.min(ty0 + th - 1 + this.halfBackgroundWindowSize, this.sourceImageHeight - 1) - y0 + 1;
            Rectangle sourceTileRectangle = new Rectangle(x0, y0, w, h);
            String srcBandName = this.targetBandNameToSourceBandName.get(targetBand.getName());
            Band sourceBand = this.sourceProduct.getBand(srcBandName);
            Tile sourceTile = this.getSourceTile((RasterDataNode)sourceBand, sourceTileRectangle);
            double noDataValue = sourceBand.getNoDataValue();
            TileIndex trgIndex = new TileIndex(targetTile);
            TileIndex srcIndex = new TileIndex(sourceTile);
            int maxy = ty0 + th;
            int maxx = tx0 + tw;
            for (int ty = ty0; ty < maxy; ++ty) {
                trgIndex.calculateStride(ty);
                srcIndex.calculateStride(ty);
                for (int tx = tx0; tx < maxx; ++tx) {
                    double targetMean = this.computeTargetMean(tx, ty, sourceTile, noDataValue);
                    if (targetMean == noDataValue) {
                        trgData.setElemIntAt(trgIndex.getIndex(tx), 0);
                        continue;
                    }
                    double backgroundThreshold = this.computeBackgroundThreshold(tx, ty, sourceTile, noDataValue);
                    if (targetMean > backgroundThreshold) {
                        trgData.setElemIntAt(trgIndex.getIndex(tx), 1);
                        continue;
                    }
                    trgData.setElemIntAt(trgIndex.getIndex(tx), 0);
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private double computeTargetMean(int tx, int ty, Tile sourceTile, double noDataValue) {
        ProductData srcData = sourceTile.getDataBuffer();
        double v = srcData.getElemDoubleAt(sourceTile.getDataBufferIndex(tx, ty));
        if (v == noDataValue) {
            return noDataValue;
        }
        if (this.targetWindowSize == 1) {
            return v;
        }
        int x0 = Math.max(tx - (this.targetWindowSize - 1) / 2, 0);
        int y0 = Math.max(ty - (this.targetWindowSize - 1) / 2, 0);
        int w = Math.min(tx + (this.targetWindowSize - 1) / 2, this.sourceImageWidth - 1) - x0 + 1;
        int h = Math.min(ty + (this.targetWindowSize - 1) / 2, this.sourceImageHeight - 1) - y0 + 1;
        int tileOffset = sourceTile.getScanlineOffset();
        int tileStride = sourceTile.getScanlineStride();
        int tileMinX = sourceTile.getMinX();
        int tileMinY = sourceTile.getMinY();
        double mean = 0.0;
        int numPixels = 0;
        int maxy = y0 + h;
        int maxx = x0 + w;
        for (int y = y0; y < maxy; ++y) {
            int stride = (y - tileMinY) * tileStride + tileOffset;
            for (int x = x0; x < maxx; ++x) {
                double val = srcData.getElemDoubleAt(x - tileMinX + stride);
                if (val == noDataValue) {
                    return noDataValue;
                }
                mean += val;
                ++numPixels;
            }
        }
        return mean / (double)numPixels;
    }

    private double computeBackgroundThreshold(int tx, int ty, Tile sourceTile, double noDataValue) {
        int x0 = Math.max(tx - this.halfBackgroundWindowSize, 0);
        int y0 = Math.max(ty - this.halfBackgroundWindowSize, 0);
        int w = Math.min(tx + this.halfBackgroundWindowSize, this.sourceImageWidth - 1) - x0 + 1;
        int h = Math.min(ty + this.halfBackgroundWindowSize, this.sourceImageHeight - 1) - y0 + 1;
        ProductData srcData = sourceTile.getDataBuffer();
        int tileOffset = sourceTile.getScanlineOffset();
        int tileStride = sourceTile.getScanlineStride();
        int tileMinX = sourceTile.getMinX();
        int tileMinY = sourceTile.getMinY();
        double sum = 0.0;
        int numPixels = 0;
        int maxy = y0 + h;
        int maxx = x0 + w;
        double[] dataArray = new double[w * h];
        for (int y = y0; y < maxy; ++y) {
            boolean yGtrHalfGuard = Math.abs(y - ty) > this.halfGuardWindowSize;
            int stride = (y - tileMinY) * tileStride + tileOffset;
            for (int x = x0; x < maxx; ++x) {
                if (!yGtrHalfGuard && Math.abs(x - tx) <= this.halfGuardWindowSize) continue;
                double val = srcData.getElemDoubleAt(x - tileMinX + stride);
                if (val == noDataValue) {
                    return Double.MAX_VALUE;
                }
                sum += val;
                dataArray[numPixels] = val;
                ++numPixels;
            }
        }
        double mean = sum / (double)numPixels;
        double std = 0.0;
        for (int i = 0; i < numPixels; ++i) {
            double tmp = dataArray[i] - mean;
            std += tmp * tmp;
        }
        double backgroundSTD = Math.sqrt(std / (double)numPixels);
        return mean + backgroundSTD * this.t;
    }

    private static double computeDetectorDesignParameter(double pfa) {
        return Math.sqrt(2.0) * AdaptiveThresholdingOp.inverf(1.0 - 2.0 * FastMath.pow((double)10.0, (double)(-pfa)));
    }

    private static double erfc(double x) {
        double z = Math.abs(x);
        double t = 1.0 / (1.0 + 0.5 * z);
        double erfc = t * FastMath.exp((double)(-z * z - 1.26551223 + t * (1.00002368 + t * (0.37409196 + t * (0.09678418 + t * (-0.18628806 + t * (0.27886807 + t * (-1.13520398 + t * (1.48851587 + t * (-0.82215223 + t * 0.17087277))))))))));
        if (x < 0.0) {
            erfc = 2.0 - erfc;
        }
        return erfc;
    }

    private static double erf(double x) {
        return 1.0 - AdaptiveThresholdingOp.erfc(x);
    }

    private static double inverfc(double p) {
        if (p >= 2.0) {
            return -100.0;
        }
        if (p <= 0.0) {
            return 100.0;
        }
        double pp = p < 1.0 ? p : 2.0 - p;
        double t = Math.sqrt(-2.0 * Math.log(pp / 2.0));
        double x = -0.70711 * ((2.30753 + t * 0.27061) / (1.0 + t * (0.99229 + t * 0.04481)) - t);
        for (int j = 0; j < 2; ++j) {
            double err = AdaptiveThresholdingOp.erfc(x) - pp;
            x += err / (1.1283791670955126 * FastMath.exp((double)(-Math.sqrt(x))) - x * err);
        }
        return p < 1.0 ? x : -x;
    }

    private static double inverf(double p) {
        return AdaptiveThresholdingOp.inverfc(1.0 - p);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(AdaptiveThresholdingOp.class);
        }
    }
}

