/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.fex.gpf.forest;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="Forest-Area-Detection", category="Radar/Feature Extraction", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2015 by Array Systems Computing Inc.", description="Detect forest area.", internal=true)
public class ForestAreaDetectionOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct = null;
    @Parameter(description="The list of source bands.", alias="sourceBands", rasterDataNodeType=Band.class, label="Nominator Band")
    private String nominatorBandName = null;
    @Parameter(description="The list of source bands.", alias="sourceBands", rasterDataNodeType=Band.class, label="Denominator Band")
    private String denominatorBandName = null;
    @Parameter(valueSet={"3x3", "5x5", "7x7", "9x9"}, defaultValue="3x3", label="Window Size")
    private String windowSizeStr = "3x3";
    @Parameter(description="The lower bound for ratio image", interval="(0, *)", defaultValue="3.76", label="Ratio lower bound (dB)")
    private double T_Ratio_Low = 3.76;
    @Parameter(description="The upper bound for ratio image", interval="(0, *)", defaultValue="6.55", label="Ratio upper bound (dB)")
    private double T_Ratio_High = 6.55;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private int windowSize = 0;
    private int halfWindowSize = 0;
    private String[] sourceBandNames = new String[2];
    public static final String FOREST_MASK_NAME = "forest_mask";
    public static final String RATIO_BAND_NAME = "ratio";
    private static final String WINDOW_SIZE_3x3 = "3x3";
    private static final String WINDOW_SIZE_5x5 = "5x5";
    private static final String WINDOW_SIZE_7x7 = "7x7";
    private static final String WINDOW_SIZE_9x9 = "9x9";

    public void initialize() throws OperatorException {
        try {
            this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
            this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
            this.setWindowSize();
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void setWindowSize() {
        switch (this.windowSizeStr) {
            case "3x3": {
                this.windowSize = 3;
                break;
            }
            case "5x5": {
                this.windowSize = 5;
                break;
            }
            case "7x7": {
                this.windowSize = 7;
                break;
            }
            case "9x9": {
                this.windowSize = 9;
                break;
            }
            default: {
                throw new OperatorException("Unknown window size: " + this.windowSize);
            }
        }
        this.halfWindowSize = this.windowSize / 2;
    }

    private void createTargetProduct() throws Exception {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        this.addSelectedBands();
    }

    private void addSelectedBands() throws OperatorException {
        this.sourceBandNames[0] = this.nominatorBandName;
        this.sourceBandNames[1] = this.denominatorBandName;
        for (String bandName : this.sourceBandNames) {
            String bandUnit = this.sourceProduct.getBand(bandName).getUnit();
            if (!(bandUnit.equals("amplitude") || bandUnit.equals("intensity") || bandUnit.equals("amplitude_db") || bandUnit.equals("intensity_db"))) {
                throw new OperatorException("Please select amplitude or intensity band");
            }
            ProductUtils.copyBand((String)bandName, (Product)this.sourceProduct, (String)bandName, (Product)this.targetProduct, (boolean)true);
        }
        Band targetRatioBand = new Band(RATIO_BAND_NAME, 30, this.sourceImageWidth, this.sourceImageHeight);
        targetRatioBand.setNoDataValue(0.0);
        targetRatioBand.setNoDataValueUsed(true);
        targetRatioBand.setUnit(RATIO_BAND_NAME);
        this.targetProduct.addBand(targetRatioBand);
        String expression = "ratio > " + String.valueOf(this.T_Ratio_Low) + " && " + RATIO_BAND_NAME + " < " + String.valueOf(this.T_Ratio_High);
        Mask mask = new Mask(FOREST_MASK_NAME, this.targetProduct.getSceneRasterWidth(), this.targetProduct.getSceneRasterHeight(), (Mask.ImageType)Mask.BandMathsType.INSTANCE);
        mask.setDescription("Forest Area");
        mask.getImageConfig().setValue("color", (Object)Color.MAGENTA);
        mask.getImageConfig().setValue("transparency", (Object)0.7);
        mask.getImageConfig().setValue("expression", (Object)expression);
        mask.setNoDataValue(0.0);
        mask.setNoDataValueUsed(true);
        this.targetProduct.getMaskGroup().add((ProductNode)mask);
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            int tx0 = targetRectangle.x;
            int ty0 = targetRectangle.y;
            int tw = targetRectangle.width;
            int th = targetRectangle.height;
            Rectangle sourceTileRectangle = this.getSourceTileRectangle(tx0, ty0, tw, th);
            Band nominatorBand = this.sourceProduct.getBand(this.sourceBandNames[0]);
            Band denominatorBand = this.sourceProduct.getBand(this.sourceBandNames[1]);
            Tile nominatorTile = this.getSourceTile((RasterDataNode)nominatorBand, sourceTileRectangle);
            Tile denominatorTile = this.getSourceTile((RasterDataNode)denominatorBand, sourceTileRectangle);
            ProductData nominatorData = nominatorTile.getDataBuffer();
            ProductData denominatorData = denominatorTile.getDataBuffer();
            String nominatorBandUnit = nominatorBand.getUnit();
            String denominatorBandUnit = denominatorBand.getUnit();
            double noDataValueN = nominatorBand.getNoDataValue();
            double noDataValueD = denominatorBand.getNoDataValue();
            Band targetRatioBand = this.targetProduct.getBand(RATIO_BAND_NAME);
            Tile targetRatioTile = targetTiles.get(targetRatioBand);
            ProductData ratioData = targetRatioTile.getDataBuffer();
            TileIndex trgIndex = new TileIndex(targetTiles.get(targetTiles.keySet().iterator().next()));
            TileIndex srcIndex = new TileIndex(nominatorTile);
            int maxy = ty0 + th;
            int maxx = tx0 + tw;
            for (int ty = ty0; ty < maxy; ++ty) {
                trgIndex.calculateStride(ty);
                srcIndex.calculateStride(ty);
                for (int tx = tx0; tx < maxx; ++tx) {
                    int trgIdx = trgIndex.getIndex(tx);
                    int srcIdx = srcIndex.getIndex(tx);
                    double vN = nominatorData.getElemDoubleAt(srcIdx);
                    double vD = denominatorData.getElemDoubleAt(srcIdx);
                    if (vN == noDataValueN || vD == noDataValueD) {
                        ratioData.setElemFloatAt(trgIdx, 0.0f);
                        continue;
                    }
                    double vRatio = this.computeRatio(tx, ty, nominatorTile, nominatorData, denominatorTile, denominatorData, nominatorBandUnit, denominatorBandUnit, noDataValueN, noDataValueD);
                    if (vRatio == noDataValueN || vRatio == noDataValueD) {
                        ratioData.setElemFloatAt(trgIdx, 0.0f);
                        continue;
                    }
                    double vRatioDB = 10.0 * Math.log10(Math.max(vRatio, 1.0E-15));
                    double vDDB = 10.0 * Math.log10(Math.max(vD, 1.0E-15));
                    ratioData.setElemFloatAt(trgIdx, (float)vRatioDB);
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private Rectangle getSourceTileRectangle(int x0, int y0, int w, int h) {
        int sx0 = x0;
        int sy0 = y0;
        int sw = w;
        int sh = h;
        if (x0 >= this.halfWindowSize) {
            sx0 -= this.halfWindowSize;
            sw += this.halfWindowSize;
        }
        if (y0 >= this.halfWindowSize) {
            sy0 -= this.halfWindowSize;
            sh += this.halfWindowSize;
        }
        if (x0 + w + this.halfWindowSize <= this.sourceImageWidth) {
            sw += this.halfWindowSize;
        }
        if (y0 + h + this.halfWindowSize <= this.sourceImageHeight) {
            sh += this.halfWindowSize;
        }
        return new Rectangle(sx0, sy0, sw, sh);
    }

    private double computeRatio(int tx, int ty, Tile nominatorTile, ProductData nominatorData, Tile denominatorTile, ProductData denominatorData, String bandUnitN, String bandUnitD, double noDataValueN, double noDataValueD) {
        double[] samplesN = new double[this.windowSize * this.windowSize];
        double[] samplesD = new double[this.windowSize * this.windowSize];
        int numSamplesN = this.getSamples(tx, ty, bandUnitN, noDataValueN, nominatorTile, nominatorData, samplesN);
        if (numSamplesN == 0) {
            return noDataValueN;
        }
        int numSamplesD = this.getSamples(tx, ty, bandUnitD, noDataValueD, denominatorTile, denominatorData, samplesD);
        if (numSamplesD == 0) {
            return noDataValueD;
        }
        double meanN = ForestAreaDetectionOp.getMeanValue(samplesN, numSamplesN);
        double meanD = ForestAreaDetectionOp.getMeanValue(samplesD, numSamplesD);
        if (meanD == 0.0) {
            return noDataValueD;
        }
        return meanN / meanD;
    }

    private int getSamples(int tx, int ty, String bandUnit, double noDataValue, Tile sourceTile, ProductData srcData, double[] samples) {
        int x0 = Math.max(tx - this.halfWindowSize, 0);
        int y0 = Math.max(ty - this.halfWindowSize, 0);
        int w = Math.min(tx + this.halfWindowSize, this.sourceImageWidth - 1) - x0 + 1;
        int h = Math.min(ty + this.halfWindowSize, this.sourceImageHeight - 1) - y0 + 1;
        TileIndex tileIndex = new TileIndex(sourceTile);
        int numSamples = 0;
        int maxy = Math.min(y0 + h, sourceTile.getMaxY() - 1);
        int maxx = Math.min(x0 + w, sourceTile.getMaxX() - 1);
        switch (bandUnit) {
            case "amplitude": {
                for (int y = y0; y < maxy; ++y) {
                    tileIndex.calculateStride(y);
                    for (int x = x0; x < maxx; ++x) {
                        double v = srcData.getElemDoubleAt(tileIndex.getIndex(x));
                        if (v == noDataValue) continue;
                        samples[numSamples++] = v * v;
                    }
                }
                break;
            }
            case "intensity": {
                for (int y = y0; y < maxy; ++y) {
                    tileIndex.calculateStride(y);
                    for (int x = x0; x < maxx; ++x) {
                        double v = srcData.getElemDoubleAt(tileIndex.getIndex(x));
                        if (v == noDataValue) continue;
                        samples[numSamples++] = v;
                    }
                }
                break;
            }
            case "amplitude_db": {
                for (int y = y0; y < maxy; ++y) {
                    tileIndex.calculateStride(y);
                    for (int x = x0; x < maxx; ++x) {
                        double v = srcData.getElemDoubleAt(tileIndex.getIndex(x));
                        if (v == noDataValue) continue;
                        double vv = FastMath.pow((double)10.0, (double)(v / 10.0));
                        samples[numSamples++] = vv * vv;
                    }
                }
                break;
            }
            case "intensity_db": {
                for (int y = y0; y < maxy; ++y) {
                    tileIndex.calculateStride(y);
                    for (int x = x0; x < maxx; ++x) {
                        double v = srcData.getElemDoubleAt(tileIndex.getIndex(x));
                        if (v == noDataValue) continue;
                        samples[numSamples++] = FastMath.pow((double)10.0, (double)(v / 10.0));
                    }
                }
                break;
            }
            default: {
                throw new OperatorException("Unknown band unit:" + bandUnit);
            }
        }
        return numSamples;
    }

    private static double getMeanValue(double[] samples, int numSamples) {
        double mean = 0.0;
        for (int i = 0; i < numSamples; ++i) {
            mean += samples[i];
        }
        return mean /= (double)numSamples;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ForestAreaDetectionOp.class);
        }
    }
}

