/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.fex.gpf;

import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.engine_utilities.gpf.TileIndex;

public class RegionGrower {
    private final Tile srcTile;
    private int minClusterSizeInPixels = 10;
    private int maxClusterSize = 0;
    private int numSamples = 0;

    public RegionGrower(Tile srcTile) {
        this.srcTile = srcTile;
    }

    public int getMaxClusterSize() {
        return this.maxClusterSize;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void run(double threshold, double[] dataArray) {
        int tx0 = this.srcTile.getMinX();
        int ty0 = this.srcTile.getMinY();
        int tw = this.srcTile.getWidth();
        int th = this.srcTile.getHeight();
        ProductData srcData = this.srcTile.getDataBuffer();
        int[][] pixelsScaned = new int[th][tw];
        ArrayList<PixelPos> clusterPixels = new ArrayList<PixelPos>(2000);
        TileIndex srcIndex = new TileIndex(this.srcTile);
        int cnt = 0;
        int maxy = ty0 + th;
        int maxx = tx0 + tw;
        for (int ty = ty0; ty < maxy; ++ty) {
            srcIndex.calculateStride(ty);
            for (int tx = tx0; tx < maxx; ++tx) {
                double val = srcData.getElemDoubleAt(srcIndex.getIndex(tx));
                dataArray[cnt++] = val;
                if (!(val > threshold)) continue;
                ++this.numSamples;
                if (pixelsScaned[ty - ty0][tx - tx0] != 0) continue;
                clusterPixels.clear();
                RegionGrower.clustering(tx, ty, tx0, ty0, tw, th, srcData, this.srcTile, threshold, pixelsScaned, clusterPixels);
                if (clusterPixels.size() <= this.maxClusterSize) continue;
                this.maxClusterSize = clusterPixels.size();
            }
        }
    }

    private static void clustering(int xc, int yc, int x0, int y0, int w, int h, ProductData data, Tile tile, double threshold, int[][] pixelsScaned, List<PixelPos> clusterPixels) {
        ArrayList<PixelPos> seeds = new ArrayList<PixelPos>();
        seeds.add(new PixelPos((double)xc, (double)yc));
        pixelsScaned[yc - y0][xc - x0] = 1;
        clusterPixels.add(new PixelPos((double)xc, (double)yc));
        while (seeds.size() > 0) {
            ArrayList<PixelPos> newSeeds = new ArrayList<PixelPos>();
            for (PixelPos pixel : seeds) {
                RegionGrower.searchNeighbourhood(pixel, x0, y0, w, h, data, tile, threshold, pixelsScaned, clusterPixels, newSeeds);
            }
            seeds.clear();
            seeds.addAll(newSeeds);
        }
    }

    private static void searchNeighbourhood(PixelPos pixel, int x0, int y0, int w, int h, ProductData data, Tile tile, double threshold, int[][] pixelsScaned, List<PixelPos> clusterPixels, List<PixelPos> newSeeds) {
        int xc = (int)pixel.x;
        int yc = (int)pixel.y;
        int[] x = new int[]{xc - 1, xc, xc + 1, xc - 1, xc + 1, xc - 1, xc, xc + 1};
        int[] y = new int[]{yc - 1, yc - 1, yc - 1, yc, yc, yc + 1, yc + 1, yc + 1};
        for (int i = 0; i < 8; ++i) {
            if (x[i] < x0 || x[i] >= x0 + w || y[i] < y0 || y[i] >= y0 + h || pixelsScaned[y[i] - y0][x[i] - x0] != 0 || !(data.getElemDoubleAt(tile.getDataBufferIndex(x[i], y[i])) > threshold)) continue;
            pixelsScaned[y[i] - y0][x[i] - x0] = 1;
            clusterPixels.add(new PixelPos((double)x[i], (double)y[i]));
            newSeeds.add(new PixelPos((double)x[i], (double)y[i]));
        }
    }
}

