/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.fex.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.engine_utilities.db.CommonReaders;
import org.esa.snap.engine_utilities.db.DBSearch;
import org.esa.snap.engine_utilities.db.ProductEntry;

@OperatorMetadata(alias="Find-Image-Pair", category="Input-Output", version="1.0", authors="Luis Veci", copyright="Copyright (C) 2015 by Array Systems Computing Inc.", description="DB query to find matching image pair")
public class FindImagePairOp
extends Operator {
    @SourceProduct
    private Product sourceProduct;
    private transient ProductReader productReader;
    @Parameter(description="Minimum days apart from master", defaultValue="1", label="Minimum days apart")
    private double minMJD = 1.0;
    @Parameter(description="Maximum days apart from master", defaultValue="99999", label="Maximum days apart")
    private double maxMJD = 99999.0;

    public void initialize() throws OperatorException {
        try {
            ProductEntry[] entryList = DBSearch.search((Product)this.sourceProduct, (int)1, (double)this.minMJD, (double)this.maxMJD);
            if (entryList.length <= 0) {
                throw new OperatorException("No image pair found in database");
            }
            File file = entryList[0].getFile();
            Product targetProduct = CommonReaders.readProduct((File)file);
            this.productReader = targetProduct.getProductReader();
            targetProduct.setFileLocation(file);
            super.setTargetProduct(targetProduct);
            this.updateMetadata();
        }
        catch (Exception e) {
            throw new OperatorException((Throwable)e);
        }
    }

    private void updateMetadata() {
        MetadataElement inputElem;
        Product targetProduct = super.getTargetProduct();
        MetadataElement root = targetProduct.getMetadataRoot();
        if (root == null) {
            return;
        }
        MetadataElement abstractedMetadata = root.getElement("Abstracted_Metadata");
        if (abstractedMetadata == null) {
            return;
        }
        MetadataElement productElem = abstractedMetadata.getElement("Product_Information");
        if (productElem == null) {
            productElem = new MetadataElement("Product_Information");
            abstractedMetadata.addElement(productElem);
        }
        if ((inputElem = productElem.getElement("InputProducts")) == null) {
            inputElem = new MetadataElement("InputProducts");
            productElem.addElement(inputElem);
        }
        MetadataAttribute[] inputProductAttrbList = inputElem.getAttributes();
        boolean found = false;
        for (MetadataAttribute attrib : inputProductAttrbList) {
            if (!attrib.getData().getElemString().equals(targetProduct.getName())) continue;
            found = true;
        }
        if (!found) {
            MetadataAttribute inputAttrb = FindImagePairOp.addAttribute(inputElem, "InputProduct", 41, "", "");
            inputAttrb.getData().setElems((Object)targetProduct.getName());
        }
    }

    public static MetadataAttribute addAttribute(MetadataElement dest, String tag, int dataType, String unit, String desc) {
        MetadataAttribute attribute = new MetadataAttribute(tag, dataType, 1);
        attribute.setUnit(unit);
        attribute.setDescription(desc);
        attribute.setReadOnly(true);
        dest.addAttribute(attribute);
        return attribute;
    }

    public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        ProductData dataBuffer = targetTile.getRawSamples();
        Rectangle rectangle = targetTile.getRectangle();
        try {
            this.productReader.readBandRasterData(band, rectangle.x, rectangle.y, rectangle.width, rectangle.height, dataBuffer, pm);
            targetTile.setRawSamples(dataBuffer);
        }
        catch (IOException e) {
            throw new OperatorException((Throwable)e);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(FindImagePairOp.class);
        }
    }
}

