/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.fex.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Map;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="Change-Detection", category="Radar/Feature Extraction", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2015 by Array Systems Computing Inc.", description="Change Detection.")
public class ChangeDetectionOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct = null;
    @Parameter(description="The list of source bands.", alias="sourceBands", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] sourceBandNames = null;
    @Parameter(description="Mask upper threshold", defaultValue="2.0", label="Mask upper threshold")
    private float maskUpperThreshold = 2.0f;
    @Parameter(description="Mask lower threshold", defaultValue="-2.0", label="Mask lower threshold")
    private float maskLowerThreshold = -2.0f;
    @Parameter(description="Include source bands", defaultValue="false", label="Include source bands")
    private boolean includeSourceBands = false;
    @Parameter(description="Output Log Ratio", defaultValue="false", label="Output Log Ratio")
    private boolean outputLogRatio = false;
    private int sourceImageWidth;
    private int sourceImageHeight;
    private String ratioBandName;
    private static String RATIO_BAND_NAME = "ratio";
    private static String LOG_RATIO_BAND_NAME = "log_ratio";
    private static final String MASK_NAME = "_change";

    public void initialize() throws OperatorException {
        try {
            this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
            this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void createTargetProduct() throws Exception {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        this.addSelectedBands();
    }

    private void addSelectedBands() throws OperatorException {
        if (this.sourceBandNames == null || this.sourceBandNames.length == 0) {
            Band[] bandArray = this.sourceProduct.getBands();
            ArrayList<String> bandNameList = new ArrayList<String>(this.sourceProduct.getNumBands());
            for (Band band : bandArray) {
                if (band.getUnit() == null || !band.getUnit().contains("intensity")) continue;
                bandNameList.add(band.getName());
                if (bandNameList.size() == 2) break;
            }
            if (bandNameList.size() < 2) {
                bandNameList.clear();
                for (Band band : bandArray) {
                    if (band.getUnit() == null || !band.getUnit().contains("amplitude")) continue;
                    bandNameList.add(band.getName());
                    if (bandNameList.size() == 2) break;
                }
            }
            if (bandNameList.size() < 2) {
                bandNameList.clear();
                for (Band band : bandArray) {
                    bandNameList.add(band.getName());
                    if (bandNameList.size() == 2) break;
                }
            }
            this.sourceBandNames = bandNameList.toArray(new String[bandNameList.size()]);
        }
        if (this.sourceBandNames.length != 2) {
            throw new OperatorException("Please select two source bands");
        }
        if (this.includeSourceBands) {
            for (String string : this.sourceBandNames) {
                ProductUtils.copyBand((String)string, (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
            }
        }
        this.ratioBandName = RATIO_BAND_NAME;
        if (this.outputLogRatio) {
            this.ratioBandName = LOG_RATIO_BAND_NAME;
        }
        Band band = new Band(this.ratioBandName, 30, this.sourceImageWidth, this.sourceImageHeight);
        band.setNoDataValue(0.0);
        band.setNoDataValueUsed(true);
        if (this.outputLogRatio) {
            band.setUnit("log_ratio");
        } else {
            band.setUnit("ratio");
        }
        this.targetProduct.addBand(band);
        String expression = band.getName() + " > " + this.maskUpperThreshold + " ? 1 : " + band.getName() + " < " + this.maskLowerThreshold + " ? -1 : 0";
        Mask mask = new Mask(band.getName() + MASK_NAME, band.getRasterWidth(), band.getRasterHeight(), (Mask.ImageType)Mask.BandMathsType.INSTANCE);
        mask.setDescription("Change");
        mask.getImageConfig().setValue("color", (Object)Color.RED);
        mask.getImageConfig().setValue("transparency", (Object)0.7);
        mask.getImageConfig().setValue("expression", (Object)expression);
        mask.setNoDataValue(0.0);
        mask.setNoDataValueUsed(true);
        this.targetProduct.getMaskGroup().add((ProductNode)mask);
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            int tx0 = targetRectangle.x;
            int ty0 = targetRectangle.y;
            int tw = targetRectangle.width;
            int th = targetRectangle.height;
            Band nominatorBand = this.sourceProduct.getBand(this.sourceBandNames[0]);
            Band denominatorBand = this.sourceProduct.getBand(this.sourceBandNames[1]);
            Tile nominatorTile = this.getSourceTile((RasterDataNode)nominatorBand, targetRectangle);
            Tile denominatorTile = this.getSourceTile((RasterDataNode)denominatorBand, targetRectangle);
            ProductData nominatorData = nominatorTile.getDataBuffer();
            ProductData denominatorData = denominatorTile.getDataBuffer();
            double noDataValueN = nominatorBand.getNoDataValue();
            double noDataValueD = denominatorBand.getNoDataValue();
            Band targetRatioBand = this.targetProduct.getBand(this.ratioBandName);
            Tile targetRatioTile = targetTiles.get(targetRatioBand);
            ProductData ratioData = targetRatioTile.getDataBuffer();
            TileIndex trgIndex = new TileIndex(targetTiles.get(targetTiles.keySet().iterator().next()));
            TileIndex srcIndex = new TileIndex(nominatorTile);
            int maxy = ty0 + th;
            int maxx = tx0 + tw;
            for (int ty = ty0; ty < maxy; ++ty) {
                trgIndex.calculateStride(ty);
                srcIndex.calculateStride(ty);
                for (int tx = tx0; tx < maxx; ++tx) {
                    int trgIdx = trgIndex.getIndex(tx);
                    int srcIdx = srcIndex.getIndex(tx);
                    double vN = nominatorData.getElemDoubleAt(srcIdx);
                    double vD = denominatorData.getElemDoubleAt(srcIdx);
                    if (vN == noDataValueN || vD == noDataValueD || vN <= 0.0 || vD <= 0.0) {
                        ratioData.setElemFloatAt(trgIdx, 0.0f);
                        continue;
                    }
                    double vRatio = vN / vD;
                    if (this.outputLogRatio) {
                        vRatio = Math.log(Math.max(vRatio, 1.0E-15));
                    }
                    ratioData.setElemFloatAt(trgIdx, (float)vRatio);
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ChangeDetectionOp.class);
        }
    }
}

