/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.fex.rcp.layersrc;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerTypeRegistry;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.Viewport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.esa.s1tbx.dat.layers.ScreenPixelConverter;
import org.esa.s1tbx.fex.gpf.oceantools.WindFieldEstimationOp;
import org.esa.s1tbx.fex.rcp.layersrc.WindFieldEstimationLayerType;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.dataop.downloadable.XMLSupport;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;

public class WindFieldEstimationLayer
extends Layer {
    private final Product product;
    private final Band band;
    private final List<WindFieldEstimationOp.WindFieldRecord> targetList = new ArrayList<WindFieldEstimationOp.WindFieldRecord>(200);
    private static final float lineThickness = 2.0f;

    public WindFieldEstimationLayer(PropertySet configuration) {
        super(LayerTypeRegistry.getLayerType((String)WindFieldEstimationLayerType.class.getName()), configuration);
        this.setName("Windfield Estimation");
        this.product = (Product)configuration.getValue("product");
        this.band = (Band)configuration.getValue("band");
        this.LoadTargets(WindFieldEstimationLayer.getWindFieldReportFile(this.product));
    }

    public static File getWindFieldReportFile(Product product) {
        File file;
        String windFieldReportFilePath;
        MetadataElement absMetadata = AbstractMetadata.getAbstractedMetadata((Product)product);
        if (absMetadata != null && (windFieldReportFilePath = absMetadata.getAttributeString("wind_field_report_file", null)) != null && (file = new File(windFieldReportFilePath)).exists()) {
            return file;
        }
        return null;
    }

    private void LoadTargets(File file) {
        Document doc;
        if (file == null) {
            return;
        }
        try {
            doc = XMLSupport.LoadXML((String)file.getAbsolutePath());
        }
        catch (IOException e) {
            return;
        }
        this.targetList.clear();
        Element root = doc.getRootElement();
        List children = root.getContent();
        for (Object aChild : children) {
            Attribute attrib;
            Element targetsDetectedElem;
            if (!(aChild instanceof Element) || !(targetsDetectedElem = (Element)aChild).getName().equals("windFieldEstimated") || (attrib = targetsDetectedElem.getAttribute("bandName")) == null || !this.band.getName().equalsIgnoreCase(attrib.getValue())) continue;
            List content = targetsDetectedElem.getContent();
            for (Object det : content) {
                Attribute ratio;
                Attribute dy;
                Attribute dx;
                Attribute speed;
                Attribute lon;
                Attribute lat;
                Element targetElem;
                if (!(det instanceof Element) || !(targetElem = (Element)det).getName().equals("windFieldInfo") || (lat = targetElem.getAttribute("lat")) == null || (lon = targetElem.getAttribute("lon")) == null || (speed = targetElem.getAttribute("speed")) == null || (dx = targetElem.getAttribute("dx")) == null || (dy = targetElem.getAttribute("dy")) == null || (ratio = targetElem.getAttribute("ratio")) == null) continue;
                this.targetList.add(new WindFieldEstimationOp.WindFieldRecord(Double.parseDouble(lat.getValue()), Double.parseDouble(lon.getValue()), Double.parseDouble(speed.getValue()), Double.parseDouble(dx.getValue()), Double.parseDouble(dy.getValue()), Double.parseDouble(ratio.getValue())));
            }
        }
    }

    protected void renderLayer(Rendering rendering) {
        RasterDataNode raster;
        if (this.band == null || this.targetList.isEmpty()) {
            return;
        }
        Viewport vp = rendering.getViewport();
        ScreenPixelConverter screenPixel = new ScreenPixelConverter(vp, raster = this.product.getRasterDataNode(this.product.getBandAt(0).getName()));
        if (!screenPixel.withInBounds()) {
            return;
        }
        GeoCoding geoCoding = this.product.getSceneGeoCoding();
        GeoPos geo = new GeoPos();
        PixelPos pix = new PixelPos();
        Graphics2D graphics = rendering.getGraphics();
        graphics.setStroke(new BasicStroke(2.0f));
        graphics.setColor(Color.RED);
        double[] ipts = new double[14];
        double[] vpts = new double[14];
        DecimalFormat frmt = new DecimalFormat("0.00");
        for (WindFieldEstimationOp.WindFieldRecord target : this.targetList) {
            geo.setLocation(target.lat, target.lon);
            geoCoding.getPixelPos(geo, pix);
            double dx = target.dx;
            double dy = target.dy;
            ipts[0] = pix.getX() - dx;
            ipts[1] = pix.getY() - dy;
            ipts[2] = pix.getX() + dx;
            ipts[3] = pix.getY() + dy;
            ipts[4] = ipts[2] - (1.732 * dx - dy) / 6.0;
            ipts[5] = ipts[3] - (1.732 * dy + dx) / 6.0;
            ipts[6] = ipts[2] - (1.732 * dx + dy) / 6.0;
            ipts[7] = ipts[3] - (1.732 * dy - dx) / 6.0;
            ipts[8] = ipts[0] + (1.732 * dx - dy) / 6.0;
            ipts[9] = ipts[1] + (1.732 * dy + dx) / 6.0;
            ipts[10] = ipts[0] + (1.732 * dx + dy) / 6.0;
            ipts[11] = ipts[1] + (1.732 * dy - dx) / 6.0;
            ipts[12] = pix.getX();
            ipts[13] = pix.getY();
            screenPixel.pixelToScreen(ipts, vpts);
            graphics.setColor(Color.RED);
            graphics.draw(new Line2D.Double(vpts[0], vpts[1], vpts[2], vpts[3]));
            graphics.draw(new Line2D.Double(vpts[4], vpts[5], vpts[2], vpts[3]));
            graphics.draw(new Line2D.Double(vpts[6], vpts[7], vpts[2], vpts[3]));
            graphics.draw(new Line2D.Double(vpts[8], vpts[9], vpts[0], vpts[1]));
            graphics.draw(new Line2D.Double(vpts[10], vpts[11], vpts[0], vpts[1]));
            graphics.drawString(frmt.format(target.speed) + "m/s", (int)vpts[12], (int)vpts[13]);
        }
    }
}

