/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.fex.rcp.layersrc;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerTypeRegistry;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.Viewport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.esa.s1tbx.dat.layers.ScreenPixelConverter;
import org.esa.s1tbx.fex.gpf.oceantools.ObjectDiscriminationOp;
import org.esa.s1tbx.fex.rcp.layersrc.ObjectDetectionLayerType;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.dataop.downloadable.XMLSupport;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;

public class ObjectDetectionLayer
extends Layer {
    private final Product product;
    private final Band band;
    private final List<ObjectDiscriminationOp.ShipRecord> targetList = new ArrayList<ObjectDiscriminationOp.ShipRecord>(200);
    private double rangeSpacing;
    private double azimuthSpacing;
    private static final float lineThickness = 2.0f;
    private static final double border = 5.0;

    public ObjectDetectionLayer(PropertySet configuration) {
        super(LayerTypeRegistry.getLayerType((String)ObjectDetectionLayerType.class.getName()), configuration);
        this.setName("Object Detection");
        this.product = (Product)configuration.getValue("product");
        this.band = (Band)configuration.getValue("band");
        this.getPixelSize();
        this.LoadTargets(ObjectDetectionLayer.getTargetFile(this.product));
    }

    private void getPixelSize() {
        MetadataElement absMetadata = AbstractMetadata.getAbstractedMetadata((Product)this.product);
        if (absMetadata != null) {
            this.rangeSpacing = absMetadata.getAttributeDouble("range_spacing", 0.0);
            this.azimuthSpacing = absMetadata.getAttributeDouble("azimuth_spacing", 0.0);
        }
    }

    public static File getTargetFile(Product product) {
        File file;
        String shipFilePath;
        MetadataElement absMetadata = AbstractMetadata.getAbstractedMetadata((Product)product);
        if (absMetadata != null && (shipFilePath = absMetadata.getAttributeString("target_report_file", null)) != null && (file = new File(shipFilePath)).exists()) {
            return file;
        }
        return null;
    }

    private void LoadTargets(File file) {
        Document doc;
        if (file == null) {
            return;
        }
        try {
            doc = XMLSupport.LoadXML((String)file.getAbsolutePath());
        }
        catch (IOException e) {
            return;
        }
        this.targetList.clear();
        Element root = doc.getRootElement();
        List children = root.getContent();
        for (Object aChild : children) {
            Attribute attrib;
            Element targetsDetectedElem;
            if (!(aChild instanceof Element) || !(targetsDetectedElem = (Element)aChild).getName().equals("targetsDetected") || (attrib = targetsDetectedElem.getAttribute("bandName")) == null || !this.band.getName().equalsIgnoreCase(attrib.getValue())) continue;
            List content = targetsDetectedElem.getContent();
            for (Object det : content) {
                Attribute intensity;
                Attribute length;
                Attribute width;
                Attribute lon;
                Attribute lat;
                Element targetElem;
                if (!(det instanceof Element) || !(targetElem = (Element)det).getName().equals("target") || (lat = targetElem.getAttribute("lat")) == null || (lon = targetElem.getAttribute("lon")) == null || (width = targetElem.getAttribute("width")) == null || (length = targetElem.getAttribute("length")) == null || (intensity = targetElem.getAttribute("intensity")) == null) continue;
                this.targetList.add(new ObjectDiscriminationOp.ShipRecord(Double.parseDouble(lat.getValue()), Double.parseDouble(lon.getValue()), Double.parseDouble(width.getValue()) / this.rangeSpacing + 5.0, Double.parseDouble(length.getValue()) / this.azimuthSpacing + 5.0, Double.parseDouble(intensity.getValue())));
            }
        }
    }

    protected void renderLayer(Rendering rendering) {
        RasterDataNode raster;
        if (this.band == null || this.targetList.isEmpty()) {
            return;
        }
        Viewport vp = rendering.getViewport();
        ScreenPixelConverter screenPixel = new ScreenPixelConverter(vp, raster = this.product.getRasterDataNode(this.product.getBandAt(0).getName()));
        if (!screenPixel.withInBounds()) {
            return;
        }
        GeoCoding geoCoding = this.product.getSceneGeoCoding();
        GeoPos geo = new GeoPos();
        PixelPos pix = new PixelPos();
        Graphics2D graphics = rendering.getGraphics();
        graphics.setStroke(new BasicStroke(2.0f));
        graphics.setColor(Color.RED);
        double[] ipts = new double[4];
        double[] vpts = new double[4];
        DecimalFormat frmt = new DecimalFormat("0.00");
        for (ObjectDiscriminationOp.ShipRecord target : this.targetList) {
            geo.setLocation(target.lat, target.lon);
            geoCoding.getPixelPos(geo, pix);
            double halfWidth = target.width / 2.0;
            double halfHeight = target.length / 2.0;
            ipts[0] = pix.getX() - halfWidth;
            ipts[1] = pix.getY() - halfHeight;
            ipts[2] = ipts[0] + target.width;
            ipts[3] = ipts[1] + target.length;
            screenPixel.pixelToScreen(ipts, vpts);
            double w = vpts[2] - vpts[0];
            double h = vpts[3] - vpts[1];
            Ellipse2D.Double circle = new Ellipse2D.Double(vpts[0], vpts[1], w, h);
            graphics.draw(circle);
            double targetWidthInMeter = (target.width - 5.0) * this.rangeSpacing;
            double targetlengthInMeter = (target.length - 5.0) * this.azimuthSpacing;
            double size = Math.sqrt(targetWidthInMeter * targetWidthInMeter + targetlengthInMeter * targetlengthInMeter);
            graphics.drawString(frmt.format(size) + "m", (int)vpts[0], (int)vpts[1]);
        }
    }
}

