/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.calibration.gpf.support;

import java.util.HashMap;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;

public class BaseCalibrator {
    protected Operator calibrationOp;
    protected Product sourceProduct;
    protected Product targetProduct;
    protected boolean outputImageInComplex = false;
    protected boolean outputImageScaleInDb = false;
    protected boolean isComplex = false;
    protected String incidenceAngleSelection = null;
    protected MetadataElement absRoot = null;
    protected MetadataElement origMetadataRoot = null;
    protected static final double underFlowFloat = 1.0E-30;
    protected static final String PRODUCT_SUFFIX = "_Cal";
    protected final HashMap<String, String[]> targetBandNameToSourceBandName = new HashMap(2);

    public void setOutputImageInComplex(boolean flag) {
        this.outputImageInComplex = flag;
    }

    public void setOutputImageIndB(boolean flag) {
        this.outputImageScaleInDb = flag;
    }

    public void setIncidenceAngleForSigma0(String incidenceAngleForSigma0) {
        this.incidenceAngleSelection = incidenceAngleForSigma0;
    }

    public void getCalibrationFlag() {
        if (this.absRoot.getAttribute("abs_calibration_flag").getData().getElemBoolean()) {
            throw new OperatorException("Absolute radiometric calibration has already been applied to the product");
        }
    }

    public void getSampleType() {
        String sampleType = this.absRoot.getAttributeString("SAMPLE_TYPE");
        if (sampleType.equals("COMPLEX")) {
            this.isComplex = true;
        }
    }

    public Product createTargetProduct(Product sourceProduct, String[] sourceBandNames) {
        this.targetProduct = new Product(sourceProduct.getName() + PRODUCT_SUFFIX, sourceProduct.getProductType(), sourceProduct.getSceneRasterWidth(), sourceProduct.getSceneRasterHeight());
        this.addSelectedBands(sourceProduct, sourceBandNames);
        ProductUtils.copyProductNodes((Product)sourceProduct, (Product)this.targetProduct);
        return this.targetProduct;
    }

    private void addSelectedBands(Product sourceProduct, String[] sourceBandNames) {
        if (this.outputImageInComplex) {
            this.outputInComplex(sourceProduct, sourceBandNames);
        } else {
            this.outputInIntensity(sourceProduct, sourceBandNames);
        }
    }

    private void outputInComplex(Product sourceProduct, String[] sourceBandNames) {
        Band[] sourceBands = OperatorUtils.getSourceBands((Product)sourceProduct, (String[])sourceBandNames, (boolean)false);
        for (int i = 0; i < sourceBands.length; i += 2) {
            Band srcBandI = sourceBands[i];
            String unit = srcBandI.getUnit();
            String nextUnit = null;
            if (unit == null) {
                throw new OperatorException("band " + srcBandI.getName() + " requires a unit");
            }
            if (unit.contains("db")) {
                throw new OperatorException("Calibration of bands in dB is not supported");
            }
            if (unit.contains("imaginary")) {
                throw new OperatorException("I and Q bands should be selected in pairs");
            }
            if (unit.contains("real")) {
                if (i + 1 >= sourceBands.length) {
                    throw new OperatorException("I and Q bands should be selected in pairs");
                }
                nextUnit = sourceBands[i + 1].getUnit();
                if (nextUnit == null || !nextUnit.contains("imaginary")) {
                    throw new OperatorException("I and Q bands should be selected in pairs");
                }
            } else {
                throw new OperatorException("Please select I and Q bands in pairs only");
            }
            Band srcBandQ = sourceBands[i + 1];
            String[] srcBandNames = new String[]{srcBandI.getName(), srcBandQ.getName()};
            this.targetBandNameToSourceBandName.put(srcBandNames[0], srcBandNames);
            Band targetBandI = this.targetProduct.addBand(srcBandNames[0], 30);
            targetBandI.setUnit(unit);
            targetBandI.setNoDataValueUsed(true);
            this.targetBandNameToSourceBandName.put(srcBandNames[1], srcBandNames);
            Band targetBandQ = this.targetProduct.addBand(srcBandNames[1], 30);
            targetBandQ.setUnit(nextUnit);
            targetBandQ.setNoDataValueUsed(true);
            String suffix = '_' + OperatorUtils.getSuffixFromBandName((String)srcBandI.getName());
            ReaderUtils.createVirtualIntensityBand((Product)this.targetProduct, (Band)targetBandI, (Band)targetBandQ, (String)suffix);
        }
    }

    private void outputInIntensity(Product sourceProduct, String[] sourceBandNames) {
        Band[] sourceBands = OperatorUtils.getSourceBands((Product)sourceProduct, (String[])sourceBandNames, (boolean)false);
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)sourceProduct);
        for (int i = 0; i < sourceBands.length; ++i) {
            String targetBandName;
            String[] srcBandNames;
            Band srcBand = sourceBands[i];
            String unit = srcBand.getUnit();
            if (unit == null) {
                throw new OperatorException("band " + srcBand.getName() + " requires a unit");
            }
            String targetUnit = "intensity";
            int targetType = 30;
            if (unit.contains("db")) {
                throw new OperatorException("Calibration of bands in dB is not supported");
            }
            if (unit.contains("phase")) {
                srcBandNames = new String[]{srcBand.getName()};
                targetBandName = srcBand.getName();
                targetType = srcBand.getDataType();
                targetUnit = "phase";
                if (this.targetProduct.getBand(targetBandName) == null) {
                    this.targetBandNameToSourceBandName.put(targetBandName, srcBandNames);
                }
            } else {
                if (unit.contains("imaginary")) {
                    throw new OperatorException("Real and imaginary bands should be selected in pairs");
                }
                if (unit.contains("real")) {
                    if (i + 1 >= sourceBands.length) {
                        throw new OperatorException("Real and imaginary bands should be selected in pairs");
                    }
                    String nextUnit = sourceBands[i + 1].getUnit();
                    if (nextUnit == null || !nextUnit.contains("imaginary")) {
                        throw new OperatorException("Real and imaginary bands should be selected in pairs");
                    }
                    String[] srcBandNames2 = new String[]{srcBand.getName(), sourceBands[i + 1].getName()};
                    targetBandName = this.createTargetBandName(srcBandNames2[0], absRoot);
                    ++i;
                    if (this.targetProduct.getBand(targetBandName) == null) {
                        this.targetBandNameToSourceBandName.put(targetBandName, srcBandNames2);
                    }
                } else {
                    srcBandNames = new String[]{srcBand.getName()};
                    targetBandName = this.createTargetBandName(srcBandNames[0], absRoot);
                    if (this.targetProduct.getBand(targetBandName) == null) {
                        this.targetBandNameToSourceBandName.put(targetBandName, srcBandNames);
                    }
                }
            }
            if (this.targetProduct.getBand(targetBandName) != null) continue;
            Band targetBand = new Band(targetBandName, targetType, srcBand.getRasterWidth(), srcBand.getRasterHeight());
            if (this.outputImageScaleInDb && !targetUnit.equals("phase")) {
                targetUnit = "intensity_db";
            }
            targetBand.setUnit(targetUnit);
            targetBand.setNoDataValueUsed(true);
            this.targetProduct.addBand(targetBand);
        }
    }

    private String createTargetBandName(String srcBandName, MetadataElement absRoot) {
        String pol = OperatorUtils.getBandPolarization((String)srcBandName, (MetadataElement)absRoot);
        String targetBandName = "Sigma0";
        if (pol != null && !pol.isEmpty()) {
            targetBandName = "Sigma0_" + pol.toUpperCase();
        }
        if (this.outputImageScaleInDb) {
            targetBandName = targetBandName + "_dB";
        }
        return targetBandName;
    }
}

