/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.calibration.gpf.calibrators;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.calibration.gpf.support.BaseCalibrator;
import org.esa.s1tbx.calibration.gpf.support.Calibrator;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.Unit;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;
import org.esa.snap.engine_utilities.util.Maths;

public class TerraSARXCalibrator
extends BaseCalibrator
implements Calibrator {
    private String productType = null;
    private String acquisitionMode = null;
    private boolean useIncidenceAngleFromGIM = false;
    private double firstLineUTC = 0.0;
    private double lineTimeInterval = 0.0;
    private int sourceImageWidth = 0;
    private TiePointGrid incidenceAngle = null;
    private TiePointGrid slantRangeTime = null;
    private final HashMap<String, Double> calibrationFactor = new HashMap(2);
    private final HashMap<String, NoiseRecord[]> noiseRecord = new HashMap(2);
    private final HashMap<String, int[]> rangeLineIndex = new HashMap(2);
    private final HashMap<String, double[][]> rangeLineNoise = new HashMap(2);
    private Product sourceGIMProduct = null;
    private boolean noiseCorrectedFlag = false;

    @Override
    public void setExternalAuxFile(File file) throws OperatorException {
        if (file != null) {
            throw new OperatorException("TerraSARXCalibrator: No external auxiliary file should be selected for TerraSAT-X product");
        }
    }

    @Override
    public void setAuxFileFlag(String file) {
    }

    @Override
    public void initialize(Operator op, Product srcProduct, Product tgtProduct, boolean mustPerformRetroCalibration, boolean mustUpdateMetadata) throws OperatorException {
        try {
            this.calibrationOp = op;
            this.sourceProduct = srcProduct;
            this.targetProduct = tgtProduct;
            this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            this.origMetadataRoot = AbstractMetadata.getOriginalProductMetadata((Product)this.sourceProduct);
            this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
            this.getMission();
            this.getAcquisitionMode();
            this.getProductType();
            this.getCalibrationFlag();
            this.getSampleType();
            this.getMetadata();
            this.getCalibrationFactor();
            this.getTiePointGridData();
            if (this.useIncidenceAngleFromGIM) {
                this.getGIMProduct();
            }
            this.getNoiseCorrectedFlag();
            if (!this.noiseCorrectedFlag) {
                this.getNoiseRecords();
                this.computeNoiseForRangeLines();
            }
            if (mustUpdateMetadata) {
                this.updateTargetProductMetadata();
            }
        }
        catch (Exception e) {
            throw new OperatorException("TerraSARXCalibrator: " + e);
        }
    }

    private void getMission() {
        String mission = this.absRoot.getAttributeString("MISSION");
        if (!mission.contains("TSX") && !mission.contains("TDX")) {
            throw new OperatorException("TerraSARXCalibrator: " + mission + " is not a valid mission for TerraSAT-X Calibration");
        }
    }

    private void getAcquisitionMode() {
        this.acquisitionMode = this.absRoot.getAttributeString("ACQUISITION_MODE");
    }

    private void getProductType() {
        this.productType = this.absRoot.getAttributeString("PRODUCT_TYPE");
        if (this.productType.contains("EEC")) {
            this.useIncidenceAngleFromGIM = true;
        }
    }

    private void getCalibrationFactor() {
        MetadataElement[] subElems;
        MetadataElement level1Product = this.origMetadataRoot.getElement("level1Product");
        MetadataElement calibrationElem = level1Product.getElement("calibration");
        for (MetadataElement ele : subElems = calibrationElem.getElements()) {
            if (!ele.getName().contains("calibrationConstant")) continue;
            String pol = ele.getAttributeString("polLayer").toUpperCase();
            double factor = Double.parseDouble(ele.getAttributeString("calFactor"));
            this.calibrationFactor.put(pol, factor);
        }
    }

    private void getMetadata() {
        this.firstLineUTC = this.absRoot.getAttributeUTC("first_line_time").getMJD();
        this.lineTimeInterval = this.absRoot.getAttributeDouble("line_time_interval") / 86400.0;
        if (this.lineTimeInterval == 0.0) {
            throw new OperatorException("Invalid input for Line Time Interval: " + this.lineTimeInterval);
        }
    }

    private void getNoiseCorrectedFlag() {
        MetadataElement level1Product = this.origMetadataRoot.getElement("level1Product");
        MetadataElement processingFlagsElem = level1Product.getElement("processing").getElement("processingFlags");
        if (processingFlagsElem == null) {
            throw new OperatorException("Cannot find \"processingFlags\" element in level1Product metadata");
        }
        this.noiseCorrectedFlag = processingFlagsElem.getAttributeString("noiseCorrectedFlag").contains("true");
        if (this.acquisitionMode.contains("ScanSAR") && !this.noiseCorrectedFlag) {
            throw new OperatorException("Noise correction for ScanSAR is currently not supported.");
        }
    }

    private void getNoiseRecords() {
        MetadataElement[] subElems;
        MetadataElement level1Product = this.origMetadataRoot.getElement("level1Product");
        for (MetadataElement ele : subElems = level1Product.getElements()) {
            MetadataElement[] imageNoiseElem;
            if (!ele.getName().contains("noise")) continue;
            String pol = ele.getAttributeString("polLayer").toUpperCase();
            int numOfNoiseRecords = Integer.parseInt(ele.getAttributeString("numberOfNoiseRecords"));
            if (numOfNoiseRecords != (imageNoiseElem = ele.getElements()).length) {
                throw new OperatorException("TerraSARXCalibrator: The number of noise records does not match the record number.");
            }
            NoiseRecord[] record = new NoiseRecord[numOfNoiseRecords];
            for (int i = 0; i < numOfNoiseRecords; ++i) {
                record[i] = new NoiseRecord();
                record[i].timeUTC = ReaderUtils.getTime((MetadataElement)imageNoiseElem[i], (String)"timeUTC", (DateFormat)AbstractMetadata.dateFormat).getMJD();
                record[i].noiseEstimateConfidence = Double.parseDouble(imageNoiseElem[i].getAttributeString("noiseEstimateConfidence"));
                MetadataElement noiseEstimate = imageNoiseElem[i].getElement("noiseEstimate");
                record[i].validityRangeMin = Double.parseDouble(noiseEstimate.getAttributeString("validityRangeMin"));
                record[i].validityRangeMax = Double.parseDouble(noiseEstimate.getAttributeString("validityRangeMax"));
                record[i].referencePoint = Double.parseDouble(noiseEstimate.getAttributeString("referencePoint"));
                record[i].polynomialDegree = Integer.parseInt(noiseEstimate.getAttributeString("polynomialDegree"));
                MetadataElement[] coefficientElem = noiseEstimate.getElements();
                if (record[i].polynomialDegree + 1 != coefficientElem.length) {
                    throw new OperatorException("TerraSARXCalibrator: The number of coefficients does not match the polynomial degree.");
                }
                record[i].coefficient = new double[record[i].polynomialDegree + 1];
                for (int j = 0; j < coefficientElem.length; ++j) {
                    record[i].coefficient[j] = Double.parseDouble(coefficientElem[j].getAttributeString("coefficient"));
                }
            }
            this.noiseRecord.put(pol, record);
        }
    }

    private void computeNoiseForRangeLines() {
        Set<Map.Entry<String, NoiseRecord[]>> set = this.noiseRecord.entrySet();
        for (Map.Entry<String, NoiseRecord[]> elem : set) {
            String pol = elem.getKey();
            NoiseRecord[] record = elem.getValue();
            int numOfNoiseRecords = record.length;
            double[][] noise = new double[numOfNoiseRecords][this.sourceImageWidth];
            int[] index = new int[numOfNoiseRecords];
            for (int i = 0; i < numOfNoiseRecords; ++i) {
                index[i] = (int)((record[i].timeUTC - this.firstLineUTC) / this.lineTimeInterval + 0.5);
                for (int j = 0; j < this.sourceImageWidth; ++j) {
                    double slantRgTime = this.slantRangeTime.getPixelDouble(j, index[i]) / 1.0E9;
                    noise[i][j] = slantRgTime >= record[i].validityRangeMin && slantRgTime <= record[i].validityRangeMax ? Maths.computePolynomialValue((double)(slantRgTime - record[i].referencePoint), (double[])record[i].coefficient) : 0.0;
                }
            }
            this.rangeLineIndex.put(pol, index);
            this.rangeLineNoise.put(pol, noise);
        }
    }

    private void getTiePointGridData() {
        this.incidenceAngle = OperatorUtils.getIncidenceAngle((Product)this.sourceProduct);
        this.slantRangeTime = OperatorUtils.getSlantRangeTime((Product)this.sourceProduct);
    }

    private void getGIMProduct() {
        try {
            if (this.sourceProduct.getFileLocation() == null) {
                this.useIncidenceAngleFromGIM = false;
                return;
            }
            File sourceGIMFile = new File(this.sourceProduct.getFileLocation().getParentFile(), "AUXRASTER" + File.separator + "GIM.tif");
            if (sourceGIMFile.exists()) {
                this.sourceGIMProduct = ProductIO.readProduct((File)sourceGIMFile);
            } else {
                this.useIncidenceAngleFromGIM = false;
            }
        }
        catch (Exception e) {
            throw new OperatorException("TerraSARXCalibrator: " + e);
        }
    }

    private void updateTargetProductMetadata() {
        MetadataElement abs = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        abs.getAttribute("abs_calibration_flag").getData().setElemBoolean(true);
    }

    @Override
    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle targetTileRectangle = targetTile.getRectangle();
        int x0 = targetTileRectangle.x;
        int y0 = targetTileRectangle.y;
        int w = targetTileRectangle.width;
        int h = targetTileRectangle.height;
        Tile sourceRaster1 = null;
        ProductData srcData1 = null;
        ProductData srcData2 = null;
        Band sourceBand1 = null;
        String[] srcBandNames = (String[])this.targetBandNameToSourceBandName.get(targetBand.getName());
        if (srcBandNames.length == 1) {
            sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
            sourceRaster1 = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand1, targetTileRectangle);
            srcData1 = sourceRaster1.getDataBuffer();
        } else {
            sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
            Band sourceBand2 = this.sourceProduct.getBand(srcBandNames[1]);
            sourceRaster1 = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand1, targetTileRectangle);
            Tile sourceRaster2 = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand2, targetTileRectangle);
            srcData1 = sourceRaster1.getDataBuffer();
            srcData2 = sourceRaster2.getDataBuffer();
        }
        Tile srcGIMTile = null;
        ProductData srcGIMData = null;
        if (this.useIncidenceAngleFromGIM) {
            srcGIMTile = this.calibrationOp.getSourceTile((RasterDataNode)this.sourceGIMProduct.getBand("band_1"), targetTileRectangle);
            srcGIMData = srcGIMTile.getDataBuffer();
        }
        Unit.UnitType tgtBandUnit = Unit.getUnitType((Band)targetBand);
        Unit.UnitType srcBandUnit = Unit.getUnitType((Band)sourceBand1);
        double noDataValue = sourceBand1.getNoDataValue();
        if (tgtBandUnit == Unit.UnitType.PHASE) {
            targetTile.setRawSamples(sourceRaster1.getRawSamples());
            return;
        }
        String pol = OperatorUtils.getBandPolarization((String)srcBandNames[0], (MetadataElement)this.absRoot).toUpperCase();
        double Ks = 0.0;
        if (pol != null) {
            Ks = this.calibrationFactor.get(pol);
        }
        double[][] tileNoise = null;
        if (!this.noiseCorrectedFlag) {
            tileNoise = new double[h][w];
            this.computeTileNoise(pol, x0, y0, w, h, tileNoise);
        }
        ProductData trgData = targetTile.getDataBuffer();
        TileIndex srcIndex = new TileIndex(sourceRaster1);
        TileIndex tgtIndex = new TileIndex(targetTile);
        int maxY = y0 + h;
        int maxX = x0 + w;
        double phaseTerm = 0.0;
        for (int y = y0; y < maxY; ++y) {
            srcIndex.calculateStride(y);
            tgtIndex.calculateStride(y);
            for (int x = x0; x < maxX; ++x) {
                double inciAng;
                double dn2;
                int srcIdx = srcIndex.getIndex(x);
                int tgtIdx = tgtIndex.getIndex(x);
                if (srcBandUnit == Unit.UnitType.AMPLITUDE) {
                    double dn = srcData1.getElemDoubleAt(srcIdx);
                    dn2 = dn * dn;
                } else if (srcBandUnit == Unit.UnitType.INTENSITY) {
                    dn2 = srcData1.getElemDoubleAt(srcIdx);
                } else if (srcBandUnit == Unit.UnitType.REAL) {
                    double i = srcData1.getElemDoubleAt(srcIdx);
                    double q = srcData2.getElemDoubleAt(srcIdx);
                    dn2 = i * i + q * q;
                    if (tgtBandUnit == Unit.UnitType.REAL) {
                        phaseTerm = i / Math.sqrt(dn2);
                    } else if (tgtBandUnit == Unit.UnitType.IMAGINARY) {
                        phaseTerm = q / Math.sqrt(dn2);
                    }
                } else if (srcBandUnit == Unit.UnitType.INTENSITY_DB) {
                    dn2 = FastMath.pow((double)10.0, (double)(srcData1.getElemDoubleAt(srcIdx) / 10.0));
                } else {
                    throw new OperatorException("TerraSAR-X Calibration: unhandled unit");
                }
                if (this.useIncidenceAngleFromGIM) {
                    int gim = srcGIMData.getElemIntAt(srcIdx);
                    inciAng = (double)(gim - gim % 10) / 100.0 * (Math.PI / 180);
                } else {
                    inciAng = this.incidenceAngle.getPixelDouble(x, y) * (Math.PI / 180);
                }
                double sigma = this.noiseCorrectedFlag ? Ks * dn2 * FastMath.sin((double)inciAng) : Ks * Math.abs(dn2 - tileNoise[y - y0][x - x0]) * FastMath.sin((double)inciAng);
                if (this.isComplex && this.outputImageInComplex) {
                    sigma = Math.sqrt(sigma) * phaseTerm;
                }
                if (this.outputImageScaleInDb) {
                    sigma = sigma < 1.0E-30 ? -1.0E-30 : 10.0 * Math.log10(sigma);
                }
                trgData.setElemDoubleAt(tgtIdx, sigma);
            }
        }
    }

    private void computeTileNoise(String pol, int x0, int y0, int w, int h, double[][] tileNoise) {
        int[] indexArray = this.rangeLineIndex.get(pol);
        double[][] noise = this.rangeLineNoise.get(pol);
        int i1 = 0;
        int i2 = 0;
        int y1 = 0;
        int y2 = 0;
        for (int y = y0; y < y0 + h; ++y) {
            for (int i = 0; i < indexArray.length; ++i) {
                if (indexArray[i] > y) {
                    i2 = i;
                    y2 = indexArray[i];
                    break;
                }
                i1 = i;
                y1 = indexArray[i];
            }
            if (y1 == indexArray[indexArray.length - 1]) {
                y2 = y1;
                i2 = i1;
            } else if (y1 > y2) {
                throw new OperatorException("TerraSARXCalibrator: No noise is defined for pixel with y = " + y);
            }
            for (int x = x0; x < x0 + w; ++x) {
                double n1 = noise[i1][x];
                double n2 = noise[i2][x];
                double mu = 0.0;
                if (y1 != y2) {
                    mu = (double)(y - y1) / (double)(y2 - y1);
                }
                tileNoise[y - y0][x - x0] = Maths.interpolationLinear((double)n1, (double)n2, (double)mu);
            }
        }
    }

    @Override
    public double applyCalibration(double v, double rangeIndex, double azimuthIndex, double slantRange, double satelliteHeight, double sceneToEarthCentre, double localIncidenceAngle, String bandName, String bandPolar, Unit.UnitType bandUnit, int[] subSwathIndex) {
        double sigma = 0.0;
        if (bandUnit == Unit.UnitType.AMPLITUDE) {
            sigma = v * v;
        } else if (bandUnit == Unit.UnitType.INTENSITY || bandUnit == Unit.UnitType.REAL || bandUnit == Unit.UnitType.IMAGINARY) {
            sigma = v;
        } else if (bandUnit == Unit.UnitType.INTENSITY_DB) {
            sigma = FastMath.pow((double)10.0, (double)(v / 10.0));
        } else {
            throw new OperatorException("TerraSARXCalibrator: Unknown band unit");
        }
        double Ks = this.calibrationFactor.get(bandPolar.toUpperCase());
        return sigma *= Ks * FastMath.sin((double)(localIncidenceAngle * (Math.PI / 180)));
    }

    @Override
    public double applyRetroCalibration(int x, int y, double v, String bandPolar, Unit.UnitType bandUnit, int[] subSwathIndex) {
        return v;
    }

    @Override
    public void removeFactorsForCurrentTile(Band targetBand, Tile targetTile, String srcBandName) throws OperatorException {
        Band sourceBand = this.sourceProduct.getBand(targetBand.getName());
        Tile sourceTile = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand, targetTile.getRectangle());
        targetTile.setRawSamples(sourceTile.getRawSamples());
    }

    private static final class NoiseRecord {
        public double timeUTC;
        public double noiseEstimateConfidence;
        public double validityRangeMin;
        public double validityRangeMax;
        public double referencePoint;
        public int polynomialDegree;
        public double[] coefficient;

        private NoiseRecord() {
        }
    }
}

