/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.calibration.gpf.calibrators;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferDouble;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.media.jai.BorderExtender;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.SubsampleAverageDescriptor;
import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.calibration.gpf.support.BaseCalibrator;
import org.esa.s1tbx.calibration.gpf.support.Calibrator;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.dataio.envisat.EnvisatAuxReader;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.DownloadableArchive;
import org.esa.snap.engine_utilities.datamodel.Unit;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.util.ResourceUtils;
import org.esa.snap.engine_utilities.util.Settings;

public final class ERSCalibrator
extends BaseCalibrator
implements Calibrator {
    private String pafID;
    private String psID;
    private String pvID;
    private String extXCAFileName;
    private int sourceImageWidth;
    private int sourceImageHeight;
    private int windowWidth;
    private int windowHeight;
    private int blockWidth;
    private int blockHeight;
    private boolean applyAntennaPatternCorrection = false;
    private boolean applyRangeSpreadingLossCorrection = false;
    private boolean applyReplicaPowerCorrection = false;
    private boolean applyADCSaturationCorrection = false;
    private boolean isERS1Mission = false;
    private boolean isCEOSFormat = false;
    private boolean isAntPattAvailable = false;
    private boolean adcHasBeenTestedFlag = false;
    private boolean antennaPatternCorrectionFlag = false;
    private boolean rangeSpreadingLossCompFlag = false;
    private boolean useExtXCAFile = false;
    private boolean multilookFlag = false;
    private double rangeSpacing;
    private double azimuthSpacing;
    private double calibrationConstant;
    private double sceneCentreLatitude;
    private double replicaPulseVariationsCorrectionFactor;
    private double elevationAngle;
    private Date processingTime;
    private Date acquisitionTime;
    private Date time19910801;
    private Date time19920401;
    private Date time19920414;
    private Date time19920901;
    private Date time19930408;
    private Date time19930628;
    private Date time19941207;
    private Date time19950317;
    private Date time19950713;
    private Date time19950716;
    private Date time19951016;
    private Date time19970120;
    private Date time19980224;
    private Date time20040904;
    private Date time20041014;
    private double[] incidenceAngles = null;
    private double[] lookAngles = null;
    private double[] rangeSpreadingLoss = null;
    private double[] antennaPatternCorrFactor = null;
    private double[] antennaPatternGain = null;
    private double[][] appendixF1 = null;
    private double[][] appendixF2 = null;
    private double[][] appendixG1 = null;
    private double[][] appendixG2 = null;
    private double[][] appendixG3 = null;
    private double[][] appendixH = null;
    private float[] antPatForPGS = null;
    private int numMPPRecords;
    private static final double referenceIncidenceAngle = 0.4014257279586958;
    private static final double relativeLookAngle = 20.355;
    private static final double aGEM6 = 6378144.0;
    private static final double bGEM6 = 6356759.0;
    private static final double aWGS84 = 6378137.0;
    private static final double bWGS84 = 6356752.314245179;
    private static final double referenceSlantRange = 847000.0;
    private static final double windowDimInRange = 15000.0;
    private static final double windowDimInAzimuth = 5000.0;
    private static final double downSampleBlockSize = 100.0;
    private static final double ers1ApplyADCThreshold = -7.0;
    private static final double ers2ApplyADCThreshold = -2.0;
    private static final String D_PAF = "D-PAF";
    private static final String I_PAF = "I-PAF";
    private static final String UK_PAF = "UK-PAF";
    private static final String ESRIN = "ES";
    private static final String VMP = "VMP";

    @Override
    public void setExternalAuxFile(File file) throws OperatorException {
        if (file != null) {
            throw new OperatorException("No external auxiliary file should be selected for ERS product");
        }
    }

    @Override
    public void setAuxFileFlag(String file) {
    }

    @Override
    public void initialize(Operator op, Product srcProduct, Product tgtProduct, boolean mustPerformRetroCalibration, boolean mustUpdateMetadata) throws OperatorException {
        try {
            this.calibrationOp = op;
            this.sourceProduct = srcProduct;
            this.targetProduct = tgtProduct;
            this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
            this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
            this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            this.origMetadataRoot = AbstractMetadata.getOriginalProductMetadata((Product)this.sourceProduct);
            this.getImportantTimes();
            this.getMissionType();
            this.getSampleType();
            this.getProductType();
            this.getCalibrationFlags();
            this.getMultilookFlag();
            this.getPixelSpacings();
            this.getProcessingTime();
            this.getProcessingSystemID();
            this.getProductAcquisitionTime();
            if (this.isCEOSFormat) {
                this.getProcessingFacilityIDFromCEOS();
                this.getProcessingVersionID();
                this.getSceneCentreLatitude();
                this.getCalibrationConstantFromCEOS();
            } else {
                this.getProcessingFacilityIDFromENVISAT();
                this.getNumOfRecordsInMainProcParam();
                this.calibrationConstant = this.absRoot.getAttributeDouble("calibration_factor");
            }
            if (this.absRoot.getAttribute("retro-calibration performed flag") != null) {
                this.setCalibrationFlags();
            } else {
                this.setCorrectionFlags();
            }
            if (this.applyADCSaturationCorrection) {
                this.prepareForADCCorrection();
            }
            if (this.applyAntennaPatternCorrection || this.applyADCSaturationCorrection) {
                this.getAntennaPatternFromFile();
            }
            if (this.applyReplicaPowerCorrection || this.applyADCSaturationCorrection) {
                this.computeReplicaPulseVariationsCorrectionFactor();
            }
            if (this.isCEOSFormat) {
                this.computeIncidenceAnglesLookAnglesRangeSpreadingLossForCEOS();
            } else {
                this.computeIncidenceAnglesLookAnglesRangeSpreadingLossForENVISAT();
            }
            if (mustUpdateMetadata) {
                this.updateTargetProductMetadata();
            }
        }
        catch (Exception e) {
            throw new OperatorException((Throwable)e);
        }
    }

    @Override
    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        try {
            Rectangle targetTileRectangle = targetTile.getRectangle();
            int x0 = targetTileRectangle.x;
            int y0 = targetTileRectangle.y;
            int w = targetTileRectangle.width;
            int h = targetTileRectangle.height;
            ProductData trgData = targetTile.getDataBuffer();
            Band sourceBand1 = null;
            Band sourceBand2 = null;
            Tile sourceRaster1 = null;
            Tile sourceRaster2 = null;
            ProductData srcData1 = null;
            ProductData srcData2 = null;
            String[] srcBandNames = (String[])this.targetBandNameToSourceBandName.get(targetBand.getName());
            if (srcBandNames.length == 1) {
                sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
                sourceRaster1 = this.getSourceTile((RasterDataNode)sourceBand1, targetTileRectangle);
                srcData1 = sourceRaster1.getDataBuffer();
            } else {
                sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
                sourceBand2 = this.sourceProduct.getBand(srcBandNames[1]);
                sourceRaster1 = this.getSourceTile((RasterDataNode)sourceBand1, targetTileRectangle);
                sourceRaster2 = this.getSourceTile((RasterDataNode)sourceBand2, targetTileRectangle);
                srcData1 = sourceRaster1.getDataBuffer();
                srcData2 = sourceRaster2.getDataBuffer();
            }
            Unit.UnitType tgtBandUnit = Unit.getUnitType((Band)targetBand);
            Unit.UnitType srcBandUnit = Unit.getUnitType((Band)sourceBand1);
            if (tgtBandUnit == Unit.UnitType.PHASE) {
                targetTile.setRawSamples(sourceRaster1.getRawSamples());
                return;
            }
            if (this.applyAntennaPatternCorrection && !this.isAntPattAvailable) {
                this.computeAntennaPatternCorrectionFactors(0, this.sourceImageWidth);
            }
            if (this.applyADCSaturationCorrection && !this.adcHasBeenTestedFlag) {
                this.testADC(sourceBand1, sourceBand2, srcBandUnit);
            }
            boolean applyADCSaturationCorrectionToCurrentTile = false;
            if (this.applyADCSaturationCorrection && h >= this.blockHeight && w >= this.blockWidth) {
                applyADCSaturationCorrectionToCurrentTile = true;
            }
            double[][] adcPowerLoss = null;
            if (applyADCSaturationCorrectionToCurrentTile) {
                adcPowerLoss = this.computeADCPowerLossValuesForCurrentTile(sourceBand1, sourceBand2, x0, y0, w, h, srcBandUnit);
            }
            double k = this.calibrationConstant * FastMath.sin((double)0.4014257279586958);
            int maxY = y0 + h;
            int maxX = x0 + w;
            double phaseTerm = 0.0;
            int adcJ = 0;
            for (int x = x0; x < maxX; ++x) {
                double sinIncidenceAngleByK = FastMath.sin((double)this.incidenceAngles[x]) / k;
                if (applyADCSaturationCorrectionToCurrentTile) {
                    adcJ = Math.min((x - x0) / this.blockWidth, adcPowerLoss[0].length - 1);
                }
                for (int y = y0; y < maxY; ++y) {
                    double dn2;
                    int index = sourceRaster1.getDataBufferIndex(x, y);
                    if (srcBandUnit == Unit.UnitType.AMPLITUDE) {
                        double dn = srcData1.getElemDoubleAt(index);
                        dn2 = dn * dn;
                    } else if (srcBandUnit == Unit.UnitType.INTENSITY) {
                        dn2 = srcData1.getElemDoubleAt(index);
                    } else if (srcBandUnit == Unit.UnitType.REAL) {
                        double i = srcData1.getElemDoubleAt(index);
                        double q = srcData2.getElemDoubleAt(index);
                        dn2 = i * i + q * q;
                        if (tgtBandUnit == Unit.UnitType.REAL) {
                            phaseTerm = i / Math.sqrt(dn2);
                        } else if (tgtBandUnit == Unit.UnitType.IMAGINARY) {
                            phaseTerm = q / Math.sqrt(dn2);
                        }
                    } else if (srcBandUnit == Unit.UnitType.INTENSITY_DB) {
                        dn2 = FastMath.pow((double)10.0, (double)(srcData1.getElemDoubleAt(index) / 10.0));
                    } else {
                        throw new OperatorException("ERS Calibration: unhandled unit");
                    }
                    double calFactor = sinIncidenceAngleByK;
                    if (this.applyAntennaPatternCorrection) {
                        calFactor *= this.antennaPatternCorrFactor[x];
                    }
                    if (this.applyRangeSpreadingLossCorrection) {
                        calFactor *= this.rangeSpreadingLoss[x];
                    }
                    if (this.applyReplicaPowerCorrection) {
                        calFactor *= this.replicaPulseVariationsCorrectionFactor;
                    }
                    if (applyADCSaturationCorrectionToCurrentTile) {
                        int adcI = Math.min((y - y0) / this.blockHeight, adcPowerLoss.length - 1);
                        calFactor *= adcPowerLoss[adcI][adcJ];
                    }
                    double sigma = dn2 * calFactor;
                    if (this.isComplex && this.outputImageInComplex) {
                        sigma = Math.sqrt(sigma) * phaseTerm;
                    }
                    if (this.outputImageScaleInDb) {
                        sigma = sigma < 1.0E-30 ? -1.0E-30 : 10.0 * Math.log10(sigma);
                    }
                    trgData.setElemDoubleAt(targetTile.getDataBufferIndex(x, y), sigma);
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"ERSCalibrator", (Throwable)e);
        }
    }

    private synchronized void testADC(Band sourceBand1, Band sourceBand2, Unit.UnitType bandUnit) {
        if (this.adcHasBeenTestedFlag) {
            return;
        }
        if (!this.isADCNeeded(sourceBand1, sourceBand2, bandUnit)) {
            this.applyADCSaturationCorrection = false;
        }
        if (this.antennaPatternCorrectionFlag) {
            this.computeAntennaPatternGain(0, this.sourceImageWidth);
        }
        this.adcHasBeenTestedFlag = true;
    }

    private void getImportantTimes() {
        SimpleDateFormat dateformat = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss.SSS");
        try {
            this.time19910801 = dateformat.parse("01-Aug-1991 00:00:00.000");
            this.time19920401 = dateformat.parse("01-Apr-1992 00:00:00.000");
            this.time19920414 = dateformat.parse("14-Apr-1992 00:00:00.000");
            this.time19920901 = dateformat.parse("01-Sep-1992 00:00:00.000");
            this.time19930408 = dateformat.parse("08-Apr-1993 00:00:00.000");
            this.time19930628 = dateformat.parse("28-Jun-1993 00:00:00.000");
            this.time19941207 = dateformat.parse("07-Dec-1994 00:00:00.000");
            this.time19950317 = dateformat.parse("17-Mar-1995 00:00:00.000");
            this.time19950713 = dateformat.parse("13-Jul-1995 00:00:00.000");
            this.time19950716 = dateformat.parse("16-Jul-1995 00:00:00.000");
            this.time19951016 = dateformat.parse("16-Oct-1995 00:00:00.000");
            this.time19970120 = dateformat.parse("20-Jan-1997 00:00:00.000");
            this.time19980224 = dateformat.parse("24-Feb-1998 00:00:00.000");
            this.time20040904 = dateformat.parse("04-Sep-2004 10:04:14.000");
            this.time20041014 = dateformat.parse("14-Oct-2004 14:37:11.000");
        }
        catch (ParseException e) {
            throw new OperatorException((Throwable)e);
        }
    }

    private static double convertUTCTimes(String utcTime) {
        SimpleDateFormat simpledateformat;
        double timeInSecond = 0.0;
        if (utcTime.length() == 23) {
            simpledateformat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss.SSS");
        } else if (utcTime.length() == 24) {
            simpledateformat = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss.SSS");
        } else {
            throw new OperatorException("Incorrect UTC time string");
        }
        simpledateformat.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            timeInSecond = (double)simpledateformat.parse(utcTime).getTime() / 1000.0;
        }
        catch (ParseException e) {
            throw new OperatorException((Throwable)e);
        }
        return timeInSecond;
    }

    private void getMissionType() {
        String missionType = this.absRoot.getAttributeString("MISSION");
        if (!missionType.equals("ERS1") && !missionType.equals("ERS2")) {
            throw new OperatorException(missionType + " is not a valid mission for ERS Calibration");
        }
        if (missionType.equals("ERS1")) {
            this.isERS1Mission = true;
        }
    }

    private void getProductType() {
        String productType = this.absRoot.getAttributeString("PRODUCT_TYPE");
        if (productType.contains("ERS")) {
            this.isCEOSFormat = true;
        } else if (productType.contains("SAR")) {
            this.isCEOSFormat = false;
        } else {
            throw new OperatorException("Invalid product type: " + productType);
        }
    }

    private void getProcessingFacilityIDFromCEOS() {
        MetadataElement facility = this.origMetadataRoot.getElement("Leader").getElement("Scene Parameters");
        if (facility == null) {
            throw new OperatorException("Scene Parameters not found");
        }
        MetadataAttribute attr = facility.getAttribute("Processing facility identifier");
        if (attr == null) {
            throw new OperatorException("Processing facility identifier not found");
        }
        this.pafID = attr.getData().getElemString();
    }

    private void getProcessingSystemID() {
        this.psID = this.absRoot.getAttributeString("Processing_system_identifier");
    }

    private void getProcessingVersionID() {
        MetadataElement facility = this.origMetadataRoot.getElement("Leader").getElement("Scene Parameters");
        if (facility == null) {
            throw new OperatorException("Scene Parameters not found");
        }
        MetadataAttribute attr = facility.getAttribute("Processing version identifier");
        if (attr == null) {
            throw new OperatorException("Processing version identifier not found");
        }
        this.pvID = attr.getData().getElemString();
    }

    private void getProductAcquisitionTime() {
        try {
            ProductData.UTC acqTimeUTC = AbstractMetadata.parseUTC((String)this.absRoot.getAttributeString("first_line_time"));
            this.acquisitionTime = acqTimeUTC.getAsDate();
        }
        catch (Exception e) {
            throw new OperatorException(e.getMessage());
        }
    }

    private void getProcessingTime() {
        try {
            ProductData.UTC procTimeUTC = AbstractMetadata.parseUTC((String)this.absRoot.getAttributeString("PROC_TIME"));
            this.processingTime = procTimeUTC.getAsDate();
        }
        catch (Exception e) {
            throw new OperatorException(e.getMessage());
        }
    }

    private void getPixelSpacings() throws Exception {
        this.rangeSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)this.absRoot, (String)"range_spacing");
        this.azimuthSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)this.absRoot, (String)"azimuth_spacing");
    }

    private void getCalibrationFlags() throws Exception {
        if (AbstractMetadata.getAttributeBoolean((MetadataElement)this.absRoot, (String)"abs_calibration_flag")) {
            throw new OperatorException("The product has already been calibrated");
        }
        this.antennaPatternCorrectionFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)this.absRoot, (String)"ant_elev_corr_flag");
        this.rangeSpreadingLossCompFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)this.absRoot, (String)"range_spread_comp_flag");
    }

    private void getMultilookFlag() throws Exception {
        this.multilookFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)this.absRoot, (String)"multilook_flag");
    }

    private void setCalibrationFlags() {
        this.applyAntennaPatternCorrection = true;
        this.applyRangeSpreadingLossCorrection = true;
        this.applyReplicaPowerCorrection = true;
        this.applyADCSaturationCorrection = false;
    }

    private void setCorrectionFlags() {
        this.applyAntennaPatternCorrection = false;
        this.applyRangeSpreadingLossCorrection = false;
        this.applyReplicaPowerCorrection = false;
        this.applyADCSaturationCorrection = false;
        if (this.isERS1Mission) {
            if (!this.isComplex) {
                if (this.psID.contains(VMP) && this.processingTime.compareTo(this.time19910801) >= 0 && this.processingTime.compareTo(this.time19950716) < 0) {
                    this.applyAntennaPatternCorrection = true;
                }
                this.applyReplicaPowerCorrection = true;
                this.applyADCSaturationCorrection = true;
            } else {
                if (!this.antennaPatternCorrectionFlag) {
                    this.applyAntennaPatternCorrection = true;
                }
                if (!this.rangeSpreadingLossCompFlag) {
                    this.applyRangeSpreadingLossCorrection = true;
                }
                this.applyReplicaPowerCorrection = true;
                this.applyADCSaturationCorrection = true;
            }
        } else if (!this.isComplex) {
            this.applyADCSaturationCorrection = true;
        } else {
            if (!this.antennaPatternCorrectionFlag) {
                this.applyAntennaPatternCorrection = true;
            }
            if (!this.rangeSpreadingLossCompFlag) {
                this.applyRangeSpreadingLossCorrection = true;
            }
            this.applyADCSaturationCorrection = true;
        }
        if (this.applyADCSaturationCorrection) {
            this.adcHasBeenTestedFlag = false;
        }
    }

    private void getCalibrationConstantFromCEOS() {
        MetadataElement facility = this.origMetadataRoot.getElement("Leader").getElement("Facility Related");
        if (facility == null) {
            throw new OperatorException("Facility Related not found");
        }
        MetadataAttribute calibrationConstantAttr = facility.getAttribute("Absolute calibration constant K");
        if (calibrationConstantAttr == null) {
            throw new OperatorException("Absolute calibration constant K not found");
        }
        this.calibrationConstant = calibrationConstantAttr.getData().getElemFloat();
    }

    private void getSceneCentreLatitude() {
        MetadataElement facility = this.origMetadataRoot.getElement("Leader").getElement("Scene Parameters");
        if (facility == null) {
            throw new OperatorException("Scene Parameters not found");
        }
        MetadataAttribute attr = facility.getAttribute("scene centre geodetic latitude");
        if (attr == null) {
            throw new OperatorException("Scene centre geodetic latitude not found");
        }
        this.sceneCentreLatitude = attr.getData().getElemFloat();
    }

    private void getAntennaPatternFromFile() throws IOException {
        if (this.isERS1Mission) {
            if (this.psID.contains(VMP)) {
                if (this.processingTime.compareTo(this.time19920901) >= 0 && this.processingTime.compareTo(this.time19950716) < 0 && (this.pafID.contains(ESRIN) || this.pafID.contains(D_PAF) || this.pafID.contains(I_PAF) || this.pafID.contains(UK_PAF))) {
                    this.getInitialERS1ElevAntPat();
                }
                if (this.processingTime.compareTo(this.time19910801) >= 0) {
                    this.getImprovedERS1ElevAntPat();
                }
                if (this.processingTime.compareTo(this.time19920901) >= 0 && this.processingTime.compareTo(this.time19930408) <= 0 && this.pafID.contains(UK_PAF)) {
                    this.getUKPAFElevAntPatCor();
                }
            } else {
                try {
                    File localFolder = SystemUtils.getAuxDataPath().resolve("AuxCal").resolve("ERS").toFile();
                    URL remotePath = new URL(Settings.getPath((String)"AuxCal.ERS.remotePath"));
                    File xcaFile = new File(localFolder, "ER1_XCA_AXNXXX20050321_000000_19910101_000000_20100101_000000.zip");
                    if (!xcaFile.exists()) {
                        File localFile = new File(localFolder, "ERS_XCA.zip");
                        DownloadableArchive archive = new DownloadableArchive(localFile, remotePath);
                        archive.getContentFiles();
                    }
                    this.getAntennaPatternGainFromAuxData(xcaFile);
                    this.extXCAFileName = "ER1_XCA_AXNXXX20050321_000000_19910101_000000_20100101_000000.zip";
                    this.useExtXCAFile = true;
                }
                catch (Exception e) {
                    throw new IOException("Unable to read ERS XCA file " + e.getMessage());
                }
            }
        } else if (this.psID.contains(VMP)) {
            this.getERS2ElevAntPat();
        } else {
            try {
                File localFolder = SystemUtils.getAuxDataPath().resolve("AuxCal").resolve("ERS").toFile();
                URL remotePath = new URL(Settings.getPath((String)"AuxCal.ERS.remotePath"));
                File xcaFile = new File(localFolder, "ER2_XCA_AXNXXX20050321_000000_19950101_000000_20100101_000000.zip");
                if (!xcaFile.exists()) {
                    File localFile = new File(localFolder, "ERS_XCA.zip");
                    DownloadableArchive archive = new DownloadableArchive(localFile, remotePath);
                    archive.getContentFiles();
                }
                this.getAntennaPatternGainFromAuxData(xcaFile);
                this.extXCAFileName = "ER2_XCA_AXNXXX20050321_000000_19950101_000000_20100101_000000.zip";
                this.useExtXCAFile = true;
            }
            catch (Exception e) {
                throw new IOException("Unable to read ERS XCA file " + e.getMessage());
            }
        }
    }

    private void getInitialERS1ElevAntPat() throws IOException {
        String fileName = "Appendix_G1.txt";
        this.appendixG1 = ERSCalibrator.readFile(this.getERSAuxFile("Appendix_G1.txt"), "Appendix_G1.txt");
    }

    private void getImprovedERS1ElevAntPat() throws IOException {
        String fileName = "";
        if (this.processingTime.compareTo(this.time19950716) >= 0 && this.pvID.compareTo("6.8") < 0) {
            fileName = "Appendix_G2_b.txt";
        } else if (this.pvID.compareTo("6.8") >= 0) {
            fileName = "Appendix_G2_c.txt";
        } else {
            throw new OperatorException("The operator does not support VMP product processed before 1995-07-16");
        }
        this.appendixG2 = ERSCalibrator.readFile(this.getERSAuxFile(fileName), fileName);
    }

    private void getUKPAFElevAntPatCor() throws IOException {
        String fileName = "";
        if (this.acquisitionTime.compareTo(this.time19920401) <= 0) {
            fileName = "Appendix_H_1.txt";
        } else if (this.acquisitionTime.compareTo(this.time19920414) >= 0 && this.acquisitionTime.compareTo(this.time19930408) <= 0) {
            fileName = "Appendix_H_2.txt";
        } else {
            throw new OperatorException("Incorrect acquisition date");
        }
        this.appendixH = ERSCalibrator.readFile(this.getERSAuxFile(fileName), fileName);
    }

    private void getERS2ElevAntPat() throws IOException {
        String fileName = "";
        if (this.pvID.compareTo("6.8") < 0) {
            fileName = "Appendix_G3_b.txt";
        } else if (this.pvID.compareTo("6.8") >= 0) {
            fileName = "Appendix_G3_c.txt";
        }
        this.appendixG3 = ERSCalibrator.readFile(this.getERSAuxFile(fileName), fileName);
    }

    private InputStream getERSAuxFile(String fileName) throws IOException {
        String path = "org/esa/s1tbx/auxdata/ers/" + fileName;
        return ResourceUtils.getResourceAsStream((String)path, this.getClass());
    }

    private static double[][] readFile(InputStream stream, String fileName) {
        double[][] array;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String line = "";
        int rowIdx = 0;
        try {
            line = reader.readLine();
            if (line == null) {
                throw new OperatorException("Empty file: " + fileName);
            }
            StringTokenizer st = new StringTokenizer(line);
            if (st.countTokens() != 2) {
                throw new OperatorException("Incorrect file format: " + fileName);
            }
            int numRows = Integer.parseInt(st.nextToken());
            int numCols = Integer.parseInt(st.nextToken());
            array = new double[numRows][numCols];
            while ((line = reader.readLine()) != null) {
                st = new StringTokenizer(line);
                if (st.countTokens() != numCols) {
                    throw new OperatorException("Incorrect file format: " + fileName);
                }
                for (int j = 0; j < numCols; ++j) {
                    array[rowIdx][j] = Double.parseDouble(st.nextToken());
                }
                ++rowIdx;
            }
            if (numRows != rowIdx) {
                throw new OperatorException("Incorrect number of lines in file: " + fileName);
            }
            reader.close();
            stream.close();
        }
        catch (IOException e) {
            throw new OperatorException((Throwable)e);
        }
        return array;
    }

    private void getAntennaPatternGainFromAuxData(File file) throws OperatorException {
        EnvisatAuxReader reader = new EnvisatAuxReader();
        try {
            reader.readProduct((Object)file);
            ProductData elevAngleData = reader.getAuxData("elev_ang_is2");
            this.elevationAngle = elevAngleData.getElemFloat();
            ProductData patData = reader.getAuxData("pattern_is2");
            float[] pattern = (float[])patData.getElems();
            if (pattern.length != 804) {
                throw new OperatorException("Incorrect array length for pattern_is2");
            }
            int numOfGains = 201;
            this.antPatForPGS = new float[201];
            System.arraycopy(pattern, 201, this.antPatForPGS, 0, 201);
        }
        catch (IOException e) {
            throw new OperatorException((Throwable)e);
        }
    }

    private static double getChirpAverageDensityImage() {
        return 267.2;
    }

    private void computeReplicaPulseVariationsCorrectionFactor() {
        double replicaPulsePower = this.isCEOSFormat ? this.getReplicaPulsePowerForCEOS() : this.getReplicaPulsePowerForENVISAT();
        this.replicaPulseVariationsCorrectionFactor = Double.compare(replicaPulsePower, -9999999.9999999) == 0 || Double.compare(replicaPulsePower, 0.0) == 0 ? 1.0 : (this.isERS1Mission ? replicaPulsePower / 205229.0 : replicaPulsePower / 156000.0);
    }

    private double getReplicaPulsePowerForCEOS() {
        MetadataElement facility = this.origMetadataRoot.getElement("Leader").getElement("Facility Related");
        if (facility == null) {
            throw new OperatorException("Facility Related not found");
        }
        MetadataAttribute attr = facility.getAttribute("Replica pulse power");
        if (attr == null) {
            throw new OperatorException("Replica pulse power");
        }
        return attr.getData().getElemFloat();
    }

    private void computeIncidenceAnglesLookAnglesRangeSpreadingLossForCEOS() {
        double b;
        double a;
        this.incidenceAngles = new double[this.sourceImageWidth];
        this.lookAngles = new double[this.sourceImageWidth];
        this.rangeSpreadingLoss = new double[this.sourceImageWidth];
        if (this.psID.contains(VMP)) {
            a = 6378144.0;
            b = 6356759.0;
        } else {
            a = 6378137.0;
            b = 6356752.314245179;
        }
        double lambda = this.sceneCentreLatitude * (Math.PI / 180);
        double alpha1 = this.getIncidenceAngleAtFirstRangePixel() * (Math.PI / 180);
        double cos2 = FastMath.pow((double)FastMath.cos((double)lambda), (double)2.0);
        double sin2 = FastMath.pow((double)FastMath.sin((double)lambda), (double)2.0);
        double e2 = FastMath.pow((double)(b / a), (double)2.0);
        double rt = a * Math.sqrt((cos2 + e2 * e2 * sin2) / (cos2 + e2 * sin2));
        double rt2 = rt * rt;
        double deltaPsi = this.rangeSpacing / rt;
        double r1 = 1.49896229E8 * this.getSlantRangeTimeToFirstRangePixel();
        double psi = 0.0;
        double alpha = 0.0;
        double ri = 0.0;
        if (!this.pafID.contains(UK_PAF) || this.processingTime.compareTo(this.time19930408) >= 0) {
            double rtPlusH = Math.sqrt(rt2 + r1 * r1 + 2.0 * rt * r1 * FastMath.cos((double)alpha1));
            double rtPlusH2 = rtPlusH * rtPlusH;
            double theta1 = FastMath.acos((double)((r1 + rt * FastMath.cos((double)alpha1)) / rtPlusH));
            double psi1 = alpha1 - theta1;
            for (int i = 0; i < this.sourceImageWidth; ++i) {
                if (!this.isComplex) {
                    psi = psi1 + (double)i * deltaPsi;
                    ri = Math.sqrt(rt2 + rtPlusH2 - 2.0 * rt * rtPlusH * FastMath.cos((double)psi));
                } else {
                    ri = r1 + (double)i * this.rangeSpacing;
                }
                this.incidenceAngles[i] = alpha = FastMath.acos((double)((rtPlusH2 - ri * ri - rt2) / (2.0 * ri * rt)));
                this.lookAngles[i] = FastMath.acos((double)((ri + rt * FastMath.cos((double)alpha)) / rtPlusH));
                this.rangeSpreadingLoss[i] = FastMath.pow((double)(ri / 847000.0), (double)3.0);
            }
        } else {
            double del = this.getTimeIntervalBetweenDataPoints();
            double firstLineTime = this.getZeroDopplerAzimuthTimeOfFirstAzimuthPixel();
            double middleLineTime = this.getZeroDopplerAzimuthTimeOfCentreAzimuthPixel();
            int k = (int)((middleLineTime - firstLineTime) / del + 0.5);
            double[] positionVector = new double[3];
            this.getPositionVector(k, positionVector);
            double x = positionVector[0];
            double y = positionVector[1];
            double z = positionVector[2];
            double rtPlusH = Math.sqrt(x * x + y * y + z * z);
            double rtPlusH2 = rtPlusH * rtPlusH;
            double theta1 = FastMath.asin((double)(FastMath.sin((double)alpha1) * rt / rtPlusH));
            double psi1 = alpha1 - theta1;
            for (int i = 0; i < this.sourceImageWidth; ++i) {
                if (!this.isComplex) {
                    psi = psi1 + FastMath.asin((double)((double)i * deltaPsi));
                    ri = Math.sqrt(rt2 + rtPlusH2 - 2.0 * rt * rtPlusH * FastMath.cos((double)psi));
                } else {
                    ri = r1 + (double)i * this.rangeSpacing;
                }
                this.incidenceAngles[i] = alpha = FastMath.acos((double)((rtPlusH2 - ri * ri - rt2) / (2.0 * ri * rt)));
                this.lookAngles[i] = FastMath.asin((double)(FastMath.sin((double)alpha) * rt / rtPlusH));
                this.rangeSpreadingLoss[i] = FastMath.pow((double)(ri / 847000.0), (double)3.0);
            }
        }
    }

    private double getIncidenceAngleAtFirstRangePixel() {
        MetadataElement facility = this.origMetadataRoot.getElement("Leader").getElement("Facility Related");
        if (facility == null) {
            throw new OperatorException("Facility Related not found");
        }
        MetadataAttribute attr = facility.getAttribute("Incidence angle at first range pixel");
        if (attr == null) {
            throw new OperatorException("Incidence angle at first range pixel not found");
        }
        return attr.getData().getElemFloat();
    }

    private double getSlantRangeTimeToFirstRangePixel() {
        MetadataElement facility = this.origMetadataRoot.getElement("Leader").getElement("Scene Parameters");
        if (facility == null) {
            throw new OperatorException("Scene Parameters not found");
        }
        MetadataAttribute attr = facility.getAttribute("Zero-doppler range time of first range pixel");
        if (attr == null) {
            throw new OperatorException("Zero-doppler range time of first range pixel not found");
        }
        return (double)attr.getData().getElemFloat() / 1000.0;
    }

    private double getTimeIntervalBetweenDataPoints() {
        MetadataElement facility = this.origMetadataRoot.getElement("Leader").getElement("Platform Position");
        if (facility == null) {
            throw new OperatorException("Platform Position not found");
        }
        MetadataAttribute attr = facility.getAttribute("Time interval between data points");
        if (attr == null) {
            throw new OperatorException("Time interval between data points not found");
        }
        return attr.getData().getElemDouble();
    }

    private double getZeroDopplerAzimuthTimeOfFirstAzimuthPixel() {
        MetadataElement facility = this.origMetadataRoot.getElement("Leader").getElement("Scene Parameters");
        if (facility == null) {
            throw new OperatorException("Scene Parameters not found");
        }
        MetadataAttribute attr = facility.getAttribute("Zero-doppler azimuth time of first azimuth pixel");
        if (attr == null) {
            throw new OperatorException("Zero-doppler azimuth time of first azimuth pixel not found");
        }
        return ERSCalibrator.convertUTCTimes(attr.getData().getElemString());
    }

    private double getZeroDopplerAzimuthTimeOfCentreAzimuthPixel() {
        MetadataElement facility = this.origMetadataRoot.getElement("Leader").getElement("Scene Parameters");
        if (facility == null) {
            throw new OperatorException("Scene Parameters not found");
        }
        MetadataAttribute attr = facility.getAttribute("Zero-doppler azimuth time of centre azimuth pixel");
        if (attr == null) {
            throw new OperatorException("Zero-doppler azimuth time of centre azimuth pixel not found");
        }
        return ERSCalibrator.convertUTCTimes(attr.getData().getElemString());
    }

    private void getPositionVector(int k, double[] array) {
        if (k > this.getNumOfDataPoints()) {
            throw new OperatorException("Invalid data point index");
        }
        MetadataElement facility = this.origMetadataRoot.getElement("Leader").getElement("Platform Position");
        if (facility == null) {
            throw new OperatorException("Platform Position not found");
        }
        MetadataAttribute xAttr = facility.getAttribute("Position vector X " + k);
        if (xAttr == null) {
            throw new OperatorException("Position vector X " + k + " not found");
        }
        MetadataAttribute yAttr = facility.getAttribute("Position vector Y " + k);
        if (yAttr == null) {
            throw new OperatorException("Position vector X " + k + " not found");
        }
        MetadataAttribute zAttr = facility.getAttribute("Position vector Z " + k);
        if (zAttr == null) {
            throw new OperatorException("Position vector Y " + k + " not found");
        }
        array[0] = xAttr.getData().getElemDouble();
        array[1] = yAttr.getData().getElemDouble();
        array[2] = zAttr.getData().getElemDouble();
    }

    private int getNumOfDataPoints() {
        MetadataElement facility = this.origMetadataRoot.getElement("Leader").getElement("Platform Position");
        if (facility == null) {
            throw new OperatorException("Platform Position not found");
        }
        MetadataAttribute attr = facility.getAttribute("Number of data points");
        if (attr == null) {
            throw new OperatorException("Number of data points not found");
        }
        return attr.getData().getElemInt();
    }

    private void updateTargetProductMetadata() {
        MetadataElement abs = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (this.applyAntennaPatternCorrection) {
            AbstractMetadata.setAttribute((MetadataElement)abs, (String)"ant_elev_corr_flag", (int)1);
        }
        if (this.applyRangeSpreadingLossCorrection) {
            AbstractMetadata.setAttribute((MetadataElement)abs, (String)"range_spread_comp_flag", (int)1);
        }
        if (this.applyReplicaPowerCorrection) {
            AbstractMetadata.setAttribute((MetadataElement)abs, (String)"replica_power_corr_flag", (int)1);
        }
        AbstractMetadata.setAttribute((MetadataElement)abs, (String)"abs_calibration_flag", (int)1);
        if (this.useExtXCAFile) {
            AbstractMetadata.setAttribute((MetadataElement)abs, (String)"external_calibration_file", (String)this.extXCAFileName);
        }
    }

    private synchronized void computeAntennaPatternCorrectionFactors(int x0, int w) {
        if (this.isAntPattAvailable) {
            return;
        }
        this.antennaPatternCorrFactor = new double[w];
        if (this.psID.contains(VMP)) {
            this.computeAntennaPatternCorrectionFactorsForVMPProduct(x0, w);
        } else {
            this.computeAntennaPatternCorrectionFactorsForPGSProduct(x0, w);
        }
        this.isAntPattAvailable = true;
    }

    private void computeAntennaPatternCorrectionFactorsForVMPProduct(int x0, int w) {
        block11: {
            block8: {
                double theta;
                block13: {
                    block12: {
                        block9: {
                            block10: {
                                if (this.processingTime.compareTo(this.time19950716) >= 0) {
                                    for (int x = x0; x < x0 + w; ++x) {
                                        this.antennaPatternCorrFactor[x - x0] = 1.0;
                                    }
                                    return;
                                }
                                theta = 0.0;
                                if (!this.isERS1Mission) break block8;
                                if (!this.pafID.contains(ESRIN) && !this.pafID.contains(D_PAF) && !this.pafID.contains(I_PAF)) break block9;
                                if (this.processingTime.compareTo(this.time19910801) < 0 || this.processingTime.compareTo(this.time19920901) >= 0) break block10;
                                for (int x = x0; x < x0 + w; ++x) {
                                    theta = this.lookAngles[x] * 57.29577951308232;
                                    this.antennaPatternCorrFactor[x - x0] = 1.0 / this.g2Im(theta);
                                }
                                break block11;
                            }
                            if (this.processingTime.compareTo(this.time19920901) < 0 || this.processingTime.compareTo(this.time19950716) >= 0) break block11;
                            for (int x = x0; x < x0 + w; ++x) {
                                theta = this.lookAngles[x] * 57.29577951308232;
                                this.antennaPatternCorrFactor[x - x0] = this.g2Init(theta) / this.g2Im(theta);
                            }
                            break block11;
                        }
                        if (!this.pafID.contains(UK_PAF)) break block11;
                        if (this.processingTime.compareTo(this.time19910801) < 0 || this.processingTime.compareTo(this.time19920901) >= 0) break block12;
                        for (int x = x0; x < x0 + w; ++x) {
                            theta = this.lookAngles[x] * 57.29577951308232;
                            this.antennaPatternCorrFactor[x - x0] = 1.0 / this.g2Im(theta);
                        }
                        break block11;
                    }
                    if (this.processingTime.compareTo(this.time19920901) < 0 || this.processingTime.compareTo(this.time19930408) >= 0) break block13;
                    for (int x = x0; x < x0 + w; ++x) {
                        theta = this.lookAngles[x] * 57.29577951308232;
                        this.antennaPatternCorrFactor[x - x0] = this.ec(theta) * this.g2Init(theta) / this.g2Im(theta);
                    }
                    break block11;
                }
                if (this.processingTime.compareTo(this.time19930408) < 0 || this.processingTime.compareTo(this.time19950716) >= 0) break block11;
                for (int x = x0; x < x0 + w; ++x) {
                    theta = this.lookAngles[x] * 57.29577951308232;
                    this.antennaPatternCorrFactor[x - x0] = this.g2Init(theta) / this.g2Im(theta);
                }
                break block11;
            }
            for (int x = x0; x < x0 + w; ++x) {
                this.antennaPatternCorrFactor[x - x0] = 1.0;
            }
        }
    }

    private void computeAntennaPatternCorrectionFactorsForPGSProduct(int x0, int w) {
        double[] antennaPatternGain = new double[w];
        this.getPGSAntennaPatternGainForCurrentTile(x0, w, antennaPatternGain);
        for (int x = x0; x < x0 + w; ++x) {
            this.antennaPatternCorrFactor[x - x0] = 1.0 / antennaPatternGain[x - x0];
        }
    }

    private void getPGSAntennaPatternGainForCurrentTile(int x0, int w, double[] array) {
        double delta = 0.05;
        for (int x = x0; x < x0 + w; ++x) {
            double theta = this.lookAngles[x] * 57.29577951308232;
            int k = (int)((theta - this.elevationAngle + 5.0) / 0.05);
            double theta1 = this.elevationAngle - 5.0 + (double)k * 0.05;
            double theta2 = theta1 + 0.05;
            double gain1 = FastMath.pow((double)10.0, (double)((double)this.antPatForPGS[k] / 10.0));
            double gain2 = FastMath.pow((double)10.0, (double)((double)this.antPatForPGS[k + 1] / 10.0));
            array[x - x0] = ((theta2 - theta) * gain1 + (theta - theta1) * gain2) / (theta2 - theta1);
        }
    }

    private double g2Init(double lookAngle) {
        return ERSCalibrator.getAntennaPatternGain(lookAngle, this.appendixG1);
    }

    private double g2Im(double lookAngle) {
        return ERSCalibrator.getAntennaPatternGain(lookAngle, this.appendixG2);
    }

    private double g2ERS2(double lookAngle) {
        return ERSCalibrator.getAntennaPatternGain(lookAngle, this.appendixG3);
    }

    private static double getAntennaPatternGain(double lookAngle, double[][] array) {
        int numRows = array.length;
        int numCols = array[0].length;
        if (numCols != 2) {
            throw new OperatorException("Incorrect array dimension");
        }
        double boreSightAngle = lookAngle - 20.355;
        int row1 = 0;
        int row2 = 0;
        if (boreSightAngle < array[0][0]) {
            row1 = 0;
            row2 = 1;
        } else if (boreSightAngle > array[numRows - 1][0]) {
            row1 = numRows - 2;
            row2 = numRows - 1;
        } else {
            for (int i = 1; i < numRows; ++i) {
                if (!(boreSightAngle < array[i][0])) continue;
                row1 = i - 1;
                row2 = i;
                break;
            }
        }
        double delTheta1 = array[row1][0];
        double delTheta2 = array[row2][0];
        double gain1 = array[row1][1];
        double gain2 = array[row2][1];
        double lambda = (boreSightAngle - delTheta1) / (delTheta2 - delTheta1);
        double gain = (1.0 - lambda) * gain1 + lambda * gain2;
        gain = FastMath.pow((double)10.0, (double)(gain / 10.0));
        return gain;
    }

    private double ec(double lookAngle) {
        int numRows = this.appendixH.length;
        int numCols = this.appendixH[0].length;
        if (numRows < 2 || numCols < 2) {
            throw new OperatorException("Not enough antenna pattern data");
        }
        double boreSightAngle = lookAngle - 20.355;
        int row1 = 0;
        int row2 = 0;
        if (this.sceneCentreLatitude < this.appendixH[1][0]) {
            row1 = 1;
            row2 = 2;
        } else if (this.sceneCentreLatitude > this.appendixH[numRows - 1][0]) {
            row1 = numRows - 2;
            row2 = numRows - 1;
        } else {
            for (int i = 2; i < numRows; ++i) {
                if (!(this.sceneCentreLatitude < this.appendixH[i][0])) continue;
                row1 = i - 1;
                row2 = i;
                break;
            }
        }
        int col1 = 0;
        int col2 = 0;
        if (boreSightAngle < this.appendixH[0][1]) {
            col1 = 1;
            col2 = 2;
        } else if (boreSightAngle > this.appendixH[numCols - 1][0]) {
            col1 = numCols - 2;
            col2 = numCols - 1;
        } else {
            for (int j = 2; j < numCols; ++j) {
                if (!(boreSightAngle < this.appendixH[0][j])) continue;
                col1 = j - 1;
                col2 = j;
                break;
            }
        }
        double lat1 = this.appendixH[row1][0];
        double lat2 = this.appendixH[row2][0];
        double delTheta1 = this.appendixH[0][col1];
        double delTheta2 = this.appendixH[0][col2];
        if (Double.compare(lat1, lat2) == 0 || Double.compare(delTheta1, delTheta2) == 0) {
            throw new OperatorException("Incorrect latitude or look angle data");
        }
        double gain11 = this.appendixH[row1][col1];
        double gain12 = this.appendixH[row1][col2];
        double gain21 = this.appendixH[row2][col1];
        double gain22 = this.appendixH[row2][col2];
        double lambda1 = (this.sceneCentreLatitude - lat1) / (lat2 - lat1);
        double lambda2 = (boreSightAngle - delTheta1) / (delTheta2 - delTheta1);
        double gain = (1.0 - lambda2) * ((1.0 - lambda1) * gain11 + lambda1 * gain21) + lambda2 * ((1.0 - lambda1) * gain12 + lambda1 * gain22);
        gain = FastMath.pow((double)10.0, (double)(gain / 10.0));
        return gain;
    }

    private void prepareForADCCorrection() throws IOException {
        this.getADCPowerLossCorrLUT();
        this.windowWidth = (int)(15000.0 / this.rangeSpacing);
        this.windowHeight = (int)(5000.0 / this.azimuthSpacing);
        this.blockWidth = (int)(100.0 / this.rangeSpacing);
        this.blockHeight = (int)(100.0 / this.azimuthSpacing);
    }

    private void getADCPowerLossCorrLUT() throws IOException {
        if (this.isERS1Mission) {
            this.appendixF1 = ERSCalibrator.readFile(this.getERSAuxFile("Appendix_F1.txt"), "Appendix_F1.txt");
        } else {
            this.appendixF2 = ERSCalibrator.readFile(this.getERSAuxFile("Appendix_F2.txt"), "Appendix_F2.txt");
        }
    }

    private boolean isADCNeeded(Band sourceBand1, Band sourceBand2, Unit.UnitType bandUnit) {
        int w = Math.min(this.windowWidth, this.sourceImageWidth);
        int h = Math.min(this.windowHeight, this.sourceImageHeight);
        int x0 = (this.sourceImageWidth - w) / 2;
        int y0 = (this.sourceImageHeight - h) / 2;
        Rectangle sourceTileRectangle = new Rectangle(x0, y0, w, h);
        Tile sourceRaster1 = this.getSourceTile((RasterDataNode)sourceBand1, sourceTileRectangle);
        Tile sourceRaster2 = null;
        if (sourceBand2 != null) {
            sourceRaster2 = this.getSourceTile((RasterDataNode)sourceBand2, sourceTileRectangle);
        }
        ProductData srcData1 = sourceRaster1.getDataBuffer();
        ProductData srcData2 = null;
        if (sourceRaster2 != null) {
            srcData2 = sourceRaster2.getDataBuffer();
        }
        double sigma = 0.0;
        for (int y = y0; y < y0 + h; ++y) {
            for (int x = x0; x < x0 + w; ++x) {
                int index = sourceRaster1.getDataBufferIndex(x, y);
                if (bandUnit == Unit.UnitType.AMPLITUDE) {
                    double dn = srcData1.getElemDoubleAt(index);
                    sigma += dn * dn;
                    continue;
                }
                if (bandUnit == Unit.UnitType.INTENSITY) {
                    sigma += srcData1.getElemDoubleAt(index);
                    continue;
                }
                double i = srcData1.getElemDoubleAt(index);
                double q = srcData2.getElemDoubleAt(index);
                sigma += i * i + q * q;
            }
        }
        sigma = (sigma /= (double)(w * h) * this.calibrationConstant) < 1.0E-30 ? Math.min(-7.0, -2.0) : 10.0 * Math.log10(sigma);
        if (this.isERS1Mission && sigma <= -7.0) {
            return false;
        }
        return this.isERS1Mission || !(sigma <= -2.0);
    }

    private void computeAntennaPatternGain(int x0, int w) {
        this.antennaPatternGain = new double[w];
        if (this.psID.contains(VMP)) {
            this.computeAntennaPatternGainForVMPProduct(x0, w);
        } else {
            this.computeAntennaPatternGainForPGSProduct(x0, w);
        }
    }

    private void computeAntennaPatternGainForVMPProduct(int x0, int w) {
        block11: {
            double theta;
            block8: {
                block13: {
                    block12: {
                        block9: {
                            block10: {
                                theta = 0.0;
                                if (!this.isERS1Mission) break block8;
                                if (this.processingTime.compareTo(this.time19950716) >= 0) {
                                    for (int x = x0; x < x0 + w; ++x) {
                                        theta = this.lookAngles[x] * 57.29577951308232;
                                        this.antennaPatternGain[x - x0] = this.g2Im(theta);
                                    }
                                    return;
                                }
                                if (!this.pafID.contains(ESRIN) && !this.pafID.contains(D_PAF) && !this.pafID.contains(I_PAF)) break block9;
                                if (this.processingTime.compareTo(this.time19910801) < 0 || this.processingTime.compareTo(this.time19920901) >= 0) break block10;
                                for (int x = x0; x < x0 + w; ++x) {
                                    this.antennaPatternGain[x - x0] = 1.0;
                                }
                                break block11;
                            }
                            if (this.processingTime.compareTo(this.time19920901) < 0 || this.processingTime.compareTo(this.time19950716) >= 0) break block11;
                            for (int x = x0; x < x0 + w; ++x) {
                                theta = this.lookAngles[x] * 57.29577951308232;
                                this.antennaPatternGain[x - x0] = this.g2Init(theta);
                            }
                            break block11;
                        }
                        if (!this.pafID.contains(UK_PAF)) break block11;
                        if (this.processingTime.compareTo(this.time19910801) < 0 || this.processingTime.compareTo(this.time19920901) >= 0) break block12;
                        for (int x = x0; x < x0 + w; ++x) {
                            this.antennaPatternGain[x - x0] = 1.0;
                        }
                        break block11;
                    }
                    if (this.processingTime.compareTo(this.time19920901) < 0 || this.processingTime.compareTo(this.time19930408) >= 0) break block13;
                    for (int x = x0; x < x0 + w; ++x) {
                        theta = this.lookAngles[x] * 57.29577951308232;
                        this.antennaPatternGain[x - x0] = this.ec(theta) * this.g2Init(theta);
                    }
                    break block11;
                }
                if (this.processingTime.compareTo(this.time19930408) < 0 || this.processingTime.compareTo(this.time19950716) >= 0) break block11;
                for (int x = x0; x < x0 + w; ++x) {
                    theta = this.lookAngles[x] * 57.29577951308232;
                    this.antennaPatternGain[x - x0] = this.g2Init(theta);
                }
                break block11;
            }
            for (int x = x0; x < x0 + w; ++x) {
                theta = this.lookAngles[x] * 57.29577951308232;
                this.antennaPatternGain[x - x0] = this.g2ERS2(theta);
            }
        }
    }

    private void computeAntennaPatternGainForPGSProduct(int x0, int w) {
        double[] antennaPatternGainArray = new double[w];
        this.getPGSAntennaPatternGainForCurrentTile(x0, w, antennaPatternGainArray);
        System.arraycopy(antennaPatternGainArray, x0 - x0, this.antennaPatternGain, x0 - x0, x0 + w - x0);
    }

    private double[][] computeADCPowerLossValuesForCurrentTile(Band sourceBand1, Band sourceBand2, int tx0, int ty0, int tw, int th, Unit.UnitType bandUnit) {
        TileDescriptionFlags tileDescriptionFlags = new TileDescriptionFlags();
        Rectangle sourceTileRectangle = this.getSourceTileRectangle(tx0, ty0, tw, th, tileDescriptionFlags);
        RenderedImage intendityImage = this.getIntensityImage(sourceBand1, sourceBand2, sourceTileRectangle, bandUnit);
        RenderedImage downSampledImage = this.downSampleImage(intendityImage);
        RenderedImage rawImage = this.removeFactorsApplied(downSampledImage, sourceTileRectangle);
        RenderedImage smoothedImage = this.smoothImage(rawImage);
        RenderedImage squaredImage = this.getSquaredImage(smoothedImage);
        return this.computeADCPowerLossValue(squaredImage, tileDescriptionFlags);
    }

    private Rectangle getSourceTileRectangle(int tx0, int ty0, int tw, int th, TileDescriptionFlags tileDescriptionFlags) {
        int halfWindowHeight = this.windowHeight / 2;
        int halfWindowWidth = this.windowWidth / 2;
        int sx0 = tx0;
        int sy0 = ty0;
        int sw = tw;
        int sh = th;
        tileDescriptionFlags.adcSourceTileTopExtFlag = false;
        tileDescriptionFlags.adcSourceTileBottomExtFlag = false;
        tileDescriptionFlags.adcSourceTileLeftExtFlag = false;
        tileDescriptionFlags.adcSourceTileRightExtFlag = false;
        if (ty0 >= halfWindowHeight) {
            tileDescriptionFlags.adcSourceTileTopExtFlag = true;
            sy0 = ty0 - halfWindowHeight;
            sh += halfWindowHeight;
        }
        if (ty0 + th + halfWindowHeight <= this.sourceImageHeight) {
            tileDescriptionFlags.adcSourceTileBottomExtFlag = true;
            sh += halfWindowHeight;
        }
        if (tx0 >= halfWindowWidth) {
            tileDescriptionFlags.adcSourceTileLeftExtFlag = true;
            sx0 = tx0 - halfWindowWidth;
            sw += halfWindowWidth;
        }
        if (tx0 + tw + halfWindowWidth <= this.sourceImageWidth) {
            tileDescriptionFlags.adcSourceTileRightExtFlag = true;
            sw += halfWindowWidth;
        }
        return new Rectangle(sx0, sy0, sw, sh);
    }

    private RenderedImage getIntensityImage(Band sourceBand1, Band sourceBand2, Rectangle sourceTileRectangle, Unit.UnitType bandUnit) {
        int sx0 = sourceTileRectangle.x;
        int sy0 = sourceTileRectangle.y;
        int sw = sourceTileRectangle.width;
        int sh = sourceTileRectangle.height;
        double[] array = new double[sw * sh];
        Tile sourceRaster1 = this.getSourceTile((RasterDataNode)sourceBand1, sourceTileRectangle);
        Tile sourceRaster2 = null;
        if (sourceBand2 != null) {
            sourceRaster2 = this.getSourceTile((RasterDataNode)sourceBand2, sourceTileRectangle);
        }
        ProductData srcData1 = sourceRaster1.getDataBuffer();
        ProductData srcData2 = null;
        if (sourceRaster2 != null) {
            srcData2 = sourceRaster2.getDataBuffer();
        }
        int k = 0;
        int maxY = sy0 + sh;
        int maxX = sx0 + sw;
        for (int y = sy0; y < maxY; ++y) {
            for (int x = sx0; x < maxX; ++x) {
                double sigma;
                int index = sourceRaster1.getDataBufferIndex(x, y);
                if (bandUnit == Unit.UnitType.AMPLITUDE) {
                    double dn = srcData1.getElemDoubleAt(index);
                    sigma = dn * dn;
                } else if (bandUnit == Unit.UnitType.INTENSITY) {
                    sigma = srcData1.getElemDoubleAt(index);
                } else {
                    double i = srcData1.getElemDoubleAt(index);
                    double q = srcData2.getElemDoubleAt(index);
                    sigma = i * i + q * q;
                }
                array[k++] = sigma;
            }
        }
        return ERSCalibrator.createRenderedImage(array, sw, sh);
    }

    private static RenderedImage createRenderedImage(double[] array, int width, int height) {
        SampleModel sampleModel = RasterFactory.createBandedSampleModel((int)5, (int)width, (int)height, (int)1);
        ColorModel colourModel = PlanarImage.createColorModel((SampleModel)sampleModel);
        DataBufferDouble dataBuffer = new DataBufferDouble(array, array.length);
        WritableRaster raster = RasterFactory.createWritableRaster((SampleModel)sampleModel, (DataBuffer)dataBuffer, (Point)new Point(0, 0));
        return new BufferedImage(colourModel, raster, false, new Hashtable());
    }

    private RenderedImage downSampleImage(RenderedImage intendityImage) {
        double scaleX = 1.0 / (double)this.blockWidth;
        double scaleY = 1.0 / (double)this.blockHeight;
        return SubsampleAverageDescriptor.create((RenderedImage)intendityImage, (Double)scaleX, (Double)scaleY, null);
    }

    private RenderedImage removeFactorsApplied(RenderedImage downSampledImage, Rectangle sourceTileRectangle) {
        int sx0 = sourceTileRectangle.x;
        int w = downSampledImage.getWidth();
        int h = downSampledImage.getHeight();
        double[] array = new double[h * w];
        Raster data = downSampledImage.getData(new Rectangle(0, 0, w, h));
        int k = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                double sigma = data.getSampleDouble(x, y, 0);
                if (this.antennaPatternCorrectionFlag) {
                    sigma *= this.antennaPatternGain[sx0 + x * this.blockWidth];
                }
                if (this.rangeSpreadingLossCompFlag) {
                    sigma /= this.rangeSpreadingLoss[sx0 + x * this.blockWidth];
                }
                if (!this.isERS1Mission) {
                    sigma /= this.replicaPulseVariationsCorrectionFactor;
                }
                array[k++] = Math.sqrt(sigma);
            }
        }
        return ERSCalibrator.createRenderedImage(array, w, h);
    }

    private RenderedImage smoothImage(RenderedImage rawImage) {
        int slidingWindowWidth = this.windowWidth / this.blockWidth;
        int slidingWindowHeight = this.windowHeight / this.blockHeight;
        BorderExtender extender = BorderExtender.createInstance((int)2);
        RenderingHints hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, extender);
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(rawImage);
        pb.add(slidingWindowWidth);
        pb.add(slidingWindowHeight);
        pb.add(slidingWindowWidth / 2);
        pb.add(slidingWindowHeight / 2);
        return JAI.create((String)"boxfilter", (ParameterBlock)pb, (RenderingHints)hints);
    }

    private RenderedImage getSquaredImage(RenderedImage smoothedImage) {
        ParameterBlock pb1 = new ParameterBlock();
        pb1.addSource(smoothedImage);
        pb1.addSource(smoothedImage);
        RenderedOp squaredImage = JAI.create((String)"multiply", (ParameterBlock)pb1);
        double[] v = new double[]{this.calibrationConstant};
        ParameterBlock pb2 = new ParameterBlock();
        pb2.addSource(squaredImage);
        pb2.add(v);
        return JAI.create((String)"dividebyconst", (ParameterBlock)pb2, null);
    }

    private double[][] computeADCPowerLossValue(RenderedImage squaredImage, TileDescriptionFlags tileDescriptionFlags) {
        int delH = this.windowHeight / 2 / this.blockHeight;
        int delW = this.windowWidth / 2 / this.blockWidth;
        int x0 = 0;
        int y0 = 0;
        int w = squaredImage.getWidth();
        int h = squaredImage.getHeight();
        if (tileDescriptionFlags.adcSourceTileTopExtFlag) {
            y0 = delH;
            h -= delH;
        }
        if (tileDescriptionFlags.adcSourceTileBottomExtFlag) {
            h -= delH;
        }
        if (h <= 0) {
            h = 1;
        }
        if (tileDescriptionFlags.adcSourceTileLeftExtFlag) {
            x0 = delW;
            w -= delW;
        }
        if (tileDescriptionFlags.adcSourceTileRightExtFlag) {
            w -= delW;
        }
        if (w <= 0) {
            w = 1;
        }
        double[][] adcPowerLoss = new double[h][w];
        Raster data = squaredImage.getData();
        for (int y = y0; y < y0 + h; ++y) {
            for (int x = x0; x < x0 + w; ++x) {
                double dn = data.getSampleDouble(x, y, 0);
                adcPowerLoss[y - y0][x - x0] = this.isERS1Mission ? ERSCalibrator.getPowerLossValue(dn, this.appendixF1) : ERSCalibrator.getPowerLossValue(dn, this.appendixF2);
            }
        }
        return adcPowerLoss;
    }

    private static void outputRealImage(RenderedImage I, int startIdx, int endIdx) {
        Raster data = I.getData();
        double[] real = data.getSamples(0, 0, I.getWidth(), I.getHeight(), 0, (double[])null);
        for (int i = startIdx; i <= endIdx; ++i) {
            System.out.print(real[i] + ",");
        }
        System.out.println();
    }

    private static double getPowerLossValue(double dn, double[][] array) {
        int numRows = array.length;
        int numCols = array[0].length;
        if (numCols != 2) {
            throw new OperatorException("Incorrect array dimension");
        }
        if (dn < 1.0E-30) {
            return -1.0E-30;
        }
        double dnInDb = 10.0 * Math.log10(dn);
        int row1 = 0;
        int row2 = 0;
        if (dnInDb < array[0][0]) {
            row1 = 0;
            row2 = 1;
        } else if (dnInDb > array[numRows - 1][0]) {
            row1 = numRows - 2;
            row2 = numRows - 1;
        } else {
            for (int i = 1; i < numRows; ++i) {
                if (!(dnInDb < array[i][0])) continue;
                row1 = i - 1;
                row2 = i;
                break;
            }
        }
        double intensityK1 = array[row1][0];
        double intensityK2 = array[row2][0];
        double loss1 = array[row1][1];
        double loss2 = array[row2][1];
        double lambda = (dnInDb - intensityK1) / (intensityK2 - intensityK1);
        double loss = (1.0 - lambda) * loss1 + lambda * loss2;
        loss = FastMath.pow((double)10.0, (double)(loss / 10.0));
        return loss;
    }

    private void getProcessingFacilityIDFromENVISAT() {
        MetadataElement mph = this.origMetadataRoot.getElement("MPH");
        if (mph == null) {
            throw new OperatorException("MPH not found");
        }
        MetadataAttribute attr = mph.getAttribute("proc_center");
        if (attr == null) {
            throw new OperatorException("proc_center not found");
        }
        this.pafID = attr.getData().getElemString();
    }

    private void getNumOfRecordsInMainProcParam() {
        MetadataElement dsd = this.origMetadataRoot.getElement("DSD").getElement("DSD.3");
        if (dsd == null) {
            throw new OperatorException("DSD not found");
        }
        MetadataAttribute numRecordsAttr = dsd.getAttribute("num_records");
        if (numRecordsAttr == null) {
            throw new OperatorException("num_records not found");
        }
        this.numMPPRecords = numRecordsAttr.getData().getElemInt();
        if (this.numMPPRecords < 1) {
            throw new OperatorException("Invalid num_records.");
        }
    }

    private void computeIncidenceAnglesLookAnglesRangeSpreadingLossForENVISAT() {
        this.incidenceAngles = new double[this.sourceImageWidth];
        this.lookAngles = new double[this.sourceImageWidth];
        this.rangeSpreadingLoss = new double[this.sourceImageWidth];
        TiePointGrid incidenceAngleTiePointGrid = OperatorUtils.getIncidenceAngle((Product)this.sourceProduct);
        TiePointGrid slantRangeTimeTiePointGrid = OperatorUtils.getSlantRangeTime((Product)this.sourceProduct);
        double rSat = this.getSatelliteToEarthCenterDistanceForENVISAT();
        int y = this.sourceImageHeight / 2;
        for (int x = 0; x < this.sourceImageWidth; ++x) {
            double alpha = incidenceAngleTiePointGrid.getPixelDouble((double)x + 0.5, (double)y + 0.5) * (Math.PI / 180);
            double time = slantRangeTimeTiePointGrid.getPixelDouble((double)x + 0.5, (double)y + 0.5) / 1.0E9;
            double r = time * 1.49896229E8;
            double theta = alpha - FastMath.asin((double)(FastMath.sin((double)alpha) * r / rSat));
            this.incidenceAngles[x] = alpha;
            this.lookAngles[x] = theta;
            this.rangeSpreadingLoss[x] = FastMath.pow((double)(r / 847000.0), (double)3.0);
        }
    }

    private double getSatelliteToEarthCenterDistanceForENVISAT() {
        float zpos;
        float ypos;
        MetadataElement orbit_state_vectors = this.absRoot.getElement("Orbit_State_Vectors");
        MetadataElement orbit_vector = orbit_state_vectors.getElement("orbit_vector3");
        float xpos = (float)orbit_vector.getAttributeDouble("x_pos");
        double rSat = Math.sqrt(xpos * xpos + (ypos = (float)orbit_vector.getAttributeDouble("y_pos")) * ypos + (zpos = (float)orbit_vector.getAttributeDouble("z_pos")) * zpos);
        if (Double.compare(rSat, 0.0) == 0) {
            throw new OperatorException("x, y and z positions in orbit_state_vectors are all zeros");
        }
        return rSat;
    }

    private double getReplicaPulsePowerForENVISAT() {
        double replicaPulsePower = this.absRoot.getAttributeDouble("chirp_power");
        replicaPulsePower = FastMath.pow((double)10.0, (double)(replicaPulsePower / 10.0));
        return replicaPulsePower;
    }

    public Tile getSourceTile(RasterDataNode rasterDataNode, Rectangle rectangle) throws OperatorException {
        return this.calibrationOp.getSourceTile(rasterDataNode, rectangle);
    }

    @Override
    public double applyRetroCalibration(int x, int y, double v, String bandPolar, Unit.UnitType bandUnit, int[] subSwathIndex) {
        return v;
    }

    @Override
    public double applyCalibration(double v, double rangeIndex, double azimuthIndex, double slantRange, double satelliteHeight, double sceneToEarthCentre, double localIncidenceAngle, String bandName, String bandPolar, Unit.UnitType bandUnit, int[] subSwathIndex) {
        double sigma = 0.0;
        if (bandUnit == Unit.UnitType.AMPLITUDE) {
            sigma = v * v;
        } else if (bandUnit == Unit.UnitType.AMPLITUDE_DB) {
            sigma = FastMath.pow((double)10.0, (double)(v / 5.0));
        } else if (bandUnit == Unit.UnitType.INTENSITY || bandUnit == Unit.UnitType.REAL || bandUnit == Unit.UnitType.IMAGINARY) {
            sigma = v;
        } else if (bandUnit == Unit.UnitType.INTENSITY_DB) {
            sigma = FastMath.pow((double)10.0, (double)(v / 10.0));
        } else {
            throw new OperatorException("Unknown band unit");
        }
        if (this.multilookFlag && this.antennaPatternCorrectionFlag) {
            return FastMath.sin((double)(Math.abs(localIncidenceAngle) * (Math.PI / 180))) / FastMath.sin((double)0.4014257279586958) / this.calibrationConstant;
        }
        sigma *= FastMath.sin((double)(Math.abs(localIncidenceAngle) * (Math.PI / 180))) / FastMath.sin((double)0.4014257279586958);
        sigma /= this.getNewAntennaPatternGainSquare((int)rangeIndex);
        sigma *= this.rangeSpreadingLoss[(int)rangeIndex];
        sigma *= this.replicaPulseVariationsCorrectionFactor;
        return sigma /= this.calibrationConstant;
    }

    private double getNewAntennaPatternGainSquare(int rangeIndex) {
        if (this.psID.contains(VMP)) {
            return this.getNewAntennaPatternGainSquareForVMPProduct(rangeIndex);
        }
        return this.getNewAntennaPatternGainSquareForPGSProduct(rangeIndex);
    }

    private double getNewAntennaPatternGainSquareForVMPProduct(int rangeIndex) {
        if (this.isERS1Mission) {
            return this.g2Im(this.lookAngles[rangeIndex] * 57.29577951308232);
        }
        return this.g2ERS2(this.lookAngles[rangeIndex] * 57.29577951308232);
    }

    private double getNewAntennaPatternGainSquareForPGSProduct(int rangeIndex) {
        double delta = 0.05;
        double theta = this.lookAngles[rangeIndex] * 57.29577951308232;
        int k = (int)((theta - this.elevationAngle + 5.0) / 0.05);
        double theta1 = this.elevationAngle - 5.0 + (double)k * 0.05;
        double theta2 = theta1 + 0.05;
        double gain1 = FastMath.pow((double)10.0, (double)((double)this.antPatForPGS[k] / 10.0));
        double gain2 = FastMath.pow((double)10.0, (double)((double)this.antPatForPGS[k + 1] / 10.0));
        double gain = ((theta2 - theta) * gain1 + (theta - theta1) * gain2) / (theta2 - theta1);
        return gain;
    }

    @Override
    public void removeFactorsForCurrentTile(Band targetBand, Tile targetTile, String srcBandName) throws OperatorException {
        Rectangle targetTileRectangle = targetTile.getRectangle();
        int tx0 = targetTileRectangle.x;
        int ty0 = targetTileRectangle.y;
        int tw = targetTileRectangle.width;
        int th = targetTileRectangle.height;
        ProductData trgData = targetTile.getDataBuffer();
        Band sourceBand1 = this.sourceProduct.getBand(srcBandName);
        Tile sourceTile = this.getSourceTile((RasterDataNode)sourceBand1, targetTileRectangle);
        ProductData srcData = sourceTile.getDataBuffer();
        String[] srcBandNames = new String[]{targetBand.getName()};
        Band sourceBand2 = null;
        if (srcBandNames.length > 1) {
            sourceBand2 = this.sourceProduct.getBand(srcBandNames[1]);
        }
        Unit.UnitType bandUnit = Unit.getUnitType((Band)sourceBand1);
        if (this.applyADCSaturationCorrection && !this.adcHasBeenTestedFlag) {
            this.testADC(sourceBand1, sourceBand2, bandUnit);
        }
        boolean applyADCSaturationCorrectionToCurrentTile = false;
        if (this.applyADCSaturationCorrection && th >= this.blockHeight && tw >= this.blockWidth) {
            applyADCSaturationCorrectionToCurrentTile = true;
        }
        double[][] adcPowerLoss = null;
        if (applyADCSaturationCorrectionToCurrentTile) {
            adcPowerLoss = this.computeADCPowerLossValuesForCurrentTile(sourceBand1, sourceBand2, tx0, ty0, tw, th, bandUnit);
        }
        double sigma = 0.0;
        int adcJ = 0;
        for (int x = tx0; x < tx0 + tw; ++x) {
            double antennaPatternByRangeSpreadingLoss = 0.0;
            if (!this.isComplex) {
                antennaPatternByRangeSpreadingLoss = this.antennaPatternGain[x] / this.rangeSpreadingLoss[x];
            }
            if (applyADCSaturationCorrectionToCurrentTile) {
                adcJ = Math.min((x - tx0) / this.blockWidth, adcPowerLoss[0].length - 1);
            }
            for (int y = ty0; y < ty0 + th; ++y) {
                int srcIndex = sourceTile.getDataBufferIndex(x, y);
                int tgtIndex = targetTile.getDataBufferIndex(x, y);
                if (bandUnit == Unit.UnitType.AMPLITUDE) {
                    double dn = srcData.getElemDoubleAt(srcIndex);
                    sigma = dn * dn;
                } else if (bandUnit == Unit.UnitType.AMPLITUDE_DB) {
                    sigma = FastMath.pow((double)10.0, (double)(srcData.getElemDoubleAt(srcIndex) / 5.0));
                } else if (bandUnit == Unit.UnitType.INTENSITY) {
                    sigma = srcData.getElemDoubleAt(srcIndex);
                } else if (bandUnit == Unit.UnitType.INTENSITY_DB) {
                    sigma = FastMath.pow((double)10.0, (double)(srcData.getElemDoubleAt(srcIndex) / 10.0));
                } else {
                    throw new OperatorException("ERSCalibrator: Unknown band unit");
                }
                if (!this.isComplex) {
                    sigma *= antennaPatternByRangeSpreadingLoss;
                }
                if (!this.isERS1Mission) {
                    sigma /= this.replicaPulseVariationsCorrectionFactor;
                }
                if (applyADCSaturationCorrectionToCurrentTile) {
                    int adcI = Math.min((y - ty0) / this.blockHeight, adcPowerLoss.length - 1);
                    sigma *= adcPowerLoss[adcI][adcJ];
                }
                if (bandUnit == Unit.UnitType.AMPLITUDE) {
                    trgData.setElemDoubleAt(tgtIndex, Math.sqrt(sigma));
                    continue;
                }
                if (bandUnit == Unit.UnitType.AMPLITUDE_DB) {
                    trgData.setElemDoubleAt(tgtIndex, 5.0 * Math.log10(sigma));
                    continue;
                }
                if (bandUnit == Unit.UnitType.INTENSITY) {
                    trgData.setElemDoubleAt(tgtIndex, sigma);
                    continue;
                }
                if (bandUnit != Unit.UnitType.INTENSITY_DB) continue;
                trgData.setElemDoubleAt(tgtIndex, 10.0 * Math.log10(sigma));
            }
        }
    }

    public static class TileDescriptionFlags {
        public boolean adcSourceTileTopExtFlag;
        public boolean adcSourceTileBottomExtFlag;
        public boolean adcSourceTileLeftExtFlag;
        public boolean adcSourceTileRightExtFlag;
    }
}

