/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.calibration.gpf.calibrators;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.calibration.gpf.support.BaseCalibrator;
import org.esa.s1tbx.calibration.gpf.support.Calibrator;
import org.esa.s1tbx.calibration.gpf.support.TiePointInterpolator;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.dataio.envisat.EnvisatAuxReader;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.DownloadableArchive;
import org.esa.snap.engine_utilities.datamodel.OrbitStateVector;
import org.esa.snap.engine_utilities.datamodel.Unit;
import org.esa.snap.engine_utilities.eo.GeoUtils;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;
import org.esa.snap.engine_utilities.util.Maths;
import org.esa.snap.engine_utilities.util.Settings;

public class ASARCalibrator
extends BaseCalibrator
implements Calibrator {
    private File externalAuxFile = null;
    private String auxFile = null;
    private String productType = null;
    private String oldXCAFileName = null;
    private String newXCAFileName = null;
    private String newXCAFilePath = null;
    private String[] mdsPolar;
    private TiePointGrid incidenceAngle = null;
    private TiePointGrid slantRangeTime = null;
    private TiePointGrid latitude = null;
    private boolean srgrFlag = false;
    private boolean multilookFlag = false;
    private boolean antElevCorrFlag = false;
    private boolean rangeSpreadCompFlag = false;
    private boolean wideSwathProductFlag = false;
    private boolean retroCalibrationFlag = false;
    private boolean applyAntennaPatternCorr = false;
    private boolean applyRangeSpreadingCorr = false;
    private double firstLineUTC = 0.0;
    private double lineTimeInterval = 0.0;
    private double avgSceneHeight = 0.0;
    private double rangeSpacing = 0.0;
    private double azimuthSpacing = 0.0;
    private double rangeSpreadingCompPower = 0.0;
    private double halfRangeSpreadingCompPower = 0.0;
    private double latMax = 0.0;
    private double delLat = 0.0;
    private double[] earthRadius = null;
    private final double[] newCalibrationConstant = new double[2];
    private double[] oldRefElevationAngle = null;
    private double[] newRefElevationAngle = null;
    private float[][] oldAntennaPatternSingleSwath = null;
    private float[][] oldAntennaPatternWideSwath = null;
    private float[][] newAntennaPatternSingleSwath = null;
    private float[][] newAntennaPatternWideSwath = null;
    private TiePointInterpolator incidenceTPGInterp = null;
    private TiePointInterpolator slantRangeTPGInterp = null;
    private int numMPPRecords;
    private String swath;
    private OrbitStateVector[] orbitStateVectors = null;
    private AbstractMetadata.SRGRCoefficientList[] srgrConvParams = null;
    private static final int numOfGains = 201;
    private static final double refSlantRange800km = 800000.0;
    private static final int INVALID_SUB_SWATH_INDEX = -1;

    @Override
    public void setExternalAuxFile(File file) {
        this.externalAuxFile = file;
    }

    @Override
    public void setAuxFileFlag(String file) {
        this.auxFile = file;
    }

    @Override
    public void initialize(Operator op, Product srcProduct, Product tgtProduct, boolean mustPerformRetroCalibration, boolean mustUpdateMetadata) throws OperatorException {
        try {
            this.calibrationOp = op;
            this.sourceProduct = srcProduct;
            this.targetProduct = tgtProduct;
            this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            this.getProductType();
            this.getSampleType();
            this.getSRGRFlag();
            this.getCalibrationFlags();
            this.getMultilookFlag();
            this.getProductSwath();
            this.setCalibrationFlags();
            this.mdsPolar = OperatorUtils.getProductPolarization((MetadataElement)this.absRoot);
            this.getRangeAzimuthSpacing();
            this.numMPPRecords = ASARCalibrator.getNumOfRecordsInMainProcParam(this.sourceProduct);
            this.getTiePointGridData(this.sourceProduct);
            this.checkXCAFileExsitence(mustPerformRetroCalibration);
            if (this.srgrFlag) {
                this.getSrgrCoeff();
            }
            if (this.retroCalibrationFlag) {
                this.getOldAntennaPattern();
            }
            if (this.applyAntennaPatternCorr) {
                this.getFirstLineTime();
                this.getLineTimeInterval();
                this.getAverageSceneHeight();
                this.getOrbitStateVectors();
                this.getNewAntennaPattern();
                this.computeEarthRadius();
            }
            this.getNewCalibrationFactor();
            this.setRangeSpreadingLossCompPower();
            if (mustUpdateMetadata) {
                this.updateTargetProductMetadata();
            }
        }
        catch (Exception e) {
            throw new OperatorException((Throwable)e);
        }
    }

    private void getProductType() throws OperatorException {
        this.productType = this.sourceProduct.getProductType();
        if (!(this.productType.contains("ASA_IMP_1") || this.productType.contains("ASA_IMM_1") || this.productType.contains("ASA_APP_1") || this.productType.contains("ASA_APM_1") || this.productType.contains("ASA_WSM_1") || this.productType.contains("ASA_IMG_1") || this.productType.contains("ASA_APG_1") || this.productType.contains("ASA_IMS_1") || this.productType.contains("ASA_APS_1") || this.productType.contains("ASA_GM") || this.productType.contains("ASA_WSS_1"))) {
            throw new OperatorException(this.productType + " is not a valid ASAR product type for calibration.");
        }
    }

    private void getCalibrationFlags() throws Exception {
        if (AbstractMetadata.getAttributeBoolean((MetadataElement)this.absRoot, (String)"abs_calibration_flag")) {
            throw new OperatorException("The product has already been calibrated.");
        }
        this.antElevCorrFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)this.absRoot, (String)"ant_elev_corr_flag");
        this.rangeSpreadCompFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)this.absRoot, (String)"range_spread_comp_flag");
    }

    private void getSRGRFlag() throws Exception {
        this.srgrFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)this.absRoot, (String)"srgr_flag");
    }

    private void getMultilookFlag() throws Exception {
        this.multilookFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)this.absRoot, (String)"multilook_flag");
    }

    private void getProductSwath() {
        this.swath = this.absRoot.getAttributeString("SWATH");
        this.wideSwathProductFlag = this.swath.contains("WS");
    }

    private void setCalibrationFlags() {
        if (this.antElevCorrFlag) {
            this.retroCalibrationFlag = !this.multilookFlag && (this.auxFile == null || !this.auxFile.contains("Product Auxiliary File"));
        }
        this.applyAntennaPatternCorr = this.auxFile != null && this.auxFile.contains("Product Auxiliary File") ? false : !this.srgrFlag || this.retroCalibrationFlag || !this.antElevCorrFlag;
        this.applyRangeSpreadingCorr = !this.rangeSpreadCompFlag;
    }

    private void getSrgrCoeff() {
        this.srgrConvParams = AbstractMetadata.getSRGRCoefficients((MetadataElement)this.absRoot);
    }

    private void getRangeAzimuthSpacing() throws Exception {
        this.rangeSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)this.absRoot, (String)"range_spacing");
        this.azimuthSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)this.absRoot, (String)"azimuth_spacing");
    }

    private Path getOldXCAFilePath() throws Exception {
        this.oldXCAFileName = this.absRoot.getAttributeString("external_calibration_file");
        File localFolder = SystemUtils.getAuxDataPath().resolve("AuxCal").resolve("ENVISAT").toFile();
        URL remotePath = new URL(Settings.getPath((String)"AuxCal.ENVISAT.remotePath"));
        File xcaFile = new File(localFolder, this.oldXCAFileName);
        if (xcaFile.exists()) {
            return xcaFile.toPath();
        }
        xcaFile = new File(localFolder, this.oldXCAFileName + ".zip");
        if (xcaFile.exists()) {
            return xcaFile.toPath();
        }
        File localFile = new File(localFolder, "ENVISAT_XCA.zip");
        DownloadableArchive archive = new DownloadableArchive(localFile, remotePath);
        archive.getContentFiles();
        return xcaFile.toPath();
    }

    private void getOldAntennaPattern() throws Exception {
        String xcaFilePath = this.getOldXCAFilePath().toString();
        if (this.wideSwathProductFlag) {
            this.oldRefElevationAngle = new double[5];
            this.oldAntennaPatternWideSwath = new float[5][201];
            ASARCalibrator.getWideSwathAntennaPatternGainFromAuxData(xcaFilePath, this.mdsPolar[0], 201, this.oldRefElevationAngle, this.oldAntennaPatternWideSwath);
        } else {
            this.oldRefElevationAngle = new double[1];
            this.oldAntennaPatternSingleSwath = new float[2][201];
            ASARCalibrator.getSingleSwathAntennaPatternGainFromAuxData(xcaFilePath, this.swath, this.mdsPolar, 201, this.oldRefElevationAngle, this.oldAntennaPatternSingleSwath);
        }
    }

    static int getNumOfRecordsInMainProcParam(Product sourceProduct) throws OperatorException {
        MetadataElement origRoot = AbstractMetadata.getOriginalProductMetadata((Product)sourceProduct);
        MetadataElement dsdElem = origRoot.getElement("DSD");
        if (dsdElem == null) {
            throw new OperatorException("DSD not found");
        }
        MetadataElement dsd = dsdElem.getElement("DSD.3");
        if (dsd == null) {
            throw new OperatorException("DSD not found");
        }
        MetadataAttribute numRecordsAttr = dsd.getAttribute("num_records");
        if (numRecordsAttr == null) {
            throw new OperatorException("num_records not found");
        }
        int numMPPRecords = numRecordsAttr.getData().getElemInt();
        if (numMPPRecords < 1) {
            throw new OperatorException("Invalid num_records.");
        }
        return numMPPRecords;
    }

    private void getTiePointGridData(Product sourceProduct) {
        this.slantRangeTime = OperatorUtils.getSlantRangeTime((Product)sourceProduct);
        this.incidenceAngle = OperatorUtils.getIncidenceAngle((Product)sourceProduct);
        this.latitude = OperatorUtils.getLatitude((Product)sourceProduct);
        this.incidenceTPGInterp = new TiePointInterpolator(this.incidenceAngle);
        this.slantRangeTPGInterp = new TiePointInterpolator(this.slantRangeTime);
    }

    private void checkXCAFileExsitence(boolean mustPerformRetroCalibration) throws Exception {
        String oldXCAFilePath = null;
        if (this.retroCalibrationFlag && !this.isFileExisting(oldXCAFilePath = this.getOldXCAFilePath().toString())) {
            if (mustPerformRetroCalibration) {
                throw new OperatorException("Cannot find XCA file: " + oldXCAFilePath);
            }
            this.retroCalibrationFlag = false;
            this.applyAntennaPatternCorr = false;
        }
        if (this.applyAntennaPatternCorr) {
            this.getNewXCAFile();
            if (!this.isFileExisting(this.newXCAFilePath)) {
                throw new OperatorException("Cannot find XCA file: " + this.newXCAFilePath);
            }
            if (this.retroCalibrationFlag && !mustPerformRetroCalibration && this.newXCAFilePath != null && (oldXCAFilePath.contains(this.newXCAFilePath) || this.newXCAFilePath.contains(oldXCAFilePath))) {
                this.retroCalibrationFlag = false;
                this.applyAntennaPatternCorr = false;
            }
        }
    }

    private boolean isFileExisting(String filePath) {
        String[] exts;
        File file = null;
        for (String ext : exts = new String[]{"", ".gz", ".zip"}) {
            file = new File(filePath + ext);
            if (!file.exists()) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getNewXCAFile() throws Exception {
        if (this.auxFile != null && this.auxFile.contains("External Auxiliary File")) {
            if (this.externalAuxFile == null || !this.externalAuxFile.exists()) throw new OperatorException("No external auxiliary file is specified.");
            if (!this.externalAuxFile.getName().contains("ASA_XCA")) {
                throw new OperatorException("Invalid XCA file for ASAR product");
            }
            this.newXCAFileName = this.externalAuxFile.getName();
            this.newXCAFilePath = this.externalAuxFile.getAbsolutePath();
            return;
        } else {
            Date startDate = this.sourceProduct.getStartTime().getAsDate();
            Date endDate = this.sourceProduct.getEndTime().getAsDate();
            File localFolder = SystemUtils.getAuxDataPath().resolve("AuxCal").resolve("ENVISAT").toFile();
            this.newXCAFileName = ASARCalibrator.findXCAFile(localFolder, startDate, endDate);
            if (this.newXCAFileName == null) {
                URL remotePath = new URL(Settings.getPath((String)"AuxCal.ENVISAT.remotePath"));
                File localFile = new File(localFolder, "ENVISAT_XCA.zip");
                DownloadableArchive archive = new DownloadableArchive(localFile, remotePath);
                archive.getContentFiles();
                this.newXCAFileName = ASARCalibrator.findXCAFile(localFolder, startDate, endDate);
            }
            this.newXCAFilePath = localFolder.toString() + File.separator + this.newXCAFileName;
        }
    }

    public static String findXCAFile(File xcaFileDir, Date productStartDate, Date productEndDate) throws Exception {
        File[] list = xcaFileDir.listFiles();
        if (list == null) {
            return null;
        }
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        Date latestCreationDate = dateformat.parse("19000101_000000");
        String xcaFileName = null;
        for (File f : list) {
            String fileName = f.getName();
            if (fileName.length() < 61 || !fileName.substring(0, 10).equals("ASA_XCA_AX")) continue;
            Date creationDate = dateformat.parse(fileName.substring(14, 29));
            Date validStartDate = dateformat.parse(fileName.substring(30, 45));
            Date validStopDate = dateformat.parse(fileName.substring(46, 61));
            if (!productStartDate.after(validStartDate) || !productEndDate.before(validStopDate) || !latestCreationDate.before(creationDate)) continue;
            latestCreationDate = creationDate;
            xcaFileName = fileName;
        }
        return xcaFileName;
    }

    private void getNewCalibrationFactor() {
        if (this.newXCAFilePath != null) {
            ASARCalibrator.getCalibrationFactorFromExternalAuxFile(this.newXCAFilePath, this.swath, this.mdsPolar, this.productType, this.newCalibrationConstant);
        } else {
            this.getCalibrationFactorFromMetadata();
        }
    }

    public static void getCalibrationFactorFromExternalAuxFile(String auxFilePath, String swath, String[] mdsPolar, String productType, double[] calibrationFactor) {
        EnvisatAuxReader reader = new EnvisatAuxReader();
        try {
            reader.readProduct((Object)auxFilePath);
            int numOfSwaths = 7;
            for (int i = 0; i < 2 && mdsPolar[i] != null && mdsPolar[i].length() != 0; ++i) {
                String calibrationFactorName;
                calibrationFactor[i] = 0.0;
                if (productType.contains("ASA_IMP_1")) {
                    calibrationFactorName = "ext_cal_im_pri_" + mdsPolar[i];
                } else if (productType.contains("ASA_IMM_1")) {
                    calibrationFactorName = "ext_cal_im_med_" + mdsPolar[i];
                } else if (productType.contains("ASA_APP_1")) {
                    calibrationFactorName = "ext_cal_ap_pri_" + mdsPolar[i];
                } else if (productType.contains("ASA_APM_1")) {
                    calibrationFactorName = "ext_cal_ap_med_" + mdsPolar[i];
                } else if (productType.contains("ASA_WS")) {
                    calibrationFactorName = "ext_cal_ws_" + mdsPolar[i];
                } else if (productType.contains("ASA_GM1_1")) {
                    calibrationFactorName = "ext_cal_gm_" + mdsPolar[i];
                } else if (productType.contains("ASA_IMG_1")) {
                    calibrationFactorName = "ext_cal_im_geo_" + mdsPolar[i];
                } else if (productType.contains("ASA_APG_1")) {
                    calibrationFactorName = "ext_cal_ap_geo_" + mdsPolar[i];
                } else if (productType.contains("ASA_IMS_1")) {
                    calibrationFactorName = "ext_cal_im_" + mdsPolar[i];
                } else if (productType.contains("ASA_APS_1")) {
                    calibrationFactorName = "ext_cal_ap_" + mdsPolar[i];
                } else {
                    throw new OperatorException("Invalid ASAR product type.");
                }
                ProductData factorData = reader.getAuxData(calibrationFactorName);
                float[] factors = (float[])factorData.getElems();
                if (productType.contains("ASA_WS") || productType.contains("ASA_GM1")) {
                    calibrationFactor[i] = factors[0];
                    continue;
                }
                if (factors.length != 7) {
                    throw new OperatorException("Incorrect array length for " + calibrationFactorName);
                }
                if (swath.contains("S1")) {
                    calibrationFactor[i] = factors[0];
                    continue;
                }
                if (swath.contains("S2")) {
                    calibrationFactor[i] = factors[1];
                    continue;
                }
                if (swath.contains("S3")) {
                    calibrationFactor[i] = factors[2];
                    continue;
                }
                if (swath.contains("S4")) {
                    calibrationFactor[i] = factors[3];
                    continue;
                }
                if (swath.contains("S5")) {
                    calibrationFactor[i] = factors[4];
                    continue;
                }
                if (swath.contains("S6")) {
                    calibrationFactor[i] = factors[5];
                    continue;
                }
                if (swath.contains("S7")) {
                    calibrationFactor[i] = factors[6];
                    continue;
                }
                throw new OperatorException("Invalid swath");
            }
        }
        catch (IOException e) {
            throw new OperatorException((Throwable)e);
        }
        if (Double.compare(calibrationFactor[0], 0.0) == 0 && Double.compare(calibrationFactor[1], 0.0) == 0) {
            throw new OperatorException("Calibration factors in user provided auxiliary file are zero");
        }
    }

    private void getCalibrationFactorFromMetadata() {
        this.newCalibrationConstant[0] = this.absRoot.getAttributeDouble("calibration_factor");
        if (this.productType.startsWith("ASA_AP")) {
            this.newCalibrationConstant[1] = this.absRoot.getAttributeDouble("calibration_factor.2");
        }
    }

    private void getOrbitStateVectors() {
        this.orbitStateVectors = AbstractMetadata.getOrbitStateVectors((MetadataElement)this.absRoot);
    }

    private void getFirstLineTime() {
        this.firstLineUTC = this.absRoot.getAttributeUTC("first_line_time").getMJD();
    }

    private void getLineTimeInterval() {
        this.lineTimeInterval = this.absRoot.getAttributeDouble("line_time_interval") / 86400.0;
    }

    private void getAverageSceneHeight() throws Exception {
        this.avgSceneHeight = AbstractMetadata.getAttributeDouble((MetadataElement)this.absRoot, (String)"avg_scene_height");
    }

    private void getNewAntennaPattern() {
        if (this.wideSwathProductFlag) {
            this.newRefElevationAngle = new double[5];
            this.newAntennaPatternWideSwath = new float[5][201];
            ASARCalibrator.getWideSwathAntennaPatternGainFromAuxData(this.newXCAFilePath, this.mdsPolar[0], 201, this.newRefElevationAngle, this.newAntennaPatternWideSwath);
        } else {
            this.newRefElevationAngle = new double[1];
            this.newAntennaPatternSingleSwath = new float[2][201];
            ASARCalibrator.getSingleSwathAntennaPatternGainFromAuxData(this.newXCAFilePath, this.swath, this.mdsPolar, 201, this.newRefElevationAngle, this.newAntennaPatternSingleSwath);
        }
    }

    public static void getSingleSwathAntennaPatternGainFromAuxData(String fileName, String swath, String[] pol, int numOfGains, double[] refElevAngle, float[][] antPatArray) throws OperatorException {
        EnvisatAuxReader reader = new EnvisatAuxReader();
        try {
            String swathName;
            reader.readProduct((Object)fileName);
            if (swath.contains("S1")) {
                swathName = "is1";
            } else if (swath.contains("S2")) {
                swathName = "is2";
            } else if (swath.contains("S3")) {
                swathName = "is3_ss2";
            } else if (swath.contains("S4")) {
                swathName = "is4_ss3";
            } else if (swath.contains("S5")) {
                swathName = "is5_ss4";
            } else if (swath.contains("S6")) {
                swathName = "is6_ss5";
            } else if (swath.contains("S7")) {
                swathName = "is7";
            } else {
                throw new OperatorException("Invalid swath");
            }
            String refElevAngleName = "elev_ang_" + swathName;
            ProductData refElevAngleData = reader.getAuxData(refElevAngleName);
            refElevAngle[0] = refElevAngleData.getElemFloat();
            String patternName = "pattern_" + swathName;
            ProductData patternData = reader.getAuxData(patternName);
            float[] pattern = (float[])patternData.getElems();
            if (pattern.length != 804) {
                throw new OperatorException("Incorret array length for " + patternName);
            }
            for (int i = 0; i < 2 && pol[i] != null && pol[i].length() != 0; ++i) {
                if (pol[i].contains("hh")) {
                    System.arraycopy(pattern, 0, antPatArray[i], 0, numOfGains);
                    continue;
                }
                if (pol[i].contains("vv")) {
                    System.arraycopy(pattern, numOfGains, antPatArray[i], 0, numOfGains);
                    continue;
                }
                if (pol[i].contains("hv")) {
                    System.arraycopy(pattern, 2 * numOfGains, antPatArray[i], 0, numOfGains);
                    continue;
                }
                if (!pol[i].contains("vh")) continue;
                System.arraycopy(pattern, 3 * numOfGains, antPatArray[i], 0, numOfGains);
            }
        }
        catch (IOException e) {
            throw new OperatorException((Throwable)e);
        }
    }

    public static void getWideSwathAntennaPatternGainFromAuxData(String fileName, String pol, int numOfGains, double[] refElevAngle, float[][] antPatArray) throws OperatorException {
        EnvisatAuxReader reader = new EnvisatAuxReader();
        try {
            reader.readProduct((Object)fileName);
            String[] swathName = new String[]{"ss1", "is3_ss2", "is4_ss3", "is5_ss4", "is6_ss5"};
            for (int i = 0; i < swathName.length; ++i) {
                String refElevAngleName = "elev_ang_" + swathName[i];
                ProductData refElevAngleData = reader.getAuxData(refElevAngleName);
                refElevAngle[i] = refElevAngleData.getElemFloat();
                String patternName = "pattern_" + swathName[i];
                ProductData patternData = reader.getAuxData(patternName);
                float[] pattern = (float[])patternData.getElems();
                if (pattern.length != 804) {
                    throw new OperatorException("Incorret array length for " + patternName);
                }
                if (pol.contains("hh")) {
                    System.arraycopy(pattern, 0, antPatArray[i], 0, numOfGains);
                    continue;
                }
                if (pol.contains("vv")) {
                    System.arraycopy(pattern, numOfGains, antPatArray[i], 0, numOfGains);
                    continue;
                }
                if (pol.contains("hv")) {
                    System.arraycopy(pattern, 2 * numOfGains, antPatArray[i], 0, numOfGains);
                    continue;
                }
                if (!pol.contains("vh")) continue;
                System.arraycopy(pattern, 3 * numOfGains, antPatArray[i], 0, numOfGains);
            }
        }
        catch (IOException e) {
            throw new OperatorException((Throwable)e);
        }
    }

    private void setRangeSpreadingLossCompPower() {
        this.rangeSpreadingCompPower = 3.0;
        if (this.productType.contains("ASA_APS_1") || this.productType.contains("ASA_WSS")) {
            this.rangeSpreadingCompPower = 4.0;
        }
        this.halfRangeSpreadingCompPower = this.rangeSpreadingCompPower / 2.0;
    }

    public void updateTargetProductMetadata() {
        MetadataElement tgtAbsRoot = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (this.applyAntennaPatternCorr) {
            AbstractMetadata.setAttribute((MetadataElement)tgtAbsRoot, (String)"ant_elev_corr_flag", (int)1);
        }
        if (this.applyRangeSpreadingCorr) {
            AbstractMetadata.setAttribute((MetadataElement)tgtAbsRoot, (String)"range_spread_comp_flag", (int)1);
        }
        AbstractMetadata.setAttribute((MetadataElement)tgtAbsRoot, (String)"abs_calibration_flag", (int)1);
        if (this.newXCAFileName != null) {
            AbstractMetadata.setAttribute((MetadataElement)tgtAbsRoot, (String)"external_calibration_file", (String)this.newXCAFileName);
        }
        AbstractMetadata.setAttribute((MetadataElement)tgtAbsRoot, (String)"calibration_factor", (double)this.newCalibrationConstant[0]);
    }

    @Override
    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        ProductData srcData1;
        Tile sourceRaster1;
        Band sourceBand1;
        Rectangle targetTileRectangle = targetTile.getRectangle();
        int x0 = targetTileRectangle.x;
        int y0 = targetTileRectangle.y;
        int w = targetTileRectangle.width;
        int h = targetTileRectangle.height;
        ProductData srcData2 = null;
        String[] srcBandNames = (String[])this.targetBandNameToSourceBandName.get(targetBand.getName());
        if (srcBandNames.length == 1) {
            sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
            sourceRaster1 = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand1, targetTileRectangle);
            srcData1 = sourceRaster1.getDataBuffer();
        } else {
            sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
            Band sourceBand2 = this.sourceProduct.getBand(srcBandNames[1]);
            sourceRaster1 = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand1, targetTileRectangle);
            Tile sourceRaster2 = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand2, targetTileRectangle);
            srcData1 = sourceRaster1.getDataBuffer();
            srcData2 = sourceRaster2.getDataBuffer();
        }
        Unit.UnitType tgtBandUnit = Unit.getUnitType((Band)targetBand);
        Unit.UnitType srcBandUnit = Unit.getUnitType((Band)sourceBand1);
        if (tgtBandUnit == Unit.UnitType.PHASE) {
            targetTile.setRawSamples(sourceRaster1.getRawSamples());
            return;
        }
        String pol = OperatorUtils.getBandPolarization((String)srcBandNames[0], (MetadataElement)this.absRoot);
        int prodBand = 0;
        if (pol != null && this.mdsPolar[1] != null && this.mdsPolar[1].contains(pol)) {
            prodBand = 1;
        }
        ProductData trgData = targetTile.getDataBuffer();
        TileIndex srcIndex = new TileIndex(sourceRaster1);
        TileIndex tgtIndex = new TileIndex(targetTile);
        int maxY = y0 + h;
        int maxX = x0 + w;
        double[] incidenceAnglesArray = new double[w];
        double[] slantRangeTimeArray = new double[w];
        double[][] targetTileOldAntPat = null;
        double[][] targetTileNewAntPat = null;
        double[][] targetTileSlantRange = null;
        if (this.applyAntennaPatternCorr) {
            targetTileNewAntPat = new double[h][w];
            targetTileSlantRange = new double[h][w];
            if (this.retroCalibrationFlag) {
                targetTileOldAntPat = new double[h][w];
            }
            if (this.wideSwathProductFlag) {
                this.computeWideSwathAntennaPatternForCurrentTile(x0, y0, w, h, targetTileOldAntPat, targetTileNewAntPat, targetTileSlantRange, this.slantRangeTPGInterp);
            } else {
                this.computeSingleSwathAntennaPatternForCurrentTile(x0, y0, w, h, targetTileOldAntPat, targetTileNewAntPat, targetTileSlantRange, prodBand, this.slantRangeTPGInterp);
            }
        }
        double phaseTerm = 0.0;
        double theCalibrationFactor = this.newCalibrationConstant[prodBand];
        int y = y0;
        int yy = 0;
        while (y < maxY) {
            srcIndex.calculateStride(y);
            tgtIndex.calculateStride(y);
            this.incidenceTPGInterp.getPixels(x0, y, w, 1, incidenceAnglesArray, pm, TiePointInterpolator.InterpMode.QUADRATIC);
            if (this.applyRangeSpreadingCorr) {
                this.slantRangeTPGInterp.getPixels(x0, y, w, 1, slantRangeTimeArray, pm, TiePointInterpolator.InterpMode.QUADRATIC);
            }
            int x = x0;
            int xx = 0;
            while (x < maxX) {
                double dn2;
                int srcIdx = srcIndex.getIndex(x);
                int tgtIdx = tgtIndex.getIndex(x);
                if (srcBandUnit == Unit.UnitType.AMPLITUDE) {
                    double dn = srcData1.getElemDoubleAt(srcIdx);
                    dn2 = dn * dn;
                } else if (srcBandUnit == Unit.UnitType.INTENSITY) {
                    dn2 = srcData1.getElemDoubleAt(srcIdx);
                } else if (srcBandUnit == Unit.UnitType.REAL) {
                    double i = srcData1.getElemDoubleAt(srcIdx);
                    double q = srcData2.getElemDoubleAt(srcIdx);
                    dn2 = i * i + q * q;
                    if (tgtBandUnit == Unit.UnitType.REAL) {
                        phaseTerm = i / Math.sqrt(dn2);
                    } else if (tgtBandUnit == Unit.UnitType.IMAGINARY) {
                        phaseTerm = q / Math.sqrt(dn2);
                    }
                } else if (srcBandUnit == Unit.UnitType.INTENSITY_DB) {
                    dn2 = FastMath.pow((double)10.0, (double)(srcData1.getElemDoubleAt(srcIdx) / 10.0));
                } else {
                    throw new OperatorException("ASAR Calibration: unhandled unit");
                }
                double calFactor = 1.0;
                if (this.retroCalibrationFlag) {
                    calFactor *= targetTileOldAntPat[yy][xx];
                }
                calFactor *= FastMath.sin((double)(incidenceAnglesArray[xx] * (Math.PI / 180))) / theCalibrationFactor;
                if (this.applyRangeSpreadingCorr && targetTileSlantRange != null) {
                    calFactor *= FastMath.pow((double)(targetTileSlantRange[yy][xx] / 800000.0), (double)this.rangeSpreadingCompPower);
                }
                if (this.applyAntennaPatternCorr) {
                    calFactor /= targetTileNewAntPat[yy][xx];
                }
                double sigma = dn2 * calFactor;
                if (this.isComplex && this.outputImageInComplex) {
                    sigma = Math.sqrt(sigma) * phaseTerm;
                }
                if (this.outputImageScaleInDb) {
                    sigma = sigma < 1.0E-30 ? -1.0E-30 : 10.0 * Math.log10(sigma);
                }
                trgData.setElemDoubleAt(tgtIdx, sigma);
                ++x;
                ++xx;
            }
            ++y;
            ++yy;
        }
    }

    private void computeSingleSwathAntennaPatternForCurrentTile(int x0, int y0, int w, int h, double[][] targetTileOldAntPat, double[][] targetTileNewAntPat, double[][] targetTileSlantRange, int band, TiePointInterpolator slantRangeTPGInterp) {
        int yMax = y0 + h;
        for (int y = y0; y < yMax; ++y) {
            double zeroDopplerTime = this.firstLineUTC + (double)y * this.lineTimeInterval;
            double satelliteHeight = ASARCalibrator.computeSatelliteHeight(zeroDopplerTime, this.orbitStateVectors);
            AbstractMetadata.SRGRCoefficientList srgrConvParam = null;
            if (this.srgrFlag) {
                srgrConvParam = this.getSRGRCoefficientsForARangeLine(zeroDopplerTime);
            }
            int yy = y - y0;
            int xMax = x0 + w;
            for (int x = x0; x < xMax; ++x) {
                int xx = x - x0;
                targetTileSlantRange[yy][xx] = this.computeSlantRange(x, y, srgrConvParam, slantRangeTPGInterp);
                double localEarthRadius = this.getEarthRadius(x, y);
                double theta = ASARCalibrator.computeElevationAngle(targetTileSlantRange[yy][xx], satelliteHeight, this.avgSceneHeight + localEarthRadius);
                targetTileNewAntPat[yy][xx] = ASARCalibrator.computeAntPatGain(theta, this.newRefElevationAngle[0], this.newAntennaPatternSingleSwath[band]);
                if (!this.retroCalibrationFlag) continue;
                targetTileOldAntPat[yy][xx] = ASARCalibrator.computeAntPatGain(theta, this.oldRefElevationAngle[0], this.oldAntennaPatternSingleSwath[band]);
            }
        }
    }

    private void computeWideSwathAntennaPatternForCurrentTile(int x0, int y0, int w, int h, double[][] targetTileOldAntPat, double[][] targetTileNewAntPat, double[][] targetTileSlantRange, TiePointInterpolator slantRangeTPGInterp) {
        int yMax = y0 + h;
        for (int y = y0; y < yMax; ++y) {
            double zeroDopplerTime = this.firstLineUTC + (double)y * this.lineTimeInterval;
            double satelitteHeight = ASARCalibrator.computeSatelliteHeight(zeroDopplerTime, this.orbitStateVectors);
            AbstractMetadata.SRGRCoefficientList srgrConvParam = null;
            if (this.srgrFlag) {
                srgrConvParam = this.getSRGRCoefficientsForARangeLine(zeroDopplerTime);
            }
            int yy = y - y0;
            int xMax = x0 + w;
            for (int x = x0; x < xMax; ++x) {
                int xx = x - x0;
                targetTileSlantRange[yy][xx] = this.computeSlantRange(x, y, srgrConvParam, slantRangeTPGInterp);
                double localEarthRadius = this.getEarthRadius(x, y);
                double theta = ASARCalibrator.computeElevationAngle(targetTileSlantRange[yy][xx], satelitteHeight, this.avgSceneHeight + localEarthRadius);
                int subSwathIndex = ASARCalibrator.findSubSwath(theta, this.newRefElevationAngle);
                targetTileNewAntPat[yy][xx] = ASARCalibrator.computeAntPatGain(theta, this.newRefElevationAngle[subSwathIndex], this.newAntennaPatternWideSwath[subSwathIndex]);
                if (!this.retroCalibrationFlag) continue;
                subSwathIndex = ASARCalibrator.findSubSwath(theta, this.oldRefElevationAngle);
                targetTileOldAntPat[yy][xx] = ASARCalibrator.computeAntPatGain(theta, this.oldRefElevationAngle[subSwathIndex], this.oldAntennaPatternWideSwath[subSwathIndex]);
            }
        }
    }

    private double getEarthRadius(int x, int y) {
        int i = (int)((this.latMax - this.latitude.getPixelDouble(x, y)) / this.delLat + 0.5);
        if (i < 0) {
            i = 0;
        } else if (i >= this.earthRadius.length) {
            i = this.earthRadius.length - 1;
        }
        return this.earthRadius[i];
    }

    public static int findSubSwath(double theta, double[] refElevationAngle) {
        int idx = -1;
        double min = 360.0;
        for (int i = 0; i < refElevationAngle.length; ++i) {
            double d = Math.abs(theta - refElevationAngle[i]);
            if (!(d < min)) continue;
            min = d;
            idx = i;
        }
        return idx;
    }

    public static double computeAntPatGain(double elevAngle, double refElevationAngle, float[] antPatArray) {
        double delta = 0.05;
        int k0 = (int)((elevAngle - refElevationAngle + 5.0) / 0.05);
        if (k0 < 0) {
            k0 = 0;
        } else if (k0 >= antPatArray.length - 1) {
            k0 = antPatArray.length - 2;
        }
        double theta0 = refElevationAngle - 5.0 + (double)k0 * 0.05;
        double theta1 = theta0 + 0.05;
        double gain0 = FastMath.pow((double)10.0, (double)((double)antPatArray[k0] / 10.0));
        double gain1 = FastMath.pow((double)10.0, (double)((double)antPatArray[k0 + 1] / 10.0));
        double mu = (elevAngle - theta0) / (theta1 - theta0);
        return Maths.interpolationLinear((double)gain0, (double)gain1, (double)mu);
    }

    private AbstractMetadata.SRGRCoefficientList getSRGRCoefficientsForARangeLine(double zeroDopplerTime) {
        if (this.srgrConvParams.length == 1) {
            return this.srgrConvParams[0];
        }
        int idx = 0;
        int i = 0;
        while (i < this.srgrConvParams.length && zeroDopplerTime >= this.srgrConvParams[i].timeMJD) {
            idx = i++;
        }
        if (idx == this.srgrConvParams.length - 1) {
            --idx;
        }
        AbstractMetadata.SRGRCoefficientList srgrConvParam = new AbstractMetadata.SRGRCoefficientList();
        srgrConvParam.timeMJD = zeroDopplerTime;
        srgrConvParam.ground_range_origin = this.srgrConvParams[idx].ground_range_origin;
        srgrConvParam.coefficients = new double[this.srgrConvParams[idx].coefficients.length];
        double mu = (zeroDopplerTime - this.srgrConvParams[idx].timeMJD) / (this.srgrConvParams[idx + 1].timeMJD - this.srgrConvParams[idx].timeMJD);
        for (int i2 = 0; i2 < srgrConvParam.coefficients.length; ++i2) {
            srgrConvParam.coefficients[i2] = Maths.interpolationLinear((double)this.srgrConvParams[idx].coefficients[i2], (double)this.srgrConvParams[idx + 1].coefficients[i2], (double)mu);
        }
        return srgrConvParam;
    }

    private double computeSlantRange(int x, int y, AbstractMetadata.SRGRCoefficientList srgrConvParam, TiePointInterpolator slantRangeTPGInterp) {
        if (this.srgrFlag) {
            return Maths.computePolynomialValue((double)((double)x * this.rangeSpacing + srgrConvParam.ground_range_origin), (double[])srgrConvParam.coefficients);
        }
        double time = slantRangeTPGInterp.getPixelDouble(x, y, TiePointInterpolator.InterpMode.QUADRATIC) / 1.0E9;
        return time * 1.49896229E8;
    }

    public static double computeSatelliteHeight(double zeroDopplerTime, OrbitStateVector[] orbitStateVectors) {
        int idx = 0;
        int i = 0;
        while (i < orbitStateVectors.length && zeroDopplerTime >= orbitStateVectors[i].time_mjd) {
            idx = i++;
        }
        double xPos = orbitStateVectors[idx].x_pos;
        double yPos = orbitStateVectors[idx].y_pos;
        double zPos = orbitStateVectors[idx].z_pos;
        return Math.sqrt(xPos * xPos + yPos * yPos + zPos * zPos);
    }

    private void computeEarthRadius() {
        OperatorUtils.ImageGeoBoundary imageGeoBoundary = OperatorUtils.computeImageGeoBoundary((Product)this.sourceProduct);
        this.latMax = imageGeoBoundary.latMax;
        double latMin = imageGeoBoundary.latMin;
        double minSpacing = Math.min(this.rangeSpacing, this.azimuthSpacing);
        double minAbsLat = latMin * this.latMax > 0.0 ? Math.min(Math.abs(latMin), Math.abs(this.latMax)) * (Math.PI / 180) : 0.0;
        this.delLat = minSpacing / 6371008.7714 * 57.29577951308232;
        double delLon = minSpacing / (6371008.7714 * FastMath.cos((double)minAbsLat)) * 57.29577951308232;
        this.delLat = Math.min(this.delLat, delLon);
        int h = (int)((this.latMax - latMin) / this.delLat) + 1;
        this.earthRadius = new double[h + 1];
        for (int i = 0; i <= h; ++i) {
            this.earthRadius[i] = ASARCalibrator.computeEarthRadius((float)(this.latMax - (double)i * this.delLat), 0.0f);
        }
    }

    private static double computeEarthRadius(float lat, float lon) {
        double[] xyz = new double[3];
        GeoUtils.geo2xyz((double)lat, (double)lon, (double)0.0, (double[])xyz, (GeoUtils.EarthModel)GeoUtils.EarthModel.WGS84);
        return Math.sqrt(xyz[0] * xyz[0] + xyz[1] * xyz[1] + xyz[2] * xyz[2]);
    }

    public static double computeElevationAngle(double slantRange, double satelliteHeight, double sceneToEarthCentre) {
        return FastMath.acos((double)((slantRange * slantRange + satelliteHeight * satelliteHeight - sceneToEarthCentre * sceneToEarthCentre) / (2.0 * slantRange * satelliteHeight))) * 57.29577951308232;
    }

    @Override
    public double applyRetroCalibration(int x, int y, double v, String bandPolar, Unit.UnitType bandUnit, int[] subSwathIndex) {
        if (!this.retroCalibrationFlag) {
            return v;
        }
        int bandPolarIdx = 0;
        if (bandPolar != null && this.mdsPolar[1] != null && this.mdsPolar[1].contains(bandPolar)) {
            bandPolarIdx = 1;
        }
        double zeroDopplerTime = this.firstLineUTC + (double)y * this.lineTimeInterval;
        double satelitteHeight = ASARCalibrator.computeSatelliteHeight(zeroDopplerTime, this.orbitStateVectors);
        AbstractMetadata.SRGRCoefficientList srgrConvParam = null;
        if (this.srgrFlag) {
            srgrConvParam = this.getSRGRCoefficientsForARangeLine(zeroDopplerTime);
        }
        TiePointInterpolator slantRangeTPGInterp = new TiePointInterpolator(this.slantRangeTime);
        double slantRange = this.computeSlantRange(x, y, srgrConvParam, slantRangeTPGInterp);
        double elevationAngle = ASARCalibrator.computeElevationAngle(slantRange, satelitteHeight, this.avgSceneHeight + this.getEarthRadius(x, y));
        double gain = 0.0;
        gain = this.wideSwathProductFlag ? ASARCalibrator.getAntennaPatternGain(elevationAngle, bandPolarIdx, this.oldRefElevationAngle, this.oldAntennaPatternWideSwath, true, subSwathIndex) : ASARCalibrator.computeAntPatGain(elevationAngle, this.oldRefElevationAngle[0], this.oldAntennaPatternSingleSwath[bandPolarIdx]);
        if (bandUnit == Unit.UnitType.AMPLITUDE) {
            return v * Math.sqrt(gain) * FastMath.pow((double)(800000.0 / slantRange), (double)this.halfRangeSpreadingCompPower);
        }
        if (bandUnit == Unit.UnitType.AMPLITUDE_DB) {
            return 10.0 * Math.log10(FastMath.pow((double)10.0, (double)(v / 10.0)) * Math.sqrt(gain) * FastMath.pow((double)(800000.0 / slantRange), (double)this.halfRangeSpreadingCompPower));
        }
        if (bandUnit == Unit.UnitType.INTENSITY || bandUnit == Unit.UnitType.REAL || bandUnit == Unit.UnitType.IMAGINARY) {
            return v * gain * FastMath.pow((double)(800000.0 / slantRange), (double)this.rangeSpreadingCompPower);
        }
        if (bandUnit == Unit.UnitType.INTENSITY_DB) {
            return 10.0 * Math.log10(FastMath.pow((double)10.0, (double)(v / 10.0)) * gain * FastMath.pow((double)(800000.0 / slantRange), (double)this.rangeSpreadingCompPower));
        }
        throw new OperatorException("Unknown band unit");
    }

    private static double getAntennaPatternGain(double elevationAngle, int bandPolar, double[] refElevationAngle, float[][] antennaPattern, boolean compSubSwathIdx, int[] subSwathIndex) {
        if (refElevationAngle.length == 1) {
            return ASARCalibrator.computeAntPatGain(elevationAngle, refElevationAngle[0], antennaPattern[bandPolar]);
        }
        if (compSubSwathIdx || subSwathIndex[0] == -1) {
            subSwathIndex[0] = ASARCalibrator.findSubSwath(elevationAngle, refElevationAngle);
        }
        return ASARCalibrator.computeAntPatGain(elevationAngle, refElevationAngle[subSwathIndex[0]], antennaPattern[subSwathIndex[0]]);
    }

    @Override
    public double applyCalibration(double v, double rangeIndex, double azimuthIndex, double slantRange, double satelliteHeight, double sceneToEarthCentre, double localIncidenceAngle, String bandName, String bandPolar, Unit.UnitType bandUnit, int[] subSwathIndex) {
        int bandPolarIdx = 0;
        if (bandPolar != null && this.mdsPolar[1] != null && this.mdsPolar[1].contains(bandPolar)) {
            bandPolarIdx = 1;
        }
        double sigma = 0.0;
        if (bandUnit == Unit.UnitType.AMPLITUDE) {
            sigma = v * v;
        } else if (bandUnit == Unit.UnitType.AMPLITUDE_DB) {
            sigma = FastMath.pow((double)10.0, (double)(v / 5.0));
        } else if (bandUnit == Unit.UnitType.INTENSITY || bandUnit == Unit.UnitType.REAL || bandUnit == Unit.UnitType.IMAGINARY) {
            sigma = v;
        } else if (bandUnit == Unit.UnitType.INTENSITY_DB) {
            sigma = FastMath.pow((double)10.0, (double)(v / 10.0));
        } else {
            throw new OperatorException("Unknown band unit");
        }
        sigma *= FastMath.sin((double)(Math.abs(localIncidenceAngle) * (Math.PI / 180))) / this.newCalibrationConstant[bandPolarIdx];
        if (this.multilookFlag && this.antElevCorrFlag) {
            return sigma;
        }
        if (this.auxFile == null || !this.auxFile.contains("Product Auxiliary File")) {
            sigma *= FastMath.pow((double)(slantRange / 800000.0), (double)this.rangeSpreadingCompPower);
        }
        if (this.applyAntennaPatternCorr) {
            double gain;
            double elevationAngle = ASARCalibrator.computeElevationAngle(slantRange, satelliteHeight, sceneToEarthCentre);
            if (this.wideSwathProductFlag) {
                if (subSwathIndex[0] == -1) {
                    TiePointInterpolator slantRangeTPGInterp = new TiePointInterpolator(this.slantRangeTime);
                    this.computeSubSwathIndex(rangeIndex, azimuthIndex, this.newRefElevationAngle, subSwathIndex, slantRangeTPGInterp);
                }
                gain = ASARCalibrator.getAntennaPatternGain(elevationAngle, bandPolarIdx, this.newRefElevationAngle, this.newAntennaPatternWideSwath, false, subSwathIndex);
            } else {
                gain = ASARCalibrator.computeAntPatGain(elevationAngle, this.newRefElevationAngle[0], this.newAntennaPatternSingleSwath[bandPolarIdx]);
            }
            sigma /= gain;
        }
        return sigma;
    }

    private void computeSubSwathIndex(double rangeIndex, double azimuthIndex, double[] refElevationAngle, int[] subSwathIndex, TiePointInterpolator slantRangeTPGInterp) {
        int x = (int)(rangeIndex + 0.5);
        int y = (int)(azimuthIndex + 0.5);
        double zeroDopplerTime = this.firstLineUTC + (double)y * this.lineTimeInterval;
        double satelitteHeight = ASARCalibrator.computeSatelliteHeight(zeroDopplerTime, this.orbitStateVectors);
        AbstractMetadata.SRGRCoefficientList srgrConvParam = null;
        if (this.srgrFlag) {
            srgrConvParam = this.getSRGRCoefficientsForARangeLine(zeroDopplerTime);
        }
        double slantRange = this.computeSlantRange(x, y, srgrConvParam, slantRangeTPGInterp);
        double elevationAngle = ASARCalibrator.computeElevationAngle(slantRange, satelitteHeight, this.avgSceneHeight + this.getEarthRadius(x, y));
        subSwathIndex[0] = ASARCalibrator.findSubSwath(elevationAngle, refElevationAngle);
    }

    @Override
    public void removeFactorsForCurrentTile(Band targetBand, Tile targetTile, String srcBandName) throws OperatorException {
        if (!this.srgrFlag) {
            return;
        }
        Rectangle targetTileRectangle = targetTile.getRectangle();
        int x0 = targetTileRectangle.x;
        int y0 = targetTileRectangle.y;
        int w = targetTileRectangle.width;
        int h = targetTileRectangle.height;
        Band sourceBand = this.sourceProduct.getBand(srcBandName);
        Tile sourceTile = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand, targetTileRectangle);
        ProductData srcData = sourceTile.getDataBuffer();
        Unit.UnitType bandUnit = Unit.getUnitType((Band)sourceBand);
        ProductData trgData = targetTile.getDataBuffer();
        String pol = OperatorUtils.getBandPolarization((String)targetBand.getName(), (MetadataElement)this.absRoot);
        int prodBand = 0;
        if (pol != null && this.mdsPolar[1] != null && this.mdsPolar[1].contains(pol)) {
            prodBand = 1;
        }
        double[][] targetTileNewAntPat = new double[h][w];
        double[][] targetTileSlantRange = new double[h][w];
        double[][] targetTileOldAntPat = new double[h][w];
        TiePointInterpolator slantRangeTPGInterp = new TiePointInterpolator(this.slantRangeTime);
        if (this.wideSwathProductFlag) {
            this.computeWideSwathAntennaPatternForCurrentTile(x0, y0, w, h, targetTileOldAntPat, targetTileNewAntPat, targetTileSlantRange, slantRangeTPGInterp);
        } else {
            this.computeSingleSwathAntennaPatternForCurrentTile(x0, y0, w, h, targetTileOldAntPat, targetTileNewAntPat, targetTileSlantRange, prodBand, slantRangeTPGInterp);
        }
        int maxY = y0 + h;
        int maxX = x0 + w;
        int y = y0;
        int yy = 0;
        while (y < maxY) {
            int x = x0;
            int xx = 0;
            while (x < maxX) {
                double v = srcData.getElemDoubleAt(sourceTile.getDataBufferIndex(x, y));
                double gain = targetTileOldAntPat[yy][xx];
                double slantRange = targetTileSlantRange[yy][xx];
                if (bandUnit == Unit.UnitType.AMPLITUDE) {
                    v *= Math.sqrt(gain) * FastMath.pow((double)(800000.0 / slantRange), (double)(0.5 * this.rangeSpreadingCompPower));
                } else if (bandUnit == Unit.UnitType.AMPLITUDE_DB) {
                    v = FastMath.pow((double)10.0, (double)(v / 10.0)) * Math.sqrt(gain) * FastMath.pow((double)(800000.0 / slantRange), (double)(0.5 * this.rangeSpreadingCompPower));
                    v = 10.0 * Math.log10(v);
                } else if (bandUnit == Unit.UnitType.INTENSITY) {
                    v *= gain * FastMath.pow((double)(800000.0 / slantRange), (double)this.rangeSpreadingCompPower);
                } else if (bandUnit == Unit.UnitType.INTENSITY_DB) {
                    v = FastMath.pow((double)10.0, (double)(v / 10.0)) * gain * FastMath.pow((double)(800000.0 / slantRange), (double)this.rangeSpreadingCompPower);
                    v = 10.0 * Math.log10(v);
                } else {
                    throw new OperatorException("Unknown band unit");
                }
                trgData.setElemDoubleAt(targetTile.getDataBufferIndex(x, y), v);
                ++x;
                ++xx;
            }
            ++y;
            ++yy;
        }
    }
}

