/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.calibration.gpf.calibrators;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.calibration.gpf.support.BaseCalibrator;
import org.esa.s1tbx.calibration.gpf.support.Calibrator;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.Unit;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

public class ALOSCalibrator
extends BaseCalibrator
implements Calibrator {
    private double calibrationFactor = 0.0;
    private TiePointGrid incidenceAngle = null;
    private static final String USE_INCIDENCE_ANGLE_FROM_DEM = "Use projected local incidence angle from DEM";

    @Override
    public void setExternalAuxFile(File file) throws OperatorException {
        if (file != null) {
            throw new OperatorException("No external auxiliary file should be selected for ALOS PALSAR product");
        }
    }

    @Override
    public void setAuxFileFlag(String file) {
    }

    @Override
    public void initialize(Operator op, Product srcProduct, Product tgtProduct, boolean mustPerformRetroCalibration, boolean mustUpdateMetadata) throws OperatorException {
        try {
            this.calibrationOp = op;
            this.sourceProduct = srcProduct;
            this.targetProduct = tgtProduct;
            this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            String mission = this.absRoot.getAttributeString("MISSION");
            if (!mission.equals("ALOS") && !mission.equals("ALOS2")) {
                throw new OperatorException(mission + " is not a valid mission for ALOS Calibration");
            }
            if (this.absRoot.getAttribute("abs_calibration_flag").getData().getElemBoolean()) {
                throw new OperatorException("Absolute radiometric calibration has already been applied to the product");
            }
            this.getSampleType();
            this.getCalibrationFactor();
            this.getTiePointGridData(this.sourceProduct);
            if (mustUpdateMetadata) {
                this.updateTargetProductMetadata();
            }
        }
        catch (Exception e) {
            throw new OperatorException((Throwable)e);
        }
    }

    private void getCalibrationFactor() {
        this.calibrationFactor = this.absRoot.getAttributeDouble("calibration_factor");
        if (this.isComplex) {
            this.calibrationFactor -= 32.0;
        }
        this.calibrationFactor = FastMath.pow((double)10.0, (double)(this.calibrationFactor / 10.0));
    }

    private void getTiePointGridData(Product sourceProduct) {
        this.incidenceAngle = OperatorUtils.getIncidenceAngle((Product)sourceProduct);
    }

    private void updateTargetProductMetadata() {
        MetadataElement abs = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        abs.getAttribute("abs_calibration_flag").getData().setElemBoolean(true);
    }

    @Override
    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle targetTileRectangle = targetTile.getRectangle();
        int x0 = targetTileRectangle.x;
        int y0 = targetTileRectangle.y;
        int w = targetTileRectangle.width;
        int h = targetTileRectangle.height;
        Tile sourceRaster1 = null;
        ProductData srcData1 = null;
        ProductData srcData2 = null;
        Band sourceBand1 = null;
        String[] srcBandNames = (String[])this.targetBandNameToSourceBandName.get(targetBand.getName());
        if (srcBandNames.length == 1) {
            sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
            sourceRaster1 = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand1, targetTileRectangle);
            srcData1 = sourceRaster1.getDataBuffer();
        } else {
            sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
            Band sourceBand2 = this.sourceProduct.getBand(srcBandNames[1]);
            sourceRaster1 = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand1, targetTileRectangle);
            Tile sourceRaster2 = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand2, targetTileRectangle);
            srcData1 = sourceRaster1.getDataBuffer();
            srcData2 = sourceRaster2.getDataBuffer();
        }
        Unit.UnitType tgtBandUnit = Unit.getUnitType((Band)targetBand);
        Unit.UnitType srcBandUnit = Unit.getUnitType((Band)sourceBand1);
        if (tgtBandUnit == Unit.UnitType.PHASE) {
            targetTile.setRawSamples(sourceRaster1.getRawSamples());
            return;
        }
        ProductData trgData = targetTile.getDataBuffer();
        TileIndex srcIndex = new TileIndex(sourceRaster1);
        TileIndex tgtIndex = new TileIndex(targetTile);
        int maxY = y0 + h;
        int maxX = x0 + w;
        double phaseTerm = 0.0;
        for (int y = y0; y < maxY; ++y) {
            srcIndex.calculateStride(y);
            tgtIndex.calculateStride(y);
            for (int x = x0; x < maxX; ++x) {
                double dn2;
                int srcIdx = srcIndex.getIndex(x);
                int tgtIdx = tgtIndex.getIndex(x);
                if (srcBandUnit == Unit.UnitType.AMPLITUDE) {
                    double dn = srcData1.getElemDoubleAt(srcIdx);
                    dn2 = dn * dn;
                } else if (srcBandUnit == Unit.UnitType.INTENSITY) {
                    dn2 = srcData1.getElemDoubleAt(srcIdx);
                } else if (srcBandUnit == Unit.UnitType.REAL) {
                    double i = srcData1.getElemDoubleAt(srcIdx);
                    double q = srcData2.getElemDoubleAt(srcIdx);
                    dn2 = i * i + q * q;
                    if (tgtBandUnit == Unit.UnitType.REAL) {
                        phaseTerm = i / Math.sqrt(dn2);
                    } else if (tgtBandUnit == Unit.UnitType.IMAGINARY) {
                        phaseTerm = q / Math.sqrt(dn2);
                    }
                } else if (srcBandUnit == Unit.UnitType.INTENSITY_DB) {
                    dn2 = FastMath.pow((double)10.0, (double)(srcData1.getElemDoubleAt(srcIdx) / 10.0));
                } else {
                    throw new OperatorException("ALOS Calibration: unhandled unit");
                }
                double sigma = dn2 * this.calibrationFactor;
                if (this.isComplex && this.outputImageInComplex) {
                    sigma = Math.sqrt(sigma) * phaseTerm;
                }
                if (this.outputImageScaleInDb) {
                    sigma = sigma < 1.0E-30 ? -1.0E-30 : 10.0 * Math.log10(sigma);
                }
                trgData.setElemDoubleAt(tgtIdx, sigma);
            }
        }
    }

    @Override
    public double applyCalibration(double v, double rangeIndex, double azimuthIndex, double slantRange, double satelliteHeight, double sceneToEarthCentre, double localIncidenceAngle, String bandName, String bandPolar, Unit.UnitType bandUnit, int[] subSwathIndex) {
        double sigma = 0.0;
        if (bandUnit == Unit.UnitType.AMPLITUDE) {
            sigma = v * v;
        } else if (bandUnit == Unit.UnitType.INTENSITY || bandUnit == Unit.UnitType.REAL || bandUnit == Unit.UnitType.IMAGINARY) {
            sigma = v;
        } else if (bandUnit == Unit.UnitType.INTENSITY_DB) {
            sigma = FastMath.pow((double)10.0, (double)(v / 10.0));
        } else {
            throw new OperatorException("Unknown band unit");
        }
        if (this.incidenceAngleSelection.contains(USE_INCIDENCE_ANGLE_FROM_DEM)) {
            return sigma * this.calibrationFactor * FastMath.sin((double)(localIncidenceAngle * (Math.PI / 180)));
        }
        return sigma * this.calibrationFactor;
    }

    @Override
    public double applyRetroCalibration(int x, int y, double v, String bandPolar, Unit.UnitType bandUnit, int[] subSwathIndex) {
        if (this.incidenceAngleSelection.contains(USE_INCIDENCE_ANGLE_FROM_DEM)) {
            return v / FastMath.sin((double)(this.incidenceAngle.getPixelDouble(x, y) * (Math.PI / 180)));
        }
        return v;
    }

    @Override
    public void removeFactorsForCurrentTile(Band targetBand, Tile targetTile, String srcBandName) throws OperatorException {
        Band sourceBand = this.sourceProduct.getBand(targetBand.getName());
        Tile sourceTile = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand, targetTile.getRectangle());
        targetTile.setRawSamples(sourceTile.getRawSamples());
    }
}

