/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.calibration.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.esa.s1tbx.calibration.gpf.calibrators.Sentinel1Calibrator;
import org.esa.s1tbx.insar.gpf.support.Sentinel1Utils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.Unit;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;
import org.esa.snap.engine_utilities.util.Maths;

@OperatorMetadata(alias="ThermalNoiseRemoval", category="Radar/Radiometric", authors="Cecilia Wong, Jun Lu, Luis Veci", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", version="1.0", description="Removes thermal noise from products")
public final class Sentinel1RemoveThermalNoiseOp
extends Operator {
    @SourceProduct
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of polarisations", label="Polarisations")
    private String[] selectedPolarisations;
    @Parameter(description="Remove thermal noise", defaultValue="true", label="Remove Thermal Noise")
    private Boolean removeThermalNoise = true;
    @Parameter(description="Re-introduce thermal noise", defaultValue="false", label="Re-Introduce Thermal Noise")
    private Boolean reIntroduceThermalNoise = false;
    private MetadataElement absRoot = null;
    private MetadataElement origMetadataRoot = null;
    private boolean thermalNoiseCorrectionPerformed = false;
    private boolean absoluteCalibrationPerformed = false;
    private boolean inputSigmaBand = false;
    private boolean inputBetaBand = false;
    private boolean inputGammaBand = false;
    private boolean inputDNBand = false;
    private boolean isTOPSARSLC = false;
    private String productType = null;
    private int numOfSubSwath = 1;
    private ThermalNoiseInfo[] noise = null;
    private Sentinel1Calibrator.CalibrationInfo[] calibration = null;
    private List<String> selectedPolList = null;
    private final HashMap<String, String[]> targetBandNameToSourceBandName = new HashMap(2);

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSentinel1Product();
            validator.checkAcquisitionMode(new String[]{"IW", "EW", "SM"});
            validator.checkProductType(new String[]{"SLC", "GRD"});
            this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            this.origMetadataRoot = AbstractMetadata.getOriginalProductMetadata((Product)this.sourceProduct);
            this.getProductType();
            this.getAcquisitionMode();
            this.getThermalNoiseCorrectionFlag();
            this.setSelectedPolarisations();
            this.noise = Sentinel1RemoveThermalNoiseOp.getThermalNoiseVectors(this.origMetadataRoot, this.selectedPolList, this.numOfSubSwath);
            this.getCalibrationFlag();
            if (this.absoluteCalibrationPerformed) {
                this.getCalibrationVectors();
            }
            this.createTargetProduct();
            this.updateTargetProductMetadata();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void getProductType() {
        this.productType = this.absRoot.getAttributeString("PRODUCT_TYPE");
        String mode = this.absRoot.getAttributeString("ACQUISITION_MODE");
        this.isTOPSARSLC = this.productType.contains("SLC") && (mode.contains("IW") || mode.contains("EW"));
    }

    private void getAcquisitionMode() {
        String acquisitionMode = this.absRoot.getAttributeString("ACQUISITION_MODE");
        if (this.productType.equals("SLC")) {
            if (acquisitionMode.equals("IW")) {
                this.numOfSubSwath = 3;
            } else if (acquisitionMode.equals("EW")) {
                this.numOfSubSwath = 5;
            }
        }
    }

    private void getThermalNoiseCorrectionFlag() {
        MetadataElement annotationElem = this.origMetadataRoot.getElement("annotation");
        MetadataElement[] annotationDataSetListElem = annotationElem.getElements();
        MetadataElement productElem = annotationDataSetListElem[0].getElement("product");
        MetadataElement imageAnnotationElem = productElem.getElement("imageAnnotation");
        MetadataElement processingInformationElem = imageAnnotationElem.getElement("processingInformation");
        this.thermalNoiseCorrectionPerformed = Boolean.parseBoolean(processingInformationElem.getAttribute("thermalNoiseCorrectionPerformed").getData().getElemString());
        if (this.removeThermalNoise.booleanValue() && this.thermalNoiseCorrectionPerformed) {
            throw new OperatorException("Thermal noise correction has already been performed for the product");
        }
        if (this.reIntroduceThermalNoise.booleanValue() && !this.thermalNoiseCorrectionPerformed) {
            throw new OperatorException("Thermal noise correction has never been performed for the product");
        }
    }

    public static ThermalNoiseInfo[] getThermalNoiseVectors(MetadataElement origMetadataRoot, List<String> selectedPolList, int numOfSubSwath) {
        ThermalNoiseInfo[] noise = new ThermalNoiseInfo[numOfSubSwath * selectedPolList.size()];
        MetadataElement noiseElem = origMetadataRoot.getElement("noise");
        MetadataElement[] noiseDataSetListElem = noiseElem.getElements();
        int dataSetIndex = 0;
        for (MetadataElement dataSetListElem : noiseDataSetListElem) {
            MetadataElement noiElem = dataSetListElem.getElement("noise");
            MetadataElement adsHeaderElem = noiElem.getElement("adsHeader");
            String pol = adsHeaderElem.getAttributeString("polarisation");
            if (!selectedPolList.contains(pol)) continue;
            MetadataElement noiseVectorListElem = noiElem.getElement("noiseVectorList");
            String subSwath = adsHeaderElem.getAttributeString("swath");
            noise[dataSetIndex] = new ThermalNoiseInfo(pol, subSwath, Sentinel1Utils.getTime((MetadataElement)adsHeaderElem, (String)"startTime").getMJD(), Sentinel1Utils.getTime((MetadataElement)adsHeaderElem, (String)"stopTime").getMJD(), Sentinel1Calibrator.getNumOfLines(origMetadataRoot, pol, subSwath), Integer.parseInt(noiseVectorListElem.getAttributeString("count")), Sentinel1Utils.getNoiseVector((MetadataElement)noiseVectorListElem));
            ++dataSetIndex;
        }
        return noise;
    }

    private void getCalibrationFlag() {
        this.absoluteCalibrationPerformed = this.absRoot.getAttribute("abs_calibration_flag").getData().getElemBoolean();
        if (this.absoluteCalibrationPerformed) {
            String[] sourceBandNames;
            for (String bandName : sourceBandNames = this.sourceProduct.getBandNames()) {
                if (bandName.contains("Sigma0")) {
                    this.inputSigmaBand = true;
                    continue;
                }
                if (bandName.contains("Gamma0")) {
                    this.inputGammaBand = true;
                    continue;
                }
                if (bandName.contains("Beta0")) {
                    this.inputBetaBand = true;
                    continue;
                }
                if (!bandName.contains("DN")) continue;
                this.inputDNBand = true;
            }
            if (!(this.inputSigmaBand || this.inputGammaBand || this.inputBetaBand || this.inputDNBand)) {
                throw new OperatorException("For calibrated product, Sigma0 or Gamma0 or Beta0 or DN band is expected");
            }
        }
    }

    private void getCalibrationVectors() {
        this.calibration = Sentinel1Calibrator.getCalibrationVectors(this.sourceProduct, this.selectedPolList, this.inputSigmaBand, this.inputBetaBand, this.inputGammaBand, this.inputDNBand);
    }

    private void setSelectedPolarisations() {
        String[] selectedPols = this.selectedPolarisations;
        if (selectedPols == null || selectedPols.length == 0) {
            selectedPols = Sentinel1Utils.getProductPolarizations((MetadataElement)this.absRoot);
        }
        this.selectedPolList = Arrays.asList(selectedPols);
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        this.addSelectedBands();
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
    }

    private void addSelectedBands() {
        Band[] sourceBands = this.sourceProduct.getBands();
        for (int i = 0; i < sourceBands.length; ++i) {
            String targetBandName;
            String[] srcBandNames;
            Band srcBand = sourceBands[i];
            String unit = srcBand.getUnit();
            if (unit == null) {
                throw new OperatorException("band " + srcBand.getName() + " requires a unit");
            }
            if (!unit.contains("real") && !unit.contains("amplitude") && !unit.contains("intensity")) continue;
            if (unit.contains("real")) {
                if (i + 1 >= sourceBands.length) {
                    throw new OperatorException("Real and imaginary bands are not in pairs");
                }
                String nextUnit = sourceBands[i + 1].getUnit();
                if (nextUnit == null || !nextUnit.contains("imaginary")) {
                    throw new OperatorException("Real and imaginary bands are not in pairs");
                }
                srcBandNames = new String[]{srcBand.getName(), sourceBands[i + 1].getName()};
                ++i;
            } else {
                srcBandNames = new String[]{srcBand.getName()};
            }
            String pol = srcBandNames[0].substring(srcBandNames[0].lastIndexOf("_") + 1);
            if (!this.selectedPolList.contains(pol) || this.targetProduct.getBand(targetBandName = this.createTargetBandName(srcBandNames[0])) != null) continue;
            this.targetBandNameToSourceBandName.put(targetBandName, srcBandNames);
            Band targetBand = new Band(targetBandName, 30, srcBand.getRasterWidth(), srcBand.getRasterHeight());
            targetBand.setUnit("intensity");
            targetBand.setDescription(srcBand.getDescription());
            targetBand.setNoDataValue(srcBand.getNoDataValue());
            targetBand.setNoDataValueUsed(srcBand.isNoDataValueUsed());
            this.targetProduct.addBand(targetBand);
        }
    }

    private String createTargetBandName(String sourceBandName) {
        if (this.absoluteCalibrationPerformed) {
            return sourceBandName;
        }
        String pol = sourceBandName.substring(sourceBandName.indexOf(95));
        return "Intensity" + pol;
    }

    private void updateTargetProductMetadata() {
        MetadataElement[] annotationDataSetListElem;
        MetadataElement abs = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        String[] targetBandNames = this.targetProduct.getBandNames();
        Sentinel1Utils.updateBandNames((MetadataElement)abs, this.selectedPolList, (String[])targetBandNames);
        MetadataElement origMetadataRoot = AbstractMetadata.getOriginalProductMetadata((Product)this.targetProduct);
        MetadataElement annotationElem = origMetadataRoot.getElement("annotation");
        for (MetadataElement elem : annotationDataSetListElem = annotationElem.getElements()) {
            MetadataElement productElem = elem.getElement("product");
            MetadataElement imageAnnotationElem = productElem.getElement("imageAnnotation");
            MetadataElement processingInformationElem = imageAnnotationElem.getElement("processingInformation");
            if (this.removeThermalNoise.booleanValue()) {
                processingInformationElem.getAttribute("thermalNoiseCorrectionPerformed").getData().setElems((Object)"true");
            }
            if (!this.reIntroduceThermalNoise.booleanValue()) continue;
            processingInformationElem.getAttribute("thermalNoiseCorrectionPerformed").getData().setElems((Object)"false");
        }
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle targetTileRectangle = targetTile.getRectangle();
        int x0 = targetTileRectangle.x;
        int y0 = targetTileRectangle.y;
        int w = targetTileRectangle.width;
        int h = targetTileRectangle.height;
        try {
            String targetBandName = targetBand.getName();
            ThermalNoiseInfo noiseInfo = this.getNoiseInfo(targetBandName);
            Tile sourceRaster1 = null;
            ProductData srcData1 = null;
            ProductData srcData2 = null;
            Band sourceBand1 = null;
            String[] srcBandNames = this.targetBandNameToSourceBandName.get(targetBand.getName());
            if (srcBandNames.length == 1) {
                sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
                sourceRaster1 = this.getSourceTile((RasterDataNode)sourceBand1, targetTileRectangle);
                srcData1 = sourceRaster1.getDataBuffer();
            } else {
                sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
                Band sourceBand2 = this.sourceProduct.getBand(srcBandNames[1]);
                sourceRaster1 = this.getSourceTile((RasterDataNode)sourceBand1, targetTileRectangle);
                Tile sourceRaster2 = this.getSourceTile((RasterDataNode)sourceBand2, targetTileRectangle);
                srcData1 = sourceRaster1.getDataBuffer();
                srcData2 = sourceRaster2.getDataBuffer();
            }
            Unit.UnitType bandUnit = Unit.getUnitType((Band)sourceBand1);
            ProductData trgData = targetTile.getDataBuffer();
            TileIndex srcIndex = new TileIndex(sourceRaster1);
            TileIndex tgtIndex = new TileIndex(targetTile);
            int maxY = y0 + h;
            int maxX = x0 + w;
            boolean complexData = bandUnit == Unit.UnitType.REAL || bandUnit == Unit.UnitType.IMAGINARY;
            Sentinel1Calibrator.CalibrationInfo calInfo = null;
            Sentinel1Calibrator.CALTYPE calType = null;
            if (this.absoluteCalibrationPerformed) {
                calInfo = this.getCalInfo(targetBandName);
                calType = Sentinel1Calibrator.getCalibrationType(targetBandName);
            }
            for (int y = y0; y < maxY; ++y) {
                srcIndex.calculateStride(y);
                tgtIndex.calculateStride(y);
                double[] lut = new double[w];
                if (this.absoluteCalibrationPerformed) {
                    int calVecIdx = calInfo.getCalibrationVectorIndex(y);
                    Sentinel1Utils.CalibrationVector vec0 = calInfo.getCalibrationVector(calVecIdx);
                    Sentinel1Utils.CalibrationVector vec1 = calInfo.getCalibrationVector(calVecIdx + 1);
                    float[] vec0LUT = Sentinel1Calibrator.getVector(calType, vec0);
                    float[] vec1LUT = Sentinel1Calibrator.getVector(calType, vec1);
                    Sentinel1Utils.CalibrationVector calVec = calInfo.calibrationVectorList[calVecIdx];
                    int pixelIdx0 = calVec.getPixelIndex(x0);
                    this.computeTileScaledNoiseLUT(y, x0, w, noiseInfo, calInfo, vec0.timeMJD, vec1.timeMJD, vec0LUT, vec1LUT, vec0.pixels, pixelIdx0, lut);
                } else {
                    Sentinel1RemoveThermalNoiseOp.computeTileNoiseLUT(y, x0, w, noiseInfo, lut);
                }
                for (int x = x0; x < maxX; ++x) {
                    double dn2;
                    int xx = x - x0;
                    int srcIdx = srcIndex.getIndex(x);
                    int tgtIdx = tgtIndex.getIndex(x);
                    if (bandUnit == Unit.UnitType.AMPLITUDE) {
                        double dn = srcData1.getElemDoubleAt(srcIdx);
                        dn2 = dn * dn;
                    } else if (complexData) {
                        double i = srcData1.getElemDoubleAt(srcIdx);
                        double q = srcData2.getElemDoubleAt(srcIdx);
                        dn2 = i * i + q * q;
                    } else if (bandUnit == Unit.UnitType.INTENSITY) {
                        dn2 = srcData1.getElemDoubleAt(srcIdx);
                    } else {
                        throw new OperatorException("Unhandled unit");
                    }
                    double value = dn2 - lut[xx];
                    if (value < 0.0) {
                        value = dn2;
                    }
                    trgData.setElemDoubleAt(tgtIdx, value);
                }
            }
        }
        catch (Throwable e) {
            throw new OperatorException(e.getMessage());
        }
    }

    private ThermalNoiseInfo getNoiseInfo(String targetBandName) throws OperatorException {
        for (ThermalNoiseInfo noiseInfo : this.noise) {
            if (!(this.isTOPSARSLC ? targetBandName.contains(noiseInfo.polarization) && targetBandName.contains(noiseInfo.subSwath) : targetBandName.contains(noiseInfo.polarization))) continue;
            return noiseInfo;
        }
        throw new OperatorException("NoiseInfo not found for " + targetBandName);
    }

    private Sentinel1Calibrator.CalibrationInfo getCalInfo(String targetBandName) {
        for (Sentinel1Calibrator.CalibrationInfo cal : this.calibration) {
            String pol = cal.polarization;
            String ss = cal.subSwath;
            if (!(this.isTOPSARSLC ? targetBandName.contains(pol) && targetBandName.contains(ss) : targetBandName.contains(pol))) continue;
            return cal;
        }
        return null;
    }

    private void computeTileScaledNoiseLUT(int y, int x0, int w, ThermalNoiseInfo noiseInfo, Sentinel1Calibrator.CalibrationInfo calInfo, double azT0, double azT1, float[] vec0LUT, float[] vec1LUT, int[] vec0Pixels, int pixelIdx0, double[] lut) {
        double[] noiseLut = new double[w];
        Sentinel1RemoveThermalNoiseOp.computeTileNoiseLUT(y, x0, w, noiseInfo, noiseLut);
        double[] calLut = new double[w];
        Sentinel1RemoveThermalNoiseOp.computeTileCalibrationLUTs(y, x0, w, calInfo, azT0, azT1, vec0LUT, vec1LUT, vec0Pixels, pixelIdx0, calLut);
        if (this.removeThermalNoise.booleanValue()) {
            for (int i = 0; i < w; ++i) {
                lut[i] = noiseLut[i] / (calLut[i] * calLut[i]);
            }
        } else {
            for (int i = 0; i < w; ++i) {
                lut[i] = -noiseLut[i] / (calLut[i] * calLut[i]);
            }
        }
    }

    public static void computeTileCalibrationLUTs(int y, int x0, int w, Sentinel1Calibrator.CalibrationInfo calInfo, double azT0, double azT1, float[] vec0LUT, float[] vec1LUT, int[] vec0Pixels, int pixelIdx0, double[] lut) {
        double azTime = calInfo.firstLineTime + (double)y * calInfo.lineTimeInterval;
        double muY = (azTime - azT0) / (azT1 - azT0);
        int pixelIdx = pixelIdx0;
        int maxX = x0 + w;
        for (int x = x0; x < maxX; ++x) {
            if (x > vec0Pixels[pixelIdx + 1]) {
                ++pixelIdx;
            }
            double muX = (double)(x - vec0Pixels[pixelIdx]) / (double)(vec0Pixels[pixelIdx + 1] - vec0Pixels[pixelIdx]);
            lut[x - x0] = Maths.interpolationBiLinear((double)vec0LUT[pixelIdx], (double)vec0LUT[pixelIdx + 1], (double)vec1LUT[pixelIdx], (double)vec1LUT[pixelIdx + 1], (double)muX, (double)muY);
        }
    }

    private static void computeTileNoiseLUT(int y, int x0, int w, ThermalNoiseInfo noiseInfo, double[] lut) {
        try {
            int noiseVecIdx = Sentinel1RemoveThermalNoiseOp.getNoiseVectorIndex(y, noiseInfo);
            Sentinel1Utils.NoiseVector noiseVector0 = noiseInfo.noiseVectorList[noiseVecIdx];
            Sentinel1Utils.NoiseVector noiseVector1 = noiseInfo.noiseVectorList[noiseVecIdx + 1];
            double azTime = noiseInfo.firstLineTime + (double)y * noiseInfo.lineTimeInterval;
            double azT0 = noiseVector0.timeMJD;
            double azT1 = noiseVector1.timeMJD;
            double muY = (azTime - azT0) / (azT1 - azT0);
            int pixelIdx0 = Sentinel1RemoveThermalNoiseOp.getPixelIndex(x0, noiseVector0);
            int pixelIdx1 = Sentinel1RemoveThermalNoiseOp.getPixelIndex(x0, noiseVector1);
            int maxLength0 = noiseVector0.pixels.length - 2;
            int maxLength1 = noiseVector1.pixels.length - 2;
            int maxX = x0 + w;
            for (int x = x0; x < maxX; ++x) {
                if (x > noiseVector0.pixels[pixelIdx0 + 1] && pixelIdx0 < maxLength0) {
                    ++pixelIdx0;
                }
                int x00 = noiseVector0.pixels[pixelIdx0];
                int x01 = noiseVector0.pixels[pixelIdx0 + 1];
                double muX0 = (double)(x - x00) / (double)(x01 - x00);
                double noise0 = Maths.interpolationLinear((double)noiseVector0.noiseLUT[pixelIdx0], (double)noiseVector0.noiseLUT[pixelIdx0 + 1], (double)muX0);
                if (x > noiseVector1.pixels[pixelIdx1 + 1] && pixelIdx1 < maxLength1) {
                    ++pixelIdx1;
                }
                int x10 = noiseVector1.pixels[pixelIdx1];
                int x11 = noiseVector1.pixels[pixelIdx1 + 1];
                double muX1 = (double)(x - x10) / (double)(x11 - x10);
                double noise1 = Maths.interpolationLinear((double)noiseVector1.noiseLUT[pixelIdx1], (double)noiseVector1.noiseLUT[pixelIdx1 + 1], (double)muX1);
                lut[x - x0] = Maths.interpolationLinear((double)noise0, (double)noise1, (double)muY);
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"computeTileNoiseLUT", (Throwable)e);
        }
    }

    private static int getNoiseVectorIndex(int y, ThermalNoiseInfo noiseInfo) {
        for (int i = 1; i < noiseInfo.count; ++i) {
            if (y >= noiseInfo.noiseVectorList[i].line) continue;
            return i - 1;
        }
        return noiseInfo.count - 2;
    }

    private static int getPixelIndex(int x, Sentinel1Utils.NoiseVector noiseVector) {
        for (int i = 0; i < noiseVector.pixels.length; ++i) {
            if (x >= noiseVector.pixels[i]) continue;
            return i - 1;
        }
        return noiseVector.pixels.length - 2;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(Sentinel1RemoveThermalNoiseOp.class);
        }
    }

    public static class ThermalNoiseInfo {
        public String polarization;
        public String subSwath;
        public double firstLineTime;
        public double lastLineTime;
        public int numOfLines;
        public int count;
        public Sentinel1Utils.NoiseVector[] noiseVectorList;
        final double lineTimeInterval;

        ThermalNoiseInfo(String pol, String subSwath, double firstLineTime, double lastLineTime, int numOfLines, int count, Sentinel1Utils.NoiseVector[] noiseVectorList) {
            this.polarization = pol;
            this.subSwath = subSwath;
            this.firstLineTime = firstLineTime;
            this.lastLineTime = lastLineTime;
            this.numOfLines = numOfLines;
            this.count = count;
            this.noiseVectorList = noiseVectorList;
            this.lineTimeInterval = (lastLineTime - firstLineTime) / (double)(numOfLines - 1);
        }
    }
}

