/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.calibration.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.esa.s1tbx.calibration.gpf.calibrators.Sentinel1Calibrator;
import org.esa.s1tbx.insar.gpf.support.Sentinel1Utils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.downloadable.StatusProgressMonitor;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.ThreadManager;
import org.esa.snap.engine_utilities.gpf.TileIndex;
import org.esa.snap.engine_utilities.util.Maths;

@OperatorMetadata(alias="Remove-GRD-Border-Noise", category="Radar/Sentinel-1 TOPS", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", version="1.0", description="Mask no-value pixels for GRD product")
public final class RemoveGRDBorderNoiseOp
extends Operator {
    @SourceProduct
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of polarisations", label="Polarisations")
    private String[] selectedPolarisations;
    @Parameter(description="The border margin limit", defaultValue="500", label="Border margin limit[pixels]")
    private int borderLimit = 500;
    @Parameter(description="The trim threshold", defaultValue="0.5", label="Threshold")
    private double trimThreshold = 0.5;
    private MetadataElement absRoot = null;
    private MetadataElement origMetadataRoot = null;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private double version = 0.0;
    private double scalingFactor = 0.0;
    private double noDataValue = 0.0;
    private String coPolarization = null;
    private Sentinel1Utils.NoiseVector noiseVector = null;
    private double[] noiseLUT = null;
    private Band coPolBand = null;
    private boolean thermalNoiseCorrectionPerformed = false;
    private boolean useBorderDetection = true;
    private boolean borderDetected = false;
    private int topBorder = 0;
    private int bottomBorder = 0;
    private int leftBorder = 0;
    private int rightBorder = 0;

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSentinel1Product();
            validator.checkIfGRD();
            validator.checkIfCalibrated(false);
            this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            this.origMetadataRoot = AbstractMetadata.getOriginalProductMetadata((Product)this.sourceProduct);
            this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
            this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
            this.topBorder = this.borderLimit;
            this.bottomBorder = this.sourceImageHeight - this.borderLimit;
            this.leftBorder = this.borderLimit;
            this.rightBorder = this.sourceImageWidth - this.borderLimit;
            this.getIPFVersion();
            this.getProductCoPolarization();
            this.getThermalNoiseCorrectionFlag();
            if (!this.thermalNoiseCorrectionPerformed) {
                this.getThermalNoiseVector();
            }
            this.computeNoiseScalingFactor();
            this.computeNoiseLUT();
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void getIPFVersion() {
        String procSysId = this.absRoot.getAttributeString("Processing_system_identifier");
        this.version = Double.valueOf(procSysId.substring(procSysId.lastIndexOf(" ")));
    }

    private void getProductCoPolarization() {
        String[] sourceBandNames;
        for (String bandName : sourceBandNames = this.sourceProduct.getBandNames()) {
            if (bandName.contains("HH")) {
                this.coPolarization = "HH";
                this.coPolBand = this.sourceProduct.getBand(bandName);
                break;
            }
            if (!bandName.contains("VV")) continue;
            this.coPolarization = "VV";
            this.coPolBand = this.sourceProduct.getBand(bandName);
            break;
        }
        if (this.coPolarization == null) {
            throw new OperatorException("Input product does not contain band with HH or VV polarization");
        }
        this.noDataValue = this.coPolBand.getNoDataValue();
    }

    private void getThermalNoiseCorrectionFlag() {
        MetadataElement annotationElem = this.origMetadataRoot.getElement("annotation");
        MetadataElement[] annotationDataSetListElem = annotationElem.getElements();
        MetadataElement productElem = annotationDataSetListElem[0].getElement("product");
        MetadataElement imageAnnotationElem = productElem.getElement("imageAnnotation");
        MetadataElement processingInformationElem = imageAnnotationElem.getElement("processingInformation");
        this.thermalNoiseCorrectionPerformed = Boolean.parseBoolean(processingInformationElem.getAttribute("thermalNoiseCorrectionPerformed").getData().getElemString());
    }

    private void getThermalNoiseVector() {
        MetadataElement[] noiseDataSetListElem;
        MetadataElement noiseElem = this.origMetadataRoot.getElement("noise");
        for (MetadataElement dataSetListElem : noiseDataSetListElem = noiseElem.getElements()) {
            MetadataElement noiElem = dataSetListElem.getElement("noise");
            MetadataElement adsHeaderElem = noiElem.getElement("adsHeader");
            String pol = adsHeaderElem.getAttributeString("polarisation");
            if (!this.coPolarization.contains(pol)) continue;
            MetadataElement noiseVectorListElem = noiElem.getElement("noiseVectorList");
            int count = Integer.parseInt(noiseVectorListElem.getAttributeString("count"));
            Sentinel1Utils.NoiseVector[] noiseVectorList = Sentinel1Utils.getNoiseVector((MetadataElement)noiseVectorListElem);
            this.noiseVector = noiseVectorList[count / 2];
            break;
        }
        if (this.noiseVector == null) {
            throw new OperatorException("Input product does not have noise vector for HH or VV band");
        }
    }

    private void computeNoiseLUT() {
        try {
            this.noiseLUT = new double[this.sourceImageWidth];
            if (!this.thermalNoiseCorrectionPerformed) {
                int pixelIdx = RemoveGRDBorderNoiseOp.getPixelIndex(0, this.noiseVector);
                int maxLength = this.noiseVector.pixels.length - 2;
                for (int x = 0; x < this.sourceImageWidth; ++x) {
                    if (x > this.noiseVector.pixels[pixelIdx + 1] && pixelIdx < maxLength) {
                        ++pixelIdx;
                    }
                    int xx0 = this.noiseVector.pixels[pixelIdx];
                    int xx1 = this.noiseVector.pixels[pixelIdx + 1];
                    double muX = (double)(x - xx0) / (double)(xx1 - xx0);
                    this.noiseLUT[x] = Maths.interpolationLinear((double)this.noiseVector.noiseLUT[pixelIdx], (double)this.noiseVector.noiseLUT[pixelIdx + 1], (double)muX) * this.scalingFactor;
                }
            } else {
                for (int x = 0; x < this.sourceImageWidth; ++x) {
                    this.noiseLUT[x] = 0.0;
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"computeNoiseLUT", (Throwable)e);
        }
    }

    private static int getPixelIndex(int x, Sentinel1Utils.NoiseVector noiseVector) {
        for (int i = 0; i < noiseVector.pixels.length; ++i) {
            if (x >= noiseVector.pixels[i]) continue;
            return i - 1;
        }
        return noiseVector.pixels.length - 2;
    }

    private void computeNoiseScalingFactor() {
        if (this.version < 2.5) {
            double knoise;
            String acquisitionMode = this.absRoot.getAttributeString("ACQUISITION_MODE");
            if (acquisitionMode.contains("IW")) {
                knoise = 75088.7;
            } else if (acquisitionMode.contains("EW")) {
                knoise = 56065.87;
            } else {
                throw new OperatorException("Cannot apply the operator to the input GRD product.");
            }
            double dn0 = this.getDN0();
            this.scalingFactor = this.version < 2.34 ? knoise * dn0 : knoise * dn0 * dn0;
        } else {
            this.scalingFactor = 1.0;
        }
    }

    private double getDN0() {
        Sentinel1Calibrator.CalibrationInfo[] calibration;
        String[] selectedPols = new String[]{this.coPolarization};
        for (Sentinel1Calibrator.CalibrationInfo cal : calibration = Sentinel1Calibrator.getCalibrationVectors(this.sourceProduct, Arrays.asList(selectedPols), false, false, false, true)) {
            if (!cal.polarization.contains(this.coPolarization)) continue;
            float[] dnLUT = Sentinel1Calibrator.getVector(Sentinel1Calibrator.CALTYPE.DN, cal.getCalibrationVector(0));
            return dnLUT[0];
        }
        return 0.0;
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
        this.addSelectedBands();
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
    }

    private void addSelectedBands() {
        Band[] sourceBands;
        for (Band srcBand : sourceBands = this.sourceProduct.getBands()) {
            String unit = srcBand.getUnit();
            if (unit == null) {
                throw new OperatorException("band " + srcBand.getName() + " requires a unit");
            }
            if (!unit.contains("amplitude") && !unit.contains("intensity")) continue;
            String srcBandName = srcBand.getName();
            if (this.selectedPolarisations != null && this.selectedPolarisations.length != 0 && !this.containSelectedPolarisations(srcBandName)) continue;
            if (srcBand instanceof VirtualBand) {
                VirtualBand sourceBand = (VirtualBand)srcBand;
                VirtualBand targetBand = new VirtualBand(srcBandName, sourceBand.getDataType(), sourceBand.getRasterWidth(), sourceBand.getRasterHeight(), sourceBand.getExpression());
                ProductUtils.copyRasterDataNodeProperties((RasterDataNode)sourceBand, (RasterDataNode)targetBand);
                this.targetProduct.addBand((Band)targetBand);
                continue;
            }
            Band targetBand = new Band(srcBandName, srcBand.getDataType(), srcBand.getRasterWidth(), srcBand.getRasterHeight());
            targetBand.setUnit(srcBand.getUnit());
            targetBand.setNoDataValue(srcBand.getNoDataValue());
            targetBand.setNoDataValueUsed(srcBand.isNoDataValueUsed());
            targetBand.setDescription(srcBand.getDescription());
            this.targetProduct.addBand(targetBand);
        }
    }

    private boolean containSelectedPolarisations(String bandName) {
        for (String pol : this.selectedPolarisations) {
            if (!bandName.contains(pol)) continue;
            return true;
        }
        return false;
    }

    public void computeTileStack(Map<Band, Tile> targetTileMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            if (this.useBorderDetection && !this.borderDetected) {
                this.detectBorders();
            }
            int x0 = targetRectangle.x;
            int y0 = targetRectangle.y;
            int w = targetRectangle.width;
            int h = targetRectangle.height;
            int yMax = y0 + h;
            int xMax = x0 + w;
            Set<Band> keySet = targetTileMap.keySet();
            int numBands = keySet.size();
            ProductData[] targetData = new ProductData[numBands];
            ProductData[] sourceData = new ProductData[numBands];
            Tile[] sourceTile = new Tile[numBands];
            Tile[] targetTile = new Tile[numBands];
            double[] bandNoDataValues = new double[numBands];
            int k = 0;
            for (Band targetBand : keySet) {
                targetTile[k] = targetTileMap.get(targetBand);
                targetData[k] = targetTile[k].getDataBuffer();
                Band srcBand = this.sourceProduct.getBand(targetBand.getName());
                sourceTile[k] = this.getSourceTile((RasterDataNode)srcBand, targetRectangle);
                sourceData[k] = sourceTile[k].getDataBuffer();
                bandNoDataValues[k] = srcBand.getNoDataValue();
                ++k;
            }
            TileIndex srcIndex = new TileIndex(sourceTile[0]);
            TileIndex tgtIndex = new TileIndex(targetTile[0]);
            Tile coPolTile = this.getSourceTile((RasterDataNode)this.coPolBand, targetRectangle);
            ProductData coPolData = coPolTile.getDataBuffer();
            for (int y = y0; y < yMax; ++y) {
                srcIndex.calculateStride(y);
                tgtIndex.calculateStride(y);
                for (int x = x0; x < xMax; ++x) {
                    int i;
                    int tgtIdx;
                    boolean testPixel;
                    int srcIdx = srcIndex.getIndex(x);
                    boolean bl = testPixel = x < this.leftBorder || x > this.rightBorder || y < this.topBorder || y > this.bottomBorder;
                    if (testPixel) {
                        double coPolDataValue = coPolData.getElemDoubleAt(srcIdx);
                        if (coPolDataValue == this.noDataValue) continue;
                        double deNoisedDataValue = Math.sqrt(Math.max(coPolDataValue * coPolDataValue - this.noiseLUT[x], 0.0));
                        if (deNoisedDataValue < this.trimThreshold || coPolDataValue < 30.0) {
                            tgtIdx = tgtIndex.getIndex(x);
                            for (i = 0; i < numBands; ++i) {
                                targetData[i].setElemDoubleAt(tgtIdx, bandNoDataValues[i]);
                            }
                        } else {
                            testPixel = false;
                        }
                    }
                    if (testPixel) continue;
                    tgtIdx = tgtIndex.getIndex(x);
                    for (i = 0; i < numBands; ++i) {
                        targetData[i].setElemDoubleAt(tgtIdx, sourceData[i].getElemDoubleAt(srcIdx));
                    }
                }
            }
        }
        catch (Throwable e) {
            throw new OperatorException(e.getMessage());
        }
    }

    private synchronized void detectBorders() throws OperatorException {
        if (this.borderDetected) {
            return;
        }
        this.detectBorder();
        SystemUtils.LOG.fine("topBorder = " + this.topBorder);
        SystemUtils.LOG.fine("bottomBorder = " + this.bottomBorder);
        SystemUtils.LOG.fine("leftBorder = " + this.leftBorder);
        SystemUtils.LOG.fine("rightBorder = " + this.rightBorder);
        this.borderDetected = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detectBorder() throws OperatorException {
        Dimension tileSize = new Dimension(this.borderLimit, this.borderLimit);
        Rectangle[] topRectangles = RemoveGRDBorderNoiseOp.getAllTileRectangles(0, 0, this.sourceImageWidth, this.borderLimit, tileSize);
        Rectangle[] bottomRectangles = RemoveGRDBorderNoiseOp.getAllTileRectangles(0, this.sourceImageHeight - this.borderLimit, this.sourceImageWidth, this.borderLimit, tileSize);
        Rectangle[] leftRectangles = RemoveGRDBorderNoiseOp.getAllTileRectangles(0, 0, this.borderLimit, this.sourceImageHeight, tileSize);
        Rectangle[] rightRectangles = RemoveGRDBorderNoiseOp.getAllTileRectangles(this.sourceImageWidth - this.borderLimit, 0, this.borderLimit, this.sourceImageHeight, tileSize);
        ArrayList<Border> borderList = new ArrayList<Border>(4);
        borderList.add(new Border(SIDE.TOP, this.borderLimit, topRectangles));
        borderList.add(new Border(SIDE.BOTTOM, this.borderLimit, bottomRectangles));
        borderList.add(new Border(SIDE.LEFT, this.borderLimit, leftRectangles));
        borderList.add(new Border(SIDE.RIGHT, this.borderLimit, rightRectangles));
        int totalRects = topRectangles.length + bottomRectangles.length + leftRectangles.length + rightRectangles.length;
        ThreadManager threadManager = new ThreadManager();
        StatusProgressMonitor status = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
        status.beginTask("Detecting border... ", totalRects);
        try {
            for (final Border border : borderList) {
                for (final Rectangle rectangle : border.tileRectangles) {
                    Thread worker = new Thread(){
                        final int xMax;
                        final int yMax;
                        {
                            this.xMax = rectangle.x + rectangle.width;
                            this.yMax = rectangle.y + rectangle.height;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Tile coPolTile = RemoveGRDBorderNoiseOp.this.getSourceTile((RasterDataNode)RemoveGRDBorderNoiseOp.this.coPolBand, rectangle);
                            ProductData coPolData = coPolTile.getDataBuffer();
                            TileIndex srcIndex = new TileIndex(coPolTile);
                            if (border.side.equals((Object)SIDE.TOP) || border.side.equals((Object)SIDE.BOTTOM)) {
                                double[] colSum = new double[RemoveGRDBorderNoiseOp.this.borderLimit];
                                for (int y = rectangle.y; y < this.yMax; ++y) {
                                    srcIndex.calculateStride(y);
                                    int yy = y - rectangle.y;
                                    double sum = 0.0;
                                    for (int x = rectangle.x; x < this.xMax; ++x) {
                                        double v = coPolData.getElemDoubleAt(srcIndex.getIndex(x));
                                        if (v == RemoveGRDBorderNoiseOp.this.noDataValue) continue;
                                        sum += v;
                                    }
                                    int n = yy;
                                    colSum[n] = colSum[n] + sum;
                                }
                                double[] y = border.avg;
                                synchronized (border.avg) {
                                    for (int r = 0; r < RemoveGRDBorderNoiseOp.this.borderLimit; ++r) {
                                        int n = r;
                                        border.avg[n] = border.avg[n] + colSum[r] / (double)rectangle.width;
                                    }
                                    // ** MonitorExit[y] (shouldn't be in output)
                                }
                            }
                            double[] rowSum = new double[RemoveGRDBorderNoiseOp.this.borderLimit];
                            for (int x = rectangle.x; x < this.xMax; ++x) {
                                int xx = x - rectangle.x;
                                double sum = 0.0;
                                for (int y = rectangle.y; y < this.yMax; ++y) {
                                    double v = coPolData.getElemDoubleAt(coPolTile.getDataBufferIndex(x, y));
                                    if (v == RemoveGRDBorderNoiseOp.this.noDataValue) continue;
                                    sum += v;
                                }
                                int n = xx;
                                rowSum[n] = rowSum[n] + sum;
                            }
                            double[] dArray = border.avg;
                            synchronized (border.avg) {
                                for (int c = 0; c < RemoveGRDBorderNoiseOp.this.borderLimit; ++c) {
                                    int n = c;
                                    border.avg[n] = border.avg[n] + rowSum[c] / (double)rectangle.height;
                                }
                                // ** MonitorExit[var5_9] (shouldn't be in output)
                                return;
                            }
                        }
                    };
                    threadManager.add(worker);
                    status.worked(1);
                }
            }
            threadManager.finish();
        }
        catch (Exception e) {
            OperatorUtils.catchOperatorException((String)(this.getId() + " detectBorder "), (Throwable)e);
        }
        finally {
            status.done();
        }
        for (final Border border : borderList) {
            int r = 0;
            while (r < this.borderLimit) {
                int n = r++;
                border.avg[n] = border.avg[n] / (double)border.tileRectangles.length;
            }
            int peakPos = RemoveGRDBorderNoiseOp.getPeakPosition(border.avg);
            switch (border.side) {
                case TOP: {
                    if (peakPos == -1) {
                        this.topBorder = 0;
                        break;
                    }
                    this.topBorder = peakPos;
                    break;
                }
                case BOTTOM: {
                    if (peakPos == -1) {
                        this.bottomBorder = this.sourceImageHeight - 1;
                        break;
                    }
                    this.bottomBorder = this.sourceImageHeight - this.borderLimit + peakPos;
                    break;
                }
                case LEFT: {
                    if (peakPos == -1) {
                        this.leftBorder = 0;
                        break;
                    }
                    this.leftBorder = peakPos;
                    break;
                }
                case RIGHT: {
                    this.rightBorder = peakPos == -1 ? this.sourceImageWidth - 1 : this.sourceImageWidth - this.borderLimit + (int)((double)peakPos * 0.8);
                }
            }
        }
    }

    public static Rectangle[] getAllTileRectangles(int x0, int y0, int width, int height, Dimension tileSize) {
        Rectangle boundary = new Rectangle(x0, y0, width, height);
        int tileCountX = MathUtils.ceilInt((double)((double)boundary.width / (double)tileSize.width));
        int tileCountY = MathUtils.ceilInt((double)((double)boundary.height / (double)tileSize.height));
        Rectangle[] rectangles = new Rectangle[tileCountX * tileCountY];
        int index = 0;
        for (int y = y0; y < y0 + height; y += tileSize.height) {
            for (int x = x0; x < x0 + width; x += tileSize.width) {
                Rectangle intersection;
                Rectangle tileRectangle = new Rectangle(x, y, tileSize.width, tileSize.height);
                rectangles[index] = intersection = boundary.intersection(tileRectangle);
                ++index;
            }
        }
        return rectangles;
    }

    private static int getPeakPosition(double[] array) {
        double[] derivative = new double[array.length - 1];
        for (int i = 0; i < derivative.length; ++i) {
            derivative[i] = Math.abs(array[i + 1] - array[i]);
        }
        int maxIdx = -1;
        double max = -1.7976931348623157E308;
        double mean = 0.0;
        for (int i = 0; i < derivative.length; ++i) {
            mean += derivative[i];
            if (!(max < derivative[i])) continue;
            max = derivative[i];
            maxIdx = i;
        }
        if ((mean /= (double)derivative.length) > 0.0 && max / mean > 10.0) {
            return maxIdx;
        }
        return -1;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(RemoveGRDBorderNoiseOp.class);
        }
    }

    private static class Border {
        public final SIDE side;
        public final double[] avg;
        public final Rectangle[] tileRectangles;

        public Border(SIDE side, int borderLimit, Rectangle[] rectangles) {
            this.side = side;
            this.avg = new double[borderLimit];
            this.tileRectangles = rectangles;
        }
    }

    private static enum SIDE {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT;

    }
}

