/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.calibration.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.util.ArrayList;
import org.esa.s1tbx.calibration.gpf.support.CalibrationFactory;
import org.esa.s1tbx.calibration.gpf.support.Calibrator;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;

@OperatorMetadata(alias="RemoveAntennaPattern", category="Radar/Radiometric", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", version="1.0", description="Remove Antenna Pattern")
public class RemoveAntennaPatternOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of source bands.", alias="sourceBands", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] sourceBandNames = null;
    private Calibrator calibrator = null;

    public void initialize() throws OperatorException {
        try {
            this.getProductType();
            this.getMultilookFlag();
            this.createTargetProduct();
            this.calibrator = CalibrationFactory.createCalibrator(this.sourceProduct);
            this.calibrator.initialize(this, this.sourceProduct, this.targetProduct, true, false);
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void getProductType() throws OperatorException {
        String productType = this.sourceProduct.getProductType();
        if (productType.contains("ASA_IMS_1") && !productType.contains("ASA_APS_1")) {
            throw new OperatorException(productType + " is not a valid ASAR product type for the operator.");
        }
    }

    private void getMultilookFlag() throws Exception {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
        if (AbstractMetadata.getAttributeBoolean((MetadataElement)absRoot, (String)"multilook_flag")) {
            throw new OperatorException("Cannot apply the operator to multilooked product.");
        }
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        this.addSelectedBands();
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"ant_elev_corr_flag", (int)0);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"range_spread_comp_flag", (int)0);
        absTgt.setAttributeInt("retro-calibration performed flag", 1);
    }

    private void addSelectedBands() {
        if (this.sourceBandNames == null || this.sourceBandNames.length == 0) {
            Band[] bands = this.sourceProduct.getBands();
            ArrayList<String> bandNameList = new ArrayList<String>(this.sourceProduct.getNumBands());
            Band[] bandArray = bands;
            int n = bandArray.length;
            for (int i = 0; i < n; ++i) {
                Band band = bandArray[i];
                String unit = band.getUnit();
                if (unit != null && (unit.contains("phase") || unit.contains("real") || unit.contains("imaginary"))) continue;
                bandNameList.add(band.getName());
            }
            this.sourceBandNames = bandNameList.toArray(new String[bandNameList.size()]);
        }
        Band[] sourceBands = new Band[this.sourceBandNames.length];
        for (int i = 0; i < this.sourceBandNames.length; ++i) {
            String sourceBandName = this.sourceBandNames[i];
            Band sourceBand = this.sourceProduct.getBand(sourceBandName);
            if (sourceBand == null) {
                throw new OperatorException("Source band not found: " + sourceBandName);
            }
            sourceBands[i] = sourceBand;
        }
        for (Band srcBand : sourceBands) {
            String unit = srcBand.getUnit();
            String srcBandName = srcBand.getName();
            if (unit == null) {
                throw new OperatorException("band " + srcBand.getName() + " requires a unit");
            }
            if (unit.contains("phase") || unit.contains("real") || unit.contains("imaginary")) {
                throw new OperatorException("Please select amplitude or intensity band.");
            }
            if (this.targetProduct.getBand(srcBandName) != null) continue;
            Band targetBand = new Band(srcBandName, 30, this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
            targetBand.setUnit(unit);
            this.targetProduct.addBand(targetBand);
        }
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        try {
            String srcBandName = targetBand.getName();
            this.calibrator.removeFactorsForCurrentTile(targetBand, targetTile, srcBandName);
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(RemoveAntennaPatternOp.class);
        }
    }
}

