/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.calibration.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import org.esa.s1tbx.calibration.gpf.calibrators.Sentinel1Calibrator;
import org.esa.s1tbx.calibration.gpf.support.CalibrationFactory;
import org.esa.s1tbx.calibration.gpf.support.Calibrator;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.StackUtils;

@OperatorMetadata(alias="Calibration", category="Radar/Radiometric", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", version="1.0", description="Calibration of products")
public class CalibrationOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of source bands.", alias="sourceBands", rasterDataNodeType=Band.class, label="Source Band")
    private String[] sourceBandNames;
    @Parameter(valueSet={"Latest Auxiliary File", "Product Auxiliary File", "External Auxiliary File"}, description="The auxiliary file", defaultValue="Latest Auxiliary File", label="Auxiliary File")
    private String auxFile = "Latest Auxiliary File";
    @Parameter(description="The antenna elevation pattern gain auxiliary data file.", label="External Aux File")
    private File externalAuxFile = null;
    @Parameter(description="Output image in complex", defaultValue="false", label="Save in complex")
    private Boolean outputImageInComplex = false;
    @Parameter(description="Output image scale", defaultValue="false", label="Scale in dB")
    private Boolean outputImageScaleInDb = false;
    @Parameter(description="Create gamma0 virtual band", defaultValue="false", label="Create gamma0 virtual band")
    private Boolean createGammaBand = false;
    @Parameter(description="Create beta0 virtual band", defaultValue="false", label="Create beta0 virtual band")
    private Boolean createBetaBand = false;
    @Parameter(description="The list of polarisations", label="Polarisations")
    private String[] selectedPolarisations;
    @Parameter(description="Output sigma0 band", defaultValue="true", label="Output sigma0 band")
    private Boolean outputSigmaBand = true;
    @Parameter(description="Output gamma0 band", defaultValue="false", label="Output gamma0 band")
    private Boolean outputGammaBand = false;
    @Parameter(description="Output beta0 band", defaultValue="false", label="Output beta0 band")
    private Boolean outputBetaBand = false;
    private Boolean outputDNBand = false;
    private Calibrator calibrator = null;
    public static final String PRODUCT_AUX = "Product Auxiliary File";
    public static final String LATEST_AUX = "Latest Auxiliary File";
    public static final String EXTERNAL_AUX = "External Auxiliary File";

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSARProduct();
            if (StackUtils.isCoregisteredStack((Product)this.sourceProduct)) {
                throw new OperatorException("Cannot apply calibration to coregistered product.");
            }
            this.calibrator = CalibrationFactory.createCalibrator(this.sourceProduct);
            this.calibrator.setAuxFileFlag(this.auxFile);
            this.calibrator.setExternalAuxFile(this.externalAuxFile);
            this.calibrator.setOutputImageInComplex(this.outputImageInComplex);
            this.calibrator.setOutputImageIndB(this.outputImageScaleInDb);
            if (this.calibrator instanceof Sentinel1Calibrator) {
                Sentinel1Calibrator cal = (Sentinel1Calibrator)this.calibrator;
                cal.setUserSelections(this.sourceProduct, this.selectedPolarisations, this.outputSigmaBand, this.outputGammaBand, this.outputBetaBand, this.outputDNBand);
            }
            this.targetProduct = this.calibrator.createTargetProduct(this.sourceProduct, this.sourceBandNames);
            this.calibrator.initialize(this, this.sourceProduct, this.targetProduct, false, true);
            if (this.createGammaBand.booleanValue()) {
                CalibrationOp.createGammaVirtualBand(this.targetProduct, this.outputImageScaleInDb);
            }
            if (this.createBetaBand.booleanValue()) {
                CalibrationOp.createBetaVirtualBand(this.targetProduct, this.outputImageScaleInDb);
            }
            this.updateTargetProductMetadata();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void updateTargetProductMetadata() {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        absRoot.getAttribute("abs_calibration_flag").getData().setElemBoolean(true);
        if (!this.outputImageInComplex.booleanValue()) {
            absRoot.setAttributeString("SAMPLE_TYPE", "DETECTED");
        }
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        try {
            this.calibrator.computeTile(targetBand, targetTile, pm);
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    public static void createGammaVirtualBand(Product trgProduct, boolean outputImageScaleInDb) {
        Band[] bands;
        int count = 1;
        for (Band trgBand : bands = trgProduct.getBands()) {
            String unit = trgBand.getUnit();
            if (trgBand instanceof VirtualBand || unit != null && unit.contains("phase")) continue;
            String trgBandName = trgBand.getName();
            String expression = outputImageScaleInDb ? "(pow(10," + trgBandName + "/10.0)" + " / cos(incident_angle * PI/180.0)) " + "==0 ? 0 : 10 * log10(abs(" + "(pow(10," + trgBandName + "/10.0)" + " / cos(incident_angle * PI/180.0))" + "))" : trgBandName + " / cos(incident_angle * PI/180.0)";
            String gammeBandName = "Gamma0";
            if (bands.length > 1) {
                if (trgBandName.contains("_HH")) {
                    gammeBandName = gammeBandName + "_HH";
                } else if (trgBandName.contains("_VV")) {
                    gammeBandName = gammeBandName + "_VV";
                } else if (trgBandName.contains("_HV")) {
                    gammeBandName = gammeBandName + "_HV";
                } else if (trgBandName.contains("_VH")) {
                    gammeBandName = gammeBandName + "_VH";
                }
            }
            if (outputImageScaleInDb) {
                gammeBandName = gammeBandName + "_dB";
            }
            while (trgProduct.getBand(gammeBandName) != null) {
                gammeBandName = gammeBandName + "_" + ++count;
            }
            VirtualBand band = new VirtualBand(gammeBandName, 30, trgBand.getRasterWidth(), trgBand.getRasterHeight(), expression);
            band.setUnit(unit);
            band.setDescription("Gamma0 image");
            trgProduct.addBand((Band)band);
        }
    }

    public static void createBetaVirtualBand(Product trgProduct, boolean outputImageScaleInDb) {
        Band[] bands;
        int count = 1;
        for (Band trgBand : bands = trgProduct.getBands()) {
            String unit = trgBand.getUnit();
            if (trgBand instanceof VirtualBand || unit != null && unit.contains("phase")) continue;
            String trgBandName = trgBand.getName();
            String expression = outputImageScaleInDb ? "(pow(10," + trgBandName + "/10.0)" + " / sin(incident_angle * PI/180.0)) " + "==0 ? 0 : 10 * log10(abs(" + "(pow(10," + trgBandName + "/10.0)" + " / sin(incident_angle * PI/180.0))" + "))" : trgBandName + " / sin(incident_angle * PI/180.0)";
            String betaBandName = "Beta0";
            if (bands.length > 1) {
                if (trgBandName.contains("_HH")) {
                    betaBandName = betaBandName + "_HH";
                } else if (trgBandName.contains("_VV")) {
                    betaBandName = betaBandName + "_VV";
                } else if (trgBandName.contains("_HV")) {
                    betaBandName = betaBandName + "_HV";
                } else if (trgBandName.contains("_VH")) {
                    betaBandName = betaBandName + "_VH";
                }
            }
            if (outputImageScaleInDb) {
                betaBandName = betaBandName + "_dB";
            }
            while (trgProduct.getBand(betaBandName) != null) {
                betaBandName = betaBandName + "_" + ++count;
            }
            VirtualBand band = new VirtualBand(betaBandName, 30, trgBand.getRasterWidth(), trgBand.getRasterHeight(), expression);
            band.setUnit(unit);
            band.setDescription("Beta0 image");
            trgProduct.addBand((Band)band);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(CalibrationOp.class);
        }
    }
}

