/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.calibration.rcp;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.Action;
import org.esa.s1tbx.calibration.gpf.Sentinel1RemoveThermalNoiseOp;
import org.esa.s1tbx.calibration.gpf.calibrators.Sentinel1Calibrator;
import org.esa.s1tbx.calibration.rcp.Bundle;
import org.esa.s1tbx.calibration.rcp.S1CalibrationTPGDialog;
import org.esa.s1tbx.insar.gpf.support.Sentinel1Utils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.AbstractSnapAction;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class S1CalibrationTPGAction
extends AbstractSnapAction
implements ContextAwareAction,
LookupListener {
    private final Lookup lkp;
    private static final String CALIBRATION_VECTOR_TPG = "CalibrationVector";
    private static final String NOISE_VECTOR_TPG = "NoiseVector";

    public S1CalibrationTPGAction() {
        this(Utilities.actionsGlobalContext());
    }

    public S1CalibrationTPGAction(Lookup lkp) {
        this.lkp = lkp;
        Lookup.Result lkpContext = lkp.lookupResult(Product.class);
        lkpContext.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), (Object)lkpContext));
        this.setEnableState();
        this.putValue("Name", Bundle.CTL_S1CalibrationTPGActionName());
        this.putValue("ShortDescription", Bundle.CTL_S1CalibrationTPGActionDescription());
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new S1CalibrationTPGAction(actionContext);
    }

    public void resultChanged(LookupEvent ev) {
        this.setEnableState();
    }

    public void setEnableState() {
        Product product = (Product)this.lkp.lookup(Product.class);
        boolean enable = false;
        if (product != null) {
            InputProductValidator validator = new InputProductValidator(product);
            enable = validator.isSentinel1Product();
        }
        this.setEnabled(enable);
    }

    public void actionPerformed(ActionEvent event) {
        Product product = (Product)this.lkp.lookup(Product.class);
        if (product != null) {
            S1CalibrationTPGDialog dlg = new S1CalibrationTPGDialog();
            dlg.show();
            if (dlg.IsOK()) {
                try {
                    Sentinel1Utils su = new Sentinel1Utils(product);
                    int numSubswaths = su.getNumOfSubSwath();
                    ArrayList<String> selectedPolList = new ArrayList<String>();
                    for (String pol : OperatorUtils.getPolarisations((Product)product)) {
                        if (pol == null) continue;
                        selectedPolList.add(pol.toUpperCase());
                    }
                    boolean doSigma0 = dlg.doSigma0();
                    boolean doGamma = dlg.doGamma();
                    boolean doBeta0 = dlg.doBeta0();
                    boolean doDN = dlg.doDN();
                    boolean doNoise = dlg.doNoise();
                    if (doSigma0 || doGamma || doBeta0 || doDN) {
                        Sentinel1Calibrator.CalibrationInfo[] calInfo = Sentinel1Calibrator.getCalibrationVectors((Product)product, selectedPolList, (boolean)doSigma0, (boolean)doBeta0, (boolean)doGamma, (boolean)doDN);
                        this.addCalibrationTiePointGrids(product, calInfo, numSubswaths, doSigma0, doGamma, doBeta0, doDN);
                    }
                    if (doNoise) {
                        MetadataElement origMetadataRoot = AbstractMetadata.getOriginalProductMetadata((Product)product);
                        Sentinel1RemoveThermalNoiseOp.ThermalNoiseInfo[] noiseList = Sentinel1RemoveThermalNoiseOp.getThermalNoiseVectors((MetadataElement)origMetadataRoot, selectedPolList, (int)numSubswaths);
                        this.addNoiseTiePointGrids(product, noiseList, numSubswaths);
                    }
                }
                catch (Exception e) {
                    SnapApp.getDefault().handleError("Unable to add TPG", (Throwable)e);
                }
            }
        }
    }

    private void addCalibrationTiePointGrids(Product product, Sentinel1Calibrator.CalibrationInfo[] calInfoList, int numSubswaths, boolean doSigma0, boolean doGamma, boolean doBeta0, boolean doDN) {
        for (Sentinel1Calibrator.CalibrationInfo calInfo : calInfoList) {
            int i;
            float[] data;
            String name;
            Band referenceBand = S1CalibrationTPGAction.findBand(product, numSubswaths, calInfo.subSwath, calInfo.polarization);
            int gridWidth = calInfo.calibrationVectorList[0].pixels.length;
            int gridHeight = calInfo.calibrationVectorList.length;
            int gridSize = gridWidth * gridHeight;
            String suffix = '_' + calInfo.subSwath + '_' + calInfo.polarization;
            if (doSigma0) {
                name = "CalibrationVector_Sigma0LUT" + suffix;
                data = new float[gridSize];
                i = 0;
                for (Sentinel1Utils.CalibrationVector calVec : calInfo.calibrationVectorList) {
                    for (float value : calVec.sigmaNought) {
                        data[i++] = value;
                    }
                }
                this.addTPG(product, gridWidth, gridHeight, referenceBand, name, data);
            }
            if (doGamma) {
                name = "CalibrationVector_GammaLUT" + suffix;
                data = new float[gridSize];
                i = 0;
                for (Sentinel1Utils.CalibrationVector calVec : calInfo.calibrationVectorList) {
                    for (float value : calVec.gamma) {
                        data[i++] = value;
                    }
                }
                this.addTPG(product, gridWidth, gridHeight, referenceBand, name, data);
            }
            if (doBeta0) {
                name = "CalibrationVector_Beta0LUT" + suffix;
                data = new float[gridSize];
                i = 0;
                for (Sentinel1Utils.CalibrationVector calVec : calInfo.calibrationVectorList) {
                    for (float value : calVec.betaNought) {
                        data[i++] = value;
                    }
                }
                this.addTPG(product, gridWidth, gridHeight, referenceBand, name, data);
            }
            if (!doDN) continue;
            name = "CalibrationVector_DNLUT" + suffix;
            data = new float[gridSize];
            i = 0;
            for (Sentinel1Utils.CalibrationVector calVec : calInfo.calibrationVectorList) {
                for (float value : calVec.dn) {
                    data[i++] = value;
                }
            }
            this.addTPG(product, gridWidth, gridHeight, referenceBand, name, data);
        }
    }

    private void addTPG(Product product, int gridWidth, int gridHeight, Band referenceBand, String name, float[] data) {
        int sceneRasterWidth = referenceBand.getRasterWidth();
        int sceneRasterHeight = referenceBand.getRasterHeight();
        double subSamplingX = (double)sceneRasterWidth / (double)(gridWidth - 1);
        double subSamplingY = (double)sceneRasterHeight / (double)(gridHeight - 1);
        if (product.getTiePointGrid(name) == null) {
            TiePointGrid tpg = new TiePointGrid(name, gridWidth, gridHeight, 0.5, 0.5, subSamplingX, subSamplingY, data);
            tpg.setUnit("intensity");
            product.addTiePointGrid(tpg);
        }
    }

    private void addNoiseTiePointGrids(Product product, Sentinel1RemoveThermalNoiseOp.ThermalNoiseInfo[] noiseList, int numSubswaths) {
        for (Sentinel1RemoveThermalNoiseOp.ThermalNoiseInfo noiseInfo : noiseList) {
            Band referenceBand = S1CalibrationTPGAction.findBand(product, numSubswaths, noiseInfo.subSwath, noiseInfo.polarization);
            int gridWidth = noiseInfo.noiseVectorList[0].pixels.length + 1;
            int gridHeight = noiseInfo.noiseVectorList.length;
            int gridSize = gridWidth * gridHeight;
            String suffix = '_' + noiseInfo.subSwath + '_' + noiseInfo.polarization;
            String name = NOISE_VECTOR_TPG + suffix;
            float[] data = new float[gridSize];
            int i = 0;
            for (Sentinel1Utils.NoiseVector noiseVec : noiseInfo.noiseVectorList) {
                for (float value : noiseVec.noiseLUT) {
                    data[i++] = value;
                }
            }
            this.addTPG(product, gridWidth, gridHeight, referenceBand, name, data);
        }
    }

    private static Band findBand(Product product, int numSubswaths, String subSwath, String polarization) {
        Band matchingBand = product.getBandAt(0);
        for (Band band : product.getBands()) {
            String name = band.getName().toUpperCase();
            if (!name.contains(polarization)) continue;
            if (numSubswaths == 1) {
                return band;
            }
            if (!name.contains(subSwath)) continue;
            return band;
        }
        return matchingBand;
    }
}

